/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.acrescimo.calculo.custom;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.acrescimo.TipoJuros;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.service.acrescimo.calculo.custom.CustomCorrecao;
import br.com.elotech.tributos.service.acrescimo.calculo.custom.CustomCorrecaoPadrao;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.springframework.stereotype.Service;

@Service
public class CustomCorrecaoPadrao
implements CustomCorrecao {
    public Integer getIndex() {
        return 0;
    }

    public Boolean accept(String cnpj) {
        return true;
    }

    public LocalDate processDataCalculo(AcrescimoDTO dados, FormaCorrecao formaCorrecao, TipoJuros tipoJuros) {
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$acrescimo$TipoCorrecao[formaCorrecao.getTipoCorrecao().ordinal()]) {
            case 1: {
                return dados.getDataLancamento();
            }
            case 2: {
                return dados.getDataVencimento();
            }
            case 3: {
                return dados.getDataBaseIndiceAcumulado(tipoJuros);
            }
        }
        throw new EloValidationException("N\u00e3o foi poss\u00edvel identificar a data de corre\u00e7\u00e3o a ser usado para o tipo " + String.valueOf(formaCorrecao.getTipoCorrecao()));
    }

    public LocalDate processDataFinalCalculo(FormaCorrecao formaCorrecao, LocalDate dataLancamento, LocalDate dataVencimento, LocalDate dataPagamento, LocalDate dataFinalCalculo) {
        return dataFinalCalculo;
    }

    public BigDecimal processValorCorrecaoAfterCalc(Long formaCorrecao, LocalDate dataLancamento, BigDecimal valorCorrecao) {
        return valorCorrecao;
    }
}

