/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.acrescimo.calculo.custom;

import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.acrescimo.TipoJuros;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.service.acrescimo.calculo.custom.CustomCorrecaoPadrao;
import br.com.elotech.tributos.util.CalculoValoresConstants;
import br.com.elotech.tributos.util.DateUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.Arrays;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class CustomCorrecaoMaringa
extends CustomCorrecaoPadrao {
    private static final String CNPJ_MARINGA = "76282656000106";
    public static final Long FORMA_CORRECAO_MOEDA_DA_EPOCA = 0L;
    public static final Long FORMA_CORRECAO_BTN_MENSAL = 2L;
    public static final Long FORMA_CORRECAO_SALARIO_MINIMO = 3L;
    public static final Long FORMA_CORRECAO_UFIR_ASFALTO = 7L;
    public static final Long FORMA_CORRECAO_UFM_ASFALTO = 8L;
    public static final Long DIVIDA_ISSQN_TAXAS = 3L;
    public static final Long DIVIDA_TAXAS_MOBILIARIAS = 7L;
    public static final Long DIVIDA_ISSQN_FIXO = 92L;
    public static final Long DIVIDA_ISSQN_HOMOLOGADO = 91L;
    public static final Long DIVIDA_ISSQN_ESTIMADO = 93L;
    public static final Long DIVIDA_ISSQN_SOCIEDADECIVIL = 94L;
    private static final LocalDate dataMoedaDiferente = LocalDate.of(1993, 8, 14);
    private static final BigDecimal DIVISOR_1000 = BigDecimal.valueOf(1000L);

    public Integer getIndex() {
        return 1;
    }

    public Boolean accept(String cnpj) {
        return CNPJ_MARINGA.equals(cnpj);
    }

    public LocalDate processDataCalculo(AcrescimoDTO dados, FormaCorrecao formaCorrecao, TipoJuros tipoJuros) {
        if (!FORMA_CORRECAO_MOEDA_DA_EPOCA.equals(formaCorrecao.getId()) && dados.getDataLancamento().isEqual(dataMoedaDiferente)) {
            return dataMoedaDiferente;
        }
        if (FORMA_CORRECAO_MOEDA_DA_EPOCA.equals(formaCorrecao.getId()) && Arrays.asList(DIVIDA_ISSQN_TAXAS, DIVIDA_TAXAS_MOBILIARIAS, DIVIDA_ISSQN_FIXO).contains(dados.getDivida().getDivida())) {
            if (Boolean.TRUE.equals(dados.getParcelado())) {
                return this.calculaDataCorrecao(dados.getParcelado().booleanValue(), dados.getDataVencimento(), dados.getDataPrimeiraParcela(), false);
            }
            if (Objects.nonNull(dados.getDataCorrecaoIgpm())) {
                return dados.getDataCorrecaoIgpm().minusYears(1L);
            }
            return dados.getDataPrimeiraParcela();
        }
        if (FORMA_CORRECAO_MOEDA_DA_EPOCA.equals(formaCorrecao.getId()) && Arrays.asList(DIVIDA_ISSQN_HOMOLOGADO, DIVIDA_ISSQN_ESTIMADO, DIVIDA_ISSQN_SOCIEDADECIVIL).contains(dados.getDivida().getDivida())) {
            if (Boolean.TRUE.equals(dados.getParcelado())) {
                return this.calculaDataCorrecao(dados.getParcelado().booleanValue(), dados.getDataVencimento(), dados.getDataPrimeiraParcela(), false);
            }
            return super.processDataCalculo(dados, formaCorrecao, tipoJuros);
        }
        if (FORMA_CORRECAO_MOEDA_DA_EPOCA.equals(formaCorrecao.getId())) {
            return this.calculaDataCorrecao(dados.getParcelado().booleanValue(), dados.getDataVencimento(), dados.getDataPrimeiraParcela(), true);
        }
        return super.processDataCalculo(dados, formaCorrecao, tipoJuros);
    }

    public LocalDate calculaDataCorrecao(boolean parcelado, LocalDate dataVencimentoParcela, LocalDate dataVencimentoPrimeiraParcela, boolean calcularDataCorrecaoPosteriorAoVencimento) {
        LocalDate resultado = dataVencimentoPrimeiraParcela;
        if (parcelado) {
            int anoDoVencimentoDaParcela = dataVencimentoParcela.getYear();
            int mesDoVencimentoDaParcela = dataVencimentoParcela.getMonthValue();
            int diaVencimentoPrimeiraParcela = dataVencimentoPrimeiraParcela.getDayOfMonth();
            YearMonth yearMonth = YearMonth.of(anoDoVencimentoDaParcela, mesDoVencimentoDaParcela);
            int diasNoMes = Math.min(diaVencimentoPrimeiraParcela, yearMonth.lengthOfMonth());
            LocalDate dataDeVencimentoDaParcela = LocalDate.of(anoDoVencimentoDaParcela, mesDoVencimentoDaParcela, diasNoMes);
            long meses = DateUtils.monthsBetween((LocalDate)dataVencimentoPrimeiraParcela, (LocalDate)dataVencimentoParcela);
            long mesesPassados = (long)Math.floor(meses % 12L) * -1L;
            if (calcularDataCorrecaoPosteriorAoVencimento && dataVencimentoPrimeiraParcela.isAfter(dataVencimentoParcela)) {
                mesesPassados *= -1L;
            }
            LocalDate tempResultado = dataDeVencimentoDaParcela.plusMonths(mesesPassados);
            try {
                resultado = LocalDate.of(tempResultado.getYear(), tempResultado.getMonth(), diaVencimentoPrimeiraParcela);
            }
            catch (Exception e) {
                resultado = tempResultado;
            }
        }
        return resultado;
    }

    public LocalDate processDataFinalCalculo(FormaCorrecao formaCorrecao, LocalDate dataLancamento, LocalDate dataVencimento, LocalDate dataPagamento, LocalDate dataFinalCalculo) {
        if (FORMA_CORRECAO_SALARIO_MINIMO.compareTo(formaCorrecao.getId()) == 0) {
            return dataPagamento;
        }
        if (!dataFinalCalculo.isAfter(dataPagamento) && dataLancamento.getYear() < 2001) {
            int fator = 1;
            if (Arrays.asList(FORMA_CORRECAO_UFIR_ASFALTO, FORMA_CORRECAO_UFM_ASFALTO).contains(formaCorrecao.getId())) {
                fator = 2;
            }
            return LocalDate.of(dataPagamento.getYear() - fator, 12, 31);
        }
        return dataFinalCalculo;
    }

    public BigDecimal processValorCorrecaoAfterCalc(Long formaCorrecao, LocalDate dataLancamento, BigDecimal valorCorrecao) {
        if (FORMA_CORRECAO_MOEDA_DA_EPOCA.equals(formaCorrecao) && dataLancamento.isEqual(dataMoedaDiferente)) {
            return valorCorrecao.divide(DIVISOR_1000, (int)CalculoValoresConstants.QUANTIDADE_CASAS_DECIMAIS, RoundingMode.HALF_UP);
        }
        return valorCorrecao;
    }
}

