/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.acertopagameto;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.AcertoPagamento;
import br.com.elotech.tributos.domain.AcertoPagamentoItem;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.pagamentocredito.PagamentoCredito;
import br.com.elotech.tributos.dto.pagamento.EstornoPagamentoDTO;
import br.com.elotech.tributos.dto.pagamento.EstornoPagamentoItemSelecionadoDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.EstornoPagamentoService;
import br.com.elotech.tributos.service.acertopagameto.AcertoPagamentoService;
import br.com.elotech.tributos.service.pagamentocredito.CreditoService;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class EstornoAcertoPagamentoService {
    private final AcertoPagamentoService acertoPagamentoService;
    private final EstornoPagamentoService estornoPagamentoService;
    private final CreditoService pagamentoCreditoService;

    @Transactional
    public AcertoPagamento estornoAcerto(Long id) {
        AcertoPagamento acertoPagamento = (AcertoPagamento)this.acertoPagamentoService.findById((Serializable)id).orElseThrow(() -> new EloValidationException(String.format("Acerto de Pagamento %d n\u00e3o encontrado.", id)));
        if (Boolean.TRUE.equals(acertoPagamento.getEstornado())) {
            throw new EloValidationException("O acerto de pagamento j\u00e1 foi estornado.");
        }
        this.estornarPagamentosNovos(acertoPagamento);
        this.estornarCredito(acertoPagamento);
        return (AcertoPagamento)this.acertoPagamentoService.save((EloEntity)acertoPagamento, null);
    }

    private void estornarPagamentosNovos(AcertoPagamento acertoPagamento) {
        List pagamentosSelecionados = acertoPagamento.getAcertoPagamentoItemList().stream().map(item -> {
            EstornoPagamentoItemSelecionadoDTO itemSelecionado = new EstornoPagamentoItemSelecionadoDTO();
            itemSelecionado.setExercicio(item.getPagamentoNovo().getId().getExercicioPagamento());
            itemSelecionado.setPagamento(item.getPagamentoNovo().getId().getPagamento());
            return itemSelecionado;
        }).collect(Collectors.toList());
        EstornoPagamentoDTO estornoPagamentoDTO = new EstornoPagamentoDTO();
        estornoPagamentoDTO.setTodosSelecionados(Boolean.FALSE);
        estornoPagamentoDTO.setSelecionados(pagamentosSelecionados);
        estornoPagamentoDTO.setData(LocalDate.now());
        estornoPagamentoDTO.setMotivoEstorno(estornoPagamentoDTO.getMotivoEstorno());
        estornoPagamentoDTO.setUtilizarComoCredito(Boolean.valueOf(false));
        estornoPagamentoDTO.setValidaAcertoDePagamento(Boolean.valueOf(false));
        estornoPagamentoDTO.setAcertoPagamento(acertoPagamento.getId());
        this.estornoPagamentoService.estornarPagamento(estornoPagamentoDTO);
        acertoPagamento.setEstornado(Boolean.TRUE);
    }

    private void estornarCredito(AcertoPagamento acertoPagamento) {
        acertoPagamento.getAcertoPagamentoItemList().stream().map(arg_0 -> this.getBoletoPagoDoItem(arg_0)).forEach(arg_0 -> this.estornarCreditosPorBoleto(arg_0));
    }

    private Bloqueto getBoletoPagoDoItem(AcertoPagamentoItem item) {
        return item.getPagamentoNovo().getPagamentoBoleto().getBoleto();
    }

    private void estornarCreditosPorBoleto(Bloqueto boletoPago) {
        List creditosUtilizados = this.pagamentoCreditoService.findCreditoByBoletoPago(boletoPago);
        String usuario = SecurityUtils.getPreferredUsername();
        creditosUtilizados.forEach(credito -> {
            credito.estornarMovimentacaoPorBoleto(boletoPago, usuario);
            this.estornarCreditoRemanescenteSeExistir(credito);
        });
        this.pagamentoCreditoService.save(creditosUtilizados);
    }

    private void estornarCreditoRemanescenteSeExistir(PagamentoCredito credito) {
        this.pagamentoCreditoService.findByCreditoOrigem(credito).ifPresent(creditoRemanescente -> {
            creditoRemanescente.estornarSaldoPorCompleto();
            this.pagamentoCreditoService.save(creditoRemanescente);
        });
    }

    @Generated
    public EstornoAcertoPagamentoService(AcertoPagamentoService acertoPagamentoService, EstornoPagamentoService estornoPagamentoService, CreditoService pagamentoCreditoService) {
        this.acertoPagamentoService = acertoPagamentoService;
        this.estornoPagamentoService = estornoPagamentoService;
        this.pagamentoCreditoService = pagamentoCreditoService;
    }
}

