/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoSituacaoParcela;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamento;
import br.com.elotech.tributos.domain.parcelamento.Parcelamento;
import br.com.elotech.tributos.dto.DebitoEmAbertoDTO;
import br.com.elotech.tributos.dto.DebitoParcelaTributoDTO;
import br.com.elotech.tributos.dto.acrescimo.CalculaAcrescimoBaseDTO;
import br.com.elotech.tributos.repository.ValidaEmissaoBoletoRepository;
import br.com.elotech.tributos.repository.parcelamento.ParcelamentoRepository;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.exception.GeraBoletoException;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ValidaEmissaoBoletoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidaEmissaoBoletoService.class);
    private final ParametroGeralService parametroGeralService;
    private final ValidaEmissaoBoletoRepository validaEmissaoBoletoRepository;
    private final ParcelamentoRepository parcelamentoRepository;

    public void validaEmissaoBoleto(List<DebitoEmAbertoDTO> listDebitoParcelaReceita) {
        this.podeEmitirBoleto(listDebitoParcelaReceita, Boolean.valueOf(true), Boolean.valueOf(false));
        this.validaProcessoCancelamento(listDebitoParcelaReceita);
    }

    public void podeEmitirBoleto(List<DebitoEmAbertoDTO> listDebitoParcelaReceita, Boolean exibeErro, Boolean validaEmissaoPorContribuinte) {
        Boolean bloqueiaAjuizamentoEletronico = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.AJUIZAMENTO_BLOQUEIA_BOLETO_ATENDIMENTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        Map params = this.getParamsByIdsParcelamentos(listDebitoParcelaReceita);
        listDebitoParcelaReceita.forEach(debito -> {
            if (exibeErro.booleanValue()) {
                this.validaConfiguracaoGuia(debito);
            }
            this.validaSituacaoParcela(debito, exibeErro);
            if (bloqueiaAjuizamentoEletronico.booleanValue()) {
                this.validaAjuizamentoEletronico(debito, exibeErro);
            }
            if (Boolean.TRUE.equals(validaEmissaoPorContribuinte)) {
                this.validaDebitoPorContribuinte(debito, exibeErro);
            }
            this.validaParamParcelamento(debito, params, exibeErro);
        });
    }

    public void validaParamParcelamento(DebitoEmAbertoDTO debito, Map<Long, ParamParcelamento> params, Boolean exibeErro) {
        if (Objects.nonNull(debito.getIdParcelamento())) {
            LocalDate dataInicial = Optional.ofNullable(params.get(debito.getIdParcelamento())).map(ParamParcelamento::getDataPermitidaMaisAntiga).orElse(null);
            LocalDate dataFinal = LocalDate.now();
            if (Objects.nonNull(dataInicial) && !debito.isCompetenciaVencimentoEntre(dataInicial, dataFinal)) {
                debito.setEmiteBoleto(Boolean.FALSE);
                if (Boolean.TRUE.equals(exibeErro)) {
                    throw GeraBoletoException.vencimentoForaDaFaixaPermitida((Long)debito.getTipoCadastro(), (Long)debito.getCadastroGeral(), (Long)debito.getExercicio(), (Long)debito.getDivida(), (Long)debito.getSubDivida(), (Long)debito.getParcela(), (LocalDate)debito.getDataVencimento(), (LocalDate)dataInicial, (LocalDate)dataFinal);
                }
            }
        }
    }

    @NotNull
    public Map<Long, ParamParcelamento> getParamsByIdsParcelamentos(List<DebitoEmAbertoDTO> listDebitoParcelaReceita) {
        Set ids = listDebitoParcelaReceita.stream().map(CalculaAcrescimoBaseDTO::getIdParcelamento).filter(Objects::nonNull).collect(Collectors.toSet());
        if (ids.isEmpty()) {
            return Map.of();
        }
        log.debug("podeEmitirBoleto - Iniciando busca para obter os par\u00e2metros dos parcelamentos com ids: {}", ids);
        Map<Long, ParamParcelamento> params = this.parcelamentoRepository.findAllById(ids).stream().collect(Collectors.toMap(Parcelamento::getId, Parcelamento::getParamParcelamento));
        log.debug("podeEmitirBoleto - Finalizado a busca para os par\u00e2metros dos parcelamentos");
        return params;
    }

    private void validaAjuizamentoEletronico(DebitoEmAbertoDTO debito, Boolean exibeErro) {
        if (debito.isAjuizadoEletronicamente().booleanValue()) {
            debito.setEmiteBoleto(Boolean.valueOf(false));
            if (exibeErro.booleanValue()) {
                throw GeraBoletoException.debitoAjuizadoEletronicamente((DebitoEmAbertoDTO)debito);
            }
        }
    }

    private void validaConfiguracaoGuia(DebitoEmAbertoDTO debito) {
        if (!debito.getEmiteBoleto().booleanValue()) {
            throw GeraBoletoException.guiaNaoEmiteBoleto((Long)debito.getDivida(), (Long)debito.getExercicio());
        }
    }

    private void validaSituacaoParcela(DebitoEmAbertoDTO debito, Boolean exibeErro) {
        TipoSituacaoParcela tipoSituacaoParcela = TipoSituacaoParcela.fromValue((Object)debito.getTipoSituacaoParcela());
        if (TipoSituacaoParcela.RECURSO_ADMINISTRATIVO.equals((Object)tipoSituacaoParcela) || TipoSituacaoParcela.SUBJUDICE.equals((Object)tipoSituacaoParcela) || TipoSituacaoParcela.DIVIDA_SUSPENSA.equals((Object)tipoSituacaoParcela)) {
            debito.setEmiteBoleto(Boolean.valueOf(false));
            if (exibeErro.booleanValue()) {
                throw GeraBoletoException.situacaoParcelaInvalida((String)tipoSituacaoParcela.getDescricao(), (Long)debito.getExercicio(), (Long)debito.getDivida(), (Long)debito.getSubDivida(), (Long)debito.getParcela());
            }
        }
    }

    private void validaDebitoPorContribuinte(DebitoEmAbertoDTO debito, Boolean exibeErro) {
        if (Boolean.TRUE.equals(debito.getPorContribuinte())) {
            debito.setEmiteBoleto(Boolean.valueOf(false));
            if (exibeErro.booleanValue()) {
                throw GeraBoletoException.debitoReparcelamentoPorContribuinte();
            }
        }
    }

    private void validaProcessoCancelamento(List<DebitoEmAbertoDTO> debitos) {
        List debitoParcelaReceita;
        if (this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_APROVACAO_PROCESSO, ModuloEnum.MODULO_TRIBUTARIO.getValue()).booleanValue() && !(debitoParcelaReceita = this.validaEmissaoBoletoRepository.findDebitoComProcessoAprovacaoEmAberto(debitos.stream().map(DebitoEmAbertoDTO::getIdDebitoParcelaReceita).collect(Collectors.toList()))).isEmpty()) {
            throw GeraBoletoException.debitoPossuiProcessoAprovacao((DebitoParcelaTributoDTO)((DebitoParcelaTributoDTO)debitoParcelaReceita.get(0)));
        }
    }

    @Generated
    public ValidaEmissaoBoletoService(ParametroGeralService parametroGeralService, ValidaEmissaoBoletoRepository validaEmissaoBoletoRepository, ParcelamentoRepository parcelamentoRepository) {
        this.parametroGeralService = parametroGeralService;
        this.validaEmissaoBoletoRepository = validaEmissaoBoletoRepository;
        this.parcelamentoRepository = parcelamentoRepository;
    }
}

