/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.TipoRequerimento;
import br.com.elotech.tributos.dto.TipoRequerimentoComTaxasDTO;
import br.com.elotech.tributos.dto.requerimento.TipoRequerimentoDTO;
import br.com.elotech.tributos.enums.tiporequerimento.TipoVencimentoRequerimento;
import br.com.elotech.tributos.exception.TipoRequerimentoPorAssuntoException;
import br.com.elotech.tributos.repository.TipoRequerimentoRepository;
import br.com.elotech.tributos.service.ServicoTaxaMaterialService;
import br.com.elotech.tributos.service.TipoRequerimentoItemService;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TipoRequerimentoService
extends CrudService<TipoRequerimento, Long> {
    private final ServicoTaxaMaterialService servicoTaxaService;
    private final TipoRequerimentoItemService tipoRequerimentoItemService;
    private final TipoRequerimentoRepository tipoRequerimentoRepository;

    public TipoRequerimentoService(ServicoTaxaMaterialService servicoTaxaService, TipoRequerimentoItemService tipoRequerimentoItemService, TipoRequerimentoRepository tipoRequerimentoRepository) {
        this.servicoTaxaService = servicoTaxaService;
        this.tipoRequerimentoItemService = tipoRequerimentoItemService;
        this.tipoRequerimentoRepository = tipoRequerimentoRepository;
    }

    protected void beforeSave(TipoRequerimento entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        entity.getItens().forEach(item -> item.setTipoRequerimento(entity));
    }

    public TipoRequerimentoComTaxasDTO findTipoRequerimentoComTaxas(Long assunto) {
        List tiposRequerimentos = this.tipoRequerimentoRepository.findByAssuntoAndAtivoTrue(assunto);
        if (tiposRequerimentos.isEmpty()) {
            throw new TipoRequerimentoPorAssuntoException(HttpStatus.NOT_FOUND, "Nenhum assunto vinculado a um tipo requerimento.");
        }
        if (tiposRequerimentos.size() > 1) {
            throw new TipoRequerimentoPorAssuntoException(HttpStatus.BAD_REQUEST, "\u00c9 permitido apenas um tipo de requerimento por assunto.");
        }
        TipoRequerimento tipoRequerimento = (TipoRequerimento)tiposRequerimentos.get(0);
        List servicosTaxas = this.servicoTaxaService.findAllServicosByTipoRequerimento(tipoRequerimento.getId());
        return new TipoRequerimentoComTaxasDTO(tipoRequerimento, servicosTaxas);
    }

    public TipoRequerimentoDTO getResumo(Long id) {
        TipoRequerimentoDTO dto = TipoRequerimentoDTO.from((TipoRequerimento)((TipoRequerimento)this.tipoRequerimentoRepository.findById((Object)id).orElseThrow(() -> new EloValidationException("Tipo Requerimento n\u00e3o encontrado."))));
        dto.getItens().addAll(this.tipoRequerimentoItemService.findByTipoRequerimento(id));
        return dto;
    }

    public LocalDate generateDate(Long idTipoRequerimento, LocalDate dataBase) {
        TipoRequerimento tipoRequerimento = (TipoRequerimento)this.findOne((Serializable)idTipoRequerimento);
        return this.generateDate(tipoRequerimento, dataBase);
    }

    public LocalDate generateDate(TipoRequerimento tipoRequerimento, LocalDate dataBase) {
        LocalDate internalDate = Objects.nonNull(dataBase) ? dataBase : LocalDate.now();
        Object suprimento = tipoRequerimento.getSuprimentoParaGerarData();
        TipoVencimentoRequerimento tipoVencimento = tipoRequerimento.getTipoVencimento();
        Assert.notNull((Object)tipoVencimento, (String)"Tipo de c\u00e1lculo de prazo \u00e9 obrigat\u00f3rio para o tipo de requerimento");
        return tipoVencimento.getDateGenerator().gerarProximaData(internalDate, suprimento);
    }
}

