/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoCadastroAba;
import br.com.elotech.tributos.dto.TipoCadastroAbaDTO;
import br.com.elotech.tributos.repository.TipoCadastroAbaRepository;
import java.util.List;
import javax.persistence.EntityNotFoundException;
import javax.transaction.Transactional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class TipoCadastroAbaService
extends CrudService<TipoCadastroAba, Long> {
    private final TipoCadastroAbaRepository repository;

    public Page<TipoCadastroAbaDTO> search(String search, Pageable pageable) {
        String rsql = StringUtils.isBlank((CharSequence)search) ? "" : search;
        return this.findByRsql(rsql, pageable).map(TipoCadastroAbaDTO::new);
    }

    public void updateAba(Long id, TipoCadastroAbaDTO dto) {
        TipoCadastroAba aba = this.getAbaOrThrow(id);
        aba.setOrdem(dto.getOrdem());
        aba.setNome(dto.getNome());
        aba.setVisivel(dto.getVisivel());
        this.repository.save((Object)aba);
    }

    public List<TipoCadastroAbaDTO> getVisiveisByTipoCadastro(Long tipoCadastro) {
        return this.repository.findDisponivelByTipoCadastro(TipoCadastro.fromValue((Long)tipoCadastro)).stream().map(TipoCadastroAbaDTO::new).toList();
    }

    public TipoCadastroAbaDTO findDtoById(Long id) {
        return new TipoCadastroAbaDTO(this.getAbaOrThrow(id));
    }

    private TipoCadastroAba getAbaOrThrow(Long id) {
        return (TipoCadastroAba)this.repository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("Aba n\u00e3o encontrada: " + id));
    }

    @Generated
    public TipoCadastroAbaService(TipoCadastroAbaRepository repository) {
        this.repository = repository;
    }
}

