/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Setor;
import br.com.elotech.tributos.domain.inscricaocadastral.ConfiguracaoInscricaoCadastral;
import br.com.elotech.tributos.repository.SetorRepository;
import br.com.elotech.tributos.service.ConfiguracaoInscricaoCadastralService;
import java.util.Objects;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SetorService
extends CrudService<Setor, Long> {
    private final SetorRepository setorRepository;
    private final ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService;

    public SetorService(SetorRepository setorRepository, ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService) {
        this.setorRepository = setorRepository;
        this.configuracaoInscricaoCadastralService = configuracaoInscricaoCadastralService;
    }

    protected void beforeInsert(Setor setor) {
        ConfiguracaoInscricaoCadastral configuracaoInscricaoCadastral = this.configuracaoInscricaoCadastralService.getConfiguracao();
        this.validaSetor(setor);
        if (this.existsDistritoSetor(setor)) {
            throw new EloValidationException(String.format("%s: %s, %s: %s j\u00e1 existe.", configuracaoInscricaoCadastral.getDistrito().getDescricao(), setor.getDistrito().getDistrito(), configuracaoInscricaoCadastral.getSetor().getDescricao(), setor.getSetor()));
        }
        super.beforeInsert((EloEntity)setor);
    }

    protected void beforeEdit(Setor setor) {
        this.validaSetor(setor);
        super.beforeEdit((EloEntity)setor);
    }

    public Setor findByDistritoDistritoAndSetor(String distrito, String setor) {
        return this.setorRepository.findByDistritoDistritoAndSetor(distrito, setor);
    }

    private boolean existsDistritoSetor(Setor setor) {
        return Objects.nonNull(this.findByDistritoDistritoAndSetor(setor.getDistrito().getDistrito(), setor.getSetor()));
    }

    private void validaSetor(Setor setor) {
        ConfiguracaoInscricaoCadastral configuracaoInscricaoCadastral = this.configuracaoInscricaoCadastralService.getConfiguracao();
        Assert.notNull((Object)setor.getDistrito(), (String)String.format("%s n\u00e3o pode ser nulo.", configuracaoInscricaoCadastral.getDistrito().getDescricao()));
    }
}

