/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.common.service.EntidadeService;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.ServicoTaxaMaterial;
import br.com.elotech.tributos.domain.ServicoTaxaMaterialId;
import br.com.elotech.tributos.repository.ServicoTaxaMaterialRepository;
import br.com.elotech.tributos.service.ExercicioService;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ServicoTaxaMaterialService
extends CrudService<ServicoTaxaMaterial, ServicoTaxaMaterialId> {
    private final ExercicioService exercicioService;
    private final EntidadeService entidadeService;
    private final ServicoTaxaMaterialRepository repository;

    public ServicoTaxaMaterialService(ExercicioService exercicioService, ServicoTaxaMaterialRepository repository, EntidadeService entidadeService) {
        this.exercicioService = exercicioService;
        this.repository = repository;
        this.entidadeService = entidadeService;
    }

    public List<ServicoTaxaMaterial> findAllServicosByTipoRequerimento(Long idTipoRequerimento) {
        Long exercicioCorrente = this.exercicioService.getExercicio();
        Long entidadePrincipal = this.entidadeService.findEntidadePrincipal().getId();
        return this.repository.findByTipoRequerimentoIdAndIdExercicioAndIdEntidade(idTipoRequerimento, exercicioCorrente, entidadePrincipal);
    }
}

