/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.contabilidade.client.RealizacaoReceitaTributosFeignClient;
import br.com.elotech.contabilidade.client.dto.RealizacaoReceitaTributoDTO;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.ParametroGeral;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.simam.RetencaoContabil;
import br.com.elotech.tributos.repository.RetencaoContabilRepository;
import br.com.elotech.tributos.service.ParametroGeralService;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.Transactional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class RetencaoContabilService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetencaoContabilService.class);
    private final RetencaoContabilRepository retencaoContabilRepository;
    private final Optional<RealizacaoReceitaTributosFeignClient> realizacaoReceitaTributosFeignClient;
    private final ParametroGeralService parametroGeralService;
    private final ConfigurableEnvironment environment;

    public void findAndSaveRetencoesPeriodo(Long entidade, Long exercicio, Long competencia) {
        List realizacoes = this.findRetencoes(entidade, exercicio, competencia);
        if (realizacoes.isEmpty()) {
            return;
        }
        this.validaParametroLeiAtoRetencao();
        ConcurrentHashMap cargaExistente = new ConcurrentHashMap();
        this.getCargaExistente(cargaExistente, competencia, exercicio);
        realizacoes.forEach(item -> {
            String chave = String.format("%d-%d-%b", item.getCodigoTributo(), item.getCompetencia(), item.getDevolucao());
            cargaExistente.compute(chave, (k, v) -> {
                if (Objects.nonNull(v)) {
                    return v;
                }
                log.info("SIM-AM - Salvando reten\u00e7\u00e3o cont\u00e1bil: " + chave);
                return ((RetencaoContabil)this.retencaoContabilRepository.save((Object)RetencaoContabil.from((RealizacaoReceitaTributoDTO)item, (Long)exercicio))).getId();
            });
        });
    }

    private List<RealizacaoReceitaTributoDTO> findRetencoes(Long entidade, Long exercicio, Long competencia) {
        if (this.realizacaoReceitaTributosFeignClient.isEmpty()) {
            log.info("SIM-AM - O client da Contabilidade n\u00e3o est\u00e1 disponivel no ambiente onpremise.");
            return new ArrayList<RealizacaoReceitaTributoDTO>();
        }
        log.info("SIM-AM - Buscando as reten\u00e7\u00f5es cont\u00e1beis na competencia " + competencia);
        try {
            return ((RealizacaoReceitaTributosFeignClient)this.realizacaoReceitaTributosFeignClient.get()).findAllRealizacaoReceitaTributos(entidade, exercicio, competencia);
        }
        catch (Exception e) {
            log.error("SIM-AM - Erro ao buscar as reten\u00e7\u00f5es cont\u00e1beis do exerc\u00edcio: " + exercicio, (Throwable)e);
            return new ArrayList<RealizacaoReceitaTributoDTO>();
        }
    }

    private void getCargaExistente(Map<String, Long> cargaExistente, Long competencia, Long exercicio) {
        LocalDate dtLancamento = LocalDate.of(exercicio.intValue(), competencia.intValue(), 1);
        dtLancamento = dtLancamento.with(TemporalAdjusters.lastDayOfMonth());
        this.retencaoContabilRepository.findCargaExistente(dtLancamento).forEach(item -> cargaExistente.put(item.getChave(), item.getId()));
    }

    public void validaParametroLeiAtoRetencao() {
        ParametroGeral parametroRetencao = this.parametroGeralService.findByParametroAndModulo(ParametroGeralEnum.LEI_ATO_RETENCAOLANCCRED, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        if (StringUtils.isBlank((CharSequence)parametroRetencao.getValor())) {
            throw new EloValidationException("O par\u00e2metro geral LEI_ATO_RETENCAOLANCCRED n\u00e3o est\u00e1 configurado.");
        }
    }

    @Generated
    public RetencaoContabilService(RetencaoContabilRepository retencaoContabilRepository, Optional<RealizacaoReceitaTributosFeignClient> realizacaoReceitaTributosFeignClient, ParametroGeralService parametroGeralService, ConfigurableEnvironment environment) {
        this.retencaoContabilRepository = retencaoContabilRepository;
        this.realizacaoReceitaTributosFeignClient = realizacaoReceitaTributosFeignClient;
        this.parametroGeralService = parametroGeralService;
        this.environment = environment;
    }
}

