/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcelaId;
import br.com.elotech.tributos.domain.DividaFormaPagamento;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoFormaPagamento;
import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.repository.DebitoParcelaRepository;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.exception.RefisValidationException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
public class RefisValidationService {
    private final ParametroGeralService parametroGeralService;
    private final DebitoService debitoService;
    private final DebitoParcelaRepository debitoParcelaRepository;

    public boolean isRefisHabilitado() {
        return Boolean.TRUE.equals(this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_FORMA_PAGAMENTO_REFIS, ModuloEnum.MODULO_TRIBUTARIO.getValue()));
    }

    public void validarImpressaoDebitos(@NonNull List<DebitoDTO> debitos) {
        if (!this.isRefisHabilitado() || debitos.isEmpty()) {
            return;
        }
        this.popularFlagPassivelRefis(debitos);
        long quantidadeDebitosRefis = this.contarDebitosRefis(debitos);
        if (this.possuiViolacao(quantidadeDebitosRefis, debitos.size())) {
            this.lancarExcecaoComMensagem(debitos);
        }
    }

    public void popularFlagPassivelRefis(@NonNull List<DebitoDTO> debitos) {
        Set idsParcela = debitos.stream().map(arg_0 -> this.toDebitoParcelaId(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (idsParcela.isEmpty()) {
            debitos.forEach(debito -> debito.setPassivelRefis(Boolean.FALSE));
            return;
        }
        Set idsPassiveisRefis = this.buscarIdsDebitosPassivelRefis(idsParcela);
        debitos.forEach(debito -> {
            DebitoParcelaId idParcela = this.toDebitoParcelaId(debito);
            debito.setPassivelRefis(Boolean.valueOf(idParcela != null && idsPassiveisRefis.contains(idParcela)));
        });
    }

    public Optional<DividaFormaPagamento> getFormaPagamentoRefis(@NonNull Debito debito) {
        return Optional.ofNullable(debito.getDivida()).stream().flatMap(divida -> divida.getFormasPagamento().stream()).filter(arg_0 -> this.isTipoRefis(arg_0)).findFirst();
    }

    private boolean isTipoRefis(DividaFormaPagamento fp) {
        if (fp == null || fp.getFormaPagamento() == null) {
            return false;
        }
        return TipoFormaPagamento.REFIS.equals((Object)fp.getFormaPagamento().getTipoFormaPagamento());
    }

    private long contarDebitosRefis(List<DebitoDTO> debitos) {
        return debitos.stream().filter(arg_0 -> this.isDebitoPassivelRefis(arg_0)).count();
    }

    private boolean possuiViolacao(long quantidadeRefis, int totalDebitos) {
        return quantidadeRefis > 0L && quantidadeRefis < (long)totalDebitos;
    }

    private void lancarExcecaoComMensagem(List<DebitoDTO> debitos) {
        String nomeFormaPagamentoRefis = this.buscarNomeFormaPagamentoRefis(debitos);
        throw new RefisValidationException("H\u00e1 d\u00e9bitos configurados com a forma de pagamento: " + nomeFormaPagamentoRefis + ". D\u00e9bitos com essa forma de pagamento n\u00e3o podem ser impressos em conjunto com outros d\u00e9bitos.");
    }

    private String buscarNomeFormaPagamentoRefis(List<DebitoDTO> debitos) {
        return debitos.stream().filter(arg_0 -> this.isDebitoPassivelRefis(arg_0)).findFirst().flatMap(d -> this.debitoService.findById((Serializable)d.getIdDebito())).flatMap(arg_0 -> this.getFormaPagamentoRefis(arg_0)).map(fp -> fp.getFormaPagamento().getDescricao()).orElse("REFIS");
    }

    public boolean isDebitoPassivelRefis(@NonNull DebitoDTO debitoDTO) {
        return this.isRefisHabilitado() && Boolean.TRUE.equals(debitoDTO.getPassivelRefis());
    }

    public Optional<Long> getIdFormaPagamentoRefis(Long idDebito) {
        if (idDebito == null) {
            return Optional.empty();
        }
        return this.debitoService.findById((Serializable)idDebito).flatMap(arg_0 -> this.getFormaPagamentoRefis(arg_0)).map(fp -> fp.getFormaPagamento().getId());
    }

    private Set<DebitoParcelaId> buscarIdsDebitosPassivelRefis(Set<DebitoParcelaId> idsDebitoParcela) {
        if (!this.isRefisHabilitado() || idsDebitoParcela == null || idsDebitoParcela.isEmpty()) {
            return Set.of();
        }
        return new HashSet<DebitoParcelaId>(this.debitoParcelaRepository.findIdsPassivelRefis(List.copyOf(idsDebitoParcela)));
    }

    private DebitoParcelaId toDebitoParcelaId(DebitoDTO debitoDTO) {
        Long entidade = this.toLong((Number)debitoDTO.getEntidade());
        Long exercicio = this.toLong((Number)debitoDTO.getExercicio());
        Long tipoCadastro = this.toLong((Number)debitoDTO.getTipoCadastro());
        Long cadastroGeral = this.toLong((Number)debitoDTO.getCadastroGeral());
        Long divida = this.toLong((Number)debitoDTO.getGuiaRecolhimento());
        Long subDivida = this.toLong((Number)debitoDTO.getSubDivida());
        Long parcela = debitoDTO.getParcela();
        if (entidade == null || exercicio == null || tipoCadastro == null || cadastroGeral == null || divida == null || subDivida == null || parcela == null) {
            return null;
        }
        return DebitoParcelaId.builder().entidade(entidade).exercicio(exercicio).tipoCadastro(tipoCadastro).cadastroGeral(cadastroGeral).divida(divida).subDivida(subDivida).parcela(parcela).build();
    }

    private Long toLong(Number value) {
        return value == null ? null : Long.valueOf(value.longValue());
    }

    @Generated
    public RefisValidationService(ParametroGeralService parametroGeralService, DebitoService debitoService, DebitoParcelaRepository debitoParcelaRepository) {
        this.parametroGeralService = parametroGeralService;
        this.debitoService = debitoService;
        this.debitoParcelaRepository = debitoParcelaRepository;
    }
}

