/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Profissional;
import br.com.elotech.tributos.domain.ProfissionalId;
import br.com.elotech.tributos.dto.ProfissionalDTO;
import br.com.elotech.tributos.repository.ProfissionalRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class ProfissionalService
extends CrudService<Profissional, ProfissionalId> {
    private final ProfissionalRepository profissionalRepository;

    protected void beforeSave(Profissional entity, Authentication authentication) {
        if (StringUtils.isBlank((CharSequence)entity.getUsuario())) {
            entity.setUsuario(SecurityUtils.getUserAise());
        }
        super.beforeSave((EloEntity)entity, authentication);
    }

    public Page<ProfissionalDTO> findAllWithDistinct(String search, Pageable pageable) {
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            query.distinct(true);
            String rsqlFilter = this.buildRsqlFilter(search);
            Specification rsqlSpec = RsqlUtils.createSpecFrom((EntityManager)this.getEm(), (String)rsqlFilter, Optional.empty());
            return rsqlSpec.toPredicate(root, query, criteriaBuilder);
        };
        return this.profissionalRepository.findAll((Specification)specification, pageable).map(ProfissionalDTO::from);
    }

    public Profissional findByIdPessoaId(Long id) {
        return (Profissional)this.profissionalRepository.findByIdPessoaId(id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o profissional com o ID %d", id)));
    }

    public List<ProfissionalDTO> findAllByIdProfissionalDTO(List<Long> ids) {
        return this.profissionalRepository.findByIdPessoaIdIn(ids).stream().map(ProfissionalDTO::from).toList();
    }

    @Generated
    public ProfissionalService(ProfissionalRepository profissionalRepository) {
        this.profissionalRepository = profissionalRepository;
    }
}

