/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.DividaTributo;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.domain.TipoOperacaoDebito;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalhe;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagemEnum;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoManualDTO;
import br.com.elotech.tributos.dto.DebitoManualObservacaoDTO;
import br.com.elotech.tributos.dto.DebitoManualTributoDTO;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.dto.GerarParcelasDebitoDTO;
import br.com.elotech.tributos.service.CadastroAvulsoService;
import br.com.elotech.tributos.service.DividaService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.GeraDebitoService;
import br.com.elotech.tributos.service.LaudoMaringaService;
import br.com.elotech.tributos.service.ModeloBoletoService;
import br.com.elotech.tributos.service.TipoMensagemService;
import br.com.elotech.tributos.ws.rest.dto.pessoa.IncluirPessoaRequestDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ProcessaPagamentoLoteLaudoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessaPagamentoLoteLaudoService.class);
    private final LaudoMaringaService laudoMaringaService;
    private final CadastroAvulsoService cadastroAvulsoService;
    private final GeraDebitoService geraDebitoService;
    private final DividaService dividaService;
    private final GeraBoletoService geraBoletoService;
    private final EntityManager entityManager;
    private final ModeloBoletoService modeloBoletoService;
    private final TipoMensagemService tipoMensagemService;

    public BaixaAutomaticaDetalhe verificarLoteSequencia(BaixaAutomaticaDetalhe detalhe) {
        Long entidade = detalhe.getId().getEntidade();
        Long exercicio = this.laudoMaringaService.extrairExercicioLaudoByNossoNumero(detalhe.getNossoNumero());
        Long codigoDivida = this.laudoMaringaService.getParametroDividaLaudo();
        if (Objects.isNull(codigoDivida)) {
            log.warn("N\u00e3o h\u00e1 parametriza\u00e7\u00e3o da D\u00edvida do Laudo");
            return this.applyMensagem(detalhe, TipoMensagemEnum.GUIA_NAO_ENCONTRADA, "N\u00e3o h\u00e1 parametriza\u00e7\u00e3o da D\u00edvida do Laudo");
        }
        Optional divida = this.dividaService.findByEntidadeAndExercicioAndDivida(entidade, exercicio, codigoDivida);
        if (divida.isEmpty()) {
            log.warn("D\u00edvida {} n\u00e3o encontrada para entidade {} e exerc\u00edcio {}", new Object[]{codigoDivida, entidade, exercicio});
            return this.applyMensagem(detalhe, TipoMensagemEnum.GUIA_NAO_ENCONTRADA, TipoMensagemEnum.GUIA_NAO_ENCONTRADA.getDescricao());
        }
        Optional dividaTributoPadrao = this.getDividaTributo(entidade, exercicio, codigoDivida);
        if (dividaTributoPadrao.isEmpty()) {
            log.warn("Receita padr\u00e3o da d\u00edvida {} n\u00e3o encontrada para entidade {} e exerc\u00edcio {}", new Object[]{codigoDivida, entidade, exercicio});
            return this.applyMensagem(detalhe, TipoMensagemEnum.RECEITA_PADRAO_NAO_ENCONTRADA, TipoMensagemEnum.RECEITA_PADRAO_NAO_ENCONTRADA.getDescricao());
        }
        log.info("D\u00edvida {} validada com sucesso para lote {}/{}", new Object[]{codigoDivida, detalhe.getId().getLote(), detalhe.getId().getExercicio()});
        return this.applyMensagem(detalhe, TipoMensagemEnum.BOLETO_VALIDADO, String.format("D\u00edvida %d validada com sucesso", codigoDivida));
    }

    public void gerarDebitoEBoleto(BaixaAutomaticaDetalhe detalhe) {
        log.info("Iniciando gera\u00e7\u00e3o de d\u00e9bito e boleto para nosso n\u00famero {}", (Object)detalhe.getNossoNumero());
        DebitoIdDTO debitoGerado = this.generateDebito(detalhe);
        Bloqueto boleto = this.generateBoleto(debitoGerado);
        detalhe.setTipoOperacao(TipoOperacaoDebito.DEBITO_GERADO);
        detalhe.setIdDebitoOperacao(debitoGerado.getIdDebito());
        detalhe.setParcelaOperacao(Long.valueOf(1L));
        detalhe.setBoleto(boleto);
        detalhe.setValor(boleto.getValorBloqueto());
        log.info("D\u00e9bito e boleto gerados com sucesso para nosso n\u00famero {}", (Object)detalhe.getNossoNumero());
    }

    private Bloqueto generateBoleto(DebitoIdDTO debitoGerado) {
        log.info("Gerando boleto para d\u00e9bito {}", (Object)debitoGerado.getIdDebito());
        ModeloBoleto modelo = this.modeloBoletoService.retornarConfiguracaoModeloBoletoSequencia();
        this.entityManager.flush();
        DebitoParcelaDTO parcelaDTO = new DebitoParcelaDTO();
        parcelaDTO.setIdDebito(debitoGerado.getIdDebito());
        parcelaDTO.setParcela(Long.valueOf(1L));
        GeraBoletoDTO boletoDTO = new GeraBoletoDTO();
        boletoDTO.setOrigemEmissao(OrigemEmissao.AISE);
        boletoDTO.setTipoBoleto(TipoBloqueto.PARCELADO);
        boletoDTO.setDebitos(Collections.singletonList(parcelaDTO));
        boletoDTO.setModeloBoleto(modelo);
        Bloqueto boleto = (Bloqueto)this.geraBoletoService.geraBoleto(boletoDTO).stream().findFirst().orElseThrow(() -> {
            log.error("Erro ao gerar boleto para d\u00e9bito {}", (Object)debitoGerado.getIdDebito());
            return new IllegalStateException("Erro ao gerar boleto");
        });
        boleto.setUtilizaValorBloqueto(Boolean.TRUE);
        return boleto;
    }

    private Optional<DividaTributo> getDividaTributo(Long entidade, Long exercicio, Long codigoDivida) {
        Divida divida = (Divida)this.dividaService.findByEntidadeAndExercicioAndDivida(entidade, exercicio, codigoDivida).orElseThrow(() -> new EloValidationException(String.format("D\u00edvida %d n\u00e3o encontrada no exerc\u00edcio %d para entidade %d", codigoDivida, exercicio, entidade)));
        return divida.getTributos().stream().filter(DividaTributo::getReceitaPadrao).findFirst();
    }

    private DebitoIdDTO generateDebito(BaixaAutomaticaDetalhe detalhe) {
        String nossoNumero = detalhe.getNossoNumero();
        Long laudo = this.laudoMaringaService.extrairNumeroLaudoByNossoNumero(nossoNumero);
        Long exercicio = this.laudoMaringaService.extrairExercicioLaudoByNossoNumero(nossoNumero);
        Long codigoDivida = this.laudoMaringaService.getParametroDividaLaudo();
        log.info("Gerando d\u00e9bito para laudo {} / exerc\u00edcio {}, nosso n\u00famero {}", new Object[]{laudo, exercicio, nossoNumero});
        Pessoa pessoa = this.laudoMaringaService.findPessoaByLaudoMaringa(laudo, exercicio);
        CadastroGeral cadastro = this.cadastroAvulsoService.obterOuCriarCadastroAvulso(pessoa, this.buildIncluirPessoaRequestDTO(pessoa));
        DividaTributo dividaTributo = (DividaTributo)this.getDividaTributo(detalhe.getId().getEntidade(), exercicio, codigoDivida).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o tributo padr\u00e3o da d\u00edvida %d/%d.", codigoDivida, exercicio)));
        List tributos = this.buildDebitoManualTributoDTO(dividaTributo, detalhe.getValorPago());
        List parcelas = this.geraDebitoService.gerarParcelas(this.buildGerarParcelasDebitoDTO(tributos, detalhe.getDataVencimento()));
        String observacao = String.format("D\u00e9bito gerado pela baixa autom\u00e1tica de lote %d/%d sequ\u00eancia %d", detalhe.getId().getLote(), detalhe.getId().getExercicio(), detalhe.getId().getSequenciaArquivo());
        DebitoManualDTO dto = DebitoManualDTO.builder().exercicio(exercicio).tipoCadastro(cadastro.getTipoCadastro()).cadastroGeral(cadastro.getCadastroGeral()).divida(codigoDivida).dataLancamento(detalhe.getPagamentoLote().getDataMovimento()).dataInclusao(LocalDate.now()).programa(JobType.BAIXA_AUTOMATICA.getTipo()).parcelas(parcelas).tributos(tributos).observacoes(List.of(DebitoManualObservacaoDTO.of((String)observacao))).build();
        return this.geraDebitoService.geraDebitoManual(dto);
    }

    private IncluirPessoaRequestDTO buildIncluirPessoaRequestDTO(Pessoa pessoa) {
        IncluirPessoaRequestDTO request = new IncluirPessoaRequestDTO();
        request.setTipoPessoa(pessoa.getTipoPessoa());
        request.setCnpjCpf(pessoa.getCnpjCpf());
        request.setNome(pessoa.getCnpjCpf());
        request.setNomeFantasia(pessoa.getNomeFantasia());
        return request;
    }

    private List<DebitoManualTributoDTO> buildDebitoManualTributoDTO(DividaTributo dividaTributo, BigDecimal valorTributo) {
        DebitoManualTributoDTO tributoDTO = new DebitoManualTributoDTO();
        tributoDTO.setTributo(dividaTributo.getTributo().getTributo());
        tributoDTO.setOrdem(dividaTributo.getOrdem());
        tributoDTO.setValorTributo(valorTributo);
        return List.of(tributoDTO);
    }

    private GerarParcelasDebitoDTO buildGerarParcelasDebitoDTO(List<DebitoManualTributoDTO> tributos, LocalDate dataVencimento) {
        GerarParcelasDebitoDTO parcelasDTO = new GerarParcelasDebitoDTO();
        parcelasDTO.setParcelaInicial(Long.valueOf(1L));
        parcelasDTO.setQuantidadeParcelas(Long.valueOf(1L));
        parcelasDTO.setDataVencimentoInicial(dataVencimento);
        parcelasDTO.setTributos(tributos);
        return parcelasDTO;
    }

    private BaixaAutomaticaDetalhe applyMensagem(BaixaAutomaticaDetalhe detalhe, TipoMensagemEnum tipoEnum, String mensagem) {
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(tipoEnum);
        detalhe.setSituacao(tipoMensagem.getClassificacao());
        detalhe.setTipoMensagem(tipoMensagem);
        detalhe.setMensagem(mensagem);
        return detalhe;
    }

    @Generated
    public ProcessaPagamentoLoteLaudoService(LaudoMaringaService laudoMaringaService, CadastroAvulsoService cadastroAvulsoService, GeraDebitoService geraDebitoService, DividaService dividaService, GeraBoletoService geraBoletoService, EntityManager entityManager, ModeloBoletoService modeloBoletoService, TipoMensagemService tipoMensagemService) {
        this.laudoMaringaService = laudoMaringaService;
        this.cadastroAvulsoService = cadastroAvulsoService;
        this.geraDebitoService = geraDebitoService;
        this.dividaService = dividaService;
        this.geraBoletoService = geraBoletoService;
        this.entityManager = entityManager;
        this.modeloBoletoService = modeloBoletoService;
        this.tipoMensagemService = tipoMensagemService;
    }
}

