/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.domain.DividaUsuario;
import br.com.elotech.tributos.domain.DividaUsuarioId;
import br.com.elotech.tributos.domain.Usuario;
import br.com.elotech.tributos.dto.DividaUsuarioDTO;
import br.com.elotech.tributos.dto.PermissaoDividaUsuarioDTO;
import br.com.elotech.tributos.repository.PermissoesDividaRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.UsuarioService;
import br.com.elotech.tributos.service.exception.PermissaoDividaException;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class PermissoesDividaService {
    private final PermissoesDividaRepository permissoesDividaRepository;
    private final ContextService contextService;
    private final UsuarioService usuarioService;

    public PermissoesDividaService(PermissoesDividaRepository permissoesDividaRepository, ContextService contextService, UsuarioService usuarioService) {
        this.permissoesDividaRepository = permissoesDividaRepository;
        this.contextService = contextService;
        this.usuarioService = usuarioService;
    }

    public List<DividaUsuarioDTO> getPermissoesDividaByUsuario(String usuario) {
        return this.permissoesDividaRepository.findByEntidadeAndExercicioAndUsuario(this.contextService.getEntidadePrincipal(), this.contextService.getExercicioAtual(), usuario);
    }

    public DividaUsuario save(DividaUsuarioDTO dividaUsuarioDTO) {
        DividaUsuarioId dividaUsuarioId = DividaUsuarioId.of((Long)dividaUsuarioDTO.getEntidade(), (Long)dividaUsuarioDTO.getExercicio(), (Long)dividaUsuarioDTO.getDivida(), (String)dividaUsuarioDTO.getUsuario());
        DividaUsuario dividaUsuario = this.permissoesDividaRepository.findById((Object)dividaUsuarioId).orElseGet(DividaUsuario::new);
        dividaUsuario.setId(dividaUsuarioId);
        dividaUsuario.setInserir(dividaUsuarioDTO.getInserir());
        dividaUsuario.setCancelar(dividaUsuarioDTO.getCancelar());
        return (DividaUsuario)this.permissoesDividaRepository.save((Object)dividaUsuario);
    }

    public PermissaoDividaUsuarioDTO copiarPermissoes(String usuarioASerCopiado, String usuarioAReceber) {
        Usuario usuarioDestino;
        Usuario usuarioOrigem = (Usuario)this.usuarioService.findOne((Serializable)((Object)usuarioASerCopiado));
        Usuario usuario = usuarioDestino = (Usuario)this.usuarioService.findOne((Serializable)((Object)usuarioAReceber));
        if (!usuarioOrigem.getPermissaoTotalDivida().equals(usuarioDestino.getPermissaoTotalDivida())) {
            usuario = this.usuarioService.updatePermissaoTotalDivida(usuarioAReceber);
        }
        this.deleteAllByUsuario(usuarioAReceber);
        List permissoesCopiadas = this.findByIdUsuario(usuarioASerCopiado);
        List novasPermissoesUsuarioAReceber = permissoesCopiadas.stream().map(permissao -> {
            DividaUsuarioId id = DividaUsuarioId.of((Long)permissao.getId().getEntidade(), (Long)permissao.getId().getExercicio(), (Long)permissao.getId().getDivida(), (String)usuarioAReceber);
            DividaUsuario dividaUsuario = new DividaUsuario();
            dividaUsuario.setId(id);
            dividaUsuario.setInserir(permissao.getInserir());
            dividaUsuario.setCancelar(permissao.getCancelar());
            return dividaUsuario;
        }).collect(Collectors.toList());
        return PermissaoDividaUsuarioDTO.of((Usuario)usuario, (List)this.permissoesDividaRepository.saveAll(novasPermissoesUsuarioAReceber));
    }

    public List<DividaUsuario> findByIdUsuario(String usuario) {
        return this.permissoesDividaRepository.findByIdUsuario(usuario);
    }

    public void deleteAllByUsuario(String usuario) {
        List dividasUsuario = this.findByIdUsuario(usuario);
        this.permissoesDividaRepository.deleteAll((Iterable)dividasUsuario);
    }

    public void validaPermissaoDividaByUsuario(Long entidade, Long exercicio, Long divida, String usuario) {
        if (!this.possuiPermissaoDividaByUsuario(entidade, exercicio, divida, usuario).booleanValue()) {
            throw new PermissaoDividaException(HttpStatus.FORBIDDEN, String.format("Usu\u00e1rio n\u00e3o possui permiss\u00e3o na d\u00edvida: %s.", divida));
        }
    }

    public Boolean possuiPermissaoDividaByUsuario(Long entidade, Long exercicio, Long divida, String usuario) {
        if (StringUtils.isEmpty((CharSequence)usuario)) {
            throw new PermissaoDividaException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        Boolean permissaoTotalDivida = ((Usuario)this.usuarioService.findOne((Serializable)((Object)usuario))).getPermissaoTotalDivida();
        if (permissaoTotalDivida.booleanValue()) {
            return Boolean.TRUE;
        }
        DividaUsuario dividaUsuario = (DividaUsuario)this.permissoesDividaRepository.findDividaPermissaoByDividaAndUsuario(entidade, exercicio, divida, usuario).orElseThrow(() -> new PermissaoDividaException(HttpStatus.NOT_FOUND, String.format("D\u00edvida n\u00e3o encontrada no cadastro de d\u00edvida do usu\u00e1rio: %s.", usuario)));
        return dividaUsuario.getInserir();
    }
}

