/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.ParametroGeral;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.enums.cenprot.TipoSistemaProtesto;
import br.com.elotech.tributos.repository.ParametroGeralRepository;
import br.com.elotech.tributos.service.ParametroGeralService;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ParametroProtestoService {
    private final ParametroGeralRepository parametroGeralRepository;
    private final ParametroGeralService parametroGeralService;

    public List<ParametroGeral> findByParametrosProtestos() {
        List parametroGeral = this.parametroGeralRepository.findByModuloAndParametroIn(ModuloEnum.MODULO_TRIBUTARIO.getValue(), this.getValuesParametrosProtesto());
        if (parametroGeral.isEmpty()) {
            throw new EloValidationException("N\u00e3o encontrado par\u00e2metros do protesto.");
        }
        return parametroGeral;
    }

    public List<ParametroGeral> update(List<ParametroGeral> parametros) {
        parametros.forEach(parametro -> {
            if (!this.getValuesParametrosProtesto().contains(parametro.getParametro())) {
                throw new EloValidationException(String.format("O par\u00e2metro %s n\u00e3o faz parte dos par\u00e2metros do protesto.", parametro.getParametro()));
            }
        });
        this.validarExclusividadeCraECenprotms(parametros);
        return this.parametroGeralRepository.saveAll(parametros);
    }

    private void validarExclusividadeCraECenprotms(List<ParametroGeral> parametros) {
        String modulo = ModuloEnum.MODULO_TRIBUTARIO.getValue();
        Boolean craAtivo = parametros.stream().filter(p -> ParametroGeralEnum.UTILIZA_WEBSERVICE_PROTESTO.getValue().equals(p.getParametro())).findFirst().map(p -> "S".equals(p.getValor())).orElse(this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_WEBSERVICE_PROTESTO, modulo));
        Boolean cenprotmsAtivo = parametros.stream().filter(p -> ParametroGeralEnum.CENPROTMS_HABILITADO.getValue().equals(p.getParametro())).findFirst().map(p -> "S".equals(p.getValor())).orElse(this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CENPROTMS_HABILITADO, modulo));
        if (Boolean.TRUE.equals(craAtivo) && Boolean.TRUE.equals(cenprotmsAtivo)) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel ter CRA e CENPROTMS habilitados simultaneamente. Desative um dos sistemas antes de ativar o outro.");
        }
    }

    public TipoSistemaProtesto getSistemaProtestoAtivo() {
        String modulo = ModuloEnum.MODULO_TRIBUTARIO.getValue();
        if (this.isParametroAtivo(ParametroGeralEnum.UTILIZA_WEBSERVICE_PROTESTO, modulo)) {
            return TipoSistemaProtesto.CRA;
        }
        if (this.isParametroAtivo(ParametroGeralEnum.CENPROTMS_HABILITADO, modulo)) {
            return TipoSistemaProtesto.CENPROTMS;
        }
        return TipoSistemaProtesto.NENHUM;
    }

    private boolean isParametroAtivo(ParametroGeralEnum parametro, String modulo) {
        return Boolean.TRUE.equals(this.parametroGeralService.getParamValueAsBoolean(parametro, modulo));
    }

    private List<String> getValuesParametrosProtesto() {
        return Arrays.asList(ParametroGeralEnum.CODIGO_CONVENIO_PROTESTO.getValue(), ParametroGeralEnum.QTD_MAX_REMESSA_DIA_PROTESTO.getValue(), ParametroGeralEnum.SENHA_WEB_SERVICE_PROTESTO.getValue(), ParametroGeralEnum.URL_WEB_SERVICE_PROTESTO.getValue(), ParametroGeralEnum.USUARIO_WEB_SERVICE_PROTESTO.getValue(), ParametroGeralEnum.VENCIMENTO_BLOQUETO_REMESSA_PROTESTO.getValue(), ParametroGeralEnum.DIAS_BLOQ_DEB_PROTESTO.getValue(), ParametroGeralEnum.BLOQUEIA_PROTESTO_BOLETO_A_VENCER.getValue(), ParametroGeralEnum.UTILIZA_WEBSERVICE_PROTESTO.getValue(), ParametroGeralEnum.PERMITE_INFORMAR_DATA_EMISSAO_CDA.getValue(), ParametroGeralEnum.GERA_INFO_PROPRIETARIO_ARQ_REMESSA.getValue(), ParametroGeralEnum.CENPROTMS_HABILITADO.getValue(), ParametroGeralEnum.CENPROTMS_URL_WEBSERVICE.getValue(), ParametroGeralEnum.CENPROTMS_USUARIO.getValue(), ParametroGeralEnum.CENPROTMS_SENHA.getValue(), ParametroGeralEnum.CENPROTMS_APRESENTANTE.getValue(), ParametroGeralEnum.CENPROTMS_TIMEOUT.getValue());
    }

    @Generated
    public ParametroProtestoService(ParametroGeralRepository parametroGeralRepository, ParametroGeralService parametroGeralService) {
        this.parametroGeralRepository = parametroGeralRepository;
        this.parametroGeralService = parametroGeralService;
    }
}

