/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.ParametroItbi;
import br.com.elotech.tributos.domain.Tributo;
import br.com.elotech.tributos.dto.ParametroItbiDTO;
import br.com.elotech.tributos.dto.ParametroItbiFlatDTO;
import br.com.elotech.tributos.repository.ParametroItbiRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DividaService;
import br.com.elotech.tributos.service.TributoService;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ParametroItbiService
extends CrudService<ParametroItbi, Long> {
    private final ContextService contextService;
    private final DividaService dividaService;
    private final TributoService tributoService;
    private final ParametroItbiRepository parametroItbiRepository;

    public ParametroItbiFlatDTO getParametroItbiExercicioAtual() {
        Long entidade = this.contextService.getEntidadePrincipal();
        Long exercicio = this.contextService.getExercicioAtual();
        return this.parametroItbiRepository.findByEntidadeAndExercicio(entidade, exercicio);
    }

    public ParametroItbiDTO findOneDTO(Long id) {
        ParametroItbi parametroItbi = (ParametroItbi)this.findById((Serializable)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar par\u00e2metro de ITBI com id %d.", id)));
        return this.buildDTO(parametroItbi);
    }

    public Page<ParametroItbiDTO> searchDto(String filter, Pageable pageable) {
        Page searchResult = this.findByRsql(filter, pageable);
        Long entidade = this.contextService.getEntidadePrincipal();
        Long exercicio = this.contextService.getExercicioAtual();
        return searchResult.map(parametro -> this.buildDTO(parametro, entidade, exercicio));
    }

    public ParametroItbiDTO create(ParametroItbiDTO dto) {
        ParametroItbi parametro = dto.toEntity();
        this.save((EloEntity)parametro, null);
        return this.buildDTO(parametro);
    }

    private ParametroItbiDTO buildDTO(ParametroItbi parametroItbi) {
        Long entidade = this.contextService.getEntidadePrincipal();
        Long exercicio = this.contextService.getExercicioAtual();
        return this.buildDTO(parametroItbi, entidade, exercicio);
    }

    private ParametroItbiDTO buildDTO(ParametroItbi parametroItbi, Long entidade, Long exercicio) {
        ParametroItbiDTO dto = ParametroItbiDTO.from((ParametroItbi)parametroItbi);
        Divida divida = (Divida)this.dividaService.findByEntidadeAndExercicioAndDivida(entidade, exercicio, parametroItbi.getDivida()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar d\u00edvida com c\u00f3digo %d no exerc\u00edcio atual.", parametroItbi.getDivida())));
        dto.setDivida(divida);
        dto.setTributoPadrao(this.getTributo(entidade, exercicio, parametroItbi.getTributoPadrao()));
        if (Objects.nonNull(parametroItbi.getTributoAnuencia())) {
            dto.setTributoAnuencia(this.getTributo(entidade, exercicio, parametroItbi.getTributoAnuencia()));
        }
        if (Objects.nonNull(parametroItbi.getTributoAVista())) {
            dto.setTributoAVista(this.getTributo(entidade, exercicio, parametroItbi.getTributoAVista()));
        }
        if (Objects.nonNull(parametroItbi.getTributoFinanciado())) {
            dto.setTributoFinanciado(this.getTributo(entidade, exercicio, parametroItbi.getTributoFinanciado()));
        }
        return dto;
    }

    private Tributo getTributo(Long entidade, Long exercicio, String tributo) {
        return Optional.ofNullable(this.tributoService.findByEntidadeAndExercicioAndTributo(entidade, exercicio, tributo)).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar tributo com c\u00f3digo %s no exerc\u00edcio atual.", tributo)));
    }

    public void delete(Long id) {
        ParametroItbi entity = (ParametroItbi)this.findById((Serializable)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar par\u00e2metro de ITBI com id %d.", id)));
        this.delete((EloEntity)entity, null);
    }

    public ParametroItbiDTO update(Long id, ParametroItbiDTO dto) {
        ParametroItbi entity = (ParametroItbi)this.findById((Serializable)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar par\u00e2metro de ITBI com id %d.", id)));
        ParametroItbi updated = dto.toEntity(entity);
        this.save((EloEntity)updated, null);
        return this.buildDTO(updated);
    }

    @Generated
    public ParametroItbiService(ContextService contextService, DividaService dividaService, TributoService tributoService, ParametroItbiRepository parametroItbiRepository) {
        this.contextService = contextService;
        this.dividaService = dividaService;
        this.tributoService = tributoService;
        this.parametroItbiRepository = parametroItbiRepository;
    }
}

