/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.common.dto.EntidadeInfo;
import br.com.elotech.core.common.service.EntidadeService;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Exercicio;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicio;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicioEnum;
import br.com.elotech.tributos.repository.ParametroEntidadeExercicioRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.ExercicioService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityNotFoundException;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ParametroEntidadeExercicioService
extends CrudService<ParametroEntidadeExercicio, Long> {
    private final ParametroEntidadeExercicioRepository parametroEntidadeExercicioRepository;
    private final EntidadeService entidadeService;
    private final ExercicioService exercicioService;
    private final ContextService contextService;

    public ParametroEntidadeExercicio findByKey(Long entidade, Long exercicio, String modulo, String parametro) {
        return this.parametroEntidadeExercicioRepository.findByKey(entidade, exercicio, modulo, parametro);
    }

    public ParametroEntidadeExercicio findByExercicioAndModuloAndParametro(Long exercicio, String modulo, String parametro) {
        EntidadeInfo entidade = this.entidadeService.findEntidadePrincipal();
        return this.parametroEntidadeExercicioRepository.findByKey(entidade.getId(), exercicio, modulo, parametro);
    }

    public ParametroEntidadeExercicio findByModuloAndParametro(String modulo, String parametro) {
        EntidadeInfo entidade = this.entidadeService.findEntidadePrincipal();
        Long exercicio = this.exercicioService.getExercicio();
        return this.parametroEntidadeExercicioRepository.findByKey(entidade.getId(), exercicio, modulo, parametro);
    }

    public Optional<ParametroEntidadeExercicio> findByModuloAndParametro(ModuloEnum modulo, ParametroEntidadeExercicioEnum parametro) {
        return Optional.ofNullable(this.findByModuloAndParametro(modulo.getValue(), parametro.getValue()));
    }

    public ParametroEntidadeExercicio findByKeyAndValorNotEmpty(String modulo, String parametro) {
        return this.parametroEntidadeExercicioRepository.findByKeyAndValorNotEmpty(this.contextService.getEntidadePrincipal(), this.contextService.getExercicioAtual(), modulo, parametro);
    }

    public Map<String, ParametroEntidadeExercicio> findByModuloAndExercicioAndParametroIn(String modulo, List<String> parametros) {
        List list = this.parametroEntidadeExercicioRepository.findByModuloAndExercicioAndEntidadeAndParametroIn(modulo, this.contextService.getExercicioAtual(), this.contextService.getEntidadePrincipal(), parametros);
        return list.stream().collect(Collectors.toMap(ParametroEntidadeExercicio::getParametro, Function.identity()));
    }

    public ParametroEntidadeExercicio save(ParametroEntidadeExercicio parametroEntidadeExercicio) {
        Long exercicioAtual = this.contextService.getExercicioAtual();
        Long entidadePrincipal = this.contextService.getEntidadePrincipal();
        String exercicioErrorMessage = String.format("N\u00e3o foi encontrado o Exerc\u00edcio %d", exercicioAtual);
        ParametroEntidadeExercicioEnum parametroFormaPagamentoEnum = ParametroEntidadeExercicioEnum.getByParametro((String)parametroEntidadeExercicio.getParametro());
        String modulo = ModuloEnum.MODULO_TRIBUTARIO.getValue();
        Optional.ofNullable(this.parametroEntidadeExercicioRepository.findByKey(entidadePrincipal, exercicioAtual, modulo, parametroFormaPagamentoEnum.getValue())).ifPresentOrElse(parametro -> {
            parametro.setValor(parametroEntidadeExercicio.getValor());
            this.save((EloEntity)parametro, null);
        }, () -> {
            parametroEntidadeExercicio.setExercicio((Exercicio)this.exercicioService.findByExercicioAndEntidade(exercicioAtual, entidadePrincipal).orElseThrow(() -> new EntityNotFoundException(exercicioErrorMessage)));
            parametroEntidadeExercicio.setParametro(parametroFormaPagamentoEnum.getValue());
            parametroEntidadeExercicio.setDescricao(parametroFormaPagamentoEnum.getDescricao());
            parametroEntidadeExercicio.setData(this.contextService.getDataAtual());
            parametroEntidadeExercicio.setModulo(modulo);
            parametroEntidadeExercicio.setUsuario(SecurityUtils.getUserAise());
            parametroEntidadeExercicio.setObservacao(parametroEntidadeExercicio.getObservacao());
            parametroEntidadeExercicio.setId(((ParametroEntidadeExercicio)this.save((EloEntity)parametroEntidadeExercicio, null)).getId());
        });
        return parametroEntidadeExercicio;
    }

    @Generated
    public ParametroEntidadeExercicioService(ParametroEntidadeExercicioRepository parametroEntidadeExercicioRepository, EntidadeService entidadeService, ExercicioService exercicioService, ContextService contextService) {
        this.parametroEntidadeExercicioRepository = parametroEntidadeExercicioRepository;
        this.entidadeService = entidadeService;
        this.exercicioService = exercicioService;
        this.contextService = contextService;
    }
}

