/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamento;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoDescontoDivida;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoDescontoParcela;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoDescontoParcelaId;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoEntrada;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoEntradaId;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoUsuario;
import br.com.elotech.tributos.dto.ParamParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.FiltroDebitoAbertoDTO;
import br.com.elotech.tributos.params.FiltroDebitoParams;
import br.com.elotech.tributos.repository.parcelamento.ParamParcelamentoRepository;
import br.com.elotech.tributos.repository.parcelamento.ParamParcelamentoUsuarioRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import java.util.Comparator;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class ParamParcelamentoService
extends CrudService<ParamParcelamento, Long> {
    private final ParamParcelamentoRepository paramParcelamentoRepository;
    private final ParamParcelamentoUsuarioRepository paramParcelamentoUsuarioRepository;

    public ParamParcelamentoService(ParamParcelamentoRepository paramParcelamentoRepository, ParamParcelamentoUsuarioRepository paramParcelamentoUsuarioRepository) {
        this.paramParcelamentoRepository = paramParcelamentoRepository;
        this.paramParcelamentoUsuarioRepository = paramParcelamentoUsuarioRepository;
    }

    public List<FiltroDebitoAbertoDTO> testeScriptFiltroDebito(FiltroDebitoParams params) {
        return this.paramParcelamentoRepository.testeScriptFiltroDebito(params);
    }

    public Page<ParamParcelamento> findParametrosByPermissaoUsuario(Pageable pageable) {
        String usuarioAise = SecurityUtils.getUserAise();
        List<ParamParcelamento> resultado = this.paramParcelamentoUsuarioRepository.findByIdUsuario(usuarioAise).stream().map(ParamParcelamentoUsuario::getParametroParcelamento).sorted(Comparator.comparing(ParamParcelamento::getId)).toList();
        return new PageImpl(resultado, pageable, (long)resultado.size());
    }

    protected void beforeSave(ParamParcelamento entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        this.processarEntradas(entity);
        this.processarParcelasSituacao(entity);
        this.processarParcelasPorValor(entity);
        this.processarDescontosPorParcela(entity);
        this.processarDescontosPorDivida(entity);
        this.processarOutrasTaxas(entity);
        this.processarValoresMinimos(entity);
    }

    private void processarEntradas(ParamParcelamento entity) {
        entity.getEntradas().forEach(entrada -> {
            this.inicializarIdEntrada(entrada, entity);
            this.validarConfiguracaoDataCompleta(entrada);
            this.vincularJurosEPercentuais(entrada);
        });
    }

    private void inicializarIdEntrada(ParamParcelamentoEntrada entrada, ParamParcelamento entity) {
        if (entrada.getId() == null) {
            entrada.setId(new ParamParcelamentoEntradaId());
        }
        entrada.getId().setParametroParcelamento(entity);
        if (entrada.getId().getEntrada() == null) {
            entrada.getId().setEntrada(entity.getNumeroProximaEntrada());
        }
    }

    private void validarConfiguracaoDataCompleta(ParamParcelamentoEntrada entrada) {
        if (!Boolean.TRUE.equals(entrada.getUtilizaDataCompletaEntrada())) {
            return;
        }
        this.validarNaoUtilizaDataFixa(entrada);
        this.validarDataCompletaPreenchida(entrada);
    }

    private void validarNaoUtilizaDataFixa(ParamParcelamentoEntrada entrada) {
        if (Boolean.TRUE.equals(entrada.getUtilizaDataFixaEntrada())) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel utilizar 'Data Completa' e 'Data Fixa' simultaneamente. Desmarque 'Utiliza data fixa' para usar data completa.");
        }
    }

    private void validarDataCompletaPreenchida(ParamParcelamentoEntrada entrada) {
        if (entrada.getDataCompletaEntrada() == null) {
            throw new EloValidationException("Quando 'Utilizar Data Completa' est\u00e1 ativo, \u00e9 obrigat\u00f3rio informar a data completa de entrada.");
        }
    }

    private void vincularJurosEPercentuais(ParamParcelamentoEntrada entrada) {
        entrada.getJuros().forEach(juros -> juros.setEntrada(entrada));
        entrada.getPercentuaisEntrada().forEach(percentualEntrada -> percentualEntrada.setEntrada(entrada));
    }

    private void processarParcelasSituacao(ParamParcelamento entity) {
        entity.getParcelasSituacao().forEach(parcela -> {
            if (parcela.getId().getParametroParcelamento() == null) {
                parcela.getId().setParametroParcelamento(entity);
            }
        });
    }

    private void processarParcelasPorValor(ParamParcelamento entity) {
        entity.getParcelasPorValor().forEach(parcela -> {
            if (parcela.getId().getParametroParcelamento() == null) {
                parcela.getId().setParametroParcelamento(entity);
            }
        });
    }

    private void processarDescontosPorParcela(ParamParcelamento entity) {
        entity.getDescontosPorParcela().forEach(desconto -> this.inicializarIdDesconto(desconto, entity));
    }

    private void inicializarIdDesconto(ParamParcelamentoDescontoParcela desconto, ParamParcelamento entity) {
        if (desconto.getId() == null) {
            desconto.setId(new ParamParcelamentoDescontoParcelaId());
        }
        desconto.getId().setParametroParcelamento(entity);
        if (desconto.getId().getSequencia() == null) {
            desconto.getId().setSequencia(entity.getSequenciaProximoDescontoPorParcela());
        }
    }

    private void processarDescontosPorDivida(ParamParcelamento entity) {
        entity.getDescontosPorDivida().forEach(desconto -> {
            desconto.setParametroParcelamento(entity);
            this.vincularReceitasAoDesconto(desconto);
        });
    }

    private void vincularReceitasAoDesconto(ParamParcelamentoDescontoDivida desconto) {
        desconto.getReceitas().forEach(tributo -> tributo.setParametroParcelamentoDescontoGuia(desconto));
    }

    private void processarOutrasTaxas(ParamParcelamento entity) {
        entity.getOutrasTaxas().forEach(outraTaxa -> outraTaxa.setParamParcelamento(entity));
    }

    private void processarValoresMinimos(ParamParcelamento entity) {
        entity.getValoresMinimos().forEach(valorMinimo -> valorMinimo.setParamParcelamento(entity));
    }

    public List<ParamParcelamento> findByDisponivelCidadao() {
        return this.paramParcelamentoRepository.findByDisponivelCidadaoTrue();
    }

    public ParamParcelamentoDTO salvarParametroParcelamentoCidadao(ParamParcelamentoDTO paramParcelamentoDTO) {
        ParamParcelamento paramParcelamento = (ParamParcelamento)this.paramParcelamentoRepository.findById((Object)paramParcelamentoDTO.getId()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel carregar o Par\u00e2metro Parcelamento com id %d", paramParcelamentoDTO.getId())));
        paramParcelamento.setDescricao(paramParcelamentoDTO.getDescricao());
        paramParcelamento.setDisponivelCidadao(paramParcelamentoDTO.getDisponivelCidadao());
        paramParcelamento.setTermoConfissaoDivida(paramParcelamentoDTO.getTermoConfissaoDivida());
        paramParcelamento.setAtivo(paramParcelamentoDTO.getAtivo());
        return ((ParamParcelamento)this.paramParcelamentoRepository.save((Object)paramParcelamento)).toDto();
    }
}

