/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.BoletoDebito;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoObservacao;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaObservacao;
import br.com.elotech.tributos.domain.EstornoPagamento;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.PagamentoBoleto;
import br.com.elotech.tributos.domain.PagamentoDebito;
import br.com.elotech.tributos.domain.PagamentoId;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoArquivoRetornoPagamento;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalhe;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalheId;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.domain.pagamentocredito.PagamentoCredito;
import br.com.elotech.tributos.domain.tipomensagem.ClassificacaoTipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagemEnum;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoParcelaPagamentoDTO;
import br.com.elotech.tributos.dto.FiltroPagamentoDTO;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.dto.fintel.FetchBoletoFintelResourcesDTO;
import br.com.elotech.tributos.dto.fintel.GeracaoDebitoEBoletoFintelResponse;
import br.com.elotech.tributos.dto.pagamento.EstornoPagamentoDTO;
import br.com.elotech.tributos.dto.pagamento.EstornoPagamentoItemSelecionadoDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoARestituirDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoResumoDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoTotalizadoresDTO;
import br.com.elotech.tributos.enums.pagamentocredito.OrigemCredito;
import br.com.elotech.tributos.repository.PagamentoRepository;
import br.com.elotech.tributos.service.BaixaAutomaticaDetalheService;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.EstornoPagamentoService;
import br.com.elotech.tributos.service.LaudoMaringaService;
import br.com.elotech.tributos.service.PagamentoDebitoService;
import br.com.elotech.tributos.service.PagamentoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.ProcessaPagamentoLoteLaudoService;
import br.com.elotech.tributos.service.ProcessaPagamentoLoteSiafiService;
import br.com.elotech.tributos.service.ProcessaPagamentoLoteSuperSimplesService;
import br.com.elotech.tributos.service.TipoMensagemService;
import br.com.elotech.tributos.service.honorarios.GerarHonorarioBloquetoService;
import br.com.elotech.tributos.service.integracaofintel.IntegracaoFintelService;
import br.com.elotech.tributos.service.pagamentocredito.CreditoService;
import br.com.elotech.tributos.util.UsuarioUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PagamentoService
extends CrudService<Pagamento, PagamentoId> {
    private final PagamentoRepository pagamentoRepository;
    private final ContextService contextService;
    private final DebitoParcelaService debitoParcelaService;
    private final PagamentoDebitoService pagamentoDebitoService;
    private final ProcessaPagamentoLoteSuperSimplesService processaPagamentoLoteSuperSimplesService;
    private final ProcessaPagamentoLoteSiafiService processaPagamentoLoteSiafiService;
    private final ProcessaPagamentoLoteLaudoService processaPagamentoLoteLaudoService;
    private final BloquetoService bloquetoService;
    private final TipoMensagemService tipoMensagemService;
    private final BaixaAutomaticaDetalheService baixaAutomaticaDetalheService;
    private final DebitoService debitoService;
    private final ParametroGeralService parametroGeralService;
    private final CreditoService creditoService;
    private final EstornoPagamentoService estornoPagamentoService;
    private final GerarHonorarioBloquetoService gerarHonorarioBloquetoService;
    private final IntegracaoFintelService integracaoFintelService;
    private final LaudoMaringaService laudoMaringaService;

    public Page<PagamentoDTO> searchPagamentoDTO(FiltroPagamentoDTO filtroPagamentoDTO, Pageable pageable) {
        return this.pagamentoRepository.findPagamentosDTO(this.contextService.getEntidadePrincipal(), filtroPagamentoDTO, pageable);
    }

    public PagamentoTotalizadoresDTO searchPagamentoTotalizadores(FiltroPagamentoDTO filtroPagamentoDTO) {
        return this.pagamentoRepository.findPagamentosTotalizadores(this.contextService.getEntidadePrincipal(), filtroPagamentoDTO);
    }

    public List<Pagamento> searchPagamentos(FiltroPagamentoDTO filtroPagamentoDTO) {
        return this.pagamentoRepository.findPagamentos(this.contextService.getEntidadePrincipal(), filtroPagamentoDTO);
    }

    public PagamentoResumoDTO getPagamentoById(Long entidade, Long exercicioPagamento, Long pagamento) {
        Pagamento pagamentoEntity = this.findPagamentoById(entidade, exercicioPagamento, pagamento);
        return PagamentoResumoDTO.of((Pagamento)pagamentoEntity);
    }

    public List<DebitoParcelaPagamentoDTO> loadDebitoParcelaPagamento(Debito debito, Long parcela) {
        return this.pagamentoRepository.loadDebitoParcelaPagamento(debito, parcela);
    }

    public Pagamento findPagamentoById(Long entidade, Long exercicioPagamento, Long pagamento) {
        PagamentoId id = PagamentoId.of((Long)entidade, (Long)exercicioPagamento, (Long)pagamento);
        return (Pagamento)this.findById((Serializable)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o pagamento %d/%d", exercicioPagamento, pagamento)));
    }

    public Pagamento geraPagamento(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe) {
        Pagamento pagamentoSalvo = this.createPagamento(baixaAutomaticaDetalhe);
        PagamentoBoleto pagamentoBoleto = pagamentoSalvo.getPagamentoBoleto();
        this.pagarParcelas(pagamentoBoleto.getPagamentosDebito());
        pagamentoBoleto.getBoleto().setPago(Boolean.TRUE);
        return (Pagamento)this.pagamentoRepository.save((Object)pagamentoSalvo);
    }

    private BaixaAutomaticaDetalhe geraCreditoPagamentoAMaior(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe, OrigemCredito origemCredito) {
        PagamentoCredito pagamentoCredito = this.creditoService.novoCredito(baixaAutomaticaDetalhe.getPagamento(), origemCredito);
        baixaAutomaticaDetalhe.setPagamentoCredito(pagamentoCredito);
        baixaAutomaticaDetalhe.setCreditoConcedido(Boolean.TRUE);
        PagamentoBoleto pagamentoBoleto = baixaAutomaticaDetalhe.getPagamento().getPagamentoBoleto();
        pagamentoBoleto.getPagamentosDebito().forEach(pagamentoDebito -> pagamentoDebito.setValorPagoMaior(BigDecimal.ZERO));
        baixaAutomaticaDetalhe.getPagamento().setValorPago(baixaAutomaticaDetalhe.getPagamento().getValorPago().subtract(baixaAutomaticaDetalhe.getPagamento().getValorPagoAMaior()));
        baixaAutomaticaDetalhe.getPagamento().setValorPagoAMaior(BigDecimal.ZERO);
        baixaAutomaticaDetalhe.setPagamento((Pagamento)this.pagamentoRepository.save((Object)baixaAutomaticaDetalhe.getPagamento()));
        return (BaixaAutomaticaDetalhe)this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
    }

    private BaixaAutomaticaDetalhe geraPagamentoDuplicadoCredito(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe) {
        Boolean geraCredito = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.PAGAMENTO_DUPLICADO_GERA_CREDITO);
        if (Boolean.FALSE.equals(geraCredito) && Boolean.FALSE.equals(baixaAutomaticaDetalhe.getCreditoConcedido())) {
            return baixaAutomaticaDetalhe;
        }
        EstornoPagamentoItemSelecionadoDTO pagamentoSelecionado = new EstornoPagamentoItemSelecionadoDTO();
        pagamentoSelecionado.setExercicio(baixaAutomaticaDetalhe.getPagamento().getId().getExercicioPagamento());
        pagamentoSelecionado.setPagamento(baixaAutomaticaDetalhe.getPagamento().getId().getPagamento());
        EstornoPagamentoDTO estornoPagamentoDTO = new EstornoPagamentoDTO();
        estornoPagamentoDTO.setTodosSelecionados(Boolean.FALSE);
        estornoPagamentoDTO.setSelecionados(Collections.singletonList(pagamentoSelecionado));
        estornoPagamentoDTO.setData(LocalDate.now());
        estornoPagamentoDTO.setMotivoEstorno("Gera\u00e7\u00e3o de Cr\u00e9dito por Pagamento em Duplicidade");
        estornoPagamentoDTO.setUtilizarComoCredito(Boolean.valueOf(true));
        estornoPagamentoDTO.setPagamentoDuplicado(Boolean.valueOf(true));
        estornoPagamentoDTO.setValidaAcertoDePagamento(Boolean.valueOf(false));
        EstornoPagamento estornoPagamento = this.estornoPagamentoService.estornarPagamentoIndividual(estornoPagamentoDTO);
        baixaAutomaticaDetalhe.setPagamentoCredito(estornoPagamento.getPagamentoCredito());
        baixaAutomaticaDetalhe.setCreditoConcedido(Boolean.TRUE);
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.CREDITO_LANCADO);
        baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
        baixaAutomaticaDetalhe.setMensagem(String.format(TipoMensagemEnum.CREDITO_LANCADO.getDescricao(), baixaAutomaticaDetalhe.getPagamentoCredito().getId()));
        baixaAutomaticaDetalhe.setSituacao(ClassificacaoTipoMensagem.CREDITO_CONTRIBUINTE);
        return (BaixaAutomaticaDetalhe)this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
    }

    private BaixaAutomaticaDetalhe geraPagamentoNormal(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe) {
        baixaAutomaticaDetalhe.setPagamento(this.geraPagamento(baixaAutomaticaDetalhe));
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.PAGO_COM_SUCESSO);
        baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
        baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
        baixaAutomaticaDetalhe.setMensagemPagoComSucesso(baixaAutomaticaDetalhe.getBoleto(), baixaAutomaticaDetalhe.getPagamento());
        this.generateObservacoesBaixaAutomatica(baixaAutomaticaDetalhe);
        return (BaixaAutomaticaDetalhe)this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
    }

    public Pagamento geraPagamentoBaixaManual(PagamentoLote pagamentoLote, Bloqueto boleto, Boolean calcularAcrescimos, Long sequenciaLote) {
        return this.geraPagamentoBaixaGenerico(pagamentoLote, boleto, calcularAcrescimos, null, sequenciaLote);
    }

    public Pagamento geraPagamentoBaixaGenerico(PagamentoLote pagamentoLote, Bloqueto boleto, Boolean calcularAcrescimos, String usuario, Long sequenciaLote) {
        if (Boolean.TRUE.equals(calcularAcrescimos)) {
            this.bloquetoService.calcularAcrescimos(boleto, pagamentoLote.getDataMovimento(), Optional.empty());
        }
        Pagamento pagamentoSalvo = this.createPagamentoBaixaManual(pagamentoLote, boleto, usuario, sequenciaLote);
        PagamentoBoleto pagamentoBoleto = pagamentoSalvo.getPagamentoBoleto();
        this.pagarParcelas(pagamentoBoleto.getPagamentosDebito());
        pagamentoBoleto.getBoleto().setPago(Boolean.TRUE);
        return (Pagamento)this.pagamentoRepository.save((Object)pagamentoSalvo);
    }

    private Pagamento createPagamento(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe) {
        PagamentoLote pagamentoLote = baixaAutomaticaDetalhe.getPagamentoLote();
        PagamentoId pagamentoId = new PagamentoId();
        pagamentoId.setEntidade(baixaAutomaticaDetalhe.getId().getEntidade());
        pagamentoId.setExercicioPagamento(baixaAutomaticaDetalhe.getId().getExercicio());
        Pagamento pagamento = new Pagamento();
        pagamento.setId(pagamentoId);
        pagamento.setLote(pagamentoLote);
        pagamento.setSequenciaLote(baixaAutomaticaDetalhe.getId().getSequenciaArquivo());
        pagamento.setContaBancaria(pagamentoLote.getContaBancaria());
        pagamento.setBanco(pagamentoLote.getBanco());
        pagamento.setDataMovimento(Boolean.TRUE.equals(this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CONTABILIZA_REGIME_DATA_PAGAMENTO)) ? baixaAutomaticaDetalhe.getDataPagamento() : pagamentoLote.getDataMovimento());
        pagamento.setDataPagamento(baixaAutomaticaDetalhe.getDataPagamento());
        pagamento.setDataCredito(baixaAutomaticaDetalhe.getDataCredito());
        pagamento.setDataBaixa(LocalDate.now());
        pagamento.setValorPago(baixaAutomaticaDetalhe.getValorPago());
        pagamento.setUsuario(UsuarioUtils.getUsuarioAise());
        PagamentoBoleto pagamentoBoleto = new PagamentoBoleto();
        pagamentoBoleto.setBoleto(baixaAutomaticaDetalhe.getBoleto());
        pagamentoBoleto.setPagamento(pagamento);
        pagamentoBoleto.setMotivoDeducao(baixaAutomaticaDetalhe.getBoleto().getMotivoDeducao());
        pagamento.setPagamentoBoleto(pagamentoBoleto);
        Pagamento pagamentoSalvo = (Pagamento)this.pagamentoRepository.save((Object)pagamento);
        PagamentoBoleto pagamentoBoletoSalvo = pagamentoSalvo.getPagamentoBoleto();
        pagamentoBoletoSalvo.getPagamentosDebito().addAll(baixaAutomaticaDetalhe.getBoleto().getDebitos().stream().map(boletoDebito -> PagamentoDebito.from((BoletoDebito)boletoDebito, (Long)pagamentoBoletoSalvo.getId())).collect(Collectors.toList()));
        return pagamentoSalvo;
    }

    public void generateObservacoesBaixaAutomatica(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe) {
        Pagamento pagamento = baixaAutomaticaDetalhe.getPagamento();
        String mensagem = baixaAutomaticaDetalhe.getMensagem();
        baixaAutomaticaDetalhe.getBoleto().getDebitos().stream().collect(Collectors.groupingBy(boletoDebito -> boletoDebito.getId().getDebitoParcelaTributo().getDebitoParcela())).forEach((debitoParcela, boletoDebitos) -> {
            String mensagemBaixaAutomatica = this.buildMensagemPagamentoBaixaAutomatica(debitoParcela.getId().getParcela(), pagamento, mensagem);
            this.addDebitoParcelaObservacao(debitoParcela, mensagemBaixaAutomatica);
            this.addDebitoObservacao(debitoParcela, mensagemBaixaAutomatica);
        });
    }

    private void addDebitoParcelaObservacao(DebitoParcela debitoParcela, String mensagemBaixaAutomatica) {
        DebitoParcelaObservacao parcelaObservacao = DebitoParcelaObservacao.from((DebitoParcela)debitoParcela, (String)mensagemBaixaAutomatica);
        debitoParcela.getObservacoes().add(parcelaObservacao);
    }

    private void addDebitoObservacao(DebitoParcela debitoParcela, String mensagemBaixaAutomatica) {
        DebitoObservacao debitoObservacao = DebitoObservacao.from((Debito)debitoParcela.getDebito(), (String)mensagemBaixaAutomatica);
        debitoParcela.getDebito().getObservacoes().add(debitoObservacao);
    }

    private String buildMensagemPagamentoBaixaAutomatica(Long numeroParcela, Pagamento pagamento, String mensagemBaixaAutomatica) {
        return String.format("Pagamento realizado pela Baixa Autom\u00e1tica, Parcela %d, Sequ\u00eancia %d do Lote %d/%d. %s", numeroParcela, pagamento.getSequenciaLote(), pagamento.getLote().getId().getLote(), pagamento.getLote().getId().getExercicio(), mensagemBaixaAutomatica);
    }

    private Pagamento createPagamentoBaixaManual(PagamentoLote pagamentoLote, Bloqueto boleto, String usuario, Long sequenciaLote) {
        PagamentoId pagamentoId = new PagamentoId();
        pagamentoId.setEntidade(boleto.getEntidade());
        pagamentoId.setExercicioPagamento(boleto.getExercicioBloqueto());
        Pagamento pagamento = new Pagamento();
        pagamento.setId(pagamentoId);
        pagamento.setLote(pagamentoLote);
        pagamento.setContaBancaria(pagamentoLote.getContaBancaria());
        pagamento.setBanco(pagamentoLote.getBanco());
        pagamento.setDataMovimento(pagamentoLote.getDataMovimento());
        pagamento.setDataPagamento(pagamentoLote.getDataMovimento());
        pagamento.setDataCredito(pagamentoLote.getDataCredito());
        pagamento.setDataBaixa(LocalDate.now());
        pagamento.setValorPago(boleto.getValorBloqueto());
        pagamento.setUsuario(this.getUsuarioPagamento(usuario));
        pagamento.setSequenciaLote(sequenciaLote);
        PagamentoBoleto pagamentoBoleto = new PagamentoBoleto();
        pagamentoBoleto.setBoleto(boleto);
        pagamentoBoleto.setPagamento(pagamento);
        pagamentoBoleto.setMotivoDeducao(boleto.getMotivoDeducao());
        pagamento.setPagamentoBoleto(pagamentoBoleto);
        Pagamento pagamentoSalvo = (Pagamento)this.pagamentoRepository.save((Object)pagamento);
        PagamentoBoleto pagamentoBoletoSalvo = pagamentoSalvo.getPagamentoBoleto();
        pagamentoBoletoSalvo.getPagamentosDebito().addAll(boleto.getDebitos().stream().map(boletoDebito -> PagamentoDebito.from((BoletoDebito)boletoDebito, (Long)pagamentoBoletoSalvo.getId())).collect(Collectors.toList()));
        return pagamentoSalvo;
    }

    public String getUsuarioPagamento(String usuario) {
        if (Objects.isNull(usuario)) {
            return UsuarioUtils.getUsuarioAise();
        }
        return usuario;
    }

    private void pagarParcelas(List<PagamentoDebito> pagamentoDebitos) {
        pagamentoDebitos.stream().map(pagamentoDebito -> pagamentoDebito.getId().getDebitoParcelaTributo().getDebitoParcela()).distinct().forEach(arg_0 -> ((DebitoParcelaService)this.debitoParcelaService).pagarParcela(arg_0));
    }

    private BaixaAutomaticaDetalhe geraPagamentoComDesconto(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe) {
        Pagamento pagamento = this.geraPagamento(baixaAutomaticaDetalhe);
        PagamentoBoleto pagamentoBoleto = pagamento.getPagamentoBoleto();
        this.pagamentoDebitoService.aplicaDescontosNaBaixa(pagamentoBoleto.getPagamentosDebito(), baixaAutomaticaDetalhe.getValorDesconto());
        pagamentoBoleto.setMotivoDeducao(baixaAutomaticaDetalhe.getMotivoDeducao());
        baixaAutomaticaDetalhe.setPagamento((Pagamento)this.pagamentoRepository.save((Object)pagamento));
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.PAGO_COM_DESCONTO_CONCEDIDO);
        baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
        baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
        baixaAutomaticaDetalhe.setMensagemPagoComDesconto(baixaAutomaticaDetalhe.getBoleto(), baixaAutomaticaDetalhe.getPagamento());
        this.generateObservacoesBaixaAutomatica(baixaAutomaticaDetalhe);
        return (BaixaAutomaticaDetalhe)this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
    }

    private BaixaAutomaticaDetalhe geraPagamentoAMaior(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe) {
        Pagamento pagamento = this.geraPagamento(baixaAutomaticaDetalhe);
        PagamentoBoleto pagamentoBoleto = pagamento.getPagamentoBoleto();
        BigDecimal valorPagoAMaior = baixaAutomaticaDetalhe.getValorPagoAMaior();
        this.pagamentoDebitoService.atualizaValorAMaior(pagamentoBoleto.getPagamentosDebito(), valorPagoAMaior);
        pagamento.setValorPagoAMaior(valorPagoAMaior);
        baixaAutomaticaDetalhe.setPagamento((Pagamento)this.pagamentoRepository.save((Object)pagamento));
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.PAGO_COM_SUCESSO);
        baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
        baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
        baixaAutomaticaDetalhe.setMensagemPagoComSucesso(baixaAutomaticaDetalhe.getBoleto(), baixaAutomaticaDetalhe.getPagamento());
        this.generateObservacoesBaixaAutomatica(baixaAutomaticaDetalhe);
        return (BaixaAutomaticaDetalhe)this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
    }

    private BaixaAutomaticaDetalhe geraPagamentoAMaiorCredito(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe) {
        if (Boolean.FALSE.equals(baixaAutomaticaDetalhe.getCreditoConcedido())) {
            return baixaAutomaticaDetalhe;
        }
        return this.geraCreditoPagamentoAMaior(baixaAutomaticaDetalhe, OrigemCredito.PAGO_MAIOR);
    }

    private BaixaAutomaticaDetalhe geraPagamentoAMenor(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe) {
        Pagamento pagamento = this.createPagamento(baixaAutomaticaDetalhe);
        PagamentoBoleto pagamentoBoleto = pagamento.getPagamentoBoleto();
        this.pagamentoDebitoService.atualizaValorAMenor(pagamentoBoleto.getPagamentosDebito(), baixaAutomaticaDetalhe.getValorPago());
        pagamento.setPagoAMenor(Boolean.TRUE);
        baixaAutomaticaDetalhe.setPagamento((Pagamento)this.pagamentoRepository.save((Object)pagamento));
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.PAGO_COM_SUCESSO);
        baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
        baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
        baixaAutomaticaDetalhe.setMensagemPagoAMenor(baixaAutomaticaDetalhe.getBoleto(), baixaAutomaticaDetalhe.getPagamento());
        return (BaixaAutomaticaDetalhe)this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
    }

    @Nullable
    public BaixaAutomaticaDetalhe verifyPagoEmDuplicidadeAndChangeSituacao(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe, Long idBoleto) {
        if (Boolean.TRUE.equals(this.existePagamentoNaoEstornadoByIdBoleto(idBoleto))) {
            TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.BOLETO_PAGO_DUPLICIDADE);
            baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
            baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
            baixaAutomaticaDetalhe.setMensagem(TipoMensagemEnum.BOLETO_PAGO_DUPLICIDADE.getDescricao());
            return baixaAutomaticaDetalhe;
        }
        return null;
    }

    public Boolean existePagamentoNaoEstornadoByIdBoleto(Long idBoleto) {
        return this.pagamentoRepository.existePagamentoNaoEstornadoByIdBoleto(idBoleto);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public BaixaAutomaticaDetalhe geraPagamentoBaixaAutomatica(BaixaAutomaticaDetalheId id) {
        return this.geraPagamentoBaixaAutomatica(id, null);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public BaixaAutomaticaDetalhe geraPagamentoBaixaAutomatica(BaixaAutomaticaDetalheId id, ListasNecessariasCalculaAcrescimoDTO parametrosAcrescimos) {
        String NOSSO_NUMERO_FINTEL = "4444";
        BaixaAutomaticaDetalhe baixaAutomaticaDetalhe = (BaixaAutomaticaDetalhe)this.baixaAutomaticaDetalheService.findOne((Serializable)id);
        baixaAutomaticaDetalhe.verificaCodigoDebitoAutomaticoInconsistente();
        TipoMensagemEnum tipoMensagemAtual = TipoMensagemEnum.fromValue((Long)baixaAutomaticaDetalhe.getTipoMensagem().getId());
        if (Objects.nonNull(baixaAutomaticaDetalhe.getBoleto()) && !TipoMensagemEnum.BOLETO_PAGO_DUPLICIDADE.equals((Object)tipoMensagemAtual) && !TipoMensagemEnum.CREDITO_LANCADO.equals((Object)tipoMensagemAtual)) {
            this.verifyPagoEmDuplicidadeAndChangeSituacao(baixaAutomaticaDetalhe, baixaAutomaticaDetalhe.getBoleto().getId());
        }
        if (TipoArquivoRetornoPagamento.SUPER_SIMPLES.equals((Object)baixaAutomaticaDetalhe.getPagamentoLote().getTipoArquivo()) && Objects.isNull(baixaAutomaticaDetalhe.getBoleto())) {
            this.processaPagamentoLoteSuperSimplesService.gerarDebitoEBoleto(baixaAutomaticaDetalhe);
            baixaAutomaticaDetalhe = (BaixaAutomaticaDetalhe)this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
        }
        if (TipoArquivoRetornoPagamento.SIAFI.equals((Object)baixaAutomaticaDetalhe.getPagamentoLote().getTipoArquivo())) {
            this.processaPagamentoLoteSiafiService.gerarDebitoEBoleto(baixaAutomaticaDetalhe);
            baixaAutomaticaDetalhe = (BaixaAutomaticaDetalhe)this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
        }
        if (this.getIntegradoFintel() && baixaAutomaticaDetalhe.getNossoNumero().startsWith("4444")) {
            FetchBoletoFintelResourcesDTO fetchBoletoFintel = FetchBoletoFintelResourcesDTO.from((BaixaAutomaticaDetalhe)baixaAutomaticaDetalhe);
            GeracaoDebitoEBoletoFintelResponse response = this.integracaoFintelService.processar().gerarDebitoEBoleto(fetchBoletoFintel);
            baixaAutomaticaDetalhe.setResponseProcessamentoFintel(response);
            baixaAutomaticaDetalhe = (BaixaAutomaticaDetalhe)this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
        }
        if (this.laudoMaringaService.isIntegradoLaudo() && this.laudoMaringaService.isNossoNumeroLaudo(baixaAutomaticaDetalhe.getNossoNumero())) {
            this.processaPagamentoLoteLaudoService.gerarDebitoEBoleto(baixaAutomaticaDetalhe);
            baixaAutomaticaDetalhe = (BaixaAutomaticaDetalhe)this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
        }
        this.gerarHonorarioBloquetoService.gerarDebitoAndBoletoDebitoHonorarioByBoleto(baixaAutomaticaDetalhe.getBoleto());
        this.bloquetoService.calcularAcrescimos(baixaAutomaticaDetalhe.getBoleto(), baixaAutomaticaDetalhe.getDataPagamento(), Optional.ofNullable(parametrosAcrescimos));
        Long idTipoMensagem = baixaAutomaticaDetalhe.getTipoMensagem().getId();
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$tipomensagem$TipoMensagemEnum[TipoMensagemEnum.fromValue((Long)idTipoMensagem).ordinal()]) {
            case 1: 
            case 2: {
                return this.geraPagamentoComDesconto(baixaAutomaticaDetalhe);
            }
            case 3: {
                return this.geraPagamentoAMaiorCredito(this.geraPagamentoAMaior(baixaAutomaticaDetalhe));
            }
            case 4: {
                return this.geraPagamentoAMenor(baixaAutomaticaDetalhe);
            }
            case 5: {
                return this.geraPagamentoDuplicadoCredito(this.geraPagamentoNormal(baixaAutomaticaDetalhe));
            }
            case 6: {
                return this.geraPagamentoNormal(baixaAutomaticaDetalhe);
            }
        }
        throw new EloValidationException("Situa\u00e7\u00e3o inv\u00e1lida para baixa.");
    }

    public List<DebitoIdDTO> findIdDebitoItbiListByPagamento(Pagamento pagamento) {
        return this.pagamentoRepository.findIdDebitoItbiListByPagamento(pagamento.getId().getEntidade(), pagamento.getId().getExercicioPagamento(), pagamento.getId().getPagamento());
    }

    public List<Long> findIdDebitoNaoConstituidoByPagamento(Pagamento pagamento) {
        return this.pagamentoRepository.findIdDebitoNaoConstituidoByPagamento(pagamento.getId().getEntidade(), pagamento.getId().getExercicioPagamento(), pagamento.getId().getPagamento());
    }

    public void constituirDebitosDoPagamento(Pagamento pagamento) {
        this.findIdDebitoNaoConstituidoByPagamento(pagamento).stream().map(arg_0 -> ((DebitoService)this.debitoService).findOne(arg_0)).forEach(debito -> {
            debito.setConstituido(Boolean.TRUE);
            debito.setDataContabilizacao(pagamento.getDataMovimento());
            this.debitoService.save(debito);
        });
    }

    public List<Pagamento> buscarPagamentosPorPagamentoLoteId(PagamentoLoteId pagamentoLoteId) {
        return this.pagamentoRepository.findByLoteId(pagamentoLoteId);
    }

    public PagamentoARestituirDTO findPagamentoParaRestituir(PagamentoId id) {
        Optional pagamento = this.findById((Serializable)id);
        return pagamento.map(PagamentoARestituirDTO::from).orElse(null);
    }

    private boolean getIntegradoFintel() {
        return this.integracaoFintelService.isIntegradoFintel();
    }

    public Page<Pagamento> findPagamentosParaEstorno(String search, Pageable page) {
        return this.pagamentoRepository.findPagamentosParaEstorno(search, page);
    }

    @Generated
    public PagamentoService(PagamentoRepository pagamentoRepository, ContextService contextService, DebitoParcelaService debitoParcelaService, PagamentoDebitoService pagamentoDebitoService, ProcessaPagamentoLoteSuperSimplesService processaPagamentoLoteSuperSimplesService, ProcessaPagamentoLoteSiafiService processaPagamentoLoteSiafiService, ProcessaPagamentoLoteLaudoService processaPagamentoLoteLaudoService, BloquetoService bloquetoService, TipoMensagemService tipoMensagemService, BaixaAutomaticaDetalheService baixaAutomaticaDetalheService, DebitoService debitoService, ParametroGeralService parametroGeralService, CreditoService creditoService, EstornoPagamentoService estornoPagamentoService, GerarHonorarioBloquetoService gerarHonorarioBloquetoService, IntegracaoFintelService integracaoFintelService, LaudoMaringaService laudoMaringaService) {
        this.pagamentoRepository = pagamentoRepository;
        this.contextService = contextService;
        this.debitoParcelaService = debitoParcelaService;
        this.pagamentoDebitoService = pagamentoDebitoService;
        this.processaPagamentoLoteSuperSimplesService = processaPagamentoLoteSuperSimplesService;
        this.processaPagamentoLoteSiafiService = processaPagamentoLoteSiafiService;
        this.processaPagamentoLoteLaudoService = processaPagamentoLoteLaudoService;
        this.bloquetoService = bloquetoService;
        this.tipoMensagemService = tipoMensagemService;
        this.baixaAutomaticaDetalheService = baixaAutomaticaDetalheService;
        this.debitoService = debitoService;
        this.parametroGeralService = parametroGeralService;
        this.creditoService = creditoService;
        this.estornoPagamentoService = estornoPagamentoService;
        this.gerarHonorarioBloquetoService = gerarHonorarioBloquetoService;
        this.integracaoFintelService = integracaoFintelService;
        this.laudoMaringaService = laudoMaringaService;
    }
}

