/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.PagamentoNegociado;
import br.com.elotech.tributos.dto.BloquetoDTO;
import br.com.elotech.tributos.dto.DebitoPagamentoNegociadoComTotalizadorDTO;
import br.com.elotech.tributos.dto.FiltroConsultaDebitoPagamentoNegociado;
import br.com.elotech.tributos.dto.FiltroSimulacaoPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.ParametrosPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.acrescimo.CalculaAcrescimoBaseDTO;
import br.com.elotech.tributos.dto.negociacaodebito.EstornoNegociacaoDebitoParamsDTO;
import br.com.elotech.tributos.enums.negociacaodebito.TipoNegociacao;
import br.com.elotech.tributos.exception.negociacaodebito.NegociacaoDebitoNotFoundException;
import br.com.elotech.tributos.repository.DebitoEmAbertoRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.service.negociacaodebito.NegociacaoJudicialService;
import br.com.elotech.tributos.service.negociacaodebito.NegociacaoPagamentoService;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PagamentoNegociadoService
extends CrudService<PagamentoNegociado, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PagamentoNegociadoService.class);
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final ContextService contextService;
    private final DebitoEmAbertoRepository debitoEmAbertoRepository;
    private final FormaPagamentoService formaPagamentoService;
    private final NegociacaoPagamentoService negociacaoPagamentoService;
    private final NegociacaoJudicialService negociacaoJudicialService;

    public DebitoPagamentoNegociadoComTotalizadorDTO findDebitos(FiltroConsultaDebitoPagamentoNegociado filtro) {
        Long entidade = this.contextService.getEntidadePrincipal();
        List debitos = this.debitoEmAbertoRepository.loadDebitosPagamentoNegociado(filtro, entidade);
        if (!debitos.isEmpty()) {
            FormaPagamento formaPagamento = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.ofNullable(filtro.getExercicioFormaPagamento()));
            debitos = this.calculoAcrescimoService.calculaAcrescimos(debitos, formaPagamento.getId(), filtro.getDataReferencia(), Boolean.TRUE);
            debitos = CalculaAcrescimoBaseDTO.agruparPorParcelaChaveComIdDebito((List)debitos);
        }
        return new DebitoPagamentoNegociadoComTotalizadorDTO(debitos);
    }

    public DebitoPagamentoNegociadoComTotalizadorDTO gerarSimulacaoPagamentoNegociado(FiltroSimulacaoPagamentoNegociadoDTO filtro) {
        filtro.gerarRateioNegociacao();
        return new DebitoPagamentoNegociadoComTotalizadorDTO(filtro.getDebitos());
    }

    public PagamentoNegociado gerar(ParametrosPagamentoNegociadoDTO dto) {
        if (TipoNegociacao.JUDICIAL.equals((Object)dto.getFiltro().getTipoNegociacao())) {
            return this.negociacaoJudicialService.gerar(dto);
        }
        return this.negociacaoPagamentoService.gerar(dto);
    }

    public PagamentoNegociado estornar(Long id, EstornoNegociacaoDebitoParamsDTO dto) {
        PagamentoNegociado negociacao = (PagamentoNegociado)this.findById((Serializable)id).orElseThrow(() -> new NegociacaoDebitoNotFoundException(id));
        if (TipoNegociacao.JUDICIAL.equals((Object)negociacao.getTipoNegociacao())) {
            return this.negociacaoJudicialService.estornar(negociacao, dto);
        }
        throw new EloValidationException(String.format("Estorno n\u00e3o foi implementada para a negocia\u00e7\u00e3o de %s", negociacao.getTipoNegociacao()));
    }

    public List<BloquetoDTO> reemitirBoleto(Long id, LocalDate dataVencimento) {
        PagamentoNegociado negociacao = (PagamentoNegociado)this.findById((Serializable)id).orElseThrow(() -> new NegociacaoDebitoNotFoundException(id));
        if (TipoNegociacao.JUDICIAL.equals((Object)negociacao.getTipoNegociacao())) {
            return this.negociacaoJudicialService.reemitirBoleto(negociacao, dataVencimento);
        }
        throw new EloValidationException(String.format("Reemiss\u00e3o de boleto n\u00e3o foi implementada para a negocia\u00e7\u00e3o de %s", negociacao.getTipoNegociacao()));
    }

    @Generated
    public PagamentoNegociadoService(CalculoAcrescimoService calculoAcrescimoService, ContextService contextService, DebitoEmAbertoRepository debitoEmAbertoRepository, FormaPagamentoService formaPagamentoService, NegociacaoPagamentoService negociacaoPagamentoService, NegociacaoJudicialService negociacaoJudicialService) {
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.contextService = contextService;
        this.debitoEmAbertoRepository = debitoEmAbertoRepository;
        this.formaPagamentoService = formaPagamentoService;
        this.negociacaoPagamentoService = negociacaoPagamentoService;
        this.negociacaoJudicialService = negociacaoJudicialService;
    }
}

