/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.MovimentacaoDiariaId;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.domain.pagamento.SituacaoPagamentoLote;
import br.com.elotech.tributos.domain.pagamento.TipoPagamentoLote;
import br.com.elotech.tributos.dto.BoletoDTO;
import br.com.elotech.tributos.dto.fintel.FetchBoletoFintelResourcesDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoLoteDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoLoteManualDTO;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.ConvenioService;
import br.com.elotech.tributos.service.PagamentoLoteService;
import br.com.elotech.tributos.service.PagamentoService;
import br.com.elotech.tributos.service.ParcelamentoService;
import br.com.elotech.tributos.service.ProtestoService;
import br.com.elotech.tributos.service.TransferenciaItbiService;
import br.com.elotech.tributos.service.ValidaDataMovimentacaoService;
import br.com.elotech.tributos.service.honorarios.GerarHonorarioBloquetoService;
import br.com.elotech.tributos.service.integracaofintel.IntegracaoFintelService;
import br.com.elotech.tributos.service.negociacaodebito.NegociacaoJudicialService;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PagamentoLoteManualService {
    private static final String ORIGEM_OXY = "OXY";
    private static final String ORIGEM_FINTEL = "FINTEL";
    private final PagamentoLoteService pagamentoLoteService;
    private final ValidaDataMovimentacaoService validaDataMovimentacaoService;
    private final PagamentoService pagamentoService;
    private final BloquetoService boletoService;
    private final ConvenioService convenioService;
    private final TransferenciaItbiService transferenciaItbiService;
    private final ParcelamentoService parcelamentoService;
    private final ProtestoService protestoService;
    private final GerarHonorarioBloquetoService gerarHonorarioBloquetoService;
    private final NegociacaoJudicialService negociacaoJudicialService;
    private final IntegracaoFintelService integracaoFintelService;

    @Transactional
    public PagamentoLoteDTO salvarPagamentoLote(PagamentoLoteManualDTO lote) {
        if (lote.getBoletos().isEmpty()) {
            throw new EloValidationException("Lote pagamento deve possuir pelo menos um boleto.");
        }
        this.validaMovimentacaoDiaria(lote);
        PagamentoLote pagamentoLote = this.createPagamentoLote(lote);
        Map boletosGroupedByOrigem = this.separarBoletosPorOrigem(lote.getBoletos());
        List boletos = Stream.of(this.getBloquetosValidadosOrigemOxy((List)boletosGroupedByOrigem.get(ORIGEM_OXY), lote.getDataMovimento()), this.getBloquetosValidadosOrigemFintel((List)boletosGroupedByOrigem.get(ORIGEM_FINTEL), pagamentoLote)).flatMap(Collection::stream).toList();
        boletosGroupedByOrigem = null;
        this.integracaoFintelService.consultar().removeCachedParameters();
        this.geraPagamentos(pagamentoLote, boletos, Boolean.TRUE);
        return PagamentoLoteDTO.of((PagamentoLote)this.pagamentoLoteService.fecharLote(pagamentoLote));
    }

    public void validaMovimentacaoDiaria(PagamentoLoteManualDTO lote) {
        MovimentacaoDiariaId movimentacaoDiariaId = new MovimentacaoDiariaId();
        movimentacaoDiariaId.setEntidade(lote.getEntidade());
        movimentacaoDiariaId.setData(lote.getDataMovimento());
        this.validaDataMovimentacaoService.verificaMovimentacaoDiaria(movimentacaoDiariaId);
    }

    public List<Pagamento> geraPagamentos(PagamentoLote pagamentoLote, List<Bloqueto> boletos, Boolean acrescimoPagamento) {
        AtomicLong sequenciaArquivo = new AtomicLong(1L);
        return boletos.stream().map(boleto -> {
            this.gerarHonorarioBloquetoService.gerarDebitoAndBoletoDebitoHonorarioByBoleto(boleto);
            Pagamento pagamento = this.pagamentoService.geraPagamentoBaixaManual(pagamentoLote, boleto, acrescimoPagamento, Long.valueOf(sequenciaArquivo.getAndIncrement()));
            this.transferenciaItbiService.validaTransferenciaItbi(pagamento);
            this.parcelamentoService.quitarContratoParcelamento(pagamento);
            this.pagamentoService.constituirDebitosDoPagamento(pagamento);
            this.negociacaoJudicialService.efetivarNegociacao(pagamento, boleto);
            return pagamento;
        }).collect(Collectors.toList());
    }

    public PagamentoLote createPagamentoLote(PagamentoLoteManualDTO lote) {
        Convenio convenio = (Convenio)this.convenioService.findById((Serializable)lote.getConvenio()).orElseThrow(() -> new EloValidationException("Conv\u00eanio n\u00e3o encontrado."));
        PagamentoLoteId id = new PagamentoLoteId();
        id.setEntidade(lote.getEntidade());
        id.setExercicio(Long.valueOf(lote.getDataMovimento().getYear()));
        PagamentoLote pagamentoLote = new PagamentoLote();
        pagamentoLote.setId(id);
        pagamentoLote.setDataMovimento(lote.getDataMovimento());
        pagamentoLote.setDataCredito(lote.getDataCredito());
        pagamentoLote.setDataLote(lote.getDataLote());
        pagamentoLote.setSituacao(SituacaoPagamentoLote.ABERTO);
        pagamentoLote.setTipo(TipoPagamentoLote.MANUAL);
        pagamentoLote.setConvenio(convenio);
        pagamentoLote.setContaBancaria(convenio.getContaBancaria());
        pagamentoLote.setBanco(convenio.getBanco());
        pagamentoLote.setObservacao(lote.getObservacao());
        return (PagamentoLote)this.pagamentoLoteService.save((EloEntity)pagamentoLote, null);
    }

    private Map<String, List<BoletoDTO>> separarBoletosPorOrigem(List<BoletoDTO> boletos) {
        HashMap<String, List<BoletoDTO>> boletosAgrupadosPorOrigem = new HashMap<String, List<BoletoDTO>>();
        for (BoletoDTO boleto : boletos) {
            String origem = this.isBoletoFintel(boleto) ? ORIGEM_FINTEL : ORIGEM_OXY;
            List boletosDaOrigem = boletosAgrupadosPorOrigem.getOrDefault(origem, new ArrayList());
            boletosDaOrigem.add(boleto);
            boletosAgrupadosPorOrigem.put(origem, boletosDaOrigem);
        }
        return boletosAgrupadosPorOrigem;
    }

    private List<Bloqueto> getBloquetosValidadosOrigemOxy(List<BoletoDTO> boletos, LocalDate dataMovimento) {
        if (Objects.isNull(boletos)) {
            return List.of();
        }
        return boletos.stream().map(boletoDTO -> {
            Bloqueto boleto = (Bloqueto)this.boletoService.findById((Serializable)boletoDTO.getId()).orElseThrow(() -> new EloValidationException("Boleto n\u00e3o encontrado."));
            if (boleto.getPago().booleanValue() || boleto.validaSeBoletoComParcelaPaga()) {
                throw new EloValidationException(String.format("Boleto %d/%d pago ou com parcelas pagas.", boleto.getBloqueto(), boleto.getExercicioBloqueto()));
            }
            if (dataMovimento.isAfter(boleto.getDataVencimento())) {
                throw new EloValidationException(String.format("Boleto %d/%d vencido em rela\u00e7\u00e3o a Data Movimento.", boleto.getBloqueto(), boleto.getExercicioBloqueto()));
            }
            this.protestoService.validaDebitoProtestado(boleto.getDebitos());
            this.preencheCamposValorAcrescimoBoleto(boleto);
            return boleto;
        }).collect(Collectors.toList());
    }

    private List<Bloqueto> getBloquetosValidadosOrigemFintel(List<BoletoDTO> boletos, PagamentoLote lote) {
        if (Objects.isNull(boletos)) {
            return List.of();
        }
        return boletos.stream().map(boletoDTO -> {
            if (!this.isIntegradoFintel()) {
                throw new EloValidationException("Boleto n\u00e3o encontrado para o nosso n\u00famero " + boletoDTO.getNossoNumero());
            }
            return this.geraBoletoFintel(boletoDTO, lote);
        }).collect(Collectors.toList());
    }

    private void preencheCamposValorAcrescimoBoleto(Bloqueto boleto) {
        boleto.getDebitos().forEach(boletoDebito -> {
            boletoDebito.setValorPrincipalAcrescimo(boletoDebito.getValorPrincipal());
            boletoDebito.setValorJurosAcrescimo(boletoDebito.getValorJuros());
            boletoDebito.setValorMultaAcrescimo(boletoDebito.getValorMulta());
            boletoDebito.setValorCorrecaoAcrescimo(boletoDebito.getValorCorrecao());
        });
    }

    private boolean isIntegradoFintel() {
        return this.integracaoFintelService.isIntegradoFintel();
    }

    private boolean isBoletoFintel(BoletoDTO boleto) {
        return this.integracaoFintelService.isNossoNumeroDeBoletoFintel(boleto.getNossoNumero());
    }

    private Bloqueto geraBoletoFintel(BoletoDTO boletoTemporario, PagamentoLote lote) {
        assert (this.isBoletoFintel(boletoTemporario));
        FetchBoletoFintelResourcesDTO resources = FetchBoletoFintelResourcesDTO.builder().dataMovimentoLote(lote.getDataMovimento()).nossoNumero(boletoTemporario.getNossoNumero()).origem("BAIXAMANUALFINTEL").dataVencimento(boletoTemporario.getDataVencimento()).lote(lote.getId().getLote().longValue()).entidade(lote.getId().getEntidade().longValue()).exercicio(lote.getId().getExercicio().longValue()).valorPago(boletoTemporario.getValorTotal()).build();
        return this.integracaoFintelService.processar().gerarDebitoEBoleto(resources).getBloquetoGerado();
    }

    @Generated
    public PagamentoLoteManualService(PagamentoLoteService pagamentoLoteService, ValidaDataMovimentacaoService validaDataMovimentacaoService, PagamentoService pagamentoService, BloquetoService boletoService, ConvenioService convenioService, TransferenciaItbiService transferenciaItbiService, ParcelamentoService parcelamentoService, ProtestoService protestoService, GerarHonorarioBloquetoService gerarHonorarioBloquetoService, NegociacaoJudicialService negociacaoJudicialService, IntegracaoFintelService integracaoFintelService) {
        this.pagamentoLoteService = pagamentoLoteService;
        this.validaDataMovimentacaoService = validaDataMovimentacaoService;
        this.pagamentoService = pagamentoService;
        this.boletoService = boletoService;
        this.convenioService = convenioService;
        this.transferenciaItbiService = transferenciaItbiService;
        this.parcelamentoService = parcelamentoService;
        this.protestoService = protestoService;
        this.gerarHonorarioBloquetoService = gerarHonorarioBloquetoService;
        this.negociacaoJudicialService = negociacaoJudicialService;
        this.integracaoFintelService = integracaoFintelService;
    }
}

