/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.PagamentoDebito;
import br.com.elotech.tributos.domain.PagamentoDebitoId;
import br.com.elotech.tributos.dto.pagamento.PagamentoDebitoPorParcelaDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoDebitoPorTributoDTO;
import br.com.elotech.tributos.repository.PagamentoDebitoRepository;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class PagamentoDebitoService
extends CrudService<PagamentoDebito, PagamentoDebitoId> {
    private final PagamentoDebitoRepository pagamentoDebitoRepository;

    public PagamentoDebitoService(PagamentoDebitoRepository pagamentoDebitoRepository) {
        this.pagamentoDebitoRepository = pagamentoDebitoRepository;
    }

    public List<PagamentoDebitoPorTributoDTO> findPagamentoDebitoPorTributoByPagamento(Long entidade, Long exercicioPagamento, Long pagamento) {
        return this.pagamentoDebitoRepository.findPagamentoDebito(entidade, exercicioPagamento, pagamento).stream().map(pd -> PagamentoDebitoPorTributoDTO.of((PagamentoDebito)pd, (Boolean)Boolean.TRUE)).collect(Collectors.toList());
    }

    public List<PagamentoDebitoPorParcelaDTO> findPagamentoDebitoPorParcelaByPagamento(Long entidade, Long exercicioPagamento, Long pagamento) {
        Map<PagamentoDebitoPorParcelaDTO, List<PagamentoDebito>> agrupado = this.pagamentoDebitoRepository.findPagamentoDebito(entidade, exercicioPagamento, pagamento).stream().collect(Collectors.groupingBy(PagamentoDebitoPorParcelaDTO::fromWithoutValue));
        ArrayList<PagamentoDebitoPorParcelaDTO> itens = new ArrayList<PagamentoDebitoPorParcelaDTO>();
        agrupado.forEach((key, pagamentoDebitos) -> itens.add(pagamentoDebitos.stream().map(PagamentoDebitoPorParcelaDTO::of).reduce((PagamentoDebitoPorParcelaDTO)key, (acumulator, item) -> {
            acumulator.setValorPrincipal(acumulator.getValorPrincipal().add(item.getValorPrincipal()));
            acumulator.setValorJuros(acumulator.getValorJuros().add(item.getValorJuros()));
            acumulator.setValorMulta(acumulator.getValorMulta().add(item.getValorMulta()));
            acumulator.setValorCorrecao(acumulator.getValorCorrecao().add(item.getValorCorrecao()));
            acumulator.setValorDesconto(acumulator.getValorDesconto().add(item.getValorDesconto()));
            acumulator.setValorCalculado(acumulator.getValorCalculado().add(item.getValorCalculado()));
            acumulator.setValorPago(acumulator.getValorPago().add(item.getValorPago()));
            acumulator.setValorDevolvido(acumulator.getValorDevolvido().add(Optional.ofNullable(item.getValorDevolvido()).orElse(BigDecimal.ZERO)));
            return acumulator;
        })));
        itens.sort(Comparator.comparing(PagamentoDebitoPorParcelaDTO::getTipoCadastro).thenComparing(PagamentoDebitoPorParcelaDTO::getCadastroGeral).thenComparing(PagamentoDebitoPorParcelaDTO::getExercicioDebito).thenComparing(PagamentoDebitoPorParcelaDTO::getDivida).thenComparing(PagamentoDebitoPorParcelaDTO::getSubDivida).thenComparing(PagamentoDebitoPorParcelaDTO::getParcela));
        return itens;
    }

    public void aplicaDescontosNaBaixa(List<PagamentoDebito> pagamentoDebitos, BigDecimal valorDesconto) {
        BigDecimal valorRestanteDesconto = valorDesconto;
        BigDecimal valorDescontoJuros = this.rateioPorSobra(pagamentoDebitos, PagamentoDebito::getValorJurosComDesconto, valorRestanteDesconto);
        valorRestanteDesconto = valorRestanteDesconto.subtract(valorDescontoJuros);
        BigDecimal valorDescontoMulta = this.rateioPorSobra(pagamentoDebitos, PagamentoDebito::getValorMultaComDesconto, valorRestanteDesconto);
        valorRestanteDesconto = valorRestanteDesconto.subtract(valorDescontoMulta);
        BigDecimal valorDescontoCorrecao = this.rateioPorSobra(pagamentoDebitos, PagamentoDebito::getValorCorrecaoComDesconto, valorRestanteDesconto);
        valorRestanteDesconto = valorRestanteDesconto.subtract(valorDescontoCorrecao);
        BigDecimal valorDescontoJurosFinanciamento = this.rateioPorSobraValorPrincipalComDescontoJurosFinanciamento(pagamentoDebitos, valorRestanteDesconto);
        valorRestanteDesconto = valorRestanteDesconto.subtract(valorDescontoJurosFinanciamento);
        BigDecimal valorDescontoPrincipal = this.rateioPorSobra(pagamentoDebitos, PagamentoDebito::getValorPrincipalComDesconto, valorRestanteDesconto);
        if ((valorRestanteDesconto = valorRestanteDesconto.subtract(valorDescontoPrincipal)).compareTo(BigDecimal.ZERO) != 0) {
            throw new IllegalStateException("O valor de desconto nunca dever\u00e1 ser maior que o valor do boleto.");
        }
        this.ratearValorDesconto(pagamentoDebitos, valorDescontoJuros, PagamentoDebito::getValorJurosComDesconto, PagamentoDebito::getValorDescontoJuros, PagamentoDebito::getValorJuros, PagamentoDebito::setValorDescontoJuros);
        this.ratearValorDesconto(pagamentoDebitos, valorDescontoMulta, PagamentoDebito::getValorMultaComDesconto, PagamentoDebito::getValorDescontoMulta, PagamentoDebito::getValorMulta, PagamentoDebito::setValorDescontoMulta);
        this.ratearValorDesconto(pagamentoDebitos, valorDescontoCorrecao, PagamentoDebito::getValorCorrecaoComDesconto, PagamentoDebito::getValorDescontoCorrecao, PagamentoDebito::getValorCorrecao, PagamentoDebito::setValorDescontoCorrecao);
        this.ratearValorDesconto(pagamentoDebitos, valorDescontoJurosFinanciamento, PagamentoDebito::getValorPrincipalComDescontoJurosFinanciamento, PagamentoDebito::getValorDescontoJurosFinanciamento, PagamentoDebito::getValorPrincipal, PagamentoDebito::setValorDescontoJurosFinanciamento);
        this.ratearValorDesconto(pagamentoDebitos, valorDescontoPrincipal, PagamentoDebito::getValorPrincipalComDesconto, PagamentoDebito::getValorDescontoPrincipal, PagamentoDebito::getValorPrincipal, PagamentoDebito::setValorDescontoPrincipal);
        pagamentoDebitos.forEach(pagamentoDebito -> {
            pagamentoDebito.setValorDesconto(pagamentoDebito.getValorDesconto().add(pagamentoDebito.getValorTotalDesconto()));
            pagamentoDebito.setValorPago(pagamentoDebito.getValorPago().subtract(pagamentoDebito.getValorDesconto()));
        });
    }

    private BigDecimal rateioPorSobra(List<PagamentoDebito> pagamentoDebitos, Function<PagamentoDebito, BigDecimal> getValorComDesconto, BigDecimal valorRestanteDesconto) {
        if (valorRestanteDesconto.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal valorDisponivel = pagamentoDebitos.stream().map(getValorComDesconto).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (valorDisponivel.compareTo(valorRestanteDesconto) >= 0) {
            return valorRestanteDesconto;
        }
        return valorDisponivel;
    }

    private BigDecimal rateioPorSobraValorPrincipalComDescontoJurosFinanciamento(List<PagamentoDebito> pagamentoDebitos, BigDecimal valorRestanteDesconto) {
        if (valorRestanteDesconto.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal valorDisponivel = pagamentoDebitos.stream().filter(p -> Objects.nonNull(p.getValorDescontoJurosFinanciamento()) && p.getValorDescontoJurosFinanciamento().compareTo(BigDecimal.ZERO) > 0).map(PagamentoDebito::getValorPrincipalComDescontoJurosFinanciamento).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (valorDisponivel.compareTo(valorRestanteDesconto) >= 0) {
            return valorRestanteDesconto;
        }
        return valorDisponivel;
    }

    private void ratearValorDesconto(List<PagamentoDebito> pagamentoDebitos, BigDecimal valorDesconto, Function<PagamentoDebito, BigDecimal> getValorComDesconto, Function<PagamentoDebito, BigDecimal> getValorDescontoExistente, Function<PagamentoDebito, BigDecimal> getValorBase, BiConsumer<PagamentoDebito, BigDecimal> setValorDesconto) {
        BigDecimal diferencaDesconto;
        if (valorDesconto.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal valorDisponivelParaDesconto = pagamentoDebitos.stream().map(getValorComDesconto).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal descontoAcumulado = BigDecimal.ZERO;
        for (PagamentoDebito pagamentoDebito : pagamentoDebitos) {
            if (valorDesconto.compareTo(descontoAcumulado) <= 0) break;
            if (valorDisponivelParaDesconto.compareTo(valorDesconto) == 0) {
                BigDecimal valorDescontoAdicionado = getValorBase.apply(pagamentoDebito).subtract(getValorDescontoExistente.apply(pagamentoDebito));
                descontoAcumulado = descontoAcumulado.add(valorDescontoAdicionado);
                setValorDesconto.accept(pagamentoDebito, getValorBase.apply(pagamentoDebito));
                continue;
            }
            BigDecimal valorDescontoProporcional = valorDesconto.multiply(getValorComDesconto.apply(pagamentoDebito)).divide(valorDisponivelParaDesconto, 2, RoundingMode.HALF_UP);
            setValorDesconto.accept(pagamentoDebito, getValorDescontoExistente.apply(pagamentoDebito).add(valorDescontoProporcional));
            descontoAcumulado = descontoAcumulado.add(valorDescontoProporcional);
        }
        if ((diferencaDesconto = valorDesconto.subtract(descontoAcumulado)).compareTo(BigDecimal.ZERO) != 0) {
            pagamentoDebitos.stream().max(Comparator.comparing(getValorDescontoExistente)).ifPresent(debito -> setValorDesconto.accept((PagamentoDebito)debito, ((BigDecimal)getValorDescontoExistente.apply((PagamentoDebito)debito)).add(diferencaDesconto)));
        }
    }

    public void atualizaValorAMaior(List<PagamentoDebito> pagamentoDebitos, BigDecimal valorPagoAMaior) {
        BigDecimal diferencaPagoAMaior;
        BigDecimal valorTotal = pagamentoDebitos.stream().map(PagamentoDebito::getValorTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal valorPagoAMaiorAcumuladoDebito = BigDecimal.ZERO;
        if (valorTotal.compareTo(BigDecimal.ZERO) != 0) {
            for (PagamentoDebito pagamentoDebito : pagamentoDebitos) {
                if (valorPagoAMaior.compareTo(valorPagoAMaiorAcumuladoDebito) <= 0) break;
                BigDecimal valorPagoAMaiorDebito = pagamentoDebito.getValorTotal().multiply(valorPagoAMaior).divide(valorTotal, 2, RoundingMode.HALF_UP);
                valorPagoAMaiorAcumuladoDebito = valorPagoAMaiorAcumuladoDebito.add(valorPagoAMaiorDebito);
                pagamentoDebito.setValorPagoMaior(valorPagoAMaiorDebito);
            }
        }
        if ((diferencaPagoAMaior = valorPagoAMaior.subtract(valorPagoAMaiorAcumuladoDebito)).compareTo(BigDecimal.ZERO) != 0) {
            pagamentoDebitos.stream().max(Comparator.comparing(PagamentoDebito::getValorTotal)).ifPresent(debito -> debito.setValorPagoMaior(debito.getValorPagoMaior().add(diferencaPagoAMaior)));
        }
    }

    public void atualizaValorAMenor(List<PagamentoDebito> pagamentoDebitos, BigDecimal valorTotalPago) {
        BigDecimal diferencaPagoAMenor;
        BigDecimal valorTotalBoleto = pagamentoDebitos.stream().map(PagamentoDebito::getValorTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal valorAcumuladoPrincipal = BigDecimal.ZERO;
        if (valorTotalBoleto.compareTo(BigDecimal.ZERO) != 0) {
            for (PagamentoDebito pagamentoDebito : pagamentoDebitos) {
                if (valorTotalPago.compareTo(valorAcumuladoPrincipal) <= 0) break;
                BigDecimal valorPrincipalDebito = pagamentoDebito.getValorTotal().multiply(valorTotalPago).divide(valorTotalBoleto, 2, RoundingMode.HALF_UP);
                valorAcumuladoPrincipal = valorAcumuladoPrincipal.add(valorPrincipalDebito);
                pagamentoDebito.setValorPrincipal(valorPrincipalDebito);
                pagamentoDebito.setValorPago(valorPrincipalDebito);
                pagamentoDebito.zeraAcrescimosEDescontos();
            }
        }
        if ((diferencaPagoAMenor = valorTotalPago.subtract(valorAcumuladoPrincipal)).compareTo(BigDecimal.ZERO) != 0) {
            pagamentoDebitos.stream().max(Comparator.comparing(PagamentoDebito::getValorTotal)).ifPresent(debito -> {
                debito.setValorPrincipal(debito.getValorPrincipal().add(diferencaPagoAMenor));
                debito.setValorPago(debito.getValorPago().add(diferencaPagoAMenor));
            });
        }
    }
}

