/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.client.painel.feign.NotificationFeign;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.lib.painel.dto.DataNotificationDTO;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincrona;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobExecution;
import org.springframework.stereotype.Service;

@Service
public class NotificacaoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotificacaoService.class);
    private final Optional<NotificationFeign> notificationFeign;

    public Optional<UUID> send(String title, String detail, JobExecution jobExecution, Optional<UUID> notificationId, NotificationStatus status) {
        try {
            UUID id = notificationId.orElse(UUID.randomUUID());
            DataNotificationDTO notification = new DataNotificationDTO();
            notification.setId(id);
            notification.setUsername(SecurityUtils.getUserAise());
            notification.setMessage(title);
            notification.setMessageDetail(Optional.ofNullable(detail).orElse(title));
            notification.setStatus(status);
            notification.setLink(String.format("/tributos/tarefas?tipoFiltro=LOTE&filters==instanceId_Igual=%d", jobExecution.getJobId()));
            notification.setType("Lote");
            notification.setModulo(Modulo.OXY_TRIBUTOS);
            notification.setCidadao(Boolean.FALSE);
            this.getNotificationFeign().publishMessage(notification);
            return Optional.of(notification.getId());
        }
        catch (Exception e) {
            log.error("Erro ao enviar notifica\u00e7\u00e3o para o usu\u00e1rio ", (Throwable)e);
            return Optional.empty();
        }
    }

    public Optional<UUID> send(String title, String detail, TarefaAssincrona tarefa, Optional<UUID> notificationId, UserSecurityDTO userSecurityDTO, NotificationStatus status) {
        try {
            UUID id = notificationId.orElse(UUID.randomUUID());
            DataNotificationDTO notification = new DataNotificationDTO();
            notification.setId(id);
            notification.setUsername(Optional.ofNullable(userSecurityDTO.getPreferredUsername()).orElse(SecurityUtils.getUserAise()));
            notification.setMessage(title);
            notification.setMessageDetail(Optional.ofNullable(detail).orElse(title));
            notification.setStatus(status);
            notification.setLink(String.format("/tributos/tarefas?tipoFiltro=TAREFA&filters==id_Igual=%d", tarefa.getId()));
            notification.setType("Notifica\u00e7\u00e3o");
            notification.setType("Tarefa");
            notification.setModulo(Modulo.OXY_TRIBUTOS);
            notification.setCidadao(Boolean.FALSE);
            this.getNotificationFeign().publishMessage(notification);
            return Optional.of(notification.getId());
        }
        catch (Exception e) {
            log.error("Erro ao enviar notifica\u00e7\u00e3o para o usu\u00e1rio ", (Throwable)e);
            return Optional.empty();
        }
    }

    public Optional<UUID> send(String title, String detail, String username, Optional<UUID> notificationId, NotificationStatus status, Boolean cidadao, String link) {
        try {
            UUID id = notificationId.orElse(UUID.randomUUID());
            DataNotificationDTO notification = new DataNotificationDTO();
            notification.setId(id);
            notification.setUsername(username);
            notification.setMessage(title);
            notification.setMessageDetail(Optional.ofNullable(detail).orElse(title));
            notification.setStatus(status);
            notification.setLink(link);
            notification.setType("Lote");
            notification.setModulo(Modulo.OXY_TRIBUTOS);
            notification.setCidadao(cidadao);
            this.getNotificationFeign().publishMessage(notification);
            return Optional.of(notification.getId());
        }
        catch (Exception e) {
            log.error("Erro ao enviar notifica\u00e7\u00e3o para o usu\u00e1rio ", (Throwable)e);
            return Optional.empty();
        }
    }

    private NotificationFeign getNotificationFeign() {
        return (NotificationFeign)this.notificationFeign.orElseThrow(() -> new EloValidationException("O feign de notifica\u00e7\u00e3o n\u00e3o est\u00e1 dispon\u00edvel no ambiente onpremise"));
    }

    public Optional<UUID> getNotificacaoIdFromJobContext(Object idNotificacao) {
        if (Objects.nonNull(idNotificacao)) {
            return Optional.of(UUID.fromString(idNotificacao.toString()));
        }
        return Optional.empty();
    }

    @Generated
    public NotificacaoService(Optional<NotificationFeign> notificationFeign) {
        this.notificationFeign = notificationFeign;
    }
}

