/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioServico;
import br.com.elotech.tributos.dto.CadastroMobiliarioServicoDTO;
import br.com.elotech.tributos.repository.mobiliario.MobiliarioServicoRepository;
import br.com.elotech.tributos.service.CadastroMobiliarioService;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class MobiliarioServicoService {
    private final MobiliarioServicoRepository mobiliarioServicoRepository;
    private final CadastroMobiliarioService cadastroMobiliarioService;

    public MobiliarioServicoService(MobiliarioServicoRepository mobiliarioServicoRepository, CadastroMobiliarioService cadastroMobiliarioService) {
        this.mobiliarioServicoRepository = mobiliarioServicoRepository;
        this.cadastroMobiliarioService = cadastroMobiliarioService;
    }

    public List<CadastroMobiliarioServicoDTO> getByCadastroMobiliarioIdAndExercicio(Long idCadastroMobiliario, Long exercicio) {
        return this.mobiliarioServicoRepository.findByCadastroMobiliarioIdAndServicoExercicio(idCadastroMobiliario, exercicio).stream().map(CadastroMobiliarioServicoDTO::from).sorted(Comparator.comparing(servico -> servico.getServico().getServico())).collect(Collectors.toList());
    }

    public CadastroMobiliarioServicoDTO save(Long idCadastro, CadastroMobiliarioServicoDTO dto) {
        CadastroMobiliarioServico cadastroMobiliarioServico;
        cadastroMobiliarioServico.setPrincipal(Boolean.valueOf((cadastroMobiliarioServico = this.dtoToEntity(idCadastro, dto)).getCadastroMobiliario().possuiServicoNoExercicio(dto.getServico().getExercicio()) == false));
        return CadastroMobiliarioServicoDTO.from((CadastroMobiliarioServico)((CadastroMobiliarioServico)this.mobiliarioServicoRepository.save((Object)cadastroMobiliarioServico)));
    }

    public CadastroMobiliarioServicoDTO update(Long idCadastro, CadastroMobiliarioServicoDTO dto) {
        CadastroMobiliarioServico cadastroMobiliarioServicoToMerge = this.dtoToEntity(idCadastro, dto);
        CadastroMobiliarioServico cadastroMobiliarioServicoFound = this.getCadastroMobiliarioServicoById(dto.getId());
        return CadastroMobiliarioServicoDTO.from((CadastroMobiliarioServico)((CadastroMobiliarioServico)this.mobiliarioServicoRepository.save((Object)cadastroMobiliarioServicoFound.merge(cadastroMobiliarioServicoToMerge))));
    }

    private CadastroMobiliarioServico dtoToEntity(Long idCadastro, CadastroMobiliarioServicoDTO dto) {
        CadastroMobiliario cadastroMobiliario = (CadastroMobiliario)this.cadastroMobiliarioService.findById((Serializable)idCadastro).orElseThrow(() -> new EloValidationException(String.format("Cadastro mobili\u00e1rio com id %d n\u00e3o encontrado.", idCadastro)));
        if (cadastroMobiliario.getCadastroMobiliarioServicos().stream().anyMatch(mobiliarioServico -> mobiliarioServico.getServico().getId().equals(dto.getServico().getId()) && !mobiliarioServico.getId().equals(dto.getId()))) {
            throw new EloValidationException("Servi\u00e7o j\u00e1 cadastrado para esse cadastro mobili\u00e1rio.");
        }
        return CadastroMobiliarioServico.from((CadastroMobiliarioServicoDTO)dto, (CadastroMobiliario)cadastroMobiliario);
    }

    public void delete(Long idCadastroMobiliarioServico) {
        CadastroMobiliarioServico cadastroMobiliarioServico = this.getCadastroMobiliarioServicoById(idCadastroMobiliarioServico);
        if (cadastroMobiliarioServico.getPrincipal().booleanValue() && this.mobiliarioServicoRepository.findByCadastroMobiliarioIdAndServicoExercicio(cadastroMobiliarioServico.getCadastroMobiliario().getId(), cadastroMobiliarioServico.getServico().getExercicio()).size() > 1) {
            throw new EloValidationException("Necess\u00e1rio informar outro servi\u00e7o como principal antes de remover este.");
        }
        this.mobiliarioServicoRepository.delete((Object)cadastroMobiliarioServico);
    }

    public void tornarPrincipal(Long idCadastroMobiliarioServico) {
        CadastroMobiliarioServico cadastroMobiliarioServico = this.getCadastroMobiliarioServicoById(idCadastroMobiliarioServico);
        List servicosByExercicio = this.mobiliarioServicoRepository.findByCadastroMobiliarioIdAndServicoExercicio(cadastroMobiliarioServico.getCadastroMobiliario().getId(), cadastroMobiliarioServico.getServico().getExercicio());
        servicosByExercicio.forEach(servico -> servico.setPrincipal(Boolean.valueOf(servico.getId().equals(idCadastroMobiliarioServico))));
        this.mobiliarioServicoRepository.saveAll((Iterable)servicosByExercicio);
    }

    private CadastroMobiliarioServico getCadastroMobiliarioServicoById(Long idCadastroMobiliarioServico) {
        return (CadastroMobiliarioServico)this.mobiliarioServicoRepository.findById((Object)idCadastroMobiliarioServico).orElseThrow(() -> new EloValidationException(String.format("Cadastro Mobili\u00e1rio Servi\u00e7o com id %d n\u00e3o encontrado", idCadastroMobiliarioServico)));
    }
}

