/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Loteamento;
import br.com.elotech.tributos.domain.projeto.Projeto;
import br.com.elotech.tributos.domain.projeto.ProjetoPK;
import br.com.elotech.tributos.repository.LoteamentoRepository;
import br.com.elotech.tributos.service.CadastroImobiliarioService;
import br.com.elotech.tributos.service.ConfiguracaoInscricaoCadastralService;
import br.com.elotech.tributos.service.SetorQuadraService;
import br.com.elotech.tributos.service.exception.projeto.ProjetoNotFoundException;
import br.com.elotech.tributos.service.projeto.ProjetoService;
import br.com.elotech.tributos.util.UsuarioUtils;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class LoteamentoService
extends CrudService<Loteamento, Long> {
    private final CadastroImobiliarioService cadastroImobiliarioService;
    private final ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService;
    private final SetorQuadraService setorQuadraService;
    private final LoteamentoRepository loteamentoRepository;
    private final ProjetoService projetoService;

    public LoteamentoService(CadastroImobiliarioService cadastroImobiliarioService, ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService, SetorQuadraService setorQuadraService, LoteamentoRepository loteamentoRepository, ProjetoService projetoService) {
        this.cadastroImobiliarioService = cadastroImobiliarioService;
        this.configuracaoInscricaoCadastralService = configuracaoInscricaoCadastralService;
        this.setorQuadraService = setorQuadraService;
        this.loteamentoRepository = loteamentoRepository;
        this.projetoService = projetoService;
    }

    protected void beforeSave(Loteamento entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        if (Objects.nonNull(entity.getProjeto())) {
            Projeto projeto = this.resolveProjeto(entity.getProjeto().getId());
            entity.setProjeto(projeto);
        } else {
            entity.setProjeto(null);
        }
        this.resolveObservacoes(entity);
        entity.setUsuario(UsuarioUtils.getUsuarioAise());
        entity.setDataAlteracao(LocalDate.now());
        entity.setChildrenId();
    }

    private Projeto resolveProjeto(ProjetoPK id) {
        if (Objects.isNull(id)) {
            return null;
        }
        return (Projeto)this.projetoService.findById((Serializable)id).orElseThrow(() -> new ProjetoNotFoundException(id));
    }

    private void resolveObservacoes(Loteamento loteamento) {
        List observacoes = loteamento.getObservacoes();
        if (Objects.nonNull(observacoes)) {
            observacoes.forEach(obs -> {
                obs.setLoteamento(Optional.ofNullable(obs.getLoteamento()).orElse(loteamento));
                obs.setUsuario(Optional.ofNullable(obs.getUsuario()).orElse(UsuarioUtils.getUsuarioAise()));
                obs.setData(Optional.ofNullable(obs.getData()).orElse(LocalDate.now()));
            });
        }
    }

    protected void beforeDelete(Loteamento entity, Authentication authentication) {
        super.beforeDelete((EloEntity)entity, authentication);
        List quadras = this.setorQuadraService.findByLoteamentoId(entity.getId());
        if (!quadras.isEmpty()) {
            throw new EloValidationException(String.format("O loteamento %d j\u00e1 possui v\u00ednculo com a %s", entity.getLoteamento(), this.configuracaoInscricaoCadastralService.getConfiguracao().getQuadra().getDescricao()));
        }
        if (Boolean.TRUE.equals(this.cadastroImobiliarioService.existsCadastroImobiliarioAssociadoLoteamento(entity.getId()))) {
            throw new EloValidationException(String.format("O loteamento %d j\u00e1 possui v\u00ednculo com o Cadastro Imobili\u00e1rio", entity.getLoteamento()));
        }
    }

    public Loteamento findByLoteamento(Long codigoLoteamento) {
        return (Loteamento)this.loteamentoRepository.findByLoteamento(codigoLoteamento).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o Loteamento com o c\u00f3digo '%d'.", codigoLoteamento)));
    }

    public Loteamento findBySetorDistritoDistritoAndSetorSetorAndLoteamento(String distrito, String setor, Long loteamento) {
        return this.loteamentoRepository.findBySetorDistritoDistritoAndSetorSetorAndLoteamento(distrito, setor, loteamento);
    }
}

