/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.LogAtualizacaoNumeroProcessoJudicial;
import br.com.elotech.tributos.dto.certidaodividaativa.AtualizaNumeroProcessoJudicialDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import java.time.LocalDateTime;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class LogAtualizacaoNumeroProcessoJudicialService
extends CrudService<LogAtualizacaoNumeroProcessoJudicial, Long> {
    @Autowired
    private PlatformTransactionManager transactionManager;

    public void runWithLog(AtualizaNumeroProcessoJudicialDTO dto, Supplier<?> supplier) {
        LogAtualizacaoNumeroProcessoJudicial log = this.createLog(dto);
        try {
            supplier.get();
            this.saveLog(log, true, null);
        }
        catch (Exception e) {
            this.saveLog(log, false, e.getMessage());
            throw new RuntimeException("Erro ao atualizar n\u00famero do processo judicial", e);
        }
    }

    private LogAtualizacaoNumeroProcessoJudicial createLog(AtualizaNumeroProcessoJudicialDTO dto) {
        return LogAtualizacaoNumeroProcessoJudicial.builder().data(LocalDateTime.now()).usuario(SecurityUtils.getUserAise()).valorAplicado(dto.getNumeroProcessoJudicial()).porLote(Boolean.valueOf(dto.isPorLote())).lotes(String.join((CharSequence)",", dto.getIdentificadoresLote().stream().map(String::valueOf).sorted().toList())).certidoes(String.join((CharSequence)",", dto.getIdentificadoresCda().stream().map(String::valueOf).sorted().toList())).build();
    }

    private void saveLog(LogAtualizacaoNumeroProcessoJudicial log, boolean sucesso, String message) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        transactionTemplate.setPropagationBehavior(3);
        transactionTemplate.executeWithoutResult(transactionStatus -> {
            log.setSucesso(Boolean.valueOf(sucesso));
            log.setMessage(message);
            this.save((EloEntity)log, null);
        });
    }
}

