/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.config.HttpEntityFactory;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoEnderecoCorrespondencia;
import br.com.elotech.tributos.domain.UnidadeFederacao;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioCnae;
import br.com.elotech.tributos.dto.BairroDTO;
import br.com.elotech.tributos.dto.CadastroMobiliarioDTO;
import br.com.elotech.tributos.dto.CidadeDTO;
import br.com.elotech.tributos.dto.LogradouroDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroImobiliarioDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.PessoaDTO;
import br.com.elotech.tributos.dto.laudomaringa.LaudoMaringaRequestLogin;
import br.com.elotech.tributos.dto.laudomaringa.LaudoMaringaResponseLogin;
import br.com.elotech.tributos.dto.laudomaringa.LaudoMaringaResponseProtocolo;
import br.com.elotech.tributos.dto.laudomaringa.LaudoMaringaResponseSocio;
import br.com.elotech.tributos.repository.CadastroGeralRepository;
import br.com.elotech.tributos.service.CnaeService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.exception.LaudoMaringaException;
import br.com.elotech.tributos.ws.rest.dto.pessoa.EnderecoPessoaRequestDTO;
import br.com.elotech.tributos.ws.rest.dto.pessoa.IncluirPessoaRequestDTO;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class LaudoMaringaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LaudoMaringaService.class);
    private static final String CIDADE_MARINGA = "Maring\u00e1";
    private final PessoaService pessoaService;
    private final CnaeService cnaeService;
    private final CadastroGeralRepository cadastroGeralRepository;
    private final ParametroGeralService parametroGeralService;
    private final RestTemplate restTemplate;

    private String getParametroUsername() {
        return this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.SERVICO_LAUDO_MARINGA_USERNAME, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private String getParametroPassword() {
        return this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.SERVICO_LAUDO_MARINGA_PASSWORD, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private String getParametroUrl() {
        return this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.SERVICO_LAUDO_MARINGA_URL, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    public boolean isIntegradoLaudo() {
        return this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.INTEGRADO_LAUDO_MARINGA, ModuloEnum.MODULO_TRIBUTARIO.getValue()).equals(SimNao.SIM.getSigla());
    }

    public Long getParametroDividaLaudo() {
        return this.parametroGeralService.getParamValueAsLong(ParametroGeralEnum.GUIA_LAUDO_MARINGA, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    public boolean isNossoNumeroLaudo(String nossoNumero) {
        String NOSSO_NUMERO_LAUDO = "8899";
        return nossoNumero != null && nossoNumero.length() >= 8 && "8899".equals(nossoNumero.substring(4, 8));
    }

    private String getUrlLogin() {
        return this.getParametroUrl() + "/auth/login";
    }

    private String getUrlProtocolo(String protocolo) {
        return this.getParametroUrl() + "/contribuintes/protocolos?id=" + protocolo;
    }

    private String getUrlSocio(String protocolo) {
        return this.getParametroUrl() + "/socios/protocolos?id=" + protocolo;
    }

    protected String getToken() {
        try {
            String url = this.getUrlLogin();
            String username = this.getParametroUsername();
            String password = this.getParametroPassword();
            URI uri = new URI(url);
            log.info("Buscando token de autentica\u00e7\u00e3o do servi\u00e7o de laudo... Url: {}", (Object)uri);
            ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.POST, HttpEntityFactory.createJsonHttpEntity((Object)new LaudoMaringaRequestLogin(username, password)), LaudoMaringaResponseLogin.class);
            return ((LaudoMaringaResponseLogin)response.getBody()).getToken().getToken();
        }
        catch (Exception ex) {
            log.error("Erro ao buscar token de autentica\u00e7\u00e3o do servi\u00e7o de laudo", (Throwable)ex);
            throw new LaudoMaringaException(HttpStatus.BAD_REQUEST, ex.getMessage(), ex);
        }
    }

    public LaudoMaringaResponseProtocolo getLaudoMaringa(String protocolo) {
        try {
            Pattern pattern = Pattern.compile("(\\d+)\\/(\\d+)");
            Matcher matcher = pattern.matcher(protocolo);
            if (!matcher.matches()) {
                log.error("O protocolo informado n\u00e3o est\u00e1 no formato esperado: {}", (Object)protocolo);
                throw new LaudoMaringaException(HttpStatus.BAD_REQUEST, "Protocolo inv\u00e1lido. Formato esperado: 'n\u00famero/ano'.");
            }
            String url = this.getUrlProtocolo(protocolo);
            URI uri = new URI(url);
            log.info("Buscando laudo de Maring\u00e1... Url: {}", (Object)uri);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept(List.of(MediaType.APPLICATION_JSON));
            headers.set("Authorization", "Bearer " + this.getToken());
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.GET, request, LaudoMaringaResponseProtocolo.class);
            LaudoMaringaResponseProtocolo laudoMaringaResponseProtocolo = (LaudoMaringaResponseProtocolo)response.getBody();
            laudoMaringaResponseProtocolo.setLaudo(Long.valueOf(matcher.group(1)));
            laudoMaringaResponseProtocolo.setExercicioLaudo(Long.valueOf(matcher.group(2)));
            return laudoMaringaResponseProtocolo;
        }
        catch (Exception ex) {
            log.error("Erro ao buscar as informa\u00e7\u00f5es de laudo de Maring\u00e1", (Throwable)ex);
            throw new LaudoMaringaException(HttpStatus.BAD_REQUEST, ex.getMessage(), ex);
        }
    }

    protected LaudoMaringaResponseSocio getSocioLaudoMaringa(String protocolo) {
        try {
            String url = this.getUrlSocio(protocolo);
            URI uri = new URI(url);
            log.info("Buscando s\u00f3cios do laudo de Maring\u00e1... Url: {}", (Object)uri);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept(List.of(MediaType.APPLICATION_JSON));
            headers.set("Authorization", "Bearer " + this.getToken());
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.GET, request, LaudoMaringaResponseSocio.class);
            return (LaudoMaringaResponseSocio)response.getBody();
        }
        catch (Exception ex) {
            log.error("Erro ao buscar os s\u00f3cios do laudo de Maring\u00e1", (Throwable)ex);
            throw new LaudoMaringaException(HttpStatus.BAD_REQUEST, ex.getMessage(), ex);
        }
    }

    private Pessoa findPessoa(LaudoMaringaResponseProtocolo laudoMaringaResponseProtocolo) {
        String cnpjCpfEmpresa = laudoMaringaResponseProtocolo.getItem().getCnpjCpfEmpresa();
        if (StringUtils.isBlank((CharSequence)cnpjCpfEmpresa)) {
            throw new LaudoMaringaException(HttpStatus.BAD_REQUEST, "CnpjCpf inv\u00e1lido no laudo de Maring\u00e1.");
        }
        Pessoa pessoa = this.pessoaService.findByCnpjCpf(cnpjCpfEmpresa);
        if (Objects.nonNull(pessoa)) {
            return pessoa;
        }
        IncluirPessoaRequestDTO incluirPessoa = new IncluirPessoaRequestDTO();
        incluirPessoa.setCnpjCpf(laudoMaringaResponseProtocolo.getItem().getCnpjCpfEmpresa());
        incluirPessoa.setNome(laudoMaringaResponseProtocolo.getItem().getNomeRazaoSocial());
        incluirPessoa.setNomeFantasia(laudoMaringaResponseProtocolo.getItem().getNomeFantasia());
        incluirPessoa.setTipoPessoa(TipoPessoa.fromString((String)laudoMaringaResponseProtocolo.getItem().getTipoPessoa()));
        incluirPessoa.setActiveFormOrigem("Laudo Maring\u00e1");
        EnderecoPessoaRequestDTO endereco = new EnderecoPessoaRequestDTO();
        endereco.setCidade(CIDADE_MARINGA);
        endereco.setLogradouro(laudoMaringaResponseProtocolo.getItem().getLogradouroDescricao());
        endereco.setBairro(laudoMaringaResponseProtocolo.getItem().getBairro());
        endereco.setCep(laudoMaringaResponseProtocolo.getItem().getCep());
        endereco.setNumero(laudoMaringaResponseProtocolo.getItem().getNumero());
        endereco.setComplemento(laudoMaringaResponseProtocolo.getItem().getComplemento());
        incluirPessoa.getEnderecos().getItems().add(endereco);
        return this.pessoaService.incluirPessoa(incluirPessoa);
    }

    public Pessoa findPessoaByLaudoMaringa(Long laudo, Long exercicioLaudo) {
        String protocolo = String.format("%d/%d", laudo, exercicioLaudo);
        log.info("Buscando pessoa pelo laudo de Maring\u00e1 com protocolo: {}", (Object)protocolo);
        LaudoMaringaResponseProtocolo laudoMaringaResponseProtocolo = this.getLaudoMaringa(protocolo);
        return this.findPessoa(laudoMaringaResponseProtocolo);
    }

    private void preencherCnae(CadastroMobiliario cadastroMobiliario, CadastroMobiliarioDTO cadastroMobiliarioDTO, String codigoCnae, Boolean principal) {
        Optional.ofNullable(codigoCnae).filter(StringUtils::isNotBlank).map(s -> s.replaceAll("[^0-9]+", "")).map(arg_0 -> ((CnaeService)this.cnaeService).findByCodigo(arg_0)).ifPresent(cnae -> {
            CadastroMobiliarioCnae mobiliarioCnae = new CadastroMobiliarioCnae();
            mobiliarioCnae.setCadastroMobiliario(cadastroMobiliario);
            mobiliarioCnae.setCnae(cnae);
            mobiliarioCnae.setCnaePrincipal(principal);
            cadastroMobiliarioDTO.getCadastroMobiliarioCnaes().add(mobiliarioCnae);
        });
    }

    protected void preencherSocios(CadastroMobiliario cadastroMobiliario, CadastroMobiliarioDTO cadastroMobiliarioDTO, String protocolo) {
        LaudoMaringaResponseSocio laudoMaringaResponseSocio = this.getSocioLaudoMaringa(protocolo);
        if (laudoMaringaResponseSocio.getItems().isEmpty()) {
            log.info("Nenhum s\u00f3cio encontrado no laudo de Maring\u00e1 para o protocolo: {}", (Object)protocolo);
            return;
        }
        AtomicReference<Boolean> principal = new AtomicReference<Boolean>(Boolean.TRUE);
        laudoMaringaResponseSocio.getItems().forEach(socioItem -> {
            String cnpjCpf = socioItem.getCnpjCpf();
            if (StringUtils.isBlank((CharSequence)cnpjCpf)) {
                log.warn("S\u00f3cio do laudo de Maring\u00e1 sem CNPJ/CPF. Ignorando s\u00f3cio: {}", socioItem);
                return;
            }
            Pessoa pessoa = this.pessoaService.findByCnpjCpf(cnpjCpf);
            if (Objects.isNull(pessoa)) {
                IncluirPessoaRequestDTO incluirPessoa = new IncluirPessoaRequestDTO();
                incluirPessoa.setCnpjCpf(socioItem.getCnpjCpf());
                incluirPessoa.setNome(socioItem.getNome());
                incluirPessoa.setTipoPessoa(TipoPessoa.fromString((String)socioItem.getTipoPessoa()));
                incluirPessoa.setActiveFormOrigem("Laudo Maring\u00e1");
                EnderecoPessoaRequestDTO endereco = new EnderecoPessoaRequestDTO();
                endereco.setCidade(CIDADE_MARINGA);
                endereco.setLogradouro(socioItem.getLogradouroDescricao());
                endereco.setBairro(socioItem.getBairro());
                endereco.setCep(socioItem.getCep());
                endereco.setNumero(socioItem.getNumero());
                endereco.setComplemento(socioItem.getComplemento());
                incluirPessoa.getEnderecos().getItems().add(endereco);
                pessoa = this.pessoaService.incluirPessoa(incluirPessoa);
            }
            Proprietario proprietario = new Proprietario();
            proprietario.setPessoa(pessoa);
            proprietario.setCadastroGeral((CadastroGeral)cadastroMobiliario);
            proprietario.setPrincipal((Boolean)principal.get());
            cadastroMobiliarioDTO.getProprietarios().add(proprietario);
            principal.set(Boolean.FALSE);
        });
    }

    protected CadastroMobiliarioDTO cadastroMobiliarioFromLaudo(LaudoMaringaResponseProtocolo laudoMaringaResponseProtocolo) {
        CadastroMobiliarioDTO cadastroMobiliarioDTO = new CadastroMobiliarioDTO();
        cadastroMobiliarioDTO.setExercicioLaudo(laudoMaringaResponseProtocolo.getExercicioLaudo());
        cadastroMobiliarioDTO.setLaudo(laudoMaringaResponseProtocolo.getLaudo());
        Pessoa pessoa = this.findPessoa(laudoMaringaResponseProtocolo);
        cadastroMobiliarioDTO.setPessoa(PessoaDTO.from((Pessoa)pessoa));
        if (Objects.nonNull(pessoa)) {
            Optional.ofNullable(pessoa.getEnderecoPrincipal()).ifPresent(enderecoPrincipal -> {
                cadastroMobiliarioDTO.setCidade(CidadeDTO.from((Cidade)enderecoPrincipal.getCidade()));
                cadastroMobiliarioDTO.setLogradouro(LogradouroDTO.from((Logradouro)enderecoPrincipal.getLogradouro()));
                cadastroMobiliarioDTO.setBairro(BairroDTO.from((Bairro)enderecoPrincipal.getBairro()));
                cadastroMobiliarioDTO.setCep(enderecoPrincipal.getCep());
                cadastroMobiliarioDTO.setNumero(enderecoPrincipal.getNumero());
                cadastroMobiliarioDTO.setComplemento(enderecoPrincipal.getComplemento());
                cadastroMobiliarioDTO.setTipoEnderecoCorrespondencia(TipoEnderecoCorrespondencia.ENDERECO_PESSOA);
                Optional.ofNullable(enderecoPrincipal.getUnidadeFederacao()).map(UnidadeFederacao::getUnidadeFederacao).ifPresent(arg_0 -> ((CadastroMobiliarioDTO)cadastroMobiliarioDTO).setUfCorrespondencia(arg_0));
            });
        }
        if (StringUtils.isNotBlank((CharSequence)laudoMaringaResponseProtocolo.getItem().getTelefone())) {
            cadastroMobiliarioDTO.setTelefone(laudoMaringaResponseProtocolo.getItem().getTelefone());
        }
        if (StringUtils.isNotBlank((CharSequence)laudoMaringaResponseProtocolo.getItem().getAtividadePrincipal())) {
            cadastroMobiliarioDTO.setAtividadePrincipal(laudoMaringaResponseProtocolo.getItem().getAtividadePrincipal());
        }
        Optional.ofNullable(laudoMaringaResponseProtocolo.getItem().getNumero()).filter(StringUtils::isNotBlank).ifPresent(arg_0 -> ((CadastroMobiliarioDTO)cadastroMobiliarioDTO).setNumero(arg_0));
        Optional.ofNullable(laudoMaringaResponseProtocolo.getItem().getComplemento()).filter(StringUtils::isNotBlank).ifPresent(arg_0 -> ((CadastroMobiliarioDTO)cadastroMobiliarioDTO).setComplemento(arg_0));
        if (StringUtils.isNotBlank((CharSequence)laudoMaringaResponseProtocolo.getItem().getCadastroImobiliario())) {
            Optional cadastroImibiliario = this.cadastroGeralRepository.findOneByTipoCadastroAndCadastroGeral(TipoCadastro.IMOBILIARIO, Long.valueOf(laudoMaringaResponseProtocolo.getItem().getCadastroImobiliario()));
            if (!cadastroImibiliario.isPresent()) {
                log.info("O cadastro imobili\u00e1rio {} informado no laudo de Maring\u00e1 n\u00e3o foi encontrado no sistema.", (Object)laudoMaringaResponseProtocolo.getItem().getCadastroImobiliario());
            }
            cadastroImibiliario.ifPresent(cadastro -> {
                CadastroImobiliarioDTO cadastroImobiliarioDTO = new CadastroImobiliarioDTO();
                cadastroImobiliarioDTO.setId(cadastro.getId());
                cadastroImobiliarioDTO.setTipoCadastro(TipoCadastro.IMOBILIARIO);
                cadastroImobiliarioDTO.setCadastroGeral(cadastro.getCadastroGeral());
                cadastroMobiliarioDTO.setCadastroImobiliario(cadastroImobiliarioDTO);
                cadastroMobiliarioDTO.setTipoCadastroSelecionado(String.valueOf(TipoCadastro.IMOBILIARIO.getValue()));
            });
        }
        CadastroMobiliario cadastroMobiliario = cadastroMobiliarioDTO.toEntity();
        this.preencherCnae(cadastroMobiliario, cadastroMobiliarioDTO, laudoMaringaResponseProtocolo.getItem().getCodigoCnae1(), Boolean.TRUE);
        this.preencherCnae(cadastroMobiliario, cadastroMobiliarioDTO, laudoMaringaResponseProtocolo.getItem().getCodigoCnae2(), Boolean.FALSE);
        this.preencherCnae(cadastroMobiliario, cadastroMobiliarioDTO, laudoMaringaResponseProtocolo.getItem().getCodigoCnae3(), Boolean.FALSE);
        this.preencherCnae(cadastroMobiliario, cadastroMobiliarioDTO, laudoMaringaResponseProtocolo.getItem().getCodigoCnae4(), Boolean.FALSE);
        this.preencherSocios(cadastroMobiliario, cadastroMobiliarioDTO, laudoMaringaResponseProtocolo.getItem().getIdProtocolo());
        return cadastroMobiliarioDTO;
    }

    public CadastroMobiliarioDTO preencherCadastroMobiliario(String protocolo) {
        LaudoMaringaResponseProtocolo laudoMaringaResponseProtocolo = this.getLaudoMaringa(protocolo);
        return this.cadastroMobiliarioFromLaudo(laudoMaringaResponseProtocolo);
    }

    public Long extrairNumeroLaudoByNossoNumero(String nossoNumero) {
        return this.extrairLongValido(nossoNumero, 8, 17, "n\u00famero do laudo");
    }

    public Long extrairExercicioLaudoByNossoNumero(String nossoNumero) {
        return this.extrairLongValido(nossoNumero, 0, 4, "exerc\u00edcio do laudo");
    }

    private Long extrairLongValido(String texto, int start, int end, String campo) {
        try {
            if (texto == null || texto.length() < end) {
                throw new IllegalArgumentException();
            }
            String trecho = texto.substring(start, end);
            long valor = Long.parseLong(trecho);
            if (valor <= 0L) {
                throw new IllegalArgumentException();
            }
            return valor;
        }
        catch (Exception e) {
            throw new EloValidationException(String.format("Valor inv\u00e1lido para o %s: '%s'.", campo, texto));
        }
    }

    @Generated
    public LaudoMaringaService(PessoaService pessoaService, CnaeService cnaeService, CadastroGeralRepository cadastroGeralRepository, ParametroGeralService parametroGeralService, RestTemplate restTemplate) {
        this.pessoaService = pessoaService;
        this.cnaeService = cnaeService;
        this.cadastroGeralRepository = cadastroGeralRepository;
        this.parametroGeralService = parametroGeralService;
        this.restTemplate = restTemplate;
    }
}

