/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.dataset.loader.DatasetLoader;
import br.com.elotech.fluent.dataset.loader.DatasetLoaders;
import br.com.elotech.fluent.dataset.loader.ReportDataLoader;
import br.com.elotech.fluent.param.Param;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.report.EloReportFactory;
import br.com.elotech.report.file.ReportFileResolverFactory;
import br.com.elotech.tributos.domain.ArquivoJasper;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.inscricaocadastral.ConfiguracaoInscricaoCadastral;
import br.com.elotech.tributos.dto.ExtratoDebitoDTO;
import br.com.elotech.tributos.dto.acrescimo.CalculaAcrescimoBaseDTO;
import br.com.elotech.tributos.enums.TipoArquivoJasper;
import br.com.elotech.tributos.report.loader.ExtratoDebitoParamLoader;
import br.com.elotech.tributos.repository.CertidaoDividaAtivaRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ArquivoJasperService;
import br.com.elotech.tributos.service.ConfiguracaoInscricaoCadastralService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.util.JasperUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ImpressaoExtratoDebitoCdaService {
    private final FormaPagamentoService formaPagamentoService;
    private final CertidaoDividaAtivaRepository certidaoDividaAtivaRepository;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService;
    private final ExtratoDebitoParamLoader extratoDebitoParamLoader;
    private final ArquivoJasperService arquivoJasperService;
    private final ObjectMapper objectMapper;
    private final ReportFileResolverFactory reportFileResolverFactory;

    public byte[] gerarExtrato(List<Long> idsDocumento) throws IOException {
        FormaPagamento formaPagamentoPadrao = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.empty());
        List debitos = this.certidaoDividaAtivaRepository.findDebitosExtratoCda(idsDocumento);
        debitos = this.calculoAcrescimoService.calculaAcrescimos(debitos, formaPagamentoPadrao.getId(), LocalDate.now(), Boolean.valueOf(true));
        debitos = CalculaAcrescimoBaseDTO.agruparPorParcela((List)debitos);
        ConfiguracaoInscricaoCadastral configuracaoInscricaoCadastral = this.configuracaoInscricaoCadastralService.getConfiguracao();
        debitos.forEach(parcela -> parcela.setInscricaoCadastralComMascara(configuracaoInscricaoCadastral.formatarInscricaoCadastral(parcela.getQuadricula(), parcela.getDistrito(), parcela.getSetor(), parcela.getQuadra(), parcela.getLoteInscricaoCadastral(), parcela.getUnidade())));
        DatasetLoader loader = DatasetLoaders.fromRecords((List)debitos, ExtratoDebitoDTO.class);
        ReportDatasource datasource = ReportDatasource.builder().add("main", (ReportDataLoader)loader).params((ParamLoader)this.extratoDebitoParamLoader).param(Param.of((String)"USUARIO", (Object)SecurityUtils.getUserAise())).param(Param.of((String)"PDataReferencia", (Object)DateUtils.localDateToStringFormatoBrasileiro((LocalDate)LocalDate.now()))).build();
        TipoArquivoJasper tipoArquivoJasper = TipoArquivoJasper.EXTRATO_DEBITO_CDA;
        ArquivoJasper arquivoJasper = this.arquivoJasperService.buscarArquivoJasperPorTipo(tipoArquivoJasper);
        String filePath = JasperUtils.geraCaminhoArquivoJasper((ArquivoJasper)arquivoJasper, (String)tipoArquivoJasper.getNomeInternoComExtensaoJasper());
        byte[] pdf = EloReportFactory.jasper().reportFile(new ReportFileResolverFactory("").fromFile(filePath)).setReportDatasource(datasource).setObjectMapper(this.objectMapper).build().exportToPdf();
        if (Objects.nonNull(arquivoJasper)) {
            Files.deleteIfExists(Paths.get(filePath, new String[0]));
        }
        return pdf;
    }

    @Generated
    public ImpressaoExtratoDebitoCdaService(FormaPagamentoService formaPagamentoService, CertidaoDividaAtivaRepository certidaoDividaAtivaRepository, CalculoAcrescimoService calculoAcrescimoService, ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService, ExtratoDebitoParamLoader extratoDebitoParamLoader, ArquivoJasperService arquivoJasperService, ObjectMapper objectMapper, ReportFileResolverFactory reportFileResolverFactory) {
        this.formaPagamentoService = formaPagamentoService;
        this.certidaoDividaAtivaRepository = certidaoDividaAtivaRepository;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.configuracaoInscricaoCadastralService = configuracaoInscricaoCadastralService;
        this.extratoDebitoParamLoader = extratoDebitoParamLoader;
        this.arquivoJasperService = arquivoJasperService;
        this.objectMapper = objectMapper;
        this.reportFileResolverFactory = reportFileResolverFactory;
    }
}

