/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.ParametroGeral;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.relatorio.Relatorio;
import br.com.elotech.tributos.domain.relatorio.RelatorioPK;
import br.com.elotech.tributos.domain.relatorio.TipoRelatorio;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.SubReportDTO;
import br.com.elotech.tributos.dto.SubReportItemDTO;
import br.com.elotech.tributos.enums.EspelhoEspecifico;
import br.com.elotech.tributos.report.loader.EspelhoImobiliarioParamLoader;
import br.com.elotech.tributos.report.loader.EspelhoMobiliarioParamLoader;
import br.com.elotech.tributos.service.ImpressaoEspelhoCadastrosService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.RelatorioService;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.stereotype.Service;

@Service
public class ImpressaoEspelhoCadastrosService {
    private final EspelhoImobiliarioParamLoader espelhoImobiliarioParamLoader;
    private final EspelhoMobiliarioParamLoader espelhoMobiliarioParamLoader;
    private final RelatorioService relatorioService;
    private final ParametroGeralService parametroGeralService;
    private static final String TIPOS_PERMITIDOS_MSG = ". Tipos permitidos: ";
    private static final String VALOR_INVALIDO_PARAMETRO = "Valor inv\u00e1lido para convers\u00e3o do par\u00e2metro ";
    private static final int VALOR_RELATORIO_TIPO_SISTEMA_INTERGER = 0;
    private static final int VALOR_RELATORIO_TIPO_USUARIO_INTERGER = 1;
    private static final String VALOR_RELATORIO_TIPO_SISTEMA_VARCHAR = "S";
    private static final String VALOR_RELATORIO_TIPO_USUARIO_VARCHAR = "U";

    public ImpressaoEspelhoCadastrosService(EspelhoImobiliarioParamLoader espelhoImobiliarioParamLoader, EspelhoMobiliarioParamLoader espelhoMobiliarioParamLoader, RelatorioService relatorioService, ParametroGeralService parametroGeralService) {
        this.espelhoImobiliarioParamLoader = espelhoImobiliarioParamLoader;
        this.espelhoMobiliarioParamLoader = espelhoMobiliarioParamLoader;
        this.relatorioService = relatorioService;
        this.parametroGeralService = parametroGeralService;
    }

    public ImprimirRelatorioDTO buildImpressaoEspelhoDTO(TipoCadastro tipoCadastro, Long cadastroGeral) {
        Integer relatorio = this.findRelatoriosEspelho(tipoCadastro);
        Integer tipoRelatorio = this.findTipoRelatorioEpelho(tipoCadastro);
        ImprimirRelatorioDTO dto = new ImprimirRelatorioDTO();
        dto.setRelatorio(relatorio);
        dto.setTipoRelatorio(TipoRelatorio.fromInteger((Integer)tipoRelatorio));
        return this.completeRelatorioDTO(dto, tipoCadastro, cadastroGeral);
    }

    public ImprimirRelatorioDTO buildImpressaoEspelhoEspecificoCompletoDTO(TipoCadastro tipoCadastro, Long cadastroGeral) {
        return this.buildImpressaoEspelhoEspecificoDTO(tipoCadastro, cadastroGeral, EspelhoEspecifico.COMPLETO);
    }

    public ImprimirRelatorioDTO buildImpressaoEspelhoEspecificoResumidoDTO(TipoCadastro tipoCadastro, Long cadastroGeral) {
        return this.buildImpressaoEspelhoEspecificoDTO(tipoCadastro, cadastroGeral, EspelhoEspecifico.RESUMIDO);
    }

    public ImprimirRelatorioDTO buildImpressaoEspelhoEspecificoDTO(TipoCadastro tipoCadastro, Long cadastroGeral, EspelhoEspecifico espelhoEspecifico) {
        Integer relatorio = this.findRelatoriosEspelhoEspecifico(tipoCadastro, espelhoEspecifico);
        Integer tipoRelatorio = this.findTipoRelatoriosEspelhoEspecifico(tipoCadastro, espelhoEspecifico);
        ImprimirRelatorioDTO dto = new ImprimirRelatorioDTO();
        dto.setRelatorio(relatorio);
        dto.setTipoRelatorio(TipoRelatorio.fromInteger((Integer)tipoRelatorio));
        return this.completeRelatorioDTO(dto, tipoCadastro, cadastroGeral);
    }

    public Integer findRelatoriosEspelhoEspecifico(TipoCadastro tipoCadastro, EspelhoEspecifico tipoEspelhoEspecifico) {
        this.validateTipoCadastroIsImobiliario(tipoCadastro);
        Map<EspelhoEspecifico, ParametroGeralEnum> parametros = Map.of(EspelhoEspecifico.COMPLETO, ParametroGeralEnum.ESPELHO_ESPECIFICO_COMPLETO_IMOBILIARIO, EspelhoEspecifico.RESUMIDO, ParametroGeralEnum.ESPELHO_ESPECIFICO_RESUMIDO_IMOBILIARIO);
        this.validadeTipoEspelhoEspecifico(tipoEspelhoEspecifico);
        return this.getParametroGeralComoInteger(parametros.get(tipoEspelhoEspecifico));
    }

    public Integer findTipoRelatoriosEspelhoEspecifico(TipoCadastro tipoCadastro, EspelhoEspecifico tipoEspelhoEspecifico) {
        this.validateTipoCadastroIsImobiliario(tipoCadastro);
        Map<EspelhoEspecifico, ParametroGeralEnum> parametros = Map.of(EspelhoEspecifico.COMPLETO, ParametroGeralEnum.TIPO_ESPELHO_ESPECIFICO_COMPLETO_IMOBILIARIO, EspelhoEspecifico.RESUMIDO, ParametroGeralEnum.TIPO_ESPELHO_ESPECIFICO_RESUMIDO_IMOBILIARIO);
        this.validadeTipoEspelhoEspecifico(tipoEspelhoEspecifico);
        return this.getTipoEspelhoParametroGeralVarcharToInteger(parametros.get(tipoEspelhoEspecifico));
    }

    private void validadeTipoEspelhoEspecifico(EspelhoEspecifico tipoEspelhoEspecifico) {
        if (tipoEspelhoEspecifico != EspelhoEspecifico.COMPLETO && tipoEspelhoEspecifico != EspelhoEspecifico.RESUMIDO) {
            throw new EloValidationException("Tipo de espelho espec\u00edfico inv\u00e1lido: " + String.valueOf(tipoEspelhoEspecifico) + TIPOS_PERMITIDOS_MSG + String.valueOf(EspelhoEspecifico.COMPLETO) + ", " + String.valueOf(EspelhoEspecifico.RESUMIDO));
        }
    }

    private void validateTipoCadastroIsImobiliario(TipoCadastro tipoCadastro) {
        if (tipoCadastro != TipoCadastro.IMOBILIARIO) {
            throw new EloValidationException("Tipo de cadastro n\u00e3o permitido. Apenas IMOBILI\u00c1RIO \u00e9 suportado.");
        }
    }

    public Integer findRelatoriosEspelho(TipoCadastro tipoCadastro) {
        Map<TipoCadastro, ParametroGeralEnum> parametros = Map.of(TipoCadastro.IMOBILIARIO, ParametroGeralEnum.RELATORIO_CAD_IMOBILIARIO_WEB, TipoCadastro.MOBILIARIO, ParametroGeralEnum.RELATORIO_CAD_MOBILIARIO_WEB);
        if (!parametros.containsKey(tipoCadastro)) {
            throw new EloValidationException("Tipo de cadastro inv\u00e1lido: " + String.valueOf(tipoCadastro) + TIPOS_PERMITIDOS_MSG + String.valueOf(parametros.keySet()));
        }
        return this.getParametroGeralComoInteger(parametros.get(tipoCadastro));
    }

    public Integer findTipoRelatorioEpelho(TipoCadastro tipoCadastro) {
        Map<TipoCadastro, ParametroGeralEnum> parametros = Map.of(TipoCadastro.IMOBILIARIO, ParametroGeralEnum.TIPO_RELATORIO_CAD_IMOBILIARIO_WEB, TipoCadastro.MOBILIARIO, ParametroGeralEnum.TIPO_RELATORIO_CAD_MOBILIARIO_WEB);
        ParametroGeralEnum parametro = parametros.get(tipoCadastro);
        if (parametro == null) {
            throw new EloValidationException("Tipo de cadastro inv\u00e1lido: " + String.valueOf(tipoCadastro) + ". Os tipos permitidos s\u00e3o: " + String.valueOf(parametros.keySet()));
        }
        return this.getTipoEspelhoParametroGeralVarcharToInteger(parametro);
    }

    private Integer getParametroGeralComoInteger(ParametroGeralEnum parametro) {
        String valor = this.buscarParametroGeral(parametro);
        return this.converterStringToInteger(valor, parametro);
    }

    private Integer getTipoEspelhoParametroGeralVarcharToInteger(ParametroGeralEnum parametro) {
        String valor = this.buscarParametroGeral(parametro);
        return this.converterParaIntegerVarchar(valor, parametro);
    }

    private String buscarParametroGeral(ParametroGeralEnum parametro) {
        return Optional.ofNullable(this.parametroGeralService.findByParametroAndModulo(parametro, ModuloEnum.MODULO_TRIBUTARIO.getValue())).map(ParametroGeral::getValor).filter(v -> !v.trim().isEmpty()).orElseThrow(() -> new EloValidationException(VALOR_INVALIDO_PARAMETRO + parametro.getValue()));
    }

    private Integer converterStringToInteger(String valor, ParametroGeralEnum parametro) {
        if (!NumberUtils.isParsable((String)valor.trim())) {
            throw new EloValidationException(VALOR_INVALIDO_PARAMETRO + parametro.getValue() + ": '" + valor + "'");
        }
        return Integer.parseInt(valor.trim());
    }

    private Integer converterParaIntegerVarchar(String valor, ParametroGeralEnum parametro) {
        Map<String, Integer> conversoes = Map.of(VALOR_RELATORIO_TIPO_SISTEMA_VARCHAR.toUpperCase(), 0, VALOR_RELATORIO_TIPO_USUARIO_VARCHAR.toUpperCase(), 1);
        return Optional.ofNullable(conversoes.get(valor.toUpperCase())).orElseThrow(() -> new EloValidationException(VALOR_INVALIDO_PARAMETRO + parametro.getValue() + ": '" + valor + "'"));
    }

    private ImprimirRelatorioDTO completeRelatorioDTO(ImprimirRelatorioDTO dto, TipoCadastro tipoCadastro, Long cadastroGeral) {
        this.validateRelatorio(dto);
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$TipoCadastro[tipoCadastro.ordinal()]) {
            case 1: {
                dto.setFiltro(String.format(" cg.TipoCadastro = %d and cg.CadastroGeral = %d", tipoCadastro.getValue(), cadastroGeral));
                dto.setListParametros(this.espelhoImobiliarioParamLoader.load());
                dto.setSubReports(this.getSubReportImobiliarioDTO(dto.getFiltro(), cadastroGeral));
                break;
            }
            case 2: {
                dto.setFiltro(String.format(" ( tcm.CadastroGeral = %d ) ", cadastroGeral));
                dto.setListParametros(this.espelhoMobiliarioParamLoader.load());
                dto.setSubReports(this.getSubReportMobiliarioDTO(dto.getFiltro()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Tipo de cadastro desconhecido: " + String.valueOf(tipoCadastro));
            }
        }
        return dto;
    }

    private void validateRelatorio(ImprimirRelatorioDTO dto) {
        Integer tipoRelatorio = dto.getTipoRelatorio();
        Integer idRelatorio = dto.getRelatorio();
        if (Objects.isNull(idRelatorio) || Objects.isNull(tipoRelatorio)) {
            throw new EloValidationException("Tipo de Relat\u00f3rio ou ID do Relat\u00f3rio inv\u00e1lidos.");
        }
        TipoRelatorio tipo = TipoRelatorio.fromInteger((Integer)tipoRelatorio);
        Relatorio relatorio = (Relatorio)this.relatorioService.findById((Serializable)RelatorioPK.builder().modulo(ModuloEnum.MODULO_TRIBUTARIO.getValue()).tipoRelatorio(tipo).relatorio(idRelatorio).build()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar relat\u00f3rio com os par\u00e2metros: M\u00f3dulo: [%s], Tipo Relat\u00f3rio: [%s], Relat\u00f3rio: [%s].", ModuloEnum.MODULO_TRIBUTARIO.getValue(), tipoRelatorio, idRelatorio)));
        dto.setRelatorio(relatorio.getRelatorio());
    }

    private SubReportDTO getSubReportImobiliarioDTO(String filtro, Long cadastroGeral) {
        SubReportDTO subReportDTO = new SubReportDTO();
        String filtroGeminada = String.format(" tcig.TipoCadastro = %d and tcig.CadastroGeral = %d", TipoCadastro.IMOBILIARIO.getValue(), cadastroGeral);
        String filtroSegmentoDemolicao = String.format(" tisd.TipoCadastro = %d and tisd.CadastroGeral = %d", TipoCadastro.IMOBILIARIO.getValue(), cadastroGeral);
        subReportDTO.setItems((Set)Sets.newHashSet((Object[])new SubReportItemDTO[]{new SubReportItemDTO("PROPRIETARIOS", filtro), new SubReportItemDTO("TESTADA", filtro), new SubReportItemDTO("CAUCAO", filtro), new SubReportItemDTO("TERRENO", filtro), new SubReportItemDTO("SEGMENTO", filtro), new SubReportItemDTO("ObservacaoImobiliario", filtro), new SubReportItemDTO("AREAVERDE", filtro), new SubReportItemDTO("Geminada", filtroGeminada), new SubReportItemDTO("Isencao", filtro), new SubReportItemDTO("SegmentoDemolicao", filtroSegmentoDemolicao), new SubReportItemDTO("TESTADA_GENERICA", filtro)}));
        return subReportDTO;
    }

    private SubReportDTO getSubReportMobiliarioDTO(String filtro) {
        SubReportDTO subReportDTO = new SubReportDTO();
        subReportDTO.setItems((Set)Sets.newHashSet((Object[])new SubReportItemDTO[]{new SubReportItemDTO("Atividade", filtro), new SubReportItemDTO("Servico", filtro), new SubReportItemDTO("Socio", filtro), new SubReportItemDTO("Observacao", filtro), new SubReportItemDTO("BOLETIMMOBILIARIO", filtro), new SubReportItemDTO("CNAE", filtro)}));
        return subReportDTO;
    }
}

