/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.DocumentoCertidaoItem;
import br.com.elotech.tributos.domain.DocumentoFinalidade;
import br.com.elotech.tributos.domain.DocumentoTipo;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.SituacaoDocumento;
import br.com.elotech.tributos.dto.DocumentoCertidaoItemDTO;
import br.com.elotech.tributos.dto.FiltroProjetoDTO;
import br.com.elotech.tributos.dto.GeracaoDocumentoDTO;
import br.com.elotech.tributos.repository.CadastroGeralIsencaoRepository;
import br.com.elotech.tributos.service.CalculaValidadeDocumentoService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DocumentoFinalidadeService;
import br.com.elotech.tributos.service.DocumentoTipoService;
import br.com.elotech.tributos.service.EntidadeTributacaoService;
import br.com.elotech.tributos.util.UsuarioUtils;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@Transactional
public class GeraDocumentoService {
    private final EntidadeTributacaoService entidadeTributacaoService;
    private final DocumentoTipoService documentoTipoService;
    private final ContextService contextService;
    private final CalculaValidadeDocumentoService calculaValidadeDocumentoService;
    private final DocumentoFinalidadeService documentoFinalidadeService;
    private final CadastroGeralIsencaoRepository cadastroGeralIsencaoRepository;

    public GeraDocumentoService(EntidadeTributacaoService entidadeTributacaoService, DocumentoTipoService documentoTipoService, ContextService contextService, CalculaValidadeDocumentoService calculaValidadeDocumentoService, DocumentoFinalidadeService documentoFinalidadeService, CadastroGeralIsencaoRepository cadastroGeralIsencaoRepository) {
        this.entidadeTributacaoService = entidadeTributacaoService;
        this.documentoTipoService = documentoTipoService;
        this.contextService = contextService;
        this.calculaValidadeDocumentoService = calculaValidadeDocumentoService;
        this.documentoFinalidadeService = documentoFinalidadeService;
        this.cadastroGeralIsencaoRepository = cadastroGeralIsencaoRepository;
    }

    public void validateDocumento(DocumentoTipo tipoDocumento, Pessoa pessoa, CadastroGeral cadastroGeral, Long idProcesso, FiltroProjetoDTO dadosProjeto, Long idFinalidade) {
        Assert.notNull((Object)tipoDocumento, (String)"Necess\u00e1rio informar o tipo documento.");
        Assert.notNull((Object)tipoDocumento.getRelatorio(), (String)String.format("Tipo de documento \"%s\" n\u00e3o possui relat\u00f3rio configurado.", tipoDocumento.getDescricao()));
        if (tipoDocumento.getExigeProcesso().booleanValue() && Objects.isNull(idProcesso)) {
            throw new EloValidationException("Necess\u00e1rio informar o processo.");
        }
        if (Objects.isNull(pessoa) && Objects.isNull(cadastroGeral)) {
            throw new EloValidationException("Necess\u00e1rio informar contribuinte ou cadastro geral.");
        }
        if (Boolean.TRUE.equals(tipoDocumento.getExigeProjeto()) && Objects.isNull(dadosProjeto)) {
            throw new EloValidationException("Necess\u00e1rio informar o projeto.");
        }
        if (Boolean.TRUE.equals(tipoDocumento.getExigeFinalidade()) && Objects.isNull(idFinalidade)) {
            throw new EloValidationException("Finalidade da Certid\u00e3o \u00e9 obrigat\u00f3rio.");
        }
    }

    public Documento getDocumentoAndValida(GeracaoDocumentoDTO geracaoDocumentoDto) {
        DocumentoTipo tipoDocumento = this.documentoTipoService.findById(geracaoDocumentoDto.getIdTipoDocumento());
        String usuarioAise = geracaoDocumentoDto.getUsuario();
        if (StringUtils.isBlank((CharSequence)usuarioAise)) {
            usuarioAise = UsuarioUtils.getUsuarioAise();
        }
        this.validateDocumento(tipoDocumento, geracaoDocumentoDto.getPessoa(), geracaoDocumentoDto.getCadastroGeral(), geracaoDocumentoDto.getIdProcesso(), geracaoDocumentoDto.getDadosProjeto(), geracaoDocumentoDto.getIdFinalidade());
        Long entidade = this.contextService.getEntidadePrincipal();
        Long exercicio = this.contextService.getExercicioAtual();
        Documento documento = new Documento();
        documento.setEntidade(entidade);
        documento.setExercicio(exercicio);
        documento.setTipoDocumento(tipoDocumento.getId());
        documento.setDocumentoTipo(tipoDocumento);
        documento.setDataEmissao(geracaoDocumentoDto.getDataEmissao() != null ? geracaoDocumentoDto.getDataEmissao() : LocalDate.now());
        documento.setDataSolicitacao(documento.getDataEmissao());
        documento.setUsuario(usuarioAise);
        documento.setRequerente(geracaoDocumentoDto.getRequerenteNome());
        documento.setCpfRequerente(geracaoDocumentoDto.getRequerenteCpfCnpj());
        documento.setTipoPessoaRequerente(geracaoDocumentoDto.getTipoPessoaRequerente());
        documento.setIdProcesso(geracaoDocumentoDto.getIdProcesso());
        documento.setExercicioProcesso(geracaoDocumentoDto.getExercicioProcesso());
        documento.setObservacao(geracaoDocumentoDto.getObservacao());
        documento.setWeb(geracaoDocumentoDto.getWeb());
        documento.setCertidaoEspecial(geracaoDocumentoDto.getCertidaoEspecial());
        documento.setIdSequenciaItbi(geracaoDocumentoDto.getIdSequenciaItbi());
        documento.setProcessoSei(geracaoDocumentoDto.getProcessoSei());
        documento.setCodigoPgd(geracaoDocumentoDto.getCodigoPgd());
        documento.setNumeroPrimeiroAlvara(geracaoDocumentoDto.getNumeroPrimeiroAlvara());
        documento.setAnoEmissaoAlvara(geracaoDocumentoDto.getAnoEmissaoAlvara());
        documento.setDataPrimeiroAlvara(geracaoDocumentoDto.getDataPrimeiroAlvara());
        documento.setCodigoPrancha(geracaoDocumentoDto.getCodigoPrancha());
        documento.setAreaAcrescimoOrDecrescimo(geracaoDocumentoDto.getAreaAcrescimoOrDecrescimo());
        documento.setAreaTotalConstruida(geracaoDocumentoDto.getAreaTotalConstruida());
        documento.setSolicitacaoAlvara(geracaoDocumentoDto.getSolicitacaoAlvara());
        if (Boolean.TRUE.equals(tipoDocumento.getPossuiCabecalho())) {
            documento.setCabecalho(geracaoDocumentoDto.getCabecalho());
        }
        if (Boolean.TRUE.equals(tipoDocumento.getPossuiRodape())) {
            documento.setRodape(geracaoDocumentoDto.getRodape());
        }
        Optional.ofNullable(geracaoDocumentoDto.getPessoa()).ifPresent(pessoa -> {
            documento.setPessoa(pessoa);
            documento.setCnpjCpf(pessoa.getCnpjCpf());
        });
        Optional.ofNullable(geracaoDocumentoDto.getCadastroGeral()).ifPresent(cadastro -> {
            documento.setCadastroGeral(cadastro);
            documento.setTipoCadastro(cadastro.getTipoCadastro());
            documento.setCodigoCadastroGeral(cadastro.getCadastroGeral());
            documento.setPessoa(cadastro.getPessoa());
            documento.setCnpjCpf(cadastro.getPessoa().getCnpjCpf());
        });
        documento.setSituacao(SituacaoDocumento.aberto());
        documento.setEntidadeTributacao(this.entidadeTributacaoService.findByEntidadeIdAndExercicio(entidade, exercicio));
        if (Objects.nonNull(geracaoDocumentoDto.getIdFinalidade())) {
            DocumentoFinalidade documentoFinalidade = this.documentoFinalidadeService.findByIdAndTipoDocumento(geracaoDocumentoDto.getIdFinalidade(), tipoDocumento);
            documento.setDocumentoFinalidade(documentoFinalidade);
            documento.setSequenciaFinalidade(documentoFinalidade.getSequencia());
        }
        documento.setDataValidade(this.calculaValidadeDocumentoService.calculaDataValidade(tipoDocumento, documento.getDocumentoFinalidade()));
        Optional.ofNullable(geracaoDocumentoDto.getDadosProjeto()).ifPresent(projeto -> {
            documento.setNumeroProjeto(projeto.getNumeroProjeto());
            documento.setExercicioProjeto(projeto.getExercicio());
        });
        List documentoCertidaoItems = Optional.ofNullable(geracaoDocumentoDto.getDocumentoCertidaoItens()).orElse(Collections.emptyList()).stream().map(arg_0 -> this.buildDocumentoCertidaoItem(arg_0)).collect(Collectors.toList());
        documento.setDocumentoCertidaoItems(documentoCertidaoItems);
        return documento;
    }

    public DocumentoCertidaoItem buildDocumentoCertidaoItem(DocumentoCertidaoItemDTO dto) {
        DocumentoCertidaoItem item = new DocumentoCertidaoItem();
        item.setArea(dto.getArea());
        item.setAreaFiscalizada(dto.getAreaFiscalizada());
        item.setTipoConstrucao(dto.getIdTipoConstrucao());
        item.setDataAprovacao(dto.getDataAprovacao());
        item.setNumeroAlvara(dto.getNumeroAlvara());
        item.setAnoAlvara(dto.getAnoAlvara());
        item.setNumeroHabitese(dto.getNumeroHabitese());
        item.setAnoHabitese(dto.getAnoHabitese());
        item.setRegular(dto.getRegular());
        item.setExpedicao(dto.getExpedicao());
        item.setUtilizacao(dto.getIdUtilizacao());
        item.setAtualizado(dto.getAtualizado());
        item.setTipoSegmento(dto.getIdTipoSegmento());
        item.setSituacao(dto.getSituacao());
        item.setSituacaoDesc(dto.getSituacaoDesc());
        item.setDataHabitese(dto.getDataHabitese());
        item.setAreaCoberta(dto.getAreaCoberta());
        item.setAreaCobertaAprovada(dto.getAreaCobertaAprovada());
        item.setAreaCobertaConcluida(dto.getAreaCobertaConcluida());
        item.setAreaCobertaRenovar(dto.getAreaCobertaRenovar());
        item.setAreaCobertaParcial(dto.getAreaCobertaParcial());
        item.setAreaCobertaAcumulada(dto.getAreaCobertaAcumulada());
        item.setAreaCobertaAConcluir(dto.getAreaCobertaAConcluir());
        item.setAreaCobertaExistente(dto.getAreaCobertaExistente());
        item.setAreaCobertaDemolida(dto.getAreaCobertaDemolida());
        item.setAreaCobertaRemanescente(dto.getAreaCobertaRemanescente());
        item.setAreaDescoberta(dto.getAreaDescoberta());
        item.setAreaDescobertaAprovada(dto.getAreaDescobertaAprovada());
        item.setAreaDescobertaConcluida(dto.getAreaDescobertaConcluida());
        item.setAreaDescobertaRenovar(dto.getAreaDescobertaRenovar());
        item.setAreaDescobertaParcial(dto.getAreaDescobertaParcial());
        item.setAreaDescobertaAcumulada(dto.getAreaDescobertaAcumulada());
        item.setAreaDescobertaAConcluir(dto.getAreaDescobertaAConcluir());
        item.setAreaDescobertaExistente(dto.getAreaDescobertaExistente());
        item.setAreaDescobertaDemolida(dto.getAreaDescobertaDemolida());
        item.setAreaDescobertaRemanescente(dto.getAreaDescobertaRemanescente());
        item.setCodigo(dto.getCodigo());
        item.setPadrao(dto.getIdRespostaSegmentoPadrao());
        item.setAnoConstrucao(dto.getAnoConstrucao());
        return item;
    }
}

