/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.domain.Exercicio;
import br.com.elotech.tributos.repository.ExercicioRepository;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ExercicioService {
    private final ExercicioRepository exercicioRepository;

    public Long getExercicio() {
        return LocalDate.now().getYear();
    }

    public Long getMes() {
        return LocalDate.now().getMonthValue();
    }

    public LocalDate getDataAtual() {
        return LocalDate.now();
    }

    public Optional<Exercicio> findByExercicioAndEntidade(Long exercicioAtual, Long entidadePrincipal) {
        return Optional.ofNullable(this.exercicioRepository.findByEntidadeIdAndExercicio(entidadePrincipal, exercicioAtual));
    }

    @Generated
    public ExercicioService(ExercicioRepository exercicioRepository) {
        this.exercicioRepository = exercicioRepository;
    }
}

