/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.AcertoPagamento;
import br.com.elotech.tributos.domain.ConfigHonorario;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.EstornoPagamento;
import br.com.elotech.tributos.domain.EstornoPagamentoId;
import br.com.elotech.tributos.domain.EstornoPagamentoItem;
import br.com.elotech.tributos.domain.EstornoPagamentoItemId;
import br.com.elotech.tributos.domain.EstornoPagamentoLote;
import br.com.elotech.tributos.domain.EstornoPagamentoLoteItem;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.PagamentoDebito;
import br.com.elotech.tributos.domain.PagamentoId;
import br.com.elotech.tributos.domain.PagamentoNegociado;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoSituacaoParcela;
import br.com.elotech.tributos.domain.pagamentocredito.PagamentoCredito;
import br.com.elotech.tributos.dto.DetalheEstornoPagamentoDTO;
import br.com.elotech.tributos.dto.PagamentoNegociadoSituacaoEnum;
import br.com.elotech.tributos.dto.pagamento.EstornoPagamentoDTO;
import br.com.elotech.tributos.dto.pagamento.ReabilitacaoEstornoPagamentoDTO;
import br.com.elotech.tributos.enums.SituacaoPagamentoDebitoEnum;
import br.com.elotech.tributos.enums.pagamentocredito.OrigemCredito;
import br.com.elotech.tributos.repository.AcertoPagamentoRepository;
import br.com.elotech.tributos.repository.EstornoPagamentoRepository;
import br.com.elotech.tributos.repository.PagamentoNegociadoRepository;
import br.com.elotech.tributos.repository.PagamentoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoObservacaoService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.EstornoPagamentoLoteService;
import br.com.elotech.tributos.service.PagamentoDebitoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.ValidaDataMovimentacaoService;
import br.com.elotech.tributos.service.honorarios.GerarHonorarioBloquetoService;
import br.com.elotech.tributos.service.impl.EntidadeServiceImpl;
import br.com.elotech.tributos.service.pagamentocredito.CreditoService;
import br.com.elotech.tributos.util.UsuarioUtils;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class EstornoPagamentoService
extends CrudService<EstornoPagamento, EstornoPagamentoId> {
    private final EstornoPagamentoRepository estornoPagamentoRepository;
    private final ContextService contextService;
    private final PagamentoRepository pagamentoRepository;
    private final ValidaDataMovimentacaoService validaDataMovimentacaoService;
    private final PagamentoDebitoService pagamentoDebitoService;
    private final DebitoParcelaService debitoParcelaService;
    private final DebitoService debitoService;
    private final DebitoObservacaoService debitoObservacaoService;
    private final EstornoPagamentoLoteService estornoPagamentoLoteService;
    private final CreditoService pagamentoCreditoService;
    private final ParametroGeralService parametroGeralService;
    private final AcertoPagamentoRepository acertoPagamentoRepository;
    private final EntidadeServiceImpl entidadeServiceImpl;
    private final GerarHonorarioBloquetoService gerarHonorarioBloquetoService;
    private final PagamentoNegociadoRepository pagamentoNegociadoRepository;
    private static final String UF_PARANA = "PR";

    public List<DetalheEstornoPagamentoDTO> getEstornoPagamentosById(Long entidade, Long exercicioPagamento, Long pagamento) {
        List estornoPagamento = this.estornoPagamentoRepository.findEstornoPagamentoByPagamento(entidade, exercicioPagamento, pagamento);
        return estornoPagamento.stream().map(DetalheEstornoPagamentoDTO::of).collect(Collectors.toList());
    }

    private void validarEstorno(EstornoPagamentoDTO estornoPagamentoDTO) {
        this.validarDadosParaIniciarFluxoDeEstornoDePagamentos(estornoPagamentoDTO);
        this.createParametros(estornoPagamentoDTO);
        this.validarContextoParaEstornoDePagamento(estornoPagamentoDTO);
    }

    public EstornoPagamento estornarPagamentoIndividual(EstornoPagamentoDTO estornoPagamentoDTO) {
        this.validarEstorno(estornoPagamentoDTO);
        EstornoPagamentoDTO.Parametros parametros = estornoPagamentoDTO.getParametrosFluxo();
        long entidade = parametros.idEntidade;
        long exercicio = parametros.exercicioAtual;
        List pagamentosParaEstornar = estornoPagamentoDTO.getParametrosFluxo().pagamentos;
        return this.criarEstornoPagamento(Long.valueOf(entidade), Long.valueOf(exercicio), estornoPagamentoDTO, (Pagamento)pagamentosParaEstornar.get(0));
    }

    public void estornarPagamento(EstornoPagamentoDTO estornoPagamentoDTO) {
        this.validarEstorno(estornoPagamentoDTO);
        this.estornar(estornoPagamentoDTO);
    }

    private void createParametros(EstornoPagamentoDTO estornoPagamentoDTO) {
        Long entidade = this.contextService.getEntidadePrincipal();
        Long exercicio = this.contextService.getExercicioAtual();
        List pagamentos = this.findPagamentosParaEstornar(estornoPagamentoDTO, entidade);
        boolean isEntidadeDoParana = this.isEntidadeDoParana(entidade);
        boolean canEstornarPagamentoExercicioAnterior = this.getValorBooleanoDoParametro(ParametroGeralEnum.ESTORNOEXERCIANTERIOR);
        boolean deveConverterEmCredito = estornoPagamentoDTO.getUtilizarComoCredito();
        boolean anyPagamentoDeExercicioAnterior = this.hasPagamentosDeExerciciosAnteriores(pagamentos);
        EstornoPagamentoDTO.Parametros parametros = EstornoPagamentoDTO.Parametros.builder().idEntidade(entidade.longValue()).exercicioAtual(exercicio.longValue()).isEntidadeParana(isEntidadeDoParana).existePagamentoExercicioAnterior(anyPagamentoDeExercicioAnterior).podeEstornarPagamentoExercicioAnterior(canEstornarPagamentoExercicioAnterior).deveConverterParaCredito(deveConverterEmCredito).pagamentos(pagamentos).build();
        estornoPagamentoDTO.setParametrosFluxo(parametros);
    }

    private void validarDadosParaIniciarFluxoDeEstornoDePagamentos(EstornoPagamentoDTO estornoPagamentoDTO) {
        if (Boolean.TRUE.equals(estornoPagamentoDTO.getTodosSelecionados())) {
            if (Objects.isNull(estornoPagamentoDTO.getFiltro())) {
                throw new EloValidationException("\u00c9 obrigat\u00f3rio informar o filtro quando todos os pagamentos estiverem selecionados.");
            }
        } else if (estornoPagamentoDTO.getSelecionados().isEmpty()) {
            throw new EloValidationException("\u00c9 obrigat\u00f3rio informar pelo menos um pagamento.");
        }
    }

    private void validarContextoParaEstornoDePagamento(EstornoPagamentoDTO estornoPagamentoDTO) {
        EstornoPagamentoDTO.Parametros parametros = estornoPagamentoDTO.getParametrosFluxo();
        List pagamentos = parametros.pagamentos;
        this.validaSeTemPagamentoParaEstornar(pagamentos);
        this.validaSeADataDeEstornoEPosteriorADataDeLancamento(estornoPagamentoDTO.getData(), pagamentos);
        this.validaSeMedEDiaEstaAberto(estornoPagamentoDTO);
        this.validaPagamentosDeExerciciosAnteriores(parametros);
        this.executaValidacoesSeEntidadeDoParana(parametros);
    }

    private void validaSeTemPagamentoParaEstornar(List<Pagamento> pagamentosParaEstornar) {
        if (pagamentosParaEstornar.isEmpty()) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel encontrar pagamentos com os filtros informados.");
        }
    }

    private void validaSeADataDeEstornoEPosteriorADataDeLancamento(LocalDate data, List<Pagamento> pagamentosParaEstornar) {
        boolean existePagamentoPagoDepoisDaDataDoEstorno = pagamentosParaEstornar.stream().anyMatch(pagamento -> data.isBefore(pagamento.getDataMovimento()));
        if (existePagamentoPagoDepoisDaDataDoEstorno) {
            throw new EloValidationException("A data do estorno deve ser maior que a data de lan\u00e7amento de todos os pagamentos selecionados.");
        }
    }

    private void validaSeMedEDiaEstaAberto(EstornoPagamentoDTO dto) {
        long entidade = dto.getParametrosFluxo().idEntidade;
        LocalDate dataEstorno = dto.getData();
        this.validaDataMovimentacaoService.validaMesEDia(Long.valueOf(entidade), dataEstorno);
    }

    private void validaPagamentosDeExerciciosAnteriores(EstornoPagamentoDTO.Parametros parametros) {
        boolean permiteEstornoExercicioAnterior = parametros.podeEstornarPagamentoExercicioAnterior;
        boolean existePagamentoExerciciosAnteriores = parametros.existePagamentoExercicioAnterior;
        if (existePagamentoExerciciosAnteriores && !permiteEstornoExercicioAnterior) {
            throw new EloValidationException("N\u00e3o \u00e9 permitido estornar pagamentos de exercicios anteriores");
        }
    }

    private void executaValidacoesSeEntidadeDoParana(EstornoPagamentoDTO.Parametros parametros) {
        boolean isEntidadeDoParana = parametros.isEntidadeParana;
        boolean deveConverterEmCredito = parametros.deveConverterParaCredito;
        boolean existePagamentoExercicioAnterior = parametros.existePagamentoExercicioAnterior;
        if (existePagamentoExercicioAnterior && isEntidadeDoParana && !deveConverterEmCredito) {
            List pagamentos = this.getPagamentoDeExerciciosAnteriores(parametros.pagamentos);
            String identificacaoPagamentos = this.identificaPagamentoDeExerciciosAnteriores(pagamentos);
            String mensagem = "Existe pagamento de exercicios anteriores. Para esses casos, deve gerar cr\u00e9dito, para realizar acerto de pagamento ou restitui\u00e7\u00e3o, ou realizar a restitui\u00e7\u00e3o do pagamento diretamente. S\u00e3o eles: " + identificacaoPagamentos;
            throw new EloValidationException(mensagem);
        }
    }

    private List<Pagamento> findPagamentosParaEstornar(EstornoPagamentoDTO estornoPagamentoDTO, Long entidade) {
        if (Boolean.TRUE.equals(estornoPagamentoDTO.getTodosSelecionados())) {
            estornoPagamentoDTO.setTodosSelecionados(Boolean.TRUE);
            return this.pagamentoRepository.findPagamentos(this.contextService.getEntidadePrincipal(), estornoPagamentoDTO.getFiltro());
        }
        List pagamentoIds = estornoPagamentoDTO.getSelecionados().stream().map(selecionado -> {
            PagamentoId pagamentoId = new PagamentoId();
            pagamentoId.setEntidade(entidade);
            pagamentoId.setExercicioPagamento(selecionado.getExercicio());
            pagamentoId.setPagamento(selecionado.getPagamento());
            return pagamentoId;
        }).collect(Collectors.toList());
        return this.pagamentoRepository.findAllById(pagamentoIds);
    }

    private void estornar(EstornoPagamentoDTO estornoPagamentoDTO) {
        EstornoPagamentoDTO.Parametros parametros = estornoPagamentoDTO.getParametrosFluxo();
        long entidade = parametros.idEntidade;
        long exercicio = parametros.exercicioAtual;
        List pagamentosParaEstornar = estornoPagamentoDTO.getParametrosFluxo().pagamentos;
        if (pagamentosParaEstornar.size() == 1) {
            this.criarEstornoPagamento(Long.valueOf(entidade), Long.valueOf(exercicio), estornoPagamentoDTO, (Pagamento)pagamentosParaEstornar.get(0));
            return;
        }
        this.criarEstornoPagamentoLote(Long.valueOf(entidade), Long.valueOf(exercicio), estornoPagamentoDTO, pagamentosParaEstornar);
    }

    public EstornoPagamento criarEstornoPagamento(Long entidade, Long exercicio, EstornoPagamentoDTO estornoPagamentoDTO, Pagamento pagamento) {
        this.validatePagamento(pagamento, estornoPagamentoDTO);
        EstornoPagamentoId estornoPagamentoId = new EstornoPagamentoId();
        estornoPagamentoId.setEntidade(entidade);
        estornoPagamentoId.setExercicio(exercicio);
        EstornoPagamento estornoPagamento = new EstornoPagamento();
        estornoPagamento.setId(estornoPagamentoId);
        estornoPagamento.setPagamento(pagamento);
        estornoPagamento.setDataEstorno(estornoPagamentoDTO.getData());
        estornoPagamento.setUsuario(UsuarioUtils.getUsuarioAise());
        estornoPagamento.setMotivoEstorno(estornoPagamentoDTO.getMotivoEstorno());
        estornoPagamento.setContaBancariaEstorno(pagamento.getContaBancaria().getContaBancaria());
        estornoPagamento.setIdProcesso(estornoPagamentoDTO.getNumeroProcesso());
        estornoPagamento.setExercicioProcesso(estornoPagamentoDTO.getAnoProcesso());
        estornoPagamento.setMotivoDeducao(estornoPagamentoDTO.getMotivoDeducao());
        estornoPagamento.setProcessoSei(estornoPagamentoDTO.getProcessoSei());
        if (Boolean.TRUE.equals(estornoPagamentoDTO.getUtilizarComoCredito())) {
            PagamentoCredito pagamentoCredito = this.pagamentoCreditoService.novoCredito(pagamento, Boolean.TRUE.equals(estornoPagamentoDTO.getPagamentoDuplicado()) ? OrigemCredito.PAGAMENTO_DUPLICADO : OrigemCredito.ESTORNO_PAGAMENTO);
            Long idContaAcerto = Optional.ofNullable(this.parametroGeralService.getParamValueAsLong(ParametroGeralEnum.CONTAACERTO, ModuloEnum.MODULO_TRIBUTARIO.getValue())).orElseThrow(() -> new EloValidationException("O parametro CONTAACERTO n\u00e3o foi configurado."));
            estornoPagamento.setContaBancariaEstorno(idContaAcerto);
            estornoPagamento.setPagamentoCredito(pagamentoCredito);
        }
        EstornoPagamento saved = (EstornoPagamento)this.save((EloEntity)estornoPagamento, null);
        ConfigHonorario configHonorario = this.gerarHonorarioBloquetoService.getConfiguracaoHonorarioByExercicio(exercicio);
        this.geraEstornoPagamentoItens(pagamento, saved, configHonorario);
        this.adicionaObservacaoDebito(saved, Boolean.valueOf(true), estornoPagamentoDTO.getAcertoPagamento());
        return (EstornoPagamento)this.save((EloEntity)saved, null);
    }

    private void criarEstornoPagamentoLote(Long entidade, Long exercicio, EstornoPagamentoDTO estornoPagamentoDTO, List<Pagamento> pagamentos) {
        EstornoPagamentoLote estornoPagamentoLote = EstornoPagamentoService.getEstornoPagamentoLote((Long)entidade, (EstornoPagamentoDTO)estornoPagamentoDTO);
        pagamentos.forEach(pagamento -> {
            EstornoPagamento estornoPagamento = this.criarEstornoPagamento(entidade, exercicio, estornoPagamentoDTO, pagamento);
            EstornoPagamentoLoteItem estornoPagamentoLoteItem = new EstornoPagamentoLoteItem();
            estornoPagamentoLoteItem.setEstornoPagamento(estornoPagamento);
            estornoPagamentoLoteItem.setLote(estornoPagamentoLote);
            estornoPagamentoLote.getItens().add(estornoPagamentoLoteItem);
        });
        this.estornoPagamentoLoteService.save((EloEntity)estornoPagamentoLote, null);
    }

    @NotNull
    private static EstornoPagamentoLote getEstornoPagamentoLote(Long entidade, EstornoPagamentoDTO estornoPagamentoDTO) {
        EstornoPagamentoLote estornoPagamentoLote = new EstornoPagamentoLote();
        estornoPagamentoLote.setDataInclusao(estornoPagamentoDTO.getData());
        estornoPagamentoLote.setEntidade(entidade);
        estornoPagamentoLote.setMotivoEstorno(estornoPagamentoDTO.getMotivoEstorno());
        estornoPagamentoLote.setUsuario(SecurityUtils.getUserAise());
        estornoPagamentoLote.setIdProcesso(estornoPagamentoDTO.getNumeroProcesso());
        estornoPagamentoLote.setExercicioProcesso(estornoPagamentoDTO.getAnoProcesso());
        estornoPagamentoLote.setProcessoSei(estornoPagamentoDTO.getProcessoSei());
        return estornoPagamentoLote;
    }

    private void validatePagamento(Pagamento pagamento, EstornoPagamentoDTO estornoPagamentoDTO) {
        this.validaSePagamentoFoiGeradoPorAcertoDePagamento(pagamento, estornoPagamentoDTO);
        this.validaSeJaEstaEstornado(pagamento);
    }

    private void validaSePagamentoFoiGeradoPorAcertoDePagamento(Pagamento pagamento, EstornoPagamentoDTO estornoPagamentoDTO) {
        Optional acertoPagamento = this.acertoPagamentoRepository.findAcertoPagamentoByPagamentoNovo(pagamento);
        if (acertoPagamento.isPresent() && Boolean.TRUE.equals(estornoPagamentoDTO.getValidaAcertoDePagamento())) {
            throw new EloValidationException(String.format("Para estornar esse pagamento, deve estornar o acerto de pagamento %s", ((AcertoPagamento)acertoPagamento.get()).getId()));
        }
    }

    private void validaSeJaEstaEstornado(Pagamento pagamento) {
        if (Boolean.TRUE.equals(pagamento.isEstornado())) {
            throw new EloValidationException(String.format("O pagamento %d/%d j\u00e1 est\u00e1 estornado.", pagamento.getId().getPagamento(), pagamento.getId().getExercicioPagamento()));
        }
    }

    private void geraEstornoPagamentoItens(Pagamento pagamento, EstornoPagamento estorno, ConfigHonorario configHonorario) {
        AtomicLong sequenciaEstornoPagamentoItem = new AtomicLong(1L);
        pagamento.getPagamentoBoleto().getPagamentosDebito().forEach(pagamentoDebito -> {
            EstornoPagamentoItemId estornoPagamentoItemId = new EstornoPagamentoItemId();
            estornoPagamentoItemId.setEntidade(estorno.getId().getEntidade());
            estornoPagamentoItemId.setExercicio(estorno.getId().getExercicio());
            estornoPagamentoItemId.setEstorno(estorno.getId().getEstorno());
            estornoPagamentoItemId.setSequencia(Long.valueOf(sequenciaEstornoPagamentoItem.getAndIncrement()));
            EstornoPagamentoItem estornoPagamentoItem = new EstornoPagamentoItem();
            estornoPagamentoItem.setId(estornoPagamentoItemId);
            estornoPagamentoItem.setIdPagamentoBoleto(pagamento.getPagamentoBoleto().getId());
            estornoPagamentoItem.setIdDebitoParcelaTributo(pagamentoDebito.getId().getDebitoParcelaTributo().getId());
            estornoPagamentoItem.setEstornoPagamento(estorno);
            estorno.getEstornoPagamentoItems().add(estornoPagamentoItem);
            pagamentoDebito.setSituacao(SituacaoPagamentoDebitoEnum.ESTORNADO);
            pagamentoDebito.setEstorno(Boolean.TRUE);
            pagamentoDebito.setDataEstorno(estorno.getDataEstorno());
            this.pagamentoDebitoService.save((EloEntity)pagamentoDebito, null);
            this.updateSituacaoParcela(pagamento, pagamentoDebito, estorno, configHonorario);
        });
    }

    private void updateSituacaoParcela(Pagamento pagamento, PagamentoDebito pagamentoDebito, EstornoPagamento estorno, ConfigHonorario configHonorario) {
        if (Boolean.FALSE.equals(this.pagamentoRepository.existePagamentoNaoEstornadoParaMesmaParcelaTributo(pagamento, pagamentoDebito.getId().getDebitoParcelaTributo()))) {
            this.debitoParcelaService.abrirParcela(pagamentoDebito.getId().getDebitoParcelaTributo().getDebitoParcela());
            this.cancelarNegociacao(pagamento, estorno);
            if (this.isDebitoParcelaDeHonorario(pagamentoDebito.getId().getDebitoParcelaTributo().getDebitoParcela(), configHonorario)) {
                this.debitoParcelaService.cancelarParcelaAberta(pagamentoDebito.getId().getDebitoParcelaTributo().getDebitoParcela());
            }
        }
    }

    public void cancelarNegociacao(Pagamento pagamento, EstornoPagamento estorno) {
        PagamentoNegociado negociacao = this.pagamentoNegociadoRepository.findByPagamentoGeradoId(pagamento.getId());
        if (Objects.isNull(negociacao)) {
            return;
        }
        negociacao.getDebitosNovos().stream().findFirst().ifPresent(d -> this.debitoParcelaService.cancelarParcelaAberta(d.getDebitoNovo()));
        negociacao.setCancelado(PagamentoNegociadoSituacaoEnum.CANCELADO);
        negociacao.setDataCancelamento(LocalDate.now());
        negociacao.setUsuarioCancelamento(SecurityUtils.getUserAise());
        negociacao.setMotivoCancelamento(EstornoPagamentoService.getObservacaoEstorno((EstornoPagamento)estorno, (Boolean)true, (PagamentoId)pagamento.getId(), null));
        this.pagamentoNegociadoRepository.save((Object)negociacao);
    }

    public boolean isDebitoParcelaDeHonorario(DebitoParcela debitoParcela, ConfigHonorario configHonorario) {
        return !Objects.isNull(configHonorario) && debitoParcela.getId().getDivida().longValue() == configHonorario.getGuiaRecolhimentoHono().longValue();
    }

    public EstornoPagamento reabilitarEstorno(EstornoPagamentoId estornoPagamentoId, ReabilitacaoEstornoPagamentoDTO reabilitacaDTO) {
        EstornoPagamento estornoPagamento = (EstornoPagamento)this.findById((Serializable)estornoPagamentoId).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o estorno %d no exercicio %d na entidade %d.", estornoPagamentoId.getEstorno(), estornoPagamentoId.getExercicio(), estornoPagamentoId.getEntidade())));
        if (Boolean.TRUE.equals(estornoPagamento.getReabilitado())) {
            throw new EloValidationException("N\u00e3o \u00e9 permitido reabilitar pagamento habilitado.");
        }
        this.validaDataMovimentacaoService.validaMesEDia(estornoPagamento.getId().getEntidade(), reabilitacaDTO.getData());
        Optional creditoFound = this.pagamentoCreditoService.findByPagamentoOrigem(estornoPagamento.getPagamento());
        if (creditoFound.isPresent()) {
            boolean hasMovimentacaoCredito;
            PagamentoCredito credito = (PagamentoCredito)creditoFound.get();
            boolean bl = hasMovimentacaoCredito = !credito.getMovimentacoes().isEmpty();
            if (hasMovimentacaoCredito) {
                throw new EloValidationException("N\u00e3o foi poss\u00edvel reabilitar o estorno pois existem movimenta\u00e7\u00f5es de cr\u00e9dito.");
            }
            this.pagamentoCreditoService.remove(credito);
        }
        ConfigHonorario configHonorario = this.gerarHonorarioBloquetoService.getConfiguracaoHonorarioByExercicio(estornoPagamentoId.getExercicio());
        estornoPagamento.setReabilitado(Boolean.TRUE);
        estornoPagamento.setDataReabilitacao(reabilitacaDTO.getData());
        estornoPagamento.setMotivoReabilitacao(reabilitacaDTO.getMotivo());
        estornoPagamento.getPagamento().getPagamentoBoleto().getPagamentosDebito().forEach(pagamentoDebito -> {
            pagamentoDebito.setSituacao(SituacaoPagamentoDebitoEnum.NORMAL);
            pagamentoDebito.setEstorno(Boolean.valueOf(false));
            pagamentoDebito.setDataEstorno(null);
            if (Boolean.FALSE.equals(estornoPagamento.getPagamento().getPagoAMenor())) {
                DebitoParcela debitoParcela = pagamentoDebito.getId().getDebitoParcelaTributo().getDebitoParcela();
                if (debitoParcela.getSituacaoDebito().getTipoSituacaoParcela().equals((Object)TipoSituacaoParcela.CANCELADO) && this.isDebitoParcelaDeHonorario(debitoParcela, configHonorario)) {
                    this.debitoParcelaService.abrirParcelaSemReabrirParcelamento(debitoParcela);
                }
                this.debitoParcelaService.pagarParcela(debitoParcela);
            }
        });
        this.adicionaObservacaoDebito(estornoPagamento, Boolean.valueOf(false), null);
        return (EstornoPagamento)this.save((EloEntity)estornoPagamento, null);
    }

    private void adicionaObservacaoDebito(EstornoPagamento estornoPagamento, Boolean isEstorno, Long acertoPagamentoId) {
        PagamentoId pagamentoId = estornoPagamento.getPagamento().getId();
        List debitosId = this.debitoService.findDebitosIdRelacionadosPagamento(pagamentoId.getEntidade(), pagamentoId.getExercicioPagamento(), pagamentoId.getPagamento());
        String observacao = EstornoPagamentoService.getObservacaoEstorno((EstornoPagamento)estornoPagamento, (Boolean)isEstorno, (PagamentoId)pagamentoId, (Long)acertoPagamentoId);
        debitosId.forEach(debitoIdDTO -> this.debitoObservacaoService.save(debitoIdDTO, observacao));
    }

    @NotNull
    private static String getObservacaoEstorno(EstornoPagamento estornoPagamento, Boolean isEstorno, PagamentoId pagamentoId, Long acertoPagamentoId) {
        String motivo;
        String string = motivo = Boolean.TRUE.equals(isEstorno) ? estornoPagamento.getMotivoEstorno() : estornoPagamento.getMotivoReabilitacao();
        if (Objects.nonNull(acertoPagamentoId)) {
            return String.format("Estorno do Acerto de Pagamento %d, onde o Pagamento %d/%d gerou o Estorno de Pagamento %d/%d", acertoPagamentoId, pagamentoId.getPagamento(), pagamentoId.getExercicioPagamento(), estornoPagamento.getId().getEstorno(), estornoPagamento.getId().getExercicio());
        }
        return String.format("%sEstorno de Pagamento %d/%d do Pagamento %d/%d. %s", Boolean.TRUE.equals(isEstorno) ? "" : "Reabilita\u00e7\u00e3o de ", estornoPagamento.getId().getEstorno(), estornoPagamento.getId().getExercicio(), pagamentoId.getPagamento(), pagamentoId.getExercicioPagamento(), StringUtils.isBlank((CharSequence)motivo) ? "" : motivo.trim());
    }

    private Boolean getValorBooleanoDoParametro(ParametroGeralEnum parametro) {
        String modulo = ModuloEnum.MODULO_TRIBUTARIO.getValue();
        return this.parametroGeralService.getParamValueAsBoolean(parametro, modulo);
    }

    private Boolean isEntidadeDoParana(Long idEntidade) {
        String ufEntidade = this.entidadeServiceImpl.getUfEntidade(idEntidade);
        return "PR".equalsIgnoreCase(ufEntidade);
    }

    private Boolean hasPagamentosDeExerciciosAnteriores(List<Pagamento> pagamentos) {
        List pagamentosDeExerciciosAnteriores = this.getPagamentoDeExerciciosAnteriores(pagamentos);
        return !pagamentosDeExerciciosAnteriores.isEmpty();
    }

    private List<Pagamento> getPagamentoDeExerciciosAnteriores(List<Pagamento> pagamentos) {
        return pagamentos.stream().filter(arg_0 -> this.isPagamentoDeExercicioAnterior(arg_0)).collect(Collectors.toList());
    }

    private boolean isPagamentoDeExercicioAnterior(Pagamento pagamento) {
        return (long)pagamento.getDataPagamento().getYear() < this.contextService.getExercicioAtual();
    }

    private String identificaPagamentoDeExerciciosAnteriores(List<Pagamento> pagamentos) {
        return pagamentos.stream().map(arg_0 -> this.identificaPagamentoRespostaFront(arg_0)).collect(Collectors.joining(", "));
    }

    private String identificaPagamentoRespostaFront(Pagamento pagamento) {
        PagamentoId id = pagamento.getId();
        return String.format("%s/%s", id.getPagamento(), id.getExercicioPagamento());
    }

    @Generated
    public EstornoPagamentoService(EstornoPagamentoRepository estornoPagamentoRepository, ContextService contextService, PagamentoRepository pagamentoRepository, ValidaDataMovimentacaoService validaDataMovimentacaoService, PagamentoDebitoService pagamentoDebitoService, DebitoParcelaService debitoParcelaService, DebitoService debitoService, DebitoObservacaoService debitoObservacaoService, EstornoPagamentoLoteService estornoPagamentoLoteService, CreditoService pagamentoCreditoService, ParametroGeralService parametroGeralService, AcertoPagamentoRepository acertoPagamentoRepository, EntidadeServiceImpl entidadeServiceImpl, GerarHonorarioBloquetoService gerarHonorarioBloquetoService, PagamentoNegociadoRepository pagamentoNegociadoRepository) {
        this.estornoPagamentoRepository = estornoPagamentoRepository;
        this.contextService = contextService;
        this.pagamentoRepository = pagamentoRepository;
        this.validaDataMovimentacaoService = validaDataMovimentacaoService;
        this.pagamentoDebitoService = pagamentoDebitoService;
        this.debitoParcelaService = debitoParcelaService;
        this.debitoService = debitoService;
        this.debitoObservacaoService = debitoObservacaoService;
        this.estornoPagamentoLoteService = estornoPagamentoLoteService;
        this.pagamentoCreditoService = pagamentoCreditoService;
        this.parametroGeralService = parametroGeralService;
        this.acertoPagamentoRepository = acertoPagamentoRepository;
        this.entidadeServiceImpl = entidadeServiceImpl;
        this.gerarHonorarioBloquetoService = gerarHonorarioBloquetoService;
        this.pagamentoNegociadoRepository = pagamentoNegociadoRepository;
    }
}

