/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.DocumentoTexto;
import br.com.elotech.tributos.domain.DocumentoTextoId;
import br.com.elotech.tributos.repository.DocumentoTextoRepository;
import br.com.elotech.tributos.service.ContextService;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class DocumentoTextoService
extends CrudService<DocumentoTexto, DocumentoTextoId> {
    private final ContextService contextService;
    private final DocumentoTextoRepository repo;

    public DocumentoTextoService(ContextService contextService, DocumentoTextoRepository repo) {
        this.contextService = contextService;
        this.repo = repo;
    }

    public Optional<DocumentoTexto> findByTipoDocumento(Long tipoDocumento) {
        Long entidade = this.contextService.getEntidadePrincipal();
        Long exercicio = this.contextService.getExercicioAtual();
        return this.repo.findFirstByIdEntidadeAndIdExercicioAndIdTipoDocumentoOrderByPadraoDescIdSequenciaAsc(entidade, exercicio, tipoDocumento);
    }
}

