/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.request.ArquivoDownloadRequest;
import br.com.elotech.arquivos.domain.request.ArquivoFindRequest;
import br.com.elotech.arquivos.domain.response.ArquivoUrl;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.console.validator.CpfCnpjValidator;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlSpecification;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.DocumentoCertidaoItem;
import br.com.elotech.tributos.domain.DocumentoCertidaoItemId;
import br.com.elotech.tributos.domain.DocumentoFinalidade;
import br.com.elotech.tributos.domain.DocumentoHistoricoSituacao;
import br.com.elotech.tributos.domain.DocumentoItemDividaAtivaId;
import br.com.elotech.tributos.domain.DocumentoResponsavelId;
import br.com.elotech.tributos.domain.GrupoDocumento;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.SituacaoLegalDebitoEmParcelamento;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.domain.TipoSegmento;
import br.com.elotech.tributos.domain.Utilizacao;
import br.com.elotech.tributos.domain.projeto.TipoConstrucao;
import br.com.elotech.tributos.dto.ArquivoUnicoSalvarDTO;
import br.com.elotech.tributos.dto.DocumentoCertidaoItemComplementarDTO;
import br.com.elotech.tributos.dto.DocumentoCertidaoItemDTO;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.DocumentoFinalidadeDTO;
import br.com.elotech.tributos.dto.DocumentoFinalidadeTributosDTO;
import br.com.elotech.tributos.dto.DocumentoGenericoDTO;
import br.com.elotech.tributos.dto.DocumentoSearchInitialValuesDTO;
import br.com.elotech.tributos.dto.FiltroProjetoDTO;
import br.com.elotech.tributos.dto.GeracaoDocumentoDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.dto.PessoaDTO;
import br.com.elotech.tributos.dto.RelatorioImpressaoDTO;
import br.com.elotech.tributos.dto.documento.SituacaoDocumentoDTO;
import br.com.elotech.tributos.dto.documento.peticao.ExecucaoPeticaoResponseDTO;
import br.com.elotech.tributos.dto.mobile.DocumentoMobileDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDebitoParcelasDTO;
import br.com.elotech.tributos.repository.CadastroGeralRepository;
import br.com.elotech.tributos.repository.DocumentoHistoricoSituacaoRepository;
import br.com.elotech.tributos.repository.DocumentoPeticaoRepository;
import br.com.elotech.tributos.repository.DocumentoRepository;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.parcelamento.ParcelamentoRepositoryCustom;
import br.com.elotech.tributos.repository.projections.DocumentoProjection;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ArquivoUnicoService;
import br.com.elotech.tributos.service.CadastroImobiliarioService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DocumentoFinalidadeService;
import br.com.elotech.tributos.service.GeraDocumentoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.TipoConstrucaoService;
import br.com.elotech.tributos.service.TipoSegmentoService;
import br.com.elotech.tributos.service.UtilizacaoService;
import br.com.elotech.tributos.service.camposdinamicos.RespostaService;
import br.com.elotech.tributos.service.documento.DocumentoResponsavelService;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import br.com.elotech.tributos.service.exception.DocumentoNotFoundException;
import br.com.elotech.tributos.service.pdfService.PdfFetchService;
import br.com.elotech.tributos.service.projeto.ProjetoItemService;
import br.com.elotech.tributos.service.resolvers.ResolversHandler;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.specs.DocumentoSpecifications;
import br.com.elotech.tributos.util.FileUtils;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.domain.TipoArquivoEnum;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@Transactional
public class DocumentoService
extends CrudService<Documento, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentoService.class);
    private final DocumentoRepository documentoRepository;
    private final CadastroGeralRepository cadastroGeralRepository;
    private final AisePdfService aisePdfService;
    private final DocumentoHistoricoSituacaoRepository documentoHistoricoSituacaoRepository;
    private final CadastroImobiliarioService cadastroImobiliarioService;
    private final EntityManager em;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final PessoaService pessoaService;
    private final GeraDocumentoService geraDocumentoService;
    private final DocumentoFinalidadeService documentoFinalidadeService;
    private final ContextService contextService;
    private final ArquivoUnicoService arquivoUnicoService;
    private final ArquivoStorageFeignClient arquivoStorageFeignClient;
    private final ParcelamentoRepositoryCustom parcelamentoRepository;
    private final ArquivoClient arquivoClient;
    private final ResolversHandler resolversHandler;
    private final DocumentoPeticaoRepository documentoPeticaoRepository;
    private final TipoConstrucaoService tipoConstrucaoService;
    private final UtilizacaoService utilizacaoService;
    private final TipoSegmentoService tipoSegmentoService;
    private final RespostaService respostaService;
    private final ParametroGeralService parametroGeralService;
    private final ProjetoItemService projetoItemService;
    private final PdfFetchService pdfFetchService;
    private final DocumentoResponsavelService documentoResponsavelService;

    protected void beforeInsert(Documento documento) {
        Assert.notNull((Object)documento.getEntidade(), (String)"A propriedade 'entidade' n\u00e3o foi associada");
        Assert.notNull((Object)documento.getExercicio(), (String)"A propriedade 'exercicio' n\u00e3o foi associada");
        Assert.notNull((Object)documento.getDocumentoTipo(), (String)"A propriedade 'documentoTipo' n\u00e3o foi associada");
        super.beforeInsert((EloEntity)documento);
        documento.setCodigoValidacao(DigestUtils.md5Hex((String)UUID.randomUUID().toString()).toUpperCase());
        if (Objects.isNull(documento.getDocumento())) {
            documento.setDocumento(this.geraCodigoDocumento(documento));
        }
        AtomicLong sequencia = new AtomicLong(1L);
        documento.getDocumentoItemDividaAtivas().forEach(item -> {
            if (Objects.isNull(item.getId())) {
                item.setId(DocumentoItemDividaAtivaId.of((Long)documento.getEntidade(), (Long)documento.getExercicio(), (Long)documento.getDocumento(), (Long)documento.getTipoDocumento(), (Long)sequencia.getAndIncrement()));
                item.setDocumento(documento);
            }
        });
    }

    protected void beforeSave(Documento entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        this.fillDocumentoCertidaoItens(entity);
    }

    private void fillDocumentoCertidaoItens(Documento entity) {
        long maxCodigo = entity.getDocumentoCertidaoItems().stream().map(DocumentoCertidaoItem::getCodigo).filter(Objects::nonNull).max(Long::compare).orElse(0L);
        AtomicLong sequenciaItem = new AtomicLong(maxCodigo + 1L);
        entity.getDocumentoCertidaoItems().forEach(item -> {
            if (Objects.isNull(item.getCodigo())) {
                item.setCodigo(Long.valueOf(sequenciaItem.getAndIncrement()));
            }
            if (Objects.isNull(item.getId())) {
                item.setId(new DocumentoCertidaoItemId(entity.getEntidade(), entity.getExercicio(), entity.getTipoDocumento(), entity.getDocumento(), item.getCodigo()));
                item.setDocumento(entity);
            }
        });
    }

    private void fillDocumentoResponsaveis(Documento entity) {
        long maxSequencia = entity.getDocumentoResponsaveis().stream().map(responsavel -> responsavel.getId() != null ? responsavel.getId().getSequencia() : null).filter(Objects::nonNull).max(Long::compareTo).orElse(0L);
        AtomicLong sequencia = new AtomicLong(maxSequencia + 1L);
        entity.getDocumentoResponsaveis().forEach(responsavel -> {
            if (responsavel.getId() == null) {
                DocumentoResponsavelId id = DocumentoResponsavelId.of((Long)entity.getEntidade(), (Long)entity.getExercicio(), (Long)entity.getTipoDocumento(), (Long)entity.getDocumento(), (Long)sequencia.getAndIncrement());
                responsavel.setId(id);
                responsavel.setDocumento(entity);
            }
        });
    }

    private void createAndfillDocumentoResponsaveis(Documento entity) {
        if (TipoDocumentoEnum.isTipoDocumentoResponsavel((TipoDocumentoEnum)TipoDocumentoEnum.fromValue((Long)entity.getTipoDocumento()))) {
            List responsaveis = this.documentoResponsavelService.createResponsavelByDocumento(entity);
            entity.getDocumentoResponsaveis().clear();
            entity.getDocumentoResponsaveis().addAll(responsaveis);
            this.fillDocumentoResponsaveis(entity);
        }
    }

    public Documento update(Documento documento) {
        if (Objects.isNull(documento.getId())) {
            throw new EloValidationException("O documento em quest\u00e3o n\u00e3o possui id! \u00c9 necess\u00e1rio criar ele ao inv\u00e9s de atualizar!");
        }
        return (Documento)this.documentoRepository.save((Object)documento);
    }

    public Documento getDocumentoByCodigoValidacao(String codigoValidacao) {
        return this.documentoRepository.findByCodigoValidacao(codigoValidacao);
    }

    public Page<ExecucaoPeticaoResponseDTO> getDocumentosExecucoesAtivas(String search, Pageable pageable) {
        Long SITUACAO_ATIVA = 1L;
        String searchFilter = String.format("tipoDocumento == %d and situacao.id == %d", TipoDocumentoEnum.PETICAO_DIVIDA_ATIVA.getCodigo(), SITUACAO_ATIVA);
        Page result = null;
        if (Objects.nonNull(search)) {
            searchFilter = searchFilter.concat(" and ").concat(search);
            result = this.documentoRepository.findAll((Specification)new RsqlSpecification(this.em, searchFilter, Optional.empty()), pageable);
        } else {
            result = this.documentoRepository.findAll(pageable);
        }
        return result.map(arg_0 -> this.buildExecucaoDTO(arg_0));
    }

    private ExecucaoPeticaoResponseDTO buildExecucaoDTO(Documento documento) {
        ExecucaoPeticaoResponseDTO dto = ExecucaoPeticaoResponseDTO.from((Documento)documento);
        this.setStatusDebitoEmDTO(documento, dto);
        return dto;
    }

    private void setStatusDebitoEmDTO(Documento documento, ExecucaoPeticaoResponseDTO dto) {
        List parcelas = documento.getCertidoesDividaAtivaPeticao().stream().flatMap(certidao -> certidao.getDocumentoItemDividaAtivas().stream()).flatMap(ExecucaoPeticaoResponseDTO::getParcelaEmDocumentoItemDividaAtivaSemValidarProcessoJudicial).distinct().collect(Collectors.toList());
        List parcelasParceladosEmProcessoJudicial = parcelas.stream().filter(parcela -> Objects.nonNull(parcela.getSituacaoDebito()) && parcela.getSituacaoDebito().isParceladoOuReparcelado() != false && parcela.isEmProcessoJudicial()).collect(Collectors.toList());
        if (!parcelasParceladosEmProcessoJudicial.isEmpty()) {
            List idsDebito = parcelasParceladosEmProcessoJudicial.stream().map(parcela -> parcela.getDebito().getId()).collect(Collectors.toList());
            dto.setStatusDebito(this.setStatusDebitoComDebitoNovo(idsDebito));
        }
        if (parcelasParceladosEmProcessoJudicial.isEmpty() && !parcelas.isEmpty()) {
            dto.setStatusDebito(((DebitoParcela)parcelas.get(0)).getSituacaoLegal().getDescricao().toUpperCase());
        }
    }

    private String setStatusDebitoComDebitoNovo(List<Long> idDebitosOrigem) {
        List parcelas = this.parcelamentoRepository.findParcelasDebitoNovoPorIdDebitoOrigem(idDebitosOrigem);
        if (parcelas.stream().noneMatch(ParcelamentoDebitoParcelasDTO::getAberto)) {
            return SituacaoLegalDebitoEmParcelamento.QUITADO.getDescricao().toUpperCase();
        }
        if (parcelas.stream().anyMatch(parcela -> parcela.getAberto() != false && parcela.getVencido() != false)) {
            return SituacaoLegalDebitoEmParcelamento.ATRASADO.getDescricao().toUpperCase();
        }
        return SituacaoLegalDebitoEmParcelamento.SUSPENSO.getDescricao().toUpperCase();
    }

    public Page<DocumentoDTO> getDocumentos(Optional<String> search, Pageable pageable) {
        Page result = search.isPresent() ? this.documentoRepository.findAll((Specification)new RsqlSpecification(this.em, search.get(), Optional.empty()), pageable) : this.documentoRepository.findAll(pageable);
        return result.map(DocumentoDTO::from);
    }

    public Page<DocumentoDTO> getDocumentosPeticoesComCDA(Optional<String> search, Pageable pageable) {
        Page result = this.getDocumentos(search, pageable);
        result.forEach(dto -> dto.getDocumentosItensPeticaoDTO().addAll(this.documentoPeticaoRepository.findAllDocumentoPeticaoCdaByPeticao(dto.getId())));
        return result;
    }

    public List<Long> getIdsPeticoesAtivasParaCheckall(Optional<String> search) {
        List result = this.documentoRepository.findAll((Specification)new RsqlSpecification(this.em, search.get(), Optional.empty()));
        return result.stream().map(Documento::getId).collect(Collectors.toList());
    }

    public DocumentoMobileDTO getDocumentoMobileDTO(Long entidade, Long exercicio, Long tipoDocumento, Long documento) {
        Documento documentoEntity = this.documentoRepository.findByEntidadeTributacaoEntidadeIdAndEntidadeTributacaoExercicioAndTipoDocumentoAndDocumento(entidade, exercicio, tipoDocumento, documento);
        String urlImpressao = this.aisePdfService.fetchDocumento(documento, tipoDocumento, exercicio);
        DocumentoMobileDTO dto = new DocumentoMobileDTO(documentoEntity, urlImpressao);
        if (Optional.ofNullable(documentoEntity.getCadastroGeral()).isPresent() && documentoEntity.getCadastroGeral().getTipoCadastro().isImobiliario().booleanValue()) {
            Optional.ofNullable(this.cadastroImobiliarioService.findByTipoCadastroAndCadastroGeral(documentoEntity.getCadastroGeral().getTipoCadastro(), documentoEntity.getCadastroGeral().getCadastroGeral())).ifPresent(arg_0 -> ((DocumentoMobileDTO)dto).setCadastroImobiliarioEntity(arg_0));
        }
        return dto.from();
    }

    public DocumentoDTO getDocumentoDTO(Long entidade, Long exercicio, Long tipoDocumento, Long documento) {
        Documento documentoEntity = this.documentoRepository.findByEntidadeTributacaoEntidadeIdAndEntidadeTributacaoExercicioAndTipoDocumentoAndDocumento(entidade, exercicio, tipoDocumento, documento);
        String urlImpressao = this.aisePdfService.fetchDocumento(documento, tipoDocumento, exercicio);
        return DocumentoDTO.from((Documento)documentoEntity, (String)urlImpressao);
    }

    public Documento getDocumento(Long entidade, Long exercicio, Long tipoDocumento, Long documento) {
        return Optional.ofNullable(this.documentoRepository.findByEntidadeTributacaoEntidadeIdAndEntidadeTributacaoExercicioAndTipoDocumentoAndDocumento(entidade, exercicio, tipoDocumento, documento)).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o Documento '%d' - Exerc\u00edcio '%d' - Tipo documento '%d' '.", documento, exercicio, tipoDocumento)));
    }

    public Optional<Documento> getDocumentoOrEmpty(Long entidade, Long exercicio, Long tipoDocumento, Long documento) {
        return Optional.ofNullable(this.documentoRepository.findByEntidadeTributacaoEntidadeIdAndEntidadeTributacaoExercicioAndTipoDocumentoAndDocumento(entidade, exercicio, tipoDocumento, documento));
    }

    public DocumentoDTO getDocumentoDTO(Documento documento) {
        String urlImpressao = this.aisePdfService.fetchDocumento(documento.getDocumento(), documento.getTipoDocumento(), documento.getExercicio());
        return DocumentoDTO.from((Documento)documento, (String)urlImpressao);
    }

    public Documento getCdaByExercicioDocumento(Long exercico, Long documento) {
        return Optional.ofNullable(this.documentoRepository.findCdaByNumeroExercicioAndTipo(documento, exercico)).orElseThrow(() -> new EloValidationException("Certid\u00e3o de d\u00edvida ativa n\u00e3o encontrada"));
    }

    public List<DocumentoProjection> getListDocumentoDTO(TipoCadastro tipoCadastro, Long cadastroGeral) {
        CadastroGeral cadastroGeralEntity = (CadastroGeral)this.cadastroGeralRepository.findOneByTipoCadastroAndCadastroGeralAndExclusaoLogicaFalse(tipoCadastro, cadastroGeral).orElseThrow(() -> new CadastroNaoEncontradoException(tipoCadastro, cadastroGeral));
        return this.documentoRepository.findByCadastroGeral(cadastroGeralEntity, LocalDate.now());
    }

    public Page<DocumentoDTO> findAllDocumentoByCpfCnpj(String cpfCnpj, LocalDate dataValidade, Optional<String> search, Pageable pageable) {
        Specification specification = DocumentoSpecifications.byImprimeWebAndCpfCnpjAndDataValidade((String)cpfCnpj, (LocalDate)dataValidade);
        if (search.isPresent()) {
            specification = specification.and(RsqlUtils.createSpecFrom((EntityManager)this.em, Documento.class, (String)search.get(), Optional.empty()));
        }
        return this.documentoRepository.findAll(specification, pageable).map(DocumentoDTO::from).map(dto -> {
            dto.setUrl(this.aisePdfService.fetchDocumento(dto.getDocumento(), dto.getTipoDocumento(), dto.getExercicio()));
            return dto;
        });
    }

    public DocumentoDTO findDocumentoById(Long id) {
        return this.documentoRepository.findById((Object)id).map(DocumentoDTO::from).orElseThrow(() -> new DocumentoNotFoundException(id));
    }

    public Documento findDocumentoDomainById(Long id) {
        return (Documento)this.documentoRepository.findById((Object)id).orElseThrow(() -> new DocumentoNotFoundException(id));
    }

    private void validateCadastroAtivo(CadastroGeral cadastroGeral) {
        if (cadastroGeral != null && cadastroGeral.getExclusaoLogica().booleanValue()) {
            throw new EloValidationException(String.format("O cadastro %d-%d est\u00e1 em exclus\u00e3o l\u00f3gica.", cadastroGeral.getTipoCadastro().getValue(), cadastroGeral.getCadastroGeral()));
        }
    }

    private void applyCancelamentoDocumento(Documento documento, SituacaoDocumentoDTO cancelamentoDTO) {
        documento.setCancelado(Boolean.valueOf(true));
        documento.setDataCancelamento(LocalDate.now());
        documento.setObservacaoCancelamento(cancelamentoDTO.getObservacao());
        this.atribuirUsuarioCancelamento(documento, cancelamentoDTO);
    }

    public String determinarUsuarioSituacao(SituacaoDocumentoDTO dto) {
        return StringUtils.isBlank((CharSequence)SecurityUtils.getUserAise()) ? dto.getUsuario() : SecurityUtils.getUserAise();
    }

    public void updateSituacaoDocumento(Documento documento, SituacaoDocumentoDTO dto) {
        DocumentoHistoricoSituacao documentoHistoricoSituacao = new DocumentoHistoricoSituacao();
        documentoHistoricoSituacao.setDocumento(documento);
        documentoHistoricoSituacao.setData(LocalDate.now());
        documentoHistoricoSituacao.setObservacao(dto.getObservacao());
        documentoHistoricoSituacao.setSituacaoAnterior(documento.getSituacao());
        documentoHistoricoSituacao.setUsuario(this.determinarUsuarioSituacao(dto));
        this.documentoHistoricoSituacaoRepository.save((Object)documentoHistoricoSituacao);
        documento.setSituacao(dto.getSituacao());
    }

    public Documento updateSituacaoAndSave(Long id, SituacaoDocumentoDTO situacaoDTO) {
        Documento documento = (Documento)this.documentoRepository.findById((Object)id).orElseThrow(() -> new DocumentoNotFoundException(id));
        this.validateCadastroAtivo(documento.getCadastroGeral());
        this.updateSituacaoDocumento(documento, situacaoDTO);
        return (Documento)this.documentoRepository.save((Object)documento);
    }

    public Documento cancelarDocumento(Long id, SituacaoDocumentoDTO situacaoDTO) {
        Documento documento = (Documento)this.documentoRepository.findById((Object)id).orElseThrow(() -> new DocumentoNotFoundException(id));
        this.validateCadastroAtivo(documento.getCadastroGeral());
        this.updateSituacaoDocumento(documento, situacaoDTO);
        this.applyCancelamentoDocumento(documento, situacaoDTO);
        return (Documento)this.documentoRepository.save((Object)documento);
    }

    private void atribuirUsuarioCancelamento(Documento documento, SituacaoDocumentoDTO cancelamentoDocumentoDTO) {
        if (Objects.isNull(cancelamentoDocumentoDTO.getUsuario())) {
            documento.setUsuarioCancelamento(SecurityUtils.getUserAise());
        } else {
            documento.setUsuarioCancelamento(cancelamentoDocumentoDTO.getUsuario());
        }
    }

    private Long geraCodigoDocumento(Documento documento) {
        Long menorGrupoDocumentoId = documento.getDocumentoTipo().getGruposDocumento().stream().map(GrupoDocumento::getId).min(Long::compareTo).orElseThrow(() -> new EloValidationException("Tipo de Documento n\u00e3o possui Grupo cadastrado."));
        if (documento.getDocumentoTipo().getGruposDocumento().stream().anyMatch(GrupoDocumento::getSequenciaPorExercicio)) {
            return this.sequenceGeneratorRepository.getNextVal(String.format("S05documentoGrupo_%d_%d_%d", documento.getEntidade(), documento.getExercicio(), menorGrupoDocumentoId));
        }
        return this.sequenceGeneratorRepository.getNextVal(String.format("S05documentoGrupo_%d_%d", documento.getEntidade(), menorGrupoDocumentoId));
    }

    public DocumentoGenericoDTO getInitialValues(@Valid DocumentoSearchInitialValuesDTO documentoSearchInitialValuesDTO, TipoDocumentoEnum tipoDocumentoEnum) {
        Boolean isPorContribuinte = documentoSearchInitialValuesDTO.getTipoFiltro().isPorContribuinte();
        Boolean isAtendimentoPresencial = documentoSearchInitialValuesDTO.getTipoAtendimento() != null ? documentoSearchInitialValuesDTO.getTipoAtendimento().isPresencial() : false;
        Boolean isAtendimentoTelefone = documentoSearchInitialValuesDTO.getTipoAtendimento() != null ? documentoSearchInitialValuesDTO.getTipoAtendimento().isTelefone() : false;
        DocumentoGenericoDTO valoresIniciais = new DocumentoGenericoDTO();
        valoresIniciais.setCodigoPessoa(isPorContribuinte != false ? this.getContribuinteFromRequest(documentoSearchInitialValuesDTO) : this.getPessoaFromRequest(documentoSearchInitialValuesDTO));
        if (documentoSearchInitialValuesDTO.getIdCadastro() != null) {
            valoresIniciais.setIdCadastro(documentoSearchInitialValuesDTO.getIdCadastro());
        }
        if (isAtendimentoPresencial.booleanValue() || isAtendimentoTelefone.booleanValue()) {
            valoresIniciais.setPessoaNome(documentoSearchInitialValuesDTO.getNomeRequerente());
            valoresIniciais.setPessoaCpfCnpj(documentoSearchInitialValuesDTO.getCpfCnpjRequerente());
            valoresIniciais.setTipoPessoa(this.getTipoPessoaByCpfCnpj(documentoSearchInitialValuesDTO.getCpfCnpjRequerente()));
            valoresIniciais.setPessoaCadastro(PessoaDTO.builder().nome(documentoSearchInitialValuesDTO.getNomeRequerente()).cnpjCpf(documentoSearchInitialValuesDTO.getCpfCnpjRequerente()).tipoPessoa(documentoSearchInitialValuesDTO.getCpfCnpjRequerente()).build());
        } else {
            Optional.ofNullable(this.pessoaService.findOne(valoresIniciais.getCodigoPessoa())).ifPresent(pessoa -> {
                valoresIniciais.setPessoaNome(pessoa.getNome());
                valoresIniciais.setPessoaCpfCnpj(pessoa.getCnpjCpf());
                valoresIniciais.setTipoPessoa(pessoa.getTipoPessoa());
                valoresIniciais.setPessoaCadastro(PessoaDTO.builder().nome(pessoa.getNome()).cnpjCpf(pessoa.getCnpjCpf()).tipoPessoa(pessoa.getTipoPessoa().getValue()).build());
            });
        }
        valoresIniciais.setFinalidadesDisponiveis(this.getFinalidadesAtivasOrdenadas(tipoDocumentoEnum.getValue(), null));
        valoresIniciais.setFinalidade((Long)valoresIniciais.getFinalidadesDisponiveis().stream().map(DocumentoFinalidadeDTO::getId).findFirst().orElse(null));
        if (TipoDocumentoEnum.CERTIDAO_LANCAMENTO_IPTU.equals((Object)tipoDocumentoEnum) || TipoDocumentoEnum.CERTIDAO_DE_CONSTRUCAO.equals((Object)tipoDocumentoEnum)) {
            valoresIniciais.setDocumentoCertidaoItens(this.cadastroImobiliarioService.loadItensDocumentoCertidao(valoresIniciais.getIdCadastro()));
        }
        if (TipoDocumentoEnum.isTipoDocumentoItemProjeto((TipoDocumentoEnum)tipoDocumentoEnum) && Objects.nonNull(documentoSearchInitialValuesDTO.getNumeroProjeto()) && Objects.nonNull(documentoSearchInitialValuesDTO.getExercicioProjeto())) {
            valoresIniciais.setDocumentoCertidaoItens(this.projetoItemService.loadItensDocumentoCertidao(documentoSearchInitialValuesDTO.getNumeroProjeto(), documentoSearchInitialValuesDTO.getExercicioProjeto()));
        }
        return valoresIniciais;
    }

    private Long getContribuinteFromRequest(DocumentoSearchInitialValuesDTO documentoSearchInitialValuesDTO) {
        return documentoSearchInitialValuesDTO.getContribuinte().getId();
    }

    private Long getPessoaFromRequest(DocumentoSearchInitialValuesDTO documentoSearchInitialValuesDTO) {
        return ((CadastroGeral)this.cadastroGeralRepository.findById((Object)documentoSearchInitialValuesDTO.getIdCadastro()).orElseThrow(() -> new EloValidationException(String.format("Cadastro Geral %d n\u00e3o encontrado", documentoSearchInitialValuesDTO.getIdCadastro())))).getPessoa().getId();
    }

    public List<DocumentoFinalidadeDTO> getFinalidadesAtivasOrdenadas(Long tipoDocumento, Long exercicioDocumento) {
        Long entidade = this.contextService.getEntidadePrincipal();
        Long exercicio = Optional.ofNullable(exercicioDocumento).orElseGet(() -> ((ContextService)this.contextService).getExercicioAtual());
        return this.documentoFinalidadeService.getListDTO(entidade, exercicio, tipoDocumento).stream().map(DocumentoFinalidadeTributosDTO::from).collect(Collectors.toList());
    }

    public TipoPessoa getTipoPessoaByCpfCnpj(String cpfCnpj) {
        if (cpfCnpj.trim().length() > 11) {
            return TipoPessoa.JURIDICA;
        }
        return TipoPessoa.FISICA;
    }

    public DocumentoDTO gerar(@Valid DocumentoGenericoDTO documentoGenericoDTO, TipoDocumentoEnum tipoDocumento) {
        GeracaoDocumentoDTO geracaoDocumentoDTO = this.getGeracaoDocumentoDTO(documentoGenericoDTO, tipoDocumento);
        Documento documento = this.geraDocumentoService.getDocumentoAndValida(geracaoDocumentoDTO);
        documento.setSubTipo(documentoGenericoDTO.getSubTipo());
        documento.setDocumento(this.geraCodigoDocumento(documento));
        this.createAndfillDocumentoResponsaveis(documento);
        return DocumentoDTO.from((Documento)((Documento)this.save((EloEntity)documento, null)));
    }

    private GeracaoDocumentoDTO getGeracaoDocumentoDTO(@Valid DocumentoGenericoDTO documentoGenericoDTO, TipoDocumentoEnum tipoDocumento) {
        if (documentoGenericoDTO.getPorCadastro().booleanValue()) {
            if (Objects.isNull(documentoGenericoDTO.getIdCadastro())) {
                throw new EloValidationException("Cadastro Geral \u00e9 obrigat\u00f3rio");
            }
            CadastroGeral cadastroGeral = (CadastroGeral)this.cadastroGeralRepository.findById((Object)documentoGenericoDTO.getIdCadastro()).orElseThrow(() -> new EloValidationException(String.format("Cadastro Geral %d n\u00e3o encontrado", documentoGenericoDTO.getIdCadastro())));
            return GeracaoDocumentoDTO.from((DocumentoGenericoDTO)documentoGenericoDTO, (CadastroGeral)cadastroGeral, (TipoDocumentoEnum)tipoDocumento);
        }
        if (Objects.isNull(documentoGenericoDTO.getCodigoPessoa())) {
            throw new EloValidationException("C\u00f3digo da pessoa \u00e9 obrigat\u00f3rio");
        }
        Pessoa pessoa = (Pessoa)this.pessoaService.findById(documentoGenericoDTO.getCodigoPessoa()).orElseThrow(() -> new EloValidationException(String.format("Pessoa %d n\u00e3o encontrada", documentoGenericoDTO.getCodigoPessoa())));
        return GeracaoDocumentoDTO.from((DocumentoGenericoDTO)documentoGenericoDTO, (Pessoa)pessoa, (TipoDocumentoEnum)tipoDocumento);
    }

    public Boolean existsDocumentoCDA(Long numero, Long exercicio) {
        return this.documentoRepository.existsDocumentoCDAByNumeroAndExercicio(numero, exercicio);
    }

    public Documento findDocumentoByEntidadeAndExercicioAndTipoDocumentoAndDocumento(Long entidade, Long exercicio, Long tipoDocumento, Long documento) {
        return this.documentoRepository.findByEntidadeTributacaoEntidadeIdAndEntidadeTributacaoExercicioAndTipoDocumentoAndDocumento(entidade, exercicio, tipoDocumento, documento);
    }

    public void removeDividaAtivaPeticao(Long id) {
        this.documentoRepository.removeDividaAtivaPeticao(id);
    }

    public String fetchDocumento(DocumentoDTO documento, RelatorioImpressaoDTO relatorio) {
        if (Objects.nonNull(relatorio) && relatorio.imprimePorLayoutSelecionado()) {
            return this.aisePdfService.fetchDocumentoPorRelatorio(documento.getDocumento(), documento.getTipoDocumento(), documento.getExercicio(), relatorio.getRelatorio(), relatorio.getTipoRelatorio());
        }
        return this.aisePdfService.fetchDocumento(documento.getDocumento(), documento.getTipoDocumento(), documento.getExercicio());
    }

    public ImpressaoDTO imprimirDocumento(Long id, RelatorioImpressaoDTO relatorioImpressao, Boolean isEditado) throws IOException {
        Documento documento = (Documento)this.findOne((Serializable)id);
        String urlImpressao = this.getUrlImpressao(documento, relatorioImpressao, isEditado);
        if (Boolean.TRUE.equals(documento.getDocumentoTipo().getArmazenarComoPdf()) && (documento.getIdArquivoUnico() == null || isEditado.booleanValue())) {
            this.savePdfAsArquivoUnico(documento, this.pdfFetchService.fetchPdfFromUrl(urlImpressao));
        }
        return ImpressaoDTO.from((Long)documento.getId(), (String)urlImpressao, (LocalDate)documento.getDataEmissao(), (String)documento.getCodigoValidacao());
    }

    public String getUrlImpressao(Documento documento, RelatorioImpressaoDTO relatorioImpressao, Boolean isEditado) {
        if (Boolean.TRUE.equals(documento.getDocumentoTipo().getArmazenarComoPdf()) && documento.getIdArquivoUnico() != null && !isEditado.booleanValue()) {
            ArquivoDTO arquivoDTO = this.getArquivoStorageDto(documento);
            ArquivoUrl arquivoUrl = this.arquivoStorageFeignClient.getUrlDownload(arquivoDTO.getFullPath(), arquivoDTO.getNome());
            return arquivoUrl.getUrlAssinada();
        }
        DocumentoDTO documentoDTO = this.findDocumentoById(documento.getId());
        return this.fetchDocumento(documentoDTO, relatorioImpressao);
    }

    private ArquivoDTO getArquivoStorageDto(Documento documento) {
        return this.arquivoStorageFeignClient.findOne(documento.getIdArquivoUnico());
    }

    public ArquivoDTO findArquivoS3(Long id) {
        Documento documento = (Documento)this.findOne((Serializable)id);
        if (!Boolean.TRUE.equals(documento.getDocumentoTipo().getArmazenarComoPdf())) {
            log.info("Certifique que o tipo de documento tenha a op\u00e7\u00e3o de armazenar documento ativa!");
            throw new EloValidationException("Tipo de Documento n\u00e3o configurado para assinar documento!");
        }
        if (documento.getIdArquivoUnico() == null) {
            log.info("Certifique que o documento tenha sido gerado com a op\u00e7\u00e3o de armazenar documento ativa");
            throw new EloValidationException("Documento n\u00e3o possui a arquivo salvo!");
        }
        return this.getArquivoStorageDto(documento);
    }

    public void updateDocumentoWithUrlDocumentoSigned(Long id) {
        Documento documento = (Documento)this.findOne((Serializable)id);
        if (Objects.isNull(documento.getUrlArquivoAssinado()) || documento.getUrlArquivoAssinado().isEmpty()) {
            ArquivoDTO arquivoDTO = this.getArquivoStorageDto(documento);
            String idArquivoS3Signed = arquivoDTO.getFullPath().concat("_signed");
            ArquivoFindRequest arquivoFindRequest = ArquivoFindRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (String)idArquivoS3Signed);
            if (!this.arquivoClient.buscarArquivo(arquivoFindRequest).isEmpty()) {
                int lastSlashIndex = idArquivoS3Signed.lastIndexOf(47);
                String everythingAfterTheFinalSlash = idArquivoS3Signed.substring(lastSlashIndex + 1);
                documento.setUrlArquivoAssinado(everythingAfterTheFinalSlash);
                this.documentoRepository.save((Object)documento);
            }
        }
    }

    public void savePdfAsArquivoUnico(Documento documento, byte[] pdfBytes) {
        ArquivoUnicoSalvarDTO arquivoUnicoSalvarDTO = this.buildSalvarArquivoUnico(pdfBytes, documento);
        Long idArquivoUnico = this.arquivoUnicoService.salvarPDF(arquivoUnicoSalvarDTO);
        documento.setIdArquivoUnico(idArquivoUnico);
        this.save((EloEntity)documento, null);
    }

    public ArquivoUnicoSalvarDTO buildSalvarArquivoUnico(byte[] pdfBytes, Documento documento) {
        ArquivoUnicoSalvarDTO arquivoUnicoSalvarDTO = new ArquivoUnicoSalvarDTO();
        arquivoUnicoSalvarDTO.setContent(pdfBytes);
        arquivoUnicoSalvarDTO.setTipoArquivo(TipoArquivoEnum.OUTROS);
        arquivoUnicoSalvarDTO.setDiretorio("/documentos");
        arquivoUnicoSalvarDTO.setFileName("documento_" + documento.getId() + ".pdf");
        return arquivoUnicoSalvarDTO;
    }

    public Documento findCdaEmAbertoByDebito(Long entidade, Long exercicioDebito, Long tipoCadastro, Long cadastroGeral, Long divida, Long subDivida) {
        return this.documentoRepository.findCdaEmAbertoByDebito(entidade, exercicioDebito, tipoCadastro, cadastroGeral, divida, subDivida);
    }

    public String printUrlSignedDocumentoPdf(String urlDownloadS3) {
        ArquivoDownloadRequest arquivoDownloadRequest = ArquivoDownloadRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (String)("oxy_tributos/documentos/" + urlDownloadS3));
        return this.resolversHandler.getArquivoClientMinio().gerarUrlParaGet(arquivoDownloadRequest).getUrlAssinada();
    }

    public Optional<Documento> findDocumentoByNumeroDocumentoExercicioTipo(Long numeroDocumento, Long exercicio) {
        return this.documentoRepository.findPeticaoByNumeroExercicio(numeroDocumento, exercicio);
    }

    public List<DocumentoCertidaoItemComplementarDTO> buildItensComplementares(List<DocumentoCertidaoItemDTO> itens) {
        String identificadorPadrao = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.IDENTIFICADOR_DOCUMENTO_ITEM_PADRAO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        return itens.stream().map(item -> this.buildItemComplementar(item, identificadorPadrao)).collect(Collectors.toList());
    }

    private DocumentoCertidaoItemComplementarDTO buildItemComplementar(DocumentoCertidaoItemDTO documentoCertidaoItemDTO, String identificadorPadrao) {
        DocumentoCertidaoItemComplementarDTO dto = new DocumentoCertidaoItemComplementarDTO();
        if (!identificadorPadrao.isEmpty()) {
            dto.setIdRespostaSegmentoPadrao(documentoCertidaoItemDTO.getIdRespostaSegmentoPadrao());
            dto.setRespostaSegmentoPadrao(this.respostaService.getRespostaSegmentoByIdentificadorAndIdAlternativa(identificadorPadrao, dto.getIdRespostaSegmentoPadrao()));
        }
        if (documentoCertidaoItemDTO.getIdTipoConstrucao() != null) {
            dto.setIdTipoConstrucao(documentoCertidaoItemDTO.getIdTipoConstrucao());
            dto.setTipoConstrucao((TipoConstrucao)this.tipoConstrucaoService.findOne((Serializable)dto.getIdTipoConstrucao()));
        }
        if (documentoCertidaoItemDTO.getIdTipoSegmento() != null) {
            dto.setIdTipoSegmento(documentoCertidaoItemDTO.getIdTipoSegmento());
            dto.setTipoSegmento((TipoSegmento)this.tipoSegmentoService.findOne((Serializable)dto.getIdTipoSegmento()));
        }
        if (documentoCertidaoItemDTO.getIdUtilizacao() != null) {
            dto.setIdUtilizacao(documentoCertidaoItemDTO.getIdUtilizacao());
            dto.setUtilizacao((Utilizacao)this.utilizacaoService.findOne((Serializable)dto.getIdUtilizacao()));
        }
        return dto;
    }

    public Long existsByEntidadeAndExercicioAndTipoDocumentoAndDocumento(Long exercicio, Long tipoDocumento, Long documento) {
        return this.documentoRepository.existsByEntidadeAndExercicioAndTipoDocumentoAndDocumento(this.contextService.getEntidadePrincipal(), exercicio, tipoDocumento, documento);
    }

    public DocumentoGenericoDTO findDocumentoCompletoById(Long id) {
        Documento documento = this.findDocumentoDomainById(id);
        DocumentoGenericoDTO dto = new DocumentoGenericoDTO();
        Optional.ofNullable(documento.getTipoCadastro()).map(TipoCadastro::getValue).ifPresent(arg_0 -> ((DocumentoGenericoDTO)dto).setTipoCadastro(arg_0));
        dto.setCadastroGeral(documento.getCodigoCadastroGeral());
        dto.setTipoDocumento(documento.getTipoDocumento());
        dto.setIdProcesso(documento.getIdProcesso());
        dto.setExercicioProcesso(documento.getExercicioProcesso());
        dto.setObservacao(documento.getObservacao());
        Optional.ofNullable(documento.getCadastroGeral()).map(CadastroGeral::getId).ifPresent(arg_0 -> ((DocumentoGenericoDTO)dto).setIdCadastro(arg_0));
        dto.setIdSequenciaItbi(documento.getIdSequenciaItbi());
        dto.setFinalidadesDisponiveis(this.getFinalidadesAtivasOrdenadas(documento.getTipoDocumento(), documento.getExercicio()));
        Optional.ofNullable(documento.getDocumentoFinalidade()).map(DocumentoFinalidade::getId).ifPresent(arg_0 -> ((DocumentoGenericoDTO)dto).setFinalidade(arg_0));
        dto.setSubTipo(documento.getSubTipo());
        dto.setUsuario(documento.getUsuario());
        dto.setWeb(documento.getWeb());
        dto.setCertidaoEspecial(documento.getCertidaoEspecial());
        dto.setProcessoSei(documento.getProcessoSei());
        dto.setCodigoPgd(documento.getCodigoPgd());
        dto.setDataEmissao(documento.getDataEmissao());
        dto.setNumeroPrimeiroAlvara(documento.getNumeroPrimeiroAlvara());
        dto.setAnoEmissaoAlvara(documento.getAnoEmissaoAlvara());
        dto.setDataPrimeiroAlvara(documento.getDataPrimeiroAlvara());
        dto.setCodigoPrancha(documento.getCodigoPrancha());
        dto.setAreaAcrescimoOrDecrescimo(documento.getAreaAcrescimoOrDecrescimo());
        this.fillPessoaDocumentoGenericoDTO(documento, dto);
        this.fillDadosProjetoDocumentoGenericoDTO(documento, dto);
        this.fillDocumentoCertidaoItens(documento, dto);
        dto.setCabecalho(FileUtils.bytesToText((byte[])documento.getCabecalho()));
        dto.setRodape(FileUtils.bytesToText((byte[])documento.getRodape()));
        return dto;
    }

    private void fillPessoaDocumentoGenericoDTO(Documento documento, DocumentoGenericoDTO dto) {
        dto.setPessoaNome(documento.getRequerente());
        dto.setPessoaCpfCnpj(documento.getCnpjCpf());
        dto.setTipoPessoa(documento.getTipoPessoaRequerente());
        Pessoa pessoa = documento.getPessoa();
        if (pessoa != null) {
            dto.setCodigoPessoa(pessoa.getId());
            dto.setPessoaCadastro(PessoaDTO.builder().nome(pessoa.getNome()).cnpjCpf(pessoa.getCnpjCpf()).tipoPessoa(pessoa.getTipoPessoa().getValue()).build());
        }
    }

    private void fillDadosProjetoDocumentoGenericoDTO(Documento documento, DocumentoGenericoDTO dto) {
        FiltroProjetoDTO dadosProjeto = new FiltroProjetoDTO();
        dadosProjeto.setNumeroProjeto(documento.getNumeroProjeto());
        dadosProjeto.setExercicio(documento.getExercicioProjeto());
        Optional.ofNullable(documento.getTipoCadastro()).map(TipoCadastro::getValue).ifPresent(arg_0 -> ((FiltroProjetoDTO)dadosProjeto).setTipoCadastro(arg_0));
        Optional.ofNullable(documento.getCadastroGeral()).ifPresent(cadastroGeral -> {
            dadosProjeto.setCadastroGeral(cadastroGeral.getCadastroGeral());
            dadosProjeto.setIdCadastro(cadastroGeral.getId());
        });
        dto.setDadosProjeto(dadosProjeto);
    }

    private void fillDocumentoCertidaoItens(Documento documento, DocumentoGenericoDTO dto) {
        List<DocumentoCertidaoItemDTO> itensDTO = Optional.ofNullable(documento.getDocumentoCertidaoItems()).orElse(List.of()).stream().map(arg_0 -> this.buildDocumentoCertidaoItemDTO(arg_0)).toList();
        dto.setDocumentoCertidaoItens(itensDTO);
    }

    public List<DocumentoCertidaoItemDTO> getDTODocumentoCertidaoItens(Documento documento) {
        return Optional.ofNullable(documento.getDocumentoCertidaoItems()).orElse(List.of()).stream().map(arg_0 -> this.buildDocumentoCertidaoItemDTO(arg_0)).toList();
    }

    private DocumentoCertidaoItemDTO buildDocumentoCertidaoItemDTO(DocumentoCertidaoItem item) {
        DocumentoCertidaoItemDTO dto = new DocumentoCertidaoItemDTO();
        this.copyDocumentoCertidaoItemFields(item, dto);
        if (item.getId() != null) {
            dto.setEntidade(item.getId().getEntidade());
            dto.setExercicio(item.getId().getExercicio());
            dto.setTipoDocumento(item.getId().getTipoDocumento());
            dto.setDocumento(item.getId().getDocumento());
            dto.setSequencia(item.getId().getSequencia());
        }
        return dto;
    }

    private DocumentoCertidaoItem buildDocumentoCertidaoItem(DocumentoCertidaoItemDTO dto) {
        DocumentoCertidaoItem item = new DocumentoCertidaoItem();
        if (Objects.nonNull(dto.getEntidade()) && Objects.nonNull(dto.getExercicio()) && Objects.nonNull(dto.getTipoDocumento()) && Objects.nonNull(dto.getDocumento()) && Objects.nonNull(dto.getSequencia())) {
            item.setId(new DocumentoCertidaoItemId(dto.getEntidade(), dto.getExercicio(), dto.getTipoDocumento(), dto.getDocumento(), dto.getSequencia()));
        }
        this.copyDocumentoCertidaoItemFields(dto, item);
        return item;
    }

    private void copyDocumentoCertidaoItemFields(DocumentoCertidaoItem origem, DocumentoCertidaoItemDTO destino) {
        destino.setArea(origem.getArea());
        destino.setIdTipoConstrucao(origem.getTipoConstrucao());
        destino.setDataAprovacao(origem.getDataAprovacao());
        destino.setAnoAlvara(origem.getAnoAlvara());
        destino.setAnoHabitese(origem.getAnoHabitese());
        destino.setRegular(origem.getRegular());
        destino.setExpedicao(origem.getExpedicao());
        destino.setNumeroAlvara(origem.getNumeroAlvara());
        destino.setNumeroHabitese(origem.getNumeroHabitese());
        destino.setIdUtilizacao(origem.getUtilizacao());
        destino.setAtualizado(origem.getAtualizado());
        destino.setAreaFiscalizada(origem.getAreaFiscalizada());
        destino.setIdTipoSegmento(origem.getTipoSegmento());
        destino.setSituacao(origem.getSituacao());
        destino.setSituacaoDesc(origem.getSituacaoDesc());
        destino.setDataHabitese(origem.getDataHabitese());
        destino.setAreaCoberta(origem.getAreaCoberta());
        destino.setAreaCobertaAprovada(origem.getAreaCobertaAprovada());
        destino.setAreaCobertaConcluida(origem.getAreaCobertaConcluida());
        destino.setAreaCobertaRenovar(origem.getAreaCobertaRenovar());
        destino.setAreaCobertaParcial(origem.getAreaCobertaParcial());
        destino.setAreaCobertaAcumulada(origem.getAreaCobertaAcumulada());
        destino.setAreaCobertaAConcluir(origem.getAreaCobertaAConcluir());
        destino.setAreaCobertaExistente(origem.getAreaCobertaExistente());
        destino.setAreaCobertaDemolida(origem.getAreaCobertaDemolida());
        destino.setAreaCobertaRemanescente(origem.getAreaCobertaRemanescente());
        destino.setAreaDescoberta(origem.getAreaDescoberta());
        destino.setAreaDescobertaAprovada(origem.getAreaDescobertaAprovada());
        destino.setAreaDescobertaConcluida(origem.getAreaDescobertaConcluida());
        destino.setAreaDescobertaRenovar(origem.getAreaDescobertaRenovar());
        destino.setAreaDescobertaParcial(origem.getAreaDescobertaParcial());
        destino.setAreaDescobertaAcumulada(origem.getAreaDescobertaAcumulada());
        destino.setAreaDescobertaAConcluir(origem.getAreaDescobertaAConcluir());
        destino.setAreaDescobertaExistente(origem.getAreaDescobertaExistente());
        destino.setAreaDescobertaDemolida(origem.getAreaDescobertaDemolida());
        destino.setAreaDescobertaRemanescente(origem.getAreaDescobertaRemanescente());
        destino.setCodigo(origem.getCodigo());
        destino.setIdRespostaSegmentoPadrao(origem.getPadrao());
        destino.setAnoConstrucao(origem.getAnoConstrucao());
    }

    private void copyDocumentoCertidaoItemFields(DocumentoCertidaoItemDTO origem, DocumentoCertidaoItem destino) {
        destino.setArea(origem.getArea());
        destino.setTipoConstrucao(origem.getIdTipoConstrucao());
        destino.setDataAprovacao(origem.getDataAprovacao());
        destino.setAnoAlvara(origem.getAnoAlvara());
        destino.setAnoHabitese(origem.getAnoHabitese());
        destino.setRegular(origem.getRegular());
        destino.setExpedicao(origem.getExpedicao());
        destino.setNumeroAlvara(origem.getNumeroAlvara());
        destino.setNumeroHabitese(origem.getNumeroHabitese());
        destino.setUtilizacao(origem.getIdUtilizacao());
        destino.setAtualizado(origem.getAtualizado());
        destino.setAreaFiscalizada(origem.getAreaFiscalizada());
        destino.setTipoSegmento(origem.getIdTipoSegmento());
        destino.setSituacao(origem.getSituacao());
        destino.setSituacaoDesc(origem.getSituacaoDesc());
        destino.setDataHabitese(origem.getDataHabitese());
        destino.setAreaCoberta(origem.getAreaCoberta());
        destino.setAreaCobertaAprovada(origem.getAreaCobertaAprovada());
        destino.setAreaCobertaConcluida(origem.getAreaCobertaConcluida());
        destino.setAreaCobertaRenovar(origem.getAreaCobertaRenovar());
        destino.setAreaCobertaParcial(origem.getAreaCobertaParcial());
        destino.setAreaCobertaAcumulada(origem.getAreaCobertaAcumulada());
        destino.setAreaCobertaAConcluir(origem.getAreaCobertaAConcluir());
        destino.setAreaCobertaExistente(origem.getAreaCobertaExistente());
        destino.setAreaCobertaDemolida(origem.getAreaCobertaDemolida());
        destino.setAreaCobertaRemanescente(origem.getAreaCobertaRemanescente());
        destino.setAreaDescoberta(origem.getAreaDescoberta());
        destino.setAreaDescobertaAprovada(origem.getAreaDescobertaAprovada());
        destino.setAreaDescobertaConcluida(origem.getAreaDescobertaConcluida());
        destino.setAreaDescobertaRenovar(origem.getAreaDescobertaRenovar());
        destino.setAreaDescobertaParcial(origem.getAreaDescobertaParcial());
        destino.setAreaDescobertaAcumulada(origem.getAreaDescobertaAcumulada());
        destino.setAreaDescobertaAConcluir(origem.getAreaDescobertaAConcluir());
        destino.setAreaDescobertaExistente(origem.getAreaDescobertaExistente());
        destino.setAreaDescobertaDemolida(origem.getAreaDescobertaDemolida());
        destino.setAreaDescobertaRemanescente(origem.getAreaDescobertaRemanescente());
        destino.setCodigo(origem.getCodigo());
        destino.setPadrao(origem.getIdRespostaSegmentoPadrao());
        destino.setAnoConstrucao(origem.getAnoConstrucao());
    }

    public DocumentoDTO editar(Long id, @Valid DocumentoGenericoDTO dto) {
        Documento documentoExists = this.findDocumentoDomainById(id);
        this.geraDocumentoService.validateDocumento(documentoExists.getDocumentoTipo(), documentoExists.getPessoa(), documentoExists.getCadastroGeral(), dto.getIdProcesso(), dto.getDadosProjeto(), dto.getFinalidade());
        documentoExists.setTipoPessoaRequerente(dto.getTipoPessoa());
        documentoExists.setCnpjCpf(dto.getPessoaCpfCnpj());
        documentoExists.setRequerente(dto.getPessoaNome());
        if (CpfCnpjValidator.isValidCPF((String)dto.getPessoaCpfCnpj())) {
            documentoExists.setCpfRequerente(dto.getPessoaCpfCnpj());
        }
        documentoExists.setIdProcesso(dto.getIdProcesso());
        documentoExists.setExercicioProcesso(dto.getExercicioProcesso());
        documentoExists.setProcessoSei(dto.getProcessoSei());
        documentoExists.setDataEmissao(dto.getDataEmissao());
        documentoExists.setCodigoPgd(dto.getCodigoPgd());
        documentoExists.setCodigoPrancha(dto.getCodigoPrancha());
        documentoExists.setAreaAcrescimoOrDecrescimo(dto.getAreaAcrescimoOrDecrescimo());
        documentoExists.setNumeroPrimeiroAlvara(dto.getNumeroPrimeiroAlvara());
        documentoExists.setAnoEmissaoAlvara(dto.getAnoEmissaoAlvara());
        documentoExists.setDataPrimeiroAlvara(dto.getDataPrimeiroAlvara());
        documentoExists.setSubTipo(dto.getSubTipo());
        documentoExists.setCertidaoEspecial(dto.getCertidaoEspecial());
        documentoExists.setObservacao(dto.getObservacao());
        documentoExists.setSituacaoCadastral(dto.getSituacaoCadastral());
        if (Boolean.TRUE.equals(documentoExists.getDocumentoTipo().getPossuiCabecalho())) {
            documentoExists.setCabecalho(FileUtils.safeTextToBytes((String)dto.getCabecalho()));
        }
        if (Boolean.TRUE.equals(documentoExists.getDocumentoTipo().getPossuiRodape())) {
            documentoExists.setRodape(FileUtils.safeTextToBytes((String)dto.getRodape()));
        }
        Optional.ofNullable(dto.getDadosProjeto()).ifPresent(dadosProjeto -> {
            documentoExists.setNumeroProjeto(dadosProjeto.getNumeroProjeto());
            documentoExists.setExercicioProjeto(dadosProjeto.getExercicio());
        });
        Optional.ofNullable(dto.getFinalidade()).flatMap(arg_0 -> ((DocumentoFinalidadeService)this.documentoFinalidadeService).findById(arg_0)).ifPresent(arg_0 -> ((Documento)documentoExists).setDocumentoFinalidade(arg_0));
        this.createAndfillDocumentoResponsaveis(documentoExists);
        List documentoCertidaoItems = dto.getDocumentoCertidaoItens().stream().map(arg_0 -> this.buildDocumentoCertidaoItem(arg_0)).collect(Collectors.toList());
        documentoExists.getDocumentoCertidaoItems().clear();
        documentoExists.getDocumentoCertidaoItems().addAll(documentoCertidaoItems);
        Documento documentoSaved = (Documento)this.save((EloEntity)documentoExists, null);
        return DocumentoDTO.from((Documento)documentoSaved);
    }

    @Generated
    public DocumentoService(DocumentoRepository documentoRepository, CadastroGeralRepository cadastroGeralRepository, AisePdfService aisePdfService, DocumentoHistoricoSituacaoRepository documentoHistoricoSituacaoRepository, CadastroImobiliarioService cadastroImobiliarioService, EntityManager em, SequenceGeneratorRepository sequenceGeneratorRepository, PessoaService pessoaService, GeraDocumentoService geraDocumentoService, DocumentoFinalidadeService documentoFinalidadeService, ContextService contextService, ArquivoUnicoService arquivoUnicoService, ArquivoStorageFeignClient arquivoStorageFeignClient, ParcelamentoRepositoryCustom parcelamentoRepository, ArquivoClient arquivoClient, ResolversHandler resolversHandler, DocumentoPeticaoRepository documentoPeticaoRepository, TipoConstrucaoService tipoConstrucaoService, UtilizacaoService utilizacaoService, TipoSegmentoService tipoSegmentoService, RespostaService respostaService, ParametroGeralService parametroGeralService, ProjetoItemService projetoItemService, PdfFetchService pdfFetchService, DocumentoResponsavelService documentoResponsavelService) {
        this.documentoRepository = documentoRepository;
        this.cadastroGeralRepository = cadastroGeralRepository;
        this.aisePdfService = aisePdfService;
        this.documentoHistoricoSituacaoRepository = documentoHistoricoSituacaoRepository;
        this.cadastroImobiliarioService = cadastroImobiliarioService;
        this.em = em;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.pessoaService = pessoaService;
        this.geraDocumentoService = geraDocumentoService;
        this.documentoFinalidadeService = documentoFinalidadeService;
        this.contextService = contextService;
        this.arquivoUnicoService = arquivoUnicoService;
        this.arquivoStorageFeignClient = arquivoStorageFeignClient;
        this.parcelamentoRepository = parcelamentoRepository;
        this.arquivoClient = arquivoClient;
        this.resolversHandler = resolversHandler;
        this.documentoPeticaoRepository = documentoPeticaoRepository;
        this.tipoConstrucaoService = tipoConstrucaoService;
        this.utilizacaoService = utilizacaoService;
        this.tipoSegmentoService = tipoSegmentoService;
        this.respostaService = respostaService;
        this.parametroGeralService = parametroGeralService;
        this.projetoItemService = projetoItemService;
        this.pdfFetchService = pdfFetchService;
        this.documentoResponsavelService = documentoResponsavelService;
    }
}

