/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.CadastroGeralIsencao;
import br.com.elotech.tributos.domain.CadastroGeralObservacao;
import br.com.elotech.tributos.domain.Isencao;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.LogradouroTestada;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoDivisaoUnificacaoLote;
import br.com.elotech.tributos.domain.TipoImovel;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSegmento;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioTestada;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioTestadaGenerica;
import br.com.elotech.tributos.domain.imobiliario.DivisaoUnificacaoLote;
import br.com.elotech.tributos.dto.DebitosEmAbertoComTotalizadorDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroImobiliarioDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroImobiliarioUnificacaoDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.DesmembrarCadastroImobiliarioDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.ObservacaoDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.UnificarCadastroImobiliarioDTO;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CadastroGeralIsencaoService;
import br.com.elotech.tributos.service.CadastroGeralObservacaoService;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.CadastroImobiliarioService;
import br.com.elotech.tributos.service.DebitoEmAbertoService;
import br.com.elotech.tributos.service.IsencaoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.util.ListUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class DivisaoUnificacaoLoteService
extends CrudService<DivisaoUnificacaoLote, Long> {
    private final CadastroImobiliarioService cadastroImobiliarioService;
    private final CadastroGeralObservacaoService cadastroGeralObservacaoService;
    private final DebitoEmAbertoService debitoEmAbertoService;
    private final IsencaoService isencaoService;
    private final CadastroGeralIsencaoService cadastroGeralIsencaoService;
    private final CadastroGeralService cadastroGeralService;
    private final ParametroGeralService parametroGeralService;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;

    public Long desmembrar(DesmembrarCadastroImobiliarioDTO desmembramento) {
        CadastroImobiliario cadastroImobiliarioOrigem = (CadastroImobiliario)this.cadastroImobiliarioService.findOne((Serializable)this.cadastroImobiliarioService.saveDTOWithFlush(desmembramento.getCadastroOrigem(), Boolean.FALSE, Boolean.FALSE).getId());
        String usuario = SecurityUtils.getUserAise();
        String observacao = String.format("Desmembramento do Cadastro %d, gerando o(s) Novo(s) Cadastro(s): %s", desmembramento.getCadastroOrigem().getCadastroGeral(), desmembramento.getNovosCadastros().stream().map(CadastroImobiliarioDTO::getCadastroGeral).map(Object::toString).collect(Collectors.joining(", ")));
        desmembramento.getNovosCadastros().stream().forEach(cadastro -> {
            ListUtils.forEachWithCounter((Iterable)cadastro.getProfundidades(), (index, profundidade) -> {
                profundidade.setId(null);
                profundidade.setSequencia(Long.valueOf(index + 1L));
            });
            ListUtils.forEachWithCounter((Iterable)cadastro.getSegmentos(), (index, segmento) -> {
                segmento.setId(null);
                segmento.setSequencia(Long.valueOf(index + 1L));
                segmento.getRespostasSegmento().forEach(resposta -> {
                    resposta.setId(null);
                    resposta.getRespostasPreenchidas().forEach(respostaPreenchida -> respostaPreenchida.setId(null));
                });
            });
            cadastro.getProprietarios().forEach(proprietario -> proprietario.setId(null));
            cadastro.getTestadas().forEach(testada -> testada.setId(null));
            cadastro.getTestadasGenericas().forEach(testada -> testada.setId(null));
            cadastro.getRespostasTerreno().forEach(resposta -> {
                resposta.setId(null);
                resposta.getRespostasPreenchidas().forEach(respostaPreenchida -> respostaPreenchida.setId(null));
            });
            ListUtils.forEachWithCounter((Iterable)cadastro.getAreasVerde(), (index, areaVerde) -> {
                areaVerde.setId(null);
                areaVerde.setSequencia(Long.valueOf(index + 1L));
            });
            cadastro.getObservacoes().clear();
            cadastro.getObservacoes().add(new ObservacaoDTO(Long.valueOf(1L), observacao, LocalDate.now(), usuario, null, null, null, Boolean.FALSE, Boolean.FALSE));
            if (cadastro.getSegmentos().isEmpty() && TipoImovel.PREDIAL.equals((Object)cadastro.getTipoImovel())) {
                cadastro.setTipoImovel(TipoImovel.TERRITORIAL);
            }
        });
        List cadastrosSalvos = desmembramento.getNovosCadastros().stream().map(cadastro -> this.cadastroImobiliarioService.saveDTOWithFlush(cadastro, Boolean.TRUE, Boolean.FALSE)).map(CadastroImobiliarioDTO::getId).map(arg_0 -> ((CadastroImobiliarioService)this.cadastroImobiliarioService).findOne(arg_0)).collect(Collectors.toList());
        DivisaoUnificacaoLote divisaoUnificacaoLote = new DivisaoUnificacaoLote();
        divisaoUnificacaoLote.setCadastroImobiliario(cadastroImobiliarioOrigem);
        divisaoUnificacaoLote.setTipo(TipoDivisaoUnificacaoLote.DIVISAO);
        divisaoUnificacaoLote.setData(LocalDateTime.now());
        divisaoUnificacaoLote.setUsuario(usuario);
        divisaoUnificacaoLote.setObservacao(observacao);
        divisaoUnificacaoLote.getCadastrosImobiliarios().addAll(cadastrosSalvos);
        return ((DivisaoUnificacaoLote)this.save((EloEntity)divisaoUnificacaoLote, null)).getId();
    }

    public DivisaoUnificacaoLote unificar(UnificarCadastroImobiliarioDTO unificarCadastroImobiliarioDTO) {
        this.validateComExclusaoLogica(unificarCadastroImobiliarioDTO);
        CadastroImobiliario cadastroImobiliarioOrigem = (CadastroImobiliario)this.cadastroImobiliarioService.findOne((Serializable)unificarCadastroImobiliarioDTO.getIdCadastroOrigem());
        String textoCadastroUnificadoObservacao = unificarCadastroImobiliarioDTO.getCadastrosSelecionados().stream().map(CadastroImobiliarioUnificacaoDTO::getCadastroGeral).map(Object::toString).collect(Collectors.joining(", "));
        String observacaoCadastroOrigem = String.format("Unifica\u00e7\u00e3o do(s) Cadastro(s): %s", textoCadastroUnificadoObservacao);
        String observacaoCadastrosUnificados = String.format("Unificado ao Cadastro: %s", cadastroImobiliarioOrigem.getCadastroGeral());
        String observacaoUnificacao = String.format("Unifica\u00e7\u00e3o do Cadastro %d, com o(s) Cadastro(s): %s", cadastroImobiliarioOrigem.getCadastroGeral(), textoCadastroUnificadoObservacao);
        String usuario = SecurityUtils.getUserAise();
        List cadastrosUnificados = unificarCadastroImobiliarioDTO.getCadastrosSelecionados().stream().map(CadastroImobiliarioUnificacaoDTO::getId).map(arg_0 -> ((CadastroImobiliarioService)this.cadastroImobiliarioService).findOne(arg_0)).map(cadastroImobiliario -> this.addObservacaoAoCadastrosImobiliarios(cadastroImobiliario, observacaoCadastrosUnificados, usuario)).collect(Collectors.toList());
        this.unifyValoresAreasCadastrosOrigem(cadastroImobiliarioOrigem, cadastrosUnificados);
        this.unifySegmentos(cadastroImobiliarioOrigem, cadastrosUnificados);
        if (this.utilizaTestadaGenerica().booleanValue()) {
            this.unifyTestadasGenericas(cadastroImobiliarioOrigem, cadastrosUnificados);
        } else {
            this.unifyTestadas(cadastroImobiliarioOrigem, cadastrosUnificados);
        }
        this.addObservacaoAoCadastrosImobiliarios(cadastroImobiliarioOrigem, observacaoCadastroOrigem, usuario);
        DivisaoUnificacaoLote divisaoUnificacaoLote = new DivisaoUnificacaoLote();
        divisaoUnificacaoLote.setCadastroImobiliario(cadastroImobiliarioOrigem);
        divisaoUnificacaoLote.setTipo(TipoDivisaoUnificacaoLote.UNIFICACAO);
        divisaoUnificacaoLote.setData(LocalDateTime.now());
        divisaoUnificacaoLote.setUsuario(usuario);
        divisaoUnificacaoLote.setObservacao(observacaoUnificacao);
        divisaoUnificacaoLote.getCadastrosImobiliarios().addAll(cadastrosUnificados);
        this.saveCadastroImobiliarios(unificarCadastroImobiliarioDTO, cadastroImobiliarioOrigem, cadastrosUnificados);
        return (DivisaoUnificacaoLote)this.save((EloEntity)divisaoUnificacaoLote, null);
    }

    private void saveCadastroImobiliarios(UnificarCadastroImobiliarioDTO unificarCadastroImobiliarioDTO, CadastroImobiliario cadastroImobiliarioOrigem, List<CadastroImobiliario> cadastrosUnificados) {
        if (unificarCadastroImobiliarioDTO.getExclusaoLogica().booleanValue()) {
            cadastrosUnificados.stream().forEach(cadastroImobiliario -> this.saveUnificacaoComExclusaoLogica(cadastroImobiliario));
        } else {
            Isencao isencao = this.findIsencao(unificarCadastroImobiliarioDTO);
            cadastrosUnificados.stream().forEach(cadastroImobiliario -> {
                Optional cadastroGeralIsencao = this.cadastroGeralIsencaoService.findByCadastroGeralIdAndIsencaoId(cadastroImobiliario.getId(), isencao.getId());
                if (!cadastroGeralIsencao.isPresent()) {
                    CadastroGeralIsencao cadastroGeralIsencaoNovo = new CadastroGeralIsencao();
                    cadastroGeralIsencaoNovo.setCadastroGeral((CadastroGeral)cadastroImobiliario);
                    cadastroGeralIsencaoNovo.setIsencao(isencao);
                    this.cadastroGeralIsencaoService.create(cadastroGeralIsencaoNovo);
                    cadastroImobiliario.getCadastroGeralIsencoes().add(cadastroGeralIsencaoNovo);
                }
                this.cadastroImobiliarioService.save((EloEntity)cadastroImobiliario, null);
            });
        }
        this.cadastroImobiliarioService.save((EloEntity)cadastroImobiliarioOrigem, null);
    }

    private void saveUnificacaoComExclusaoLogica(CadastroImobiliario cadastroImobiliario) {
        this.cadastroImobiliarioService.save((EloEntity)cadastroImobiliario, null);
        this.cadastroGeralService.excludeCadastroLogicamente(cadastroImobiliario.getId());
    }

    private Isencao findIsencao(UnificarCadastroImobiliarioDTO unificarCadastroImobiliarioDTO) {
        if (Objects.isNull(unificarCadastroImobiliarioDTO.getIsencaoId())) {
            throw new EloValidationException("N\u0101o \u00e9 poss\u00edvel salvar unifica\u00e7\u00e3o sem isen\u00e7\u00e3o.");
        }
        return (Isencao)this.isencaoService.findById((Serializable)unificarCadastroImobiliarioDTO.getIsencaoId()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar isen\u00e7\u00e3o de id %d.", unificarCadastroImobiliarioDTO.getIsencaoId())));
    }

    private void validateComExclusaoLogica(UnificarCadastroImobiliarioDTO unificarCadastroImobiliarioDTO) {
        if (unificarCadastroImobiliarioDTO.getCadastrosSelecionados().isEmpty()) {
            throw new EloValidationException("Nenhum cadastro para unifica\u00e7\u00e3o selecionado.");
        }
        if (Objects.isNull(unificarCadastroImobiliarioDTO.getExclusaoLogica())) {
            throw new EloValidationException("Exclus\u00e3o l\u00f3gica \u00e9 obrigat\u00f3ria");
        }
        if (unificarCadastroImobiliarioDTO.getExclusaoLogica().booleanValue() && Objects.nonNull(unificarCadastroImobiliarioDTO.getIdCadastroOrigem())) {
            this.validateDebitosEmAberto(unificarCadastroImobiliarioDTO.getIdCadastroOrigem());
            unificarCadastroImobiliarioDTO.getCadastrosSelecionados().stream().forEach(cadastroImobiliarioUnificacaoDTO -> this.validateDebitosEmAberto(cadastroImobiliarioUnificacaoDTO.getId()));
        }
    }

    private void validateDebitosEmAberto(Long idCadastro) {
        DebitosEmAbertoComTotalizadorDTO debitosEmAbertoComTotalizadorDTO = this.debitoEmAbertoService.loadDebitosAbertosAgrupados(this.createStringFilter(idCadastro), Boolean.TRUE);
        if (debitosEmAbertoComTotalizadorDTO.getValorTotal().compareTo(BigDecimal.ZERO) > 0) {
            CadastroGeral cadastroGeral = (CadastroGeral)this.cadastroGeralService.findOne((Serializable)idCadastro);
            throw new EloValidationException(String.format("O cadastro %d possui d\u00e9bitos pendentes. N\u00e3o ser\u00e1 poss\u00edvel unifica-lo.", cadastroGeral.getCadastroGeral()));
        }
    }

    private String createStringFilter(Long id) {
        return String.format(" TRIBCADASTROGERAL.IDKEY = %d ", id);
    }

    private void unifyValoresAreasCadastrosOrigem(CadastroImobiliario cadastroImobiliarioOrigem, List<CadastroImobiliario> cadastrosUnificados) {
        cadastroImobiliarioOrigem.setAreaLote(cadastrosUnificados.stream().map(cad -> Optional.ofNullable(cad.getAreaLote()).orElse(BigDecimal.ZERO)).reduce(Optional.ofNullable(cadastroImobiliarioOrigem.getAreaLote()).orElse(BigDecimal.ZERO), BigDecimal::add));
        cadastroImobiliarioOrigem.setAreaUtilLote(cadastrosUnificados.stream().map(cad -> Optional.ofNullable(cad.getAreaUtilLote()).orElse(BigDecimal.ZERO)).reduce(Optional.ofNullable(cadastroImobiliarioOrigem.getAreaUtilLote()).orElse(BigDecimal.ZERO), BigDecimal::add));
        cadastroImobiliarioOrigem.setAreaPrivativa(cadastrosUnificados.stream().map(cad -> Optional.ofNullable(cad.getAreaPrivativa()).orElse(BigDecimal.ZERO)).reduce(Optional.ofNullable(cadastroImobiliarioOrigem.getAreaPrivativa()).orElse(BigDecimal.ZERO), BigDecimal::add));
        cadastroImobiliarioOrigem.setAreaComum(cadastrosUnificados.stream().map(cad -> Optional.ofNullable(cad.getAreaComum()).orElse(BigDecimal.ZERO)).reduce(Optional.ofNullable(cadastroImobiliarioOrigem.getAreaComum()).orElse(BigDecimal.ZERO), BigDecimal::add));
        cadastroImobiliarioOrigem.setAreaTotalConstruida(cadastrosUnificados.stream().map(cad -> Optional.ofNullable(cad.getAreaTotalConstruida()).orElse(BigDecimal.ZERO)).reduce(Optional.ofNullable(cadastroImobiliarioOrigem.getAreaTotalConstruida()).orElse(BigDecimal.ZERO), BigDecimal::add));
    }

    private void unifySegmentos(CadastroImobiliario imobiliarioOrigem, List<CadastroImobiliario> imobiliariosParaUnificar) {
        AtomicLong sequencia = new AtomicLong(imobiliarioOrigem.getLastSequencia());
        List segmentosSemDemolicao = this.getSegmentosSemDemolicoes(imobiliariosParaUnificar);
        List segmentosValidosParaUnificar = segmentosSemDemolicao.stream().map(segmento -> this.getNewSegmento(imobiliarioOrigem, segmento, sequencia)).collect(Collectors.toList());
        segmentosValidosParaUnificar.addAll(imobiliarioOrigem.getSegmentos());
        imobiliarioOrigem.mergeSegmentos(segmentosValidosParaUnificar);
    }

    private List<CadastroImobiliarioSegmento> getSegmentosSemDemolicoes(List<CadastroImobiliario> imobiliariosParaUnificar) {
        return imobiliariosParaUnificar.stream().flatMap(i -> i.getSegmentos().stream()).filter(CadastroImobiliarioSegmento::semDemolicoes).toList();
    }

    private CadastroImobiliarioSegmento getNewSegmento(CadastroImobiliario imobiliarioOrigem, CadastroImobiliarioSegmento segmento, AtomicLong sequencia) {
        CadastroImobiliarioSegmento newSegmento = segmento.copyIgnoringProperties(new String[]{"id", "sequencia", "tipoCadastro", "cadastroGeral", "respostasSegmento", "demolicoes"});
        newSegmento.setSequencia(Long.valueOf(sequencia.incrementAndGet()));
        newSegmento.setTipoCadastro(imobiliarioOrigem.getTipoCadastro());
        newSegmento.setCadastroGeral(imobiliarioOrigem.getCadastroGeral());
        return newSegmento;
    }

    private void unifyTestadasGenericas(CadastroImobiliario cadastroImobiliarioOrigem, List<CadastroImobiliario> cadastrosUnificados) {
        Map mapAgrupaTestadasDoMesmoLogradouro = cadastroImobiliarioOrigem.getTestadasGenericas().stream().collect(Collectors.groupingBy(CadastroImobiliarioTestadaGenerica::getLogradouro, this.acumularValoresGenerica()));
        List testadasASeremUnificadasAgrupadas = cadastrosUnificados.stream().flatMap(cadastroImobiliario -> cadastroImobiliario.getTestadasGenericas().stream()).collect(Collectors.groupingBy(CadastroImobiliarioTestadaGenerica::getLogradouro, this.acumularValoresGenerica())).values().stream().map(Optional::get).collect(Collectors.toList());
        List listTestadasDoMesmoLogradouro = mapAgrupaTestadasDoMesmoLogradouro.values().stream().map(Optional::get).collect(Collectors.toList());
        AtomicLong nextCodigoTestadaGenericaValido = this.getNextCodigoTestadaGenericaValido(cadastroImobiliarioOrigem.getTestadasGenericas());
        List testadasGenericasAdicionarAoOriginal = this.retornaTestadasLogradouroDiferenteGenerica(testadasASeremUnificadasAgrupadas, mapAgrupaTestadasDoMesmoLogradouro).stream().map(testadaToCopy -> this.createNewTestadaGenerica(testadaToCopy, nextCodigoTestadaGenericaValido)).collect(Collectors.toList());
        cadastroImobiliarioOrigem.getTestadasGenericas().clear();
        cadastroImobiliarioOrigem.getTestadasGenericas().addAll(Stream.concat(listTestadasDoMesmoLogradouro.stream(), testadasGenericasAdicionarAoOriginal.stream()).collect(Collectors.toList()));
    }

    private List<CadastroImobiliarioTestadaGenerica> retornaTestadasLogradouroDiferenteGenerica(List<CadastroImobiliarioTestadaGenerica> testadasASeremUnificadasAgrupadas, Map<Logradouro, Optional<CadastroImobiliarioTestadaGenerica>> mapAgruapaTestadasDoMesmoLogradouro) {
        return testadasASeremUnificadasAgrupadas.stream().filter(testaUnificada -> {
            if (mapAgruapaTestadasDoMesmoLogradouro.containsKey(testaUnificada.getLogradouro())) {
                Optional testadaCadastroOrigem = (Optional)mapAgruapaTestadasDoMesmoLogradouro.get(testaUnificada.getLogradouro());
                testadaCadastroOrigem.ifPresent(cadastroImobiliarioTestadaGenerica -> cadastroImobiliarioTestadaGenerica.setTamanho(cadastroImobiliarioTestadaGenerica.getTamanho().add(testaUnificada.getTamanho())));
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    private Collector<CadastroImobiliarioTestadaGenerica, ?, Optional<CadastroImobiliarioTestadaGenerica>> acumularValoresGenerica() {
        return Collectors.reducing((accum, element) -> {
            accum.setTamanho(accum.getTamanho().add(element.getTamanho()));
            return accum;
        });
    }

    private CadastroImobiliarioTestadaGenerica createNewTestadaGenerica(CadastroImobiliarioTestadaGenerica testadaToCopy, AtomicLong nextCodigoValido) {
        Long nextVal = this.sequenceGeneratorRepository.getNextVal("S_TRIBIMOBILIARIOTESTADAGENERI");
        CadastroImobiliarioTestadaGenerica testadaNew = testadaToCopy.copy();
        testadaNew.setCodigoTestadaGenerica(Long.valueOf(nextCodigoValido.incrementAndGet()));
        testadaNew.setId(nextVal);
        return testadaNew;
    }

    public AtomicLong getNextCodigoTestadaGenericaValido(List<CadastroImobiliarioTestadaGenerica> listTestadasDoMesmoLogradouro) {
        return new AtomicLong(listTestadasDoMesmoLogradouro.stream().mapToLong(CadastroImobiliarioTestadaGenerica::getCodigoTestadaGenerica).max().orElse(0L));
    }

    private void unifyTestadas(CadastroImobiliario cadastroImobiliarioOrigem, List<CadastroImobiliario> cadastrosUnificados) {
        Map mapAgrupaTestadasDoMesmoLogradouro = cadastroImobiliarioOrigem.getTestadas().stream().collect(Collectors.groupingBy(CadastroImobiliarioTestada::getLogradouroTestada, this.acumularValores()));
        List testadasASeremUnificadasAgrupadas = cadastrosUnificados.stream().flatMap(cadastroImobiliario -> cadastroImobiliario.getTestadas().stream()).collect(Collectors.groupingBy(CadastroImobiliarioTestada::getIdLogradouroTestada, this.acumularValores())).values().stream().map(Optional::get).collect(Collectors.toList());
        List listTestadasDoMesmoLogradouro = mapAgrupaTestadasDoMesmoLogradouro.values().stream().map(Optional::get).collect(Collectors.toList());
        List testadasAdicionarAoOriginal = this.retornaTestadasLogradouroDiferente(testadasASeremUnificadasAgrupadas, mapAgrupaTestadasDoMesmoLogradouro).stream().map(arg_0 -> this.createNewTestada(arg_0)).collect(Collectors.toList());
        cadastroImobiliarioOrigem.getTestadas().clear();
        cadastroImobiliarioOrigem.getTestadas().addAll(Stream.concat(listTestadasDoMesmoLogradouro.stream(), testadasAdicionarAoOriginal.stream()).collect(Collectors.toList()));
    }

    private CadastroImobiliarioTestada createNewTestada(CadastroImobiliarioTestada testadaToCopy) {
        Long nextVal = this.sequenceGeneratorRepository.getNextVal("S_TRIBIMOBILIARIOTESTADA_ID");
        CadastroImobiliarioTestada testadaNew = testadaToCopy.copy();
        testadaNew.setId(nextVal);
        return testadaNew;
    }

    private List<CadastroImobiliarioTestada> retornaTestadasLogradouroDiferente(List<CadastroImobiliarioTestada> testadasASeremUnificadasAgrupadas, Map<LogradouroTestada, Optional<CadastroImobiliarioTestada>> mapAgruapaTestadasDoMesmoLogradouro) {
        return testadasASeremUnificadasAgrupadas.stream().filter(testaUnificada -> {
            if (mapAgruapaTestadasDoMesmoLogradouro.containsKey(testaUnificada.getLogradouroTestada())) {
                Optional testadaCadastroOrigem = (Optional)mapAgruapaTestadasDoMesmoLogradouro.get(testaUnificada.getLogradouroTestada());
                testadaCadastroOrigem.ifPresent(cadastroImobiliarioTestadaGenerica -> cadastroImobiliarioTestadaGenerica.setTamanhoTestada(cadastroImobiliarioTestadaGenerica.getTamanhoTestada().add(testaUnificada.getTamanhoTestada())));
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    private Collector<CadastroImobiliarioTestada, ?, Optional<CadastroImobiliarioTestada>> acumularValores() {
        return Collectors.reducing((accum, element) -> {
            accum.setTamanhoTestada(accum.getTamanhoTestada().add(element.getTamanhoTestada()));
            return accum;
        });
    }

    private Boolean utilizaTestadaGenerica() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_TESTADA_GENERICA, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private CadastroImobiliario addObservacaoAoCadastrosImobiliarios(CadastroImobiliario imobiliario, String observacaoCadastroOrigem, String usuario) {
        CadastroGeralObservacao cadastroGeralObservacao = this.cadastroGeralObservacaoService.geraObservacao((CadastroGeral)imobiliario, observacaoCadastroOrigem, usuario);
        List observacoesToMerge = imobiliario.getObservacoes();
        observacoesToMerge.add(cadastroGeralObservacao);
        imobiliario.addObservacoes(observacoesToMerge);
        return imobiliario;
    }

    @Generated
    public DivisaoUnificacaoLoteService(CadastroImobiliarioService cadastroImobiliarioService, CadastroGeralObservacaoService cadastroGeralObservacaoService, DebitoEmAbertoService debitoEmAbertoService, IsencaoService isencaoService, CadastroGeralIsencaoService cadastroGeralIsencaoService, CadastroGeralService cadastroGeralService, ParametroGeralService parametroGeralService, SequenceGeneratorRepository sequenceGeneratorRepository) {
        this.cadastroImobiliarioService = cadastroImobiliarioService;
        this.cadastroGeralObservacaoService = cadastroGeralObservacaoService;
        this.debitoEmAbertoService = debitoEmAbertoService;
        this.isencaoService = isencaoService;
        this.cadastroGeralIsencaoService = cadastroGeralIsencaoService;
        this.cadastroGeralService = cadastroGeralService;
        this.parametroGeralService = parametroGeralService;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
    }
}

