/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.domain.DebitoParcelaObservacao;
import br.com.elotech.tributos.dto.DebitoParcelaObservacaoDTO;
import br.com.elotech.tributos.repository.DebitoParcelaObservacaoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DebitoParcelaObservacaoService {
    private final DebitoParcelaObservacaoRepository debitoParcelaObservacaoRepository;

    public DebitoParcelaObservacaoService(DebitoParcelaObservacaoRepository debitoParcelaObservacaoRepository) {
        this.debitoParcelaObservacaoRepository = debitoParcelaObservacaoRepository;
    }

    public List<DebitoParcelaObservacao> findByDebitoParcela(Long entidade, Long exercicio, Long tipoCadastro, Long cadastroGeral, Long divida, Long subdivida, Long parcela) {
        return this.debitoParcelaObservacaoRepository.findObservacoesParcelas(entidade, exercicio, tipoCadastro, cadastroGeral, divida, subdivida, parcela);
    }

    @Transactional
    public void saveAll(Iterable<DebitoParcelaObservacao> observacoes) {
        this.debitoParcelaObservacaoRepository.saveAll(observacoes);
    }

    public DebitoParcelaObservacao saveObservacaoParcela(DebitoParcelaObservacaoDTO observacaoDTO) {
        if (Objects.isNull(observacaoDTO.getDataInclusao())) {
            observacaoDTO.setDataInclusao(LocalDate.now());
        }
        if (Objects.isNull(observacaoDTO.getUsuario())) {
            observacaoDTO.setUsuario(SecurityUtils.getUserAise());
        }
        if (Objects.isNull(observacaoDTO.getId().getSequencia())) {
            observacaoDTO.getId().setSequencia(Long.valueOf(this.debitoParcelaObservacaoRepository.findLastSequence(observacaoDTO.getId().getEntidade(), observacaoDTO.getId().getExercicio(), observacaoDTO.getId().getTipoCadastro(), observacaoDTO.getId().getCadastroGeral(), observacaoDTO.getId().getDivida(), observacaoDTO.getId().getSubDivida(), observacaoDTO.getId().getParcela()) + 1L));
        }
        DebitoParcelaObservacao observacao = new DebitoParcelaObservacao();
        observacao.setId(observacaoDTO.getId());
        observacao.setObservacao(observacaoDTO.getObservacao());
        observacao.setUsuario(observacaoDTO.getUsuario());
        observacao.setDataInclusao(observacaoDTO.getDataInclusao());
        return (DebitoParcelaObservacao)this.debitoParcelaObservacaoRepository.save((Object)observacao);
    }
}

