/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.SituacaoParcela;
import br.com.elotech.tributos.domain.TipoSituacaoParcela;
import br.com.elotech.tributos.dto.DebitoEmAbertoDTO;
import br.com.elotech.tributos.dto.DebitosEmAbertoComTotalizadorDTO;
import br.com.elotech.tributos.dto.ExtratoDebitoDTO;
import br.com.elotech.tributos.dto.FiltroDebitoPorContribuinteDTO;
import br.com.elotech.tributos.dto.FiltroExtratoDebitoDTO;
import br.com.elotech.tributos.dto.acrescimo.CalculaAcrescimoBaseDTO;
import br.com.elotech.tributos.repository.DebitoEmAbertoRepository;
import br.com.elotech.tributos.repository.SituacaoParcelaRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.ValidaEmissaoBoletoService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class DebitoEmAbertoService {
    private final DebitoEmAbertoRepository debitoEmAbertoRepository;
    private final FormaPagamentoService formaPagamentoService;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final ParametroGeralService parametroGeralService;
    private final ContextService contextService;
    private final ValidaEmissaoBoletoService validaEmissaoBoletoService;
    private final SituacaoParcelaRepository situacaoParcelaRepository;

    public List<DebitoEmAbertoDTO> loadDebitoEmAberto(String filtro, Boolean geraBoletoSomenteConstituidos) {
        return this.debitoEmAbertoRepository.loadDebitoEmAberto(filtro, geraBoletoSomenteConstituidos);
    }

    public List<ExtratoDebitoDTO> loadExtratoDebitosByIdCadastro(String filtro) {
        return this.debitoEmAbertoRepository.loadExtratoDebitosByFilter(filtro);
    }

    public List<ExtratoDebitoDTO> loadExtratoDebitosByFiltro(FiltroExtratoDebitoDTO filtro) {
        Boolean visualizaDebitosNaoConstituidos = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VISUALIZA_DEBITO_NAO_CONSTITUIDO);
        List retorno = this.debitoEmAbertoRepository.loadExtratoDebitosByFiltro(filtro, visualizaDebitosNaoConstituidos);
        if (Objects.nonNull(filtro.getDataReferencia()) && filtro.getDataReferencia().isBefore(LocalDate.now())) {
            TipoSituacaoParcela tipoSituacaoParcelaAberto = TipoSituacaoParcela.ABERTO;
            SituacaoParcela situacaoParcelaAberto = (SituacaoParcela)this.situacaoParcelaRepository.findFirstByTipoSituacaoParcelaOrderById(tipoSituacaoParcelaAberto).orElseThrow(() -> new EloValidationException(String.format("Situa\u00e7\u00e3o da parcela com c\u00f3digo %d n\u00e3o encontrada.", tipoSituacaoParcelaAberto.getValue())));
            retorno.addAll(this.debitoEmAbertoRepository.loadExtratoParcelamentoByCustomDataReferencia(filtro, visualizaDebitosNaoConstituidos, situacaoParcelaAberto));
            retorno.addAll(this.debitoEmAbertoRepository.loadExtratoPagamentoByCustomDataReferencia(filtro, visualizaDebitosNaoConstituidos, situacaoParcelaAberto));
            retorno.addAll(this.debitoEmAbertoRepository.loadExtratoDAByCustomDataReferencia(filtro, visualizaDebitosNaoConstituidos, situacaoParcelaAberto));
            retorno.addAll(this.debitoEmAbertoRepository.loadExtratoCancelamentoByCustomDataReferencia(filtro, visualizaDebitosNaoConstituidos, situacaoParcelaAberto));
        }
        if (Objects.nonNull(filtro.getDataReferencia()) && filtro.getDataReferencia().isAfter(LocalDate.now())) {
            retorno.forEach(ed -> ed.setIgnorarIndiceCorrecaoNaoLocalizado(Boolean.TRUE));
        }
        return retorno;
    }

    public DebitosEmAbertoComTotalizadorDTO loadDebitosAbertosAgrupados(String filtro, Boolean geraBoletoSomenteConstituidos) {
        List debitosEmAberto = this.loadDebitoEmAberto(filtro, geraBoletoSomenteConstituidos);
        return new DebitosEmAbertoComTotalizadorDTO(debitosEmAberto);
    }

    public List<DebitoEmAbertoDTO> loadDebitosContribuinte(Long idPessoa, FiltroDebitoPorContribuinteDTO filtro) {
        FormaPagamento formaPagamento = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.empty());
        List debitos = this.debitoEmAbertoRepository.findDebitosPorContribuinte(this.contextService.getEntidadePrincipal(), this.contextService.getExercicioAtual(), formaPagamento, idPessoa, filtro);
        List debitosCalculados = this.calculoAcrescimoService.calculaAcrescimos(debitos, formaPagamento.getId(), Boolean.TRUE);
        return CalculaAcrescimoBaseDTO.agruparPorParcela((List)debitosCalculados);
    }

    @Generated
    public DebitoEmAbertoService(DebitoEmAbertoRepository debitoEmAbertoRepository, FormaPagamentoService formaPagamentoService, CalculoAcrescimoService calculoAcrescimoService, ParametroGeralService parametroGeralService, ContextService contextService, ValidaEmissaoBoletoService validaEmissaoBoletoService, SituacaoParcelaRepository situacaoParcelaRepository) {
        this.debitoEmAbertoRepository = debitoEmAbertoRepository;
        this.formaPagamentoService = formaPagamentoService;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.parametroGeralService = parametroGeralService;
        this.contextService = contextService;
        this.validaEmissaoBoletoService = validaEmissaoBoletoService;
        this.situacaoParcelaRepository = situacaoParcelaRepository;
    }
}

