/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.DebitoAutomaticoRemessa;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemACaixa;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemAFebraban;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemECaixa;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemEFebraban;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemZCaixa;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemZFebraban;
import br.com.elotech.tributos.dto.debitoautomatico.RemessaDebitoAutomaticoArquivoItemDTO;
import br.com.elotech.tributos.dto.debitoautomatico.RemessaDebitoAutomaticoFilterDTO;
import br.com.elotech.tributos.exception.DebitoAutomaticoException;
import br.com.elotech.tributos.repository.BancoRepository;
import br.com.elotech.tributos.repository.ConvenioRepository;
import br.com.elotech.tributos.repository.DebitoAutomaticoRemessaRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.batch.debitoautomatico.ImportacaoArquivoDebitoAutomaticoJobStarter;
import br.com.elotech.tributos.service.batch.debitoautomatico.RemessaArquivoDebitoAutomaticoJobStarter;
import br.com.elotech.tributos.util.FieldItem;
import br.com.elotech.tributos.util.FieldUtils;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.domain.TipoArquivoEnum;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DebitoAutomaticoRemessaService
extends CrudService<DebitoAutomaticoRemessa, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DebitoAutomaticoRemessaService.class);
    private static final Long CODIGO_REMESSA = 1L;
    private static final String MOEDA_REAL = "03";
    private static final Long CODIGO_MOVIMENTO = 0L;
    private final ArquivoStorageFeignClient arquivoStorageFeignClient;
    private final DebitoAutomaticoRemessaRepository debitoAutomaticoRemessaRepository;
    private final ImportacaoArquivoDebitoAutomaticoJobStarter importacaoArquivoDebitoAutomaticoJobStarter;
    private final RemessaArquivoDebitoAutomaticoJobStarter remessaArquivoDebitoAutomaticoJobStarter;
    private final BancoRepository bancoRepository;
    private final ConvenioRepository convenioRepository;
    private final ParametroGeralService parametroGeralService;
    private final ContextService contextService;

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void importarArquivos(List<MultipartFile> arquivos) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        for (MultipartFile arquivo : arquivos) {
            ArquivoDTO retornoS3 = this.salvarArquivoNoS3(arquivo);
            Long idArquivo = retornoS3.getId();
            String nomeArquivo = retornoS3.getNome();
            this.importacaoArquivoDebitoAutomaticoJobStarter.startJob(idArquivo, nomeArquivo);
        }
    }

    public ArquivoDTO salvarArquivoNoS3(MultipartFile arquivo) {
        ArquivoDTO arquivoDTO = new ArquivoDTO(null, arquivo.getOriginalFilename(), SecurityUtils.getUserId(), TipoArquivoEnum.OUTROS, Modulo.OXY_TRIBUTOS, "/importacao-debito-automatico", LocalDate.now(), "text/plain", null, null, null);
        return this.arquivoStorageFeignClient.createWithFile(arquivoDTO, arquivo);
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void gerarRemessa(RemessaDebitoAutomaticoFilterDTO filtro) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JsonProcessingException, JobRestartException {
        Convenio convenio;
        Long totalItens = this.debitoAutomaticoRemessaRepository.totalItensParaGerar(filtro);
        if (totalItens.compareTo(0L) == 0) {
            throw new DebitoAutomaticoException("N\u00e3o h\u00e1 itens para gerar com o filtro informado");
        }
        convenio.setSequenciaArquivoEnvio(Long.valueOf(Objects.isNull((convenio = this.convenioRepository.findByConvenio(filtro.getConvenio())).getSequenciaArquivoEnvio()) ? 0L : convenio.getSequenciaArquivoEnvio() + 1L));
        convenio = (Convenio)this.convenioRepository.saveAndFlush((Object)convenio);
        DebitoAutomaticoRemessa remessa = new DebitoAutomaticoRemessa();
        remessa.setEntidade(this.contextService.getEntidadePrincipal());
        remessa.setDataEmissao(LocalDate.now());
        remessa.setExercicio(Long.valueOf(remessa.getDataEmissao().getYear()));
        remessa.setConvenio(convenio);
        remessa.setNumeroSequencialArquivo(convenio.getSequenciaArquivoEnvio());
        remessa = (DebitoAutomaticoRemessa)this.debitoAutomaticoRemessaRepository.save((Object)remessa);
        this.debitoAutomaticoRemessaRepository.flush();
        this.remessaArquivoDebitoAutomaticoJobStarter.startJob(remessa.getId(), filtro);
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void regerarRemessa(Long idRemessa) {
        try {
            RemessaDebitoAutomaticoFilterDTO filtro = new RemessaDebitoAutomaticoFilterDTO();
            filtro.setIdRemessa(idRemessa);
            Long totalItens = this.debitoAutomaticoRemessaRepository.totalItensParaGerar(filtro);
            if (totalItens.compareTo(0L) == 0) {
                throw new DebitoAutomaticoException("N\u00e3o h\u00e1 itens para gerar com o filtro informado");
            }
            this.remessaArquivoDebitoAutomaticoJobStarter.startJob(idRemessa, filtro);
        }
        catch (Exception e) {
            throw new DebitoAutomaticoException(String.format("Erro ao regerar remessa - %s", e.getMessage()), (Throwable)e);
        }
    }

    public byte[] gerarArquivo(Long idRemessa) throws IOException {
        String nomeEntidade = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.NOME_ENTIDADE_DEBITO_AUTOMATICO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        ArrayList<Object> itensDoArquivo = new ArrayList<Object>();
        List itensDaRemessa = this.debitoAutomaticoRemessaRepository.findItensArquivoRemessa(idRemessa);
        RemessaDebitoAutomaticoArquivoItemDTO primeiroItem = (RemessaDebitoAutomaticoArquivoItemDTO)itensDaRemessa.getFirst();
        if (Objects.isNull(primeiroItem.getNumeroSequencialArquivo())) {
            throw new DebitoAutomaticoException("A remessa informada n\u00e3o possui n\u00famero sequencial do arquivo.");
        }
        Banco banco = (Banco)this.bancoRepository.findOne((Object)primeiroItem.getBanco());
        Convenio convenio = this.convenioRepository.findByConvenio(primeiroItem.getConvenio());
        ADAItemACaixa adaItemA = banco.isCaixaEconomica() != false ? new ADAItemACaixa() : new ADAItemAFebraban();
        adaItemA.setCodigoRemessa(CODIGO_REMESSA);
        adaItemA.setCodigoConvenio(convenio.getNumeroConvenio());
        adaItemA.setNomeEmpresa(nomeEntidade);
        adaItemA.setCodigoBanco(banco.getId());
        adaItemA.setNomeBanco(banco.getDescricao());
        adaItemA.setDataGeracao(LocalDate.now());
        adaItemA.setNsa(primeiroItem.getNumeroSequencialArquivo());
        adaItemA.setVersaoLayout(Long.valueOf(4L));
        adaItemA.setIdentificacaoServico("DEBITO AUTOMATICO");
        if (!banco.isCaixaEconomica().booleanValue()) {
            assert (adaItemA instanceof ADAItemAFebraban);
            ((ADAItemAFebraban)adaItemA).setReservado("");
        }
        itensDoArquivo.add(adaItemA);
        Integer sequencia = 1;
        BigDecimal valorTotal = BigDecimal.ZERO;
        for (RemessaDebitoAutomaticoArquivoItemDTO item : itensDaRemessa) {
            ADAItemECaixa adaItemE = banco.isCaixaEconomica() != false ? new ADAItemECaixa() : new ADAItemEFebraban();
            adaItemE.setIdentificacaoClienteEmpresa(item.getClienteEmpresa());
            adaItemE.setAgenciaDebito(item.getAgencia());
            adaItemE.setIdentificacaoClienteBanco(item.getIdentificacao());
            adaItemE.setDataVencimento(item.getDataVencimento());
            adaItemE.setValorDebito(item.getValor());
            adaItemE.setCodigoMoeda(MOEDA_REAL);
            if (banco.isCaixaEconomica().booleanValue()) {
                assert (adaItemE instanceof ADAItemECaixa);
                ADAItemECaixa adaItemECaixa = adaItemE;
                adaItemECaixa.setUsuEmpresa(item.getUsoDaEmpresa());
                adaItemECaixa.setNumeroAgendamento(Long.valueOf(sequencia.intValue()));
                adaItemECaixa.setReservado("");
                adaItemECaixa.setSequencialRegistro(Long.valueOf(sequencia.intValue()));
            } else {
                assert (adaItemE instanceof ADAItemEFebraban);
                ADAItemEFebraban adaItemEFebraban = (ADAItemEFebraban)adaItemE;
                adaItemEFebraban.setUsuEmpresa(item.getUsoDaEmpresa());
                adaItemEFebraban.setTipoIdentificacao("");
                adaItemEFebraban.setIdentificacao("");
                adaItemEFebraban.setReservado("");
            }
            adaItemE.setCodigoMovimento(CODIGO_MOVIMENTO);
            itensDoArquivo.add(adaItemE);
            valorTotal = valorTotal.add(item.getValor());
            Integer n = sequencia;
            sequencia = sequencia + 1;
        }
        ADAItemZCaixa adaItemZ = banco.isCaixaEconomica() != false ? new ADAItemZCaixa() : new ADAItemZFebraban();
        adaItemZ.setTotalRegistros(Long.valueOf((long)itensDaRemessa.size() + 2L));
        adaItemZ.setValorTotal(valorTotal);
        if (banco.isCaixaEconomica().booleanValue()) {
            assert (adaItemZ instanceof ADAItemZCaixa);
            ADAItemZCaixa adaItemZCaixa = adaItemZ;
            adaItemZCaixa.setReservado1("");
            adaItemZCaixa.setSequencialRegistro(Long.valueOf((long)itensDaRemessa.size() + 1L));
            adaItemZCaixa.setReservado2("");
        } else {
            assert (adaItemZ instanceof ADAItemZFebraban);
            ADAItemZFebraban adaItemEFebraban = (ADAItemZFebraban)adaItemZ;
            adaItemEFebraban.setReservado("");
        }
        itensDoArquivo.add(adaItemZ);
        File tempFile = File.createTempFile("temp", ".rem");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));){
            for (FieldItem fieldItem : itensDoArquivo) {
                writer.write(FieldUtils.getString((Object)fieldItem));
                writer.newLine();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return Files.readAllBytes(tempFile.toPath());
    }

    @Generated
    public DebitoAutomaticoRemessaService(ArquivoStorageFeignClient arquivoStorageFeignClient, DebitoAutomaticoRemessaRepository debitoAutomaticoRemessaRepository, ImportacaoArquivoDebitoAutomaticoJobStarter importacaoArquivoDebitoAutomaticoJobStarter, RemessaArquivoDebitoAutomaticoJobStarter remessaArquivoDebitoAutomaticoJobStarter, BancoRepository bancoRepository, ConvenioRepository convenioRepository, ParametroGeralService parametroGeralService, ContextService contextService) {
        this.arquivoStorageFeignClient = arquivoStorageFeignClient;
        this.debitoAutomaticoRemessaRepository = debitoAutomaticoRemessaRepository;
        this.importacaoArquivoDebitoAutomaticoJobStarter = importacaoArquivoDebitoAutomaticoJobStarter;
        this.remessaArquivoDebitoAutomaticoJobStarter = remessaArquivoDebitoAutomaticoJobStarter;
        this.bancoRepository = bancoRepository;
        this.convenioRepository = convenioRepository;
        this.parametroGeralService = parametroGeralService;
        this.contextService = contextService;
    }
}

