/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.DebitoAutomaticoArquivoConfirmacao;
import br.com.elotech.tributos.domain.DebitoAutomaticoInconsistencia;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemA;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemACaixa;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemAFebraban;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemC;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemZ;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemZCaixa;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemZFebraban;
import br.com.elotech.tributos.repository.ConvenioRepository;
import br.com.elotech.tributos.repository.DebitoAutomaticoArquivoConfirmacaoRepository;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.util.FieldUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DebitoAutomaticoRemessaInconsistenciaService
extends CrudService<DebitoAutomaticoInconsistencia, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DebitoAutomaticoRemessaInconsistenciaService.class);
    private static final Long RETORNO = 1L;
    private static final Long VERSAO_LAYOUT = 4L;
    private static final String IDENTIFICACAO_SERVICO = "DEBITO AUTOM\u00c1TICO";
    private static final String QUEBRA_LINHA = System.lineSeparator();
    private final ParametroGeralService parametroGeralService;
    private final DebitoAutomaticoArquivoConfirmacaoRepository debitoAutomaticoArquivoConfirmacaoRepository;
    private final ConvenioRepository convenioRepository;

    public String gerarRemessaInconsistencia(Long idArquivo) throws EloValidationException {
        DebitoAutomaticoArquivoConfirmacao arquivo = (DebitoAutomaticoArquivoConfirmacao)this.debitoAutomaticoArquivoConfirmacaoRepository.findById(idArquivo).orElseThrow(() -> new EloValidationException("Arquivo n\u00e3o encontrado " + idArquivo));
        List inconsistencias = arquivo.getInconsistencias();
        if (inconsistencias.isEmpty()) {
            throw new EloValidationException("Nenhuma inconsist\u00eancia encontrada para o arquivo " + idArquivo);
        }
        ADAItemA header = this.buildHeader((DebitoAutomaticoInconsistencia)inconsistencias.getFirst());
        List detalhes = this.buildDetalhes(inconsistencias);
        ADAItemZ trailer = this.buildTrailer(header.getCodigoBanco(), Long.valueOf((long)detalhes.size() + 2L), BigDecimal.ZERO);
        return String.join((CharSequence)QUEBRA_LINHA, FieldUtils.getString((Object)header), this.processarListaDetalhe(detalhes), FieldUtils.getString((Object)trailer)).concat(QUEBRA_LINHA);
    }

    public ADAItemA buildHeader(DebitoAutomaticoInconsistencia debitoAutomaticoInconsistencia) {
        String nomeEntidade = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.NOME_ENTIDADE_DEBITO_AUTOMATICO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        Convenio convenio = this.getConvenio(debitoAutomaticoInconsistencia);
        Long nsa = this.getNsaArquivo(debitoAutomaticoInconsistencia.getArquivoConfirmacao(), convenio);
        ADAItemACaixa itemA = convenio.getBanco().isCaixaEconomica() != false ? new ADAItemACaixa() : new ADAItemAFebraban();
        itemA.setCodigoRemessa(RETORNO);
        itemA.setCodigoConvenio(debitoAutomaticoInconsistencia.getArquivoConfirmacao().getCodigoConvenio());
        itemA.setNomeEmpresa(nomeEntidade);
        itemA.setCodigoBanco(debitoAutomaticoInconsistencia.getBanco());
        itemA.setNomeBanco(debitoAutomaticoInconsistencia.getArquivoConfirmacao().getNomeBanco());
        itemA.setDataGeracao(LocalDate.now());
        itemA.setNsa(nsa);
        itemA.setVersaoLayout(VERSAO_LAYOUT);
        itemA.setIdentificacaoServico(IDENTIFICACAO_SERVICO);
        if (!convenio.getBanco().isCaixaEconomica().booleanValue()) {
            assert (itemA instanceof ADAItemAFebraban);
            ((ADAItemAFebraban)itemA).setReservado("");
        }
        return itemA;
    }

    private Long getNsaArquivo(DebitoAutomaticoArquivoConfirmacao debitoAutomaticoArquivoConfirmacao, Convenio convenio) {
        if (Objects.isNull(debitoAutomaticoArquivoConfirmacao.getSequenciaArquivo()) || debitoAutomaticoArquivoConfirmacao.getSequenciaArquivo().equals(0L)) {
            convenio.setSequenciaArquivoEnvio(Long.valueOf(Objects.isNull(convenio.getSequenciaArquivoEnvio()) ? 0L : convenio.getSequenciaArquivoEnvio() + 1L));
            convenio = (Convenio)this.convenioRepository.saveAndFlush((Object)convenio);
            this.gravarSequenciaArquivo(debitoAutomaticoArquivoConfirmacao, convenio.getSequenciaArquivoEnvio());
            return convenio.getSequenciaArquivoEnvio();
        }
        return debitoAutomaticoArquivoConfirmacao.getSequenciaArquivo();
    }

    public void gravarSequenciaArquivo(DebitoAutomaticoArquivoConfirmacao debitoAutomaticoArquivoConfirmacao, Long sequenciaArquivo) {
        debitoAutomaticoArquivoConfirmacao.setSequenciaArquivo(sequenciaArquivo);
        this.debitoAutomaticoArquivoConfirmacaoRepository.saveAndFlush((Object)debitoAutomaticoArquivoConfirmacao);
    }

    public Convenio getConvenio(DebitoAutomaticoInconsistencia debitoAutomaticoInconsistencia) {
        Convenio convenio = this.convenioRepository.findByEntidadeAndNumeroConvenioAndBancoId(Long.valueOf(1L), debitoAutomaticoInconsistencia.getArquivoConfirmacao().getCodigoConvenio(), debitoAutomaticoInconsistencia.getBanco());
        if (Objects.isNull(convenio)) {
            throw new EloValidationException(String.format("Conv\u00eanio %s n\u00e3o encontrado no banco %d", debitoAutomaticoInconsistencia.getArquivoConfirmacao().getCodigoConvenio(), debitoAutomaticoInconsistencia.getBanco()));
        }
        return convenio;
    }

    public ADAItemZ buildTrailer(Long banco, Long totalRegistros, BigDecimal valorTotal) {
        ADAItemZCaixa itemZ = Banco.CODIGO_CAIXA_ECONOMICA.equals(banco) ? new ADAItemZCaixa() : new ADAItemZFebraban();
        itemZ.setTotalRegistros(totalRegistros);
        itemZ.setValorTotal(valorTotal);
        if (Banco.CODIGO_CAIXA_ECONOMICA.equals(banco)) {
            assert (itemZ instanceof ADAItemZCaixa);
            ADAItemZCaixa adaItemZCaixa = itemZ;
            adaItemZCaixa.setReservado1("");
            adaItemZCaixa.setSequencialRegistro(Long.valueOf(totalRegistros - 1L));
            adaItemZCaixa.setReservado2("");
        } else {
            assert (itemZ instanceof ADAItemZFebraban);
            ADAItemZFebraban adaItemEFebraban = (ADAItemZFebraban)itemZ;
            adaItemEFebraban.setReservado("");
        }
        return itemZ;
    }

    public ADAItemC buildDetalhe(DebitoAutomaticoInconsistencia debitoAutomaticoInconsistencia) {
        ADAItemC itemC = new ADAItemC();
        itemC.setIdentificacaoClienteEmpresa(debitoAutomaticoInconsistencia.getIdentificacaoEmpresa());
        itemC.setAgenciaDebito(debitoAutomaticoInconsistencia.getAgencia());
        itemC.setIdentificacaoClienteBanco(debitoAutomaticoInconsistencia.getIdentificacaoBanco());
        itemC.setOcorrencia1(debitoAutomaticoInconsistencia.getInconsistencia().getDescricao());
        itemC.setOcorrencia2(debitoAutomaticoInconsistencia.getInconsistencia().getDescricao());
        itemC.setCodigoMovimento(debitoAutomaticoInconsistencia.getCodigoMovimentacao());
        itemC.setReservado("");
        return itemC;
    }

    private List<ADAItemC> buildDetalhes(List<DebitoAutomaticoInconsistencia> inconsistencias) {
        return inconsistencias.stream().map(arg_0 -> this.buildDetalhe(arg_0)).collect(Collectors.toList());
    }

    private String processarListaDetalhe(List<ADAItemC> list) {
        return list.stream().map(FieldUtils::getString).collect(Collectors.joining(QUEBRA_LINHA));
    }

    @Generated
    public DebitoAutomaticoRemessaInconsistenciaService(ParametroGeralService parametroGeralService, DebitoAutomaticoArquivoConfirmacaoRepository debitoAutomaticoArquivoConfirmacaoRepository, ConvenioRepository convenioRepository) {
        this.parametroGeralService = parametroGeralService;
        this.debitoAutomaticoArquivoConfirmacaoRepository = debitoAutomaticoArquivoConfirmacaoRepository;
        this.convenioRepository = convenioRepository;
    }
}

