/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.tributos.domain.ParametroGeral;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.service.ParametroGeralService;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class DataVencimentoBloquetoService {
    private static final String CALCULA_DATA_VENCIMENTO_DIAS = "I";
    private final ParametroGeralService parametroGeralService;

    public DataVencimentoBloquetoService(ParametroGeralService parametroGeralService) {
        this.parametroGeralService = parametroGeralService;
    }

    public LocalDate getDataVecimentoBloquetoEmAtraso(List<LocalDate> listDataVencimento, LocalDate dataReferencia) {
        ParametroGeral parametroDataVencimentoBloqueto = this.parametroGeralService.findByParametroAndModulo(ParametroGeralEnum.DATA_VENCIMENTO_BLOQUETO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        if (this.calculaDataVencimentoBloquetoPorQuantidadeDias(parametroDataVencimentoBloqueto).booleanValue() && this.existeParcelaVencida(listDataVencimento, dataReferencia).booleanValue()) {
            return dataReferencia.with(TemporalAdjusters.lastDayOfMonth());
        }
        return null;
    }

    private Boolean calculaDataVencimentoBloquetoPorQuantidadeDias(ParametroGeral parametroDataVencimentoBloqueto) {
        return parametroDataVencimentoBloqueto != null && parametroDataVencimentoBloqueto.getValor().equals(CALCULA_DATA_VENCIMENTO_DIAS);
    }

    private Boolean existeParcelaVencida(List<LocalDate> listDataVencimento, LocalDate dataReferencia) {
        for (LocalDate data : listDataVencimento) {
            if (data.compareTo(dataReferencia) >= 0) continue;
            return true;
        }
        return false;
    }
}

