/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Ato;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Contencioso;
import br.com.elotech.tributos.domain.ContenciosoAto;
import br.com.elotech.tributos.domain.ContenciosoAtoId;
import br.com.elotech.tributos.domain.ContenciosoDebito;
import br.com.elotech.tributos.domain.ContenciosoDebitoID;
import br.com.elotech.tributos.domain.ContenciosoDebitoParcela;
import br.com.elotech.tributos.domain.ContenciosoDebitoParcelaId;
import br.com.elotech.tributos.domain.ContenciosoSituacaoContenciosoEnum;
import br.com.elotech.tributos.domain.ContenciosoSituacaoEnum;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.SituacaoContenciosoDebito;
import br.com.elotech.tributos.domain.SituacaoParcela;
import br.com.elotech.tributos.domain.TipoEventoSituacaoParcelaEnum;
import br.com.elotech.tributos.domain.TipoSituacaoParcela;
import br.com.elotech.tributos.dto.contencioso.ContenciosoDebitosExararDTO;
import br.com.elotech.tributos.dto.contencioso.ContenciosoDebitosResponseDTO;
import br.com.elotech.tributos.repository.ContenciosoRepository;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.SituacaoParcelaService;
import br.com.elotech.tributos.service.autoinfracao.AutoInfracaoService;
import br.com.elotech.tributos.service.contencioso.AcaoExararCancelarDebito;
import br.com.elotech.tributos.service.contencioso.AcaoExararFactory;
import br.com.elotech.tributos.service.contencioso.AcaoExararManterDebito;
import br.com.elotech.tributos.service.contencioso.ContenciosoHistoricoService;
import br.com.elotech.tributos.service.memoria.MemoriaCadastroService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openl.util.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ContenciosoService
extends CrudService<Contencioso, Long> {
    private ContenciosoRepository contenciosoRepository;
    private SituacaoParcelaService situacaoParcelaService;
    private DebitoParcelaService debitoParcelaService;
    private DebitoService debitoService;
    private CadastroGeralService cadastroGeralService;
    private MemoriaCadastroService memoriaCadastroService;
    private AcaoExararFactory acaoExararFactory;
    private ContenciosoHistoricoService contenciosoHistoricoService;
    private AutoInfracaoService autoInfracaoService;

    public Contencioso exarar(ContenciosoDebitosExararDTO dto, Long id) {
        this.validarSeExisteParecerista(dto);
        AcaoExararCancelarDebito acaoExarar = this.acaoExararFactory.getExararCancelarDebito(dto.getParecer());
        Contencioso contencioso = Optional.ofNullable((Contencioso)this.findOne((Serializable)id)).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o contencioso com o id %d", id)));
        contencioso.setParecerista(dto.getParecerista());
        Contencioso contenciosoSaved = acaoExarar.exararCancelarDebito(dto, contencioso);
        this.contenciosoHistoricoService.createAndSaveHistorico(contenciosoSaved, dto.getParecer(), dto.getMotivoDeducao());
        this.autoInfracaoService.atualizarAutoAposExararContencioso(contenciosoSaved, dto.getParecer(), Boolean.TRUE);
        return contenciosoSaved;
    }

    public Contencioso exararManterDebitos(ContenciosoDebitosExararDTO dto, Long id) {
        this.validarSeExisteParecerista(dto);
        AcaoExararManterDebito acaoExarar = this.acaoExararFactory.getExararManterDebito(dto.getParecer());
        Contencioso contencioso = Optional.ofNullable((Contencioso)this.findOne((Serializable)id)).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o contencioso com o id %d", id)));
        contencioso.setParecerista(dto.getParecerista());
        Contencioso contenciosoSaved = acaoExarar.exararManterDebito(dto, contencioso);
        this.contenciosoHistoricoService.createAndSaveHistorico(contenciosoSaved, dto.getParecer(), dto.getMotivoDeducao());
        this.autoInfracaoService.atualizarAutoAposExararContencioso(contenciosoSaved, dto.getParecer(), Boolean.FALSE);
        return contenciosoSaved;
    }

    private void validarSeExisteParecerista(ContenciosoDebitosExararDTO dto) {
        if (Objects.isNull(dto.getParecerista())) {
            throw new EloValidationException("O parecerista n\u00e3o foi informado.");
        }
    }

    public Contencioso create(ContenciosoDebitosResponseDTO dto) {
        Contencioso contenciosoSaved = (Contencioso)this.contenciosoRepository.save((Object)this.createContencioso(dto));
        this.memoriaCadastroService.generateAndAssociarMemoriaCadastro(contenciosoSaved, Boolean.FALSE);
        this.contenciosoHistoricoService.createAndSaveHistorico(contenciosoSaved, dto.getParecer(), dto.getMotivoDeducao());
        return contenciosoSaved;
    }

    private Contencioso createContencioso(ContenciosoDebitosResponseDTO dto) {
        Optional cadastroGeral;
        Contencioso contencioso;
        Contencioso contencioso2 = contencioso = Objects.isNull(dto.getId()) ? new Contencioso() : (Contencioso)this.findOne((Serializable)dto.getId());
        if (dto.getDebitos().isEmpty()) {
            throw new EloValidationException("Contencioso deve possuir pelo menos um d\u00e9bito");
        }
        if (this.validateCadastrosIguais(this.getListCadastrosDebitos(dto)) && (cadastroGeral = this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(((ContenciosoDebito)dto.getDebitos().get(0)).getId().getTipoCadastro(), ((ContenciosoDebito)dto.getDebitos().get(0)).getId().getCadastroGeral())).isPresent()) {
            dto.setCadastroGeral((CadastroGeral)cadastroGeral.get());
        }
        Contencioso.from((ContenciosoDebitosResponseDTO)dto, (Contencioso)contencioso);
        Contencioso entidadeSalva = (Contencioso)this.contenciosoRepository.save((Object)contencioso);
        this.updateIdContenciosoDebitos(dto, contencioso, entidadeSalva);
        this.updateSituacaoAntigaDebito(dto, contencioso);
        this.updateSituacaoparcela(contencioso);
        this.updateFundamentoLegal(dto, contencioso);
        return contencioso;
    }

    private void updateFundamentoLegal(ContenciosoDebitosResponseDTO dto, Contencioso contencioso) {
        HashMap<Long, ContenciosoAto> atosNaoDuplicados = new HashMap<Long, ContenciosoAto>();
        for (Ato ato : dto.getContenciosoAtos()) {
            if (atosNaoDuplicados.containsKey(ato.getId())) continue;
            ContenciosoAto novoContenciosoAto = this.createNewContenciosoAto(contencioso, ato);
            atosNaoDuplicados.put(ato.getId(), novoContenciosoAto);
        }
        contencioso.setContenciosoAtos((List)Lists.newArrayList(atosNaoDuplicados.values()));
    }

    private ContenciosoAto createNewContenciosoAto(Contencioso contencioso, Ato novoAto) {
        ContenciosoAto novoContenciosoAto = new ContenciosoAto();
        ContenciosoAtoId novoId = new ContenciosoAtoId();
        novoId.setIdContencioso(contencioso.getId());
        novoId.setEntidade(novoAto.getEntidade().getId());
        novoId.setFundamentoLegal(novoAto.getIdAto());
        novoContenciosoAto.setId(novoId);
        novoContenciosoAto.setContencioso(contencioso);
        novoContenciosoAto.setFundamentoLegal(novoAto);
        return novoContenciosoAto;
    }

    private void updateSituacaoAntigaDebito(ContenciosoDebitosResponseDTO dto, Contencioso contencioso) {
        Iterator contenciosoDebitoIterator = contencioso.getDebitos().iterator();
        while (contenciosoDebitoIterator.hasNext()) {
            ContenciosoDebito contenciosoDebito = (ContenciosoDebito)contenciosoDebitoIterator.next();
            if (dto.getDebitos().contains(contenciosoDebito)) continue;
            contenciosoDebito.getParcelas().forEach(arg_0 -> this.updateSituacaoparcelaAntiga(arg_0));
            contenciosoDebitoIterator.remove();
        }
    }

    private Contencioso abrirSegundaInstancia(ContenciosoDebitosResponseDTO dto) {
        Contencioso contencioso = (Contencioso)this.findOne((Serializable)dto.getId());
        if (!contencioso.getSituacao().getValue().equals(ContenciosoSituacaoEnum.ENCERRADO.getValue())) {
            throw new EloValidationException("O contencioso precisa estar encerrado para abrir uma nova inst\u00e2ncia");
        }
        Contencioso.from((ContenciosoDebitosResponseDTO)dto, (Contencioso)contencioso);
        this.changeDebitoAndParcelasSeElegiveis(contencioso);
        Contencioso salvo = (Contencioso)this.contenciosoRepository.save((Object)contencioso);
        this.memoriaCadastroService.generateAndAssociarMemoriaCadastro(salvo, Boolean.FALSE);
        this.contenciosoHistoricoService.createAndSaveHistorico(salvo, dto.getParecer(), dto.getMotivoDeducao());
        return salvo;
    }

    private void changeDebitoAndParcelasSeElegiveis(Contencioso contencioso) {
        boolean temDebitoElegivel = this.processarDebitos(contencioso);
        if (!temDebitoElegivel) {
            throw new EloValidationException("Nenhum d\u00e9bito \u00e9 eleg\u00edvel para Segunda Inst\u00e2ncia!");
        }
    }

    private boolean processarDebitos(Contencioso contencioso) {
        AtomicBoolean temDebitoElegivel = new AtomicBoolean(false);
        contencioso.getDebitos().forEach(debito -> {
            List parcelasElegiveis = this.getParcelasElegiveis(debito);
            if (!parcelasElegiveis.isEmpty()) {
                debito.setSituacao(SituacaoContenciosoDebito.AGUARDANDOPARECER);
                parcelasElegiveis.forEach(parcela -> this.updateParcelasElegiveis(parcela, contencioso));
                this.vincularContenciosoComAuto(contencioso, debito);
                temDebitoElegivel.set(true);
            }
        });
        return temDebitoElegivel.get();
    }

    private void updateParcelasElegiveis(ContenciosoDebitoParcela parcela, Contencioso contencioso) {
        SituacaoParcela novaSituacao = this.generateSituacaoParcelaRA(parcela);
        parcela.setSituacaoAtual(novaSituacao);
        this.updateDebitoParcela(parcela, contencioso);
    }

    private List<ContenciosoDebitoParcela> getParcelasElegiveis(ContenciosoDebito debito) {
        return debito.getParcelas().stream().filter(arg_0 -> this.isParcelaAbertaParaContencioso(arg_0)).toList();
    }

    private void updateDebitoParcela(ContenciosoDebitoParcela parcela, Contencioso contencioso) {
        DebitoParcela debitoParcela = this.buscarDebitoParcela(parcela);
        SituacaoParcela novaSituacao = this.generateSituacaoParcela(contencioso, parcela);
        parcela.setSituacaoFimPrimeiraInstancia(debitoParcela.getSituacaoDebito());
        debitoParcela.setSituacaoDebito(novaSituacao);
        debitoParcela.setDataSituacao(LocalDate.now());
        this.debitoParcelaService.save((EloEntity)debitoParcela, null);
    }

    private Contencioso updateIdContenciosoDebitos(ContenciosoDebitosResponseDTO dto, Contencioso contencioso, Contencioso entidadeSalva) {
        dto.getDebitos().forEach(e -> {
            if (!contencioso.getDebitos().contains(e)) {
                e.getParcelas().forEach(contenciosoDebitoParcela -> {
                    contenciosoDebitoParcela.getId().setId(entidadeSalva.getId());
                    if (contenciosoDebitoParcela.getSituacaoDebito().getTipoSituacaoParcela().equals((Object)TipoSituacaoParcela.ABERTO)) {
                        SituacaoParcela novaSituacao = this.generateSituacaoParcelaRA(contenciosoDebitoParcela);
                        contenciosoDebitoParcela.setSituacaoAtual(novaSituacao);
                    } else {
                        contenciosoDebitoParcela.setSituacaoAtual(contenciosoDebitoParcela.getSituacaoDebito());
                    }
                });
                e.getId().setIdContencioso(entidadeSalva.getId());
                this.vinculandoConteciosoComDebito(contencioso, e);
                this.vincularContenciosoComAuto(contencioso, e);
            }
        });
        return contencioso;
    }

    private void vincularContenciosoComAuto(Contencioso contencioso, ContenciosoDebito debito) {
        Optional autoInfracao = this.autoInfracaoService.findByDebito(debito.getIdDebito());
        autoInfracao.ifPresent(auto -> {
            debito.setIdAutoInfracaoFiscal(auto.getId());
            this.autoInfracaoService.vincularContencioso(auto.getId(), contencioso);
        });
    }

    private void vinculandoConteciosoComDebito(Contencioso contencioso, ContenciosoDebito debito) {
        contencioso.getDebitos().add(debito);
        this.debitoService.findByCompositeKey(debito.getId().getEntidade(), debito.getId().getExercicio(), debito.getId().getTipoCadastro().getValue(), debito.getId().getCadastroGeral(), debito.getId().getDivida(), debito.getId().getSubDivida()).ifPresent(arg_0 -> ((ContenciosoDebito)debito).setDebito(arg_0));
        debito.getDebito().setContencioso(contencioso);
    }

    private SituacaoParcela generateSituacaoParcelaRA(ContenciosoDebitoParcela contenciosoDebitoParcela) {
        return this.situacaoParcelaService.getNovaSituacaoParcela(TipoEventoSituacaoParcelaEnum.RECURSO_ADMINISTRATIVO, contenciosoDebitoParcela.getSituacaoDebito());
    }

    private SituacaoParcela generateSituacaoParcela(Contencioso contencioso, ContenciosoDebitoParcela debitoParcela) {
        if (contencioso.getSituacaoContencioso().equals((Object)ContenciosoSituacaoContenciosoEnum.SUB_JUDICE)) {
            return this.situacaoParcelaService.getNovaSituacaoParcela(TipoEventoSituacaoParcelaEnum.SUBJUDICE, debitoParcela.getSituacaoDebito());
        }
        return this.situacaoParcelaService.getNovaSituacaoParcela(TipoEventoSituacaoParcelaEnum.RECURSO_ADMINISTRATIVO, debitoParcela.getSituacaoDebito());
    }

    private SituacaoParcela generateSituacaoAntiga(ContenciosoDebitoParcela contenciosoDebitoParcela) {
        TipoEventoSituacaoParcelaEnum situacao = TipoEventoSituacaoParcelaEnum.fromValue((Long)contenciosoDebitoParcela.getSituacaoDebito().getId());
        return this.situacaoParcelaService.getNovaSituacaoParcela(situacao, contenciosoDebitoParcela.getSituacaoAtual());
    }

    private boolean validateCadastrosIguais(List<Long> list) {
        return list.stream().allMatch(list.get(0)::equals);
    }

    private void updateSituacaoparcela(Contencioso contencioso) {
        contencioso.getDebitos().forEach(debito -> debito.getParcelas().forEach(parcela -> {
            Optional debitoParcela = this.debitoParcelaService.findByDebitoParcela(debito.getId().getEntidade(), debito.getId().getExercicio(), debito.getId().getTipoCadastro().getValue(), debito.getId().getCadastroGeral(), debito.getId().getDivida(), debito.getId().getSubDivida(), parcela.getId().getParcela());
            debitoParcela.ifPresent(e -> {
                if (e.getSituacaoDebito().getTipoSituacaoParcela() == TipoSituacaoParcela.ABERTO) {
                    SituacaoParcela novaSituacao = this.generateSituacaoParcela(contencioso, parcela);
                    e.setSituacaoDebito(novaSituacao);
                    e.setDataSituacao(LocalDate.now());
                    this.debitoParcelaService.save((EloEntity)e, null);
                }
            });
        }));
    }

    private void updateSituacaoparcelaAntiga(ContenciosoDebitoParcela parcela) {
        Optional debitoParcela = this.debitoParcelaService.findByDebitoParcela(parcela.getId().getEntidade(), parcela.getId().getExercicio(), parcela.getId().getTipoCadastro().getValue(), parcela.getId().getCadastroGeral(), parcela.getId().getDivida(), parcela.getId().getSubDivida(), parcela.getId().getParcela());
        debitoParcela.ifPresent(e -> {
            if (parcela.getSituacaoAtual().getTipoSituacaoParcela() == TipoSituacaoParcela.RECURSO_ADMINISTRATIVO) {
                SituacaoParcela novaSituacao = this.generateSituacaoAntiga(parcela);
                e.setSituacaoDebito(novaSituacao);
                e.setDataSituacao(LocalDate.now());
                this.debitoParcelaService.save((EloEntity)((DebitoParcela)debitoParcela.get()), null);
            }
        });
    }

    private List<Long> getListCadastrosDebitos(ContenciosoDebitosResponseDTO contencioso) {
        List<Long> cadastroGeralList = contencioso.getDebitos().stream().map(ContenciosoDebito::getId).map(ContenciosoDebitoID::getCadastroGeral).collect(Collectors.toList());
        return cadastroGeralList;
    }

    public void generateCadastroMemoriaByIdContencioso(Long id) {
        Contencioso contencioso = (Contencioso)this.contenciosoRepository.findOne((Object)id);
        Contencioso contenciosoWithMemoria = this.memoriaCadastroService.generateAndAssociarMemoriaCadastro(contencioso, Boolean.TRUE);
        this.contenciosoRepository.save((Object)contenciosoWithMemoria);
    }

    public Contencioso editContencioso(ContenciosoDebitosResponseDTO contenciosoDebitosResponseDTO) {
        if (!StringUtils.isBlank((CharSequence)contenciosoDebitosResponseDTO.getSituacao()) && contenciosoDebitosResponseDTO.getSituacao().equals(ContenciosoSituacaoEnum.ENCERRADO.getValue())) {
            throw new EloValidationException("Contencioso Encerrado n\u00e3o pode ser editado");
        }
        return this.create(contenciosoDebitosResponseDTO);
    }

    public Contencioso reabrir(ContenciosoDebitosResponseDTO contenciosoDebitosResponseDTO) {
        return this.abrirSegundaInstancia(ContenciosoDebitosResponseDTO.atualizarParaSegundaInstancia((ContenciosoDebitosResponseDTO)contenciosoDebitosResponseDTO));
    }

    private boolean isParcelaAbertaParaContencioso(ContenciosoDebitoParcela parcela) {
        DebitoParcela debitoParcela = this.buscarDebitoParcela(parcela);
        return debitoParcela.getSituacaoDebito().getTipoSituacaoParcela().isAbertoParaContencioso();
    }

    public boolean isPossivelReabrir(Long id) {
        Contencioso contencioso = (Contencioso)this.contenciosoRepository.findOne((Object)id);
        if (contencioso.getInstancia() == 2L) {
            return false;
        }
        List contenciosoDebitos = contencioso.getDebitos();
        boolean temDebitoIndeferido = contenciosoDebitos.stream().anyMatch(debito -> debito.getSituacao() == SituacaoContenciosoDebito.INDEFERIDO);
        if (temDebitoIndeferido) {
            return true;
        }
        return contenciosoDebitos.stream().filter(debito -> debito.getParcelas() != null).flatMap(debito -> debito.getParcelas().stream()).anyMatch(arg_0 -> this.isParcelaAbertaParaContencioso(arg_0));
    }

    private DebitoParcela buscarDebitoParcela(ContenciosoDebitoParcela parcela) {
        ContenciosoDebitoParcelaId id = parcela.getId();
        return (DebitoParcela)this.debitoParcelaService.findByDebitoParcela(id.getEntidade(), id.getExercicio(), id.getTipoCadastro().getValue(), id.getCadastroGeral(), id.getDivida(), id.getSubDivida(), id.getParcela()).orElseThrow(() -> new EloValidationException("Parcela n\u00e3o encontrada: " + String.valueOf(id)));
    }

    @Generated
    public ContenciosoService(ContenciosoRepository contenciosoRepository, SituacaoParcelaService situacaoParcelaService, DebitoParcelaService debitoParcelaService, DebitoService debitoService, CadastroGeralService cadastroGeralService, MemoriaCadastroService memoriaCadastroService, AcaoExararFactory acaoExararFactory, ContenciosoHistoricoService contenciosoHistoricoService, AutoInfracaoService autoInfracaoService) {
        this.contenciosoRepository = contenciosoRepository;
        this.situacaoParcelaService = situacaoParcelaService;
        this.debitoParcelaService = debitoParcelaService;
        this.debitoService = debitoService;
        this.cadastroGeralService = cadastroGeralService;
        this.memoriaCadastroService = memoriaCadastroService;
        this.acaoExararFactory = acaoExararFactory;
        this.contenciosoHistoricoService = contenciosoHistoricoService;
        this.autoInfracaoService = autoInfracaoService;
    }
}

