/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.dataset.loader.DatasetLoader;
import br.com.elotech.fluent.dataset.loader.DatasetLoaders;
import br.com.elotech.fluent.dataset.loader.ReportDataLoader;
import br.com.elotech.fluent.param.Param;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.report.EloReportBuilder;
import br.com.elotech.report.EloReportFactory;
import br.com.elotech.report.file.ReportFileResolverFactory;
import br.com.elotech.tributos.domain.ArquivoJasper;
import br.com.elotech.tributos.domain.ConsultaDebito;
import br.com.elotech.tributos.domain.ConsultaDebitoTipoAgrupamento;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoSituacaoParcela;
import br.com.elotech.tributos.dto.ConsultaDebitoItemDTO;
import br.com.elotech.tributos.dto.ConsultaDebitoValoresDTO;
import br.com.elotech.tributos.dto.DebitoConstituidoItemDTO;
import br.com.elotech.tributos.dto.FiltroConsultaDebitoDTO;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.enums.TipoArquivoJasper;
import br.com.elotech.tributos.enums.TipoArquivoRelatorioEnum;
import br.com.elotech.tributos.report.loader.ExtratoDebitoParamLoader;
import br.com.elotech.tributos.repository.ConsultaDebitoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ArquivoJasperService;
import br.com.elotech.tributos.service.BatchService;
import br.com.elotech.tributos.service.ConsultaDebitoBatchService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.util.FileUtils;
import br.com.elotech.tributos.utils.TenantUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.batch.core.JobParameters;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

@Service
public class ConsultaDebitoBatchService
extends CrudService<ConsultaDebito, Long> {
    private final ConsultaDebitoRepository consultaDebitoRepository;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final BatchService batchService;
    private final ObjectMapper objectMapper;
    private final ExtratoDebitoParamLoader extratoDebitoParamLoader;
    private final ArquivoJasperService arquivoJasperService;
    private final ReportFileResolverFactory reportFileResolverFactory;
    private static final String SEPARADOR_FILTRO = " | ";
    private static final String SEPARADOR_REGISTRO = ": ";
    private static final String EXTENSAO_ARQUIVO_JASPER = ".jrxml";
    private static final String FORMATO_DATA_BR = "dd/MM/yyyy";
    private static final String TYPE_FILE_CSV = "CSV";
    private static final String TYPE_FILE_PDF = "PDF";
    private static final String CONTENT_TYPE_TEXT_CSV = "text/csv";
    private static final String CONTENT_DISPOSITION_ATTACHMENT = "attachment";

    public ConsultaDebitoBatchService(ConsultaDebitoRepository consultaDebitoRepository, CalculoAcrescimoService calculoAcrescimoService, BatchService batchService, ObjectMapper objectMapper, ExtratoDebitoParamLoader extratoDebitoParamLoader, ArquivoJasperService arquivoJasperService, ReportFileResolverFactory reportFileResolverFactory) {
        this.consultaDebitoRepository = consultaDebitoRepository;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.batchService = batchService;
        this.objectMapper = objectMapper;
        this.extratoDebitoParamLoader = extratoDebitoParamLoader;
        this.arquivoJasperService = arquivoJasperService;
        this.reportFileResolverFactory = reportFileResolverFactory;
    }

    public void calcularAcrescimos(List<DebitoConstituidoItemDTO> debitoConstituidoItem, FormaPagamento formaPagamentoPadrao, LocalDate dataReferencia, ListasNecessariasCalculaAcrescimoDTO parametrosAcrescimos) {
        debitoConstituidoItem.forEach(debito -> {
            AcrescimoDTO acrescimo = this.calculoAcrescimoService.calculaAcrescimos(AcrescimoDTO.of((DebitoConstituidoItemDTO)debito, (Long)formaPagamentoPadrao.getId(), (LocalDate)dataReferencia), Optional.of(parametrosAcrescimos));
            debito.setValor(acrescimo.getValor());
            debito.setValorJuros(acrescimo.getValorJuros());
            debito.setValorMulta(acrescimo.getValorMulta());
            debito.setValorCorrecao(acrescimo.getValorCorrecao());
            debito.setValorLiquido(acrescimo.getValorTotal());
            debito.setValorHonorario(acrescimo.getValorHonorario());
        });
    }

    public ConsultaDebito create(ConsultaDebito consultaDebito) {
        return (ConsultaDebito)this.consultaDebitoRepository.save((Object)consultaDebito);
    }

    public Page<ConsultaDebitoItemDTO> getDebitos(Long idConsulta, String tipoAgrupamento, Pageable pageable) {
        return this.consultaDebitoRepository.findDebitos(idConsulta, tipoAgrupamento, pageable);
    }

    public ConsultaDebitoValoresDTO getResumo(Long idConsulta) {
        return this.consultaDebitoRepository.getResumo(idConsulta);
    }

    public FiltroConsultaDebitoDTO getFiltro(Long idConsulta) throws JsonProcessingException {
        JobParameters jobParameters = this.findJobParametersById(idConsulta);
        String filtro = jobParameters.getString("filtro");
        return (FiltroConsultaDebitoDTO)this.objectMapper.readValue(filtro, FiltroConsultaDebitoDTO.class);
    }

    private JobParameters findJobParametersById(Long idConsulta) {
        ConsultaDebito consultaDebito = (ConsultaDebito)this.consultaDebitoRepository.findById((Object)idConsulta).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar a consulta de d\u00e9bitos com id %d", idConsulta)));
        return this.batchService.getJobParametersById(consultaDebito.getBatchJobExecution().getId());
    }

    public List<ConsultaDebitoItemDTO> getDebitosPorAgrupamento(Long idConsulta, ConsultaDebitoTipoAgrupamento tipoAgrupamento) {
        return this.consultaDebitoRepository.getDebitosPorAgrupamento(idConsulta, tipoAgrupamento);
    }

    public byte[] getArquivoReport(Long idConsulta, ConsultaDebitoTipoAgrupamento tipoAgrupamento, TipoArquivoRelatorioEnum formatoRelatorio) throws IOException {
        FiltroConsultaDebitoDTO filtro = this.getFiltro(idConsulta);
        String cabecalhoFiltro = "";
        if (Objects.nonNull(filtro)) {
            cabecalhoFiltro = this.buliderFiltroRelatorio(filtro);
        }
        List consultaDebitos = this.getDebitosPorAgrupamento(idConsulta, tipoAgrupamento);
        DatasetLoader mainDatasetLoader = DatasetLoaders.fromRecords((List)consultaDebitos, ConsultaDebitoItemDTO.class);
        ReportDatasource datasource = ReportDatasource.builder().add("main", (ReportDataLoader)mainDatasetLoader).params((ParamLoader)this.extratoDebitoParamLoader).param(Param.of((String)"USUARIO", (Object)SecurityUtils.getUserAise())).param(Param.of((String)"FILTRO", (Object)cabecalhoFiltro)).build();
        TipoArquivoJasper tipoJasper = this.getTipoArquivoJasper(tipoAgrupamento, formatoRelatorio);
        ArquivoJasper arquivoJasper = this.arquivoJasperService.buscarArquivoJasperPorTipo(tipoJasper);
        String filePath = this.getReportCustomizado(arquivoJasper, tipoJasper);
        return this.builderExportacaoReport(arquivoJasper, filePath, datasource, formatoRelatorio);
    }

    public HttpHeaders builderHeaders(TipoArquivoRelatorioEnum typeReport, ConsultaDebitoTipoAgrupamento tipoAgrupamentoEnum, byte[] arquivo) {
        String contentType = Objects.equals(typeReport.getValue(), TYPE_FILE_PDF) ? "application/pdf" : CONTENT_TYPE_TEXT_CSV;
        String fileExtension = Objects.equals(typeReport.getValue(), TYPE_FILE_PDF) ? TYPE_FILE_PDF.toLowerCase() : TYPE_FILE_CSV.toLowerCase();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)contentType));
        headers.setContentLength((long)arquivo.length);
        headers.setContentDisposition(ContentDisposition.builder((String)CONTENT_DISPOSITION_ATTACHMENT).filename(String.format("consulta_debito_%s.%s", tipoAgrupamentoEnum.getTipoAgrupamento(), fileExtension)).build());
        return headers;
    }

    public TipoArquivoJasper getTipoArquivoJasper(ConsultaDebitoTipoAgrupamento tipoAgrupamento, TipoArquivoRelatorioEnum tipoArquivoRelatorio) {
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$ConsultaDebitoTipoAgrupamento[tipoAgrupamento.ordinal()]) {
            case 1: {
                return tipoArquivoRelatorio.equals((Object)TipoArquivoRelatorioEnum.CSV) ? TipoArquivoJasper.CONSULTA_DEBITOS_ANO_DIVIDA_CSV : TipoArquivoJasper.CONSULTA_DEBITOS_ANO_DIVIDA_PDF;
            }
            case 2: {
                return tipoArquivoRelatorio.equals((Object)TipoArquivoRelatorioEnum.CSV) ? TipoArquivoJasper.CONSULTA_DEBITOS_CADASTRO_CSV : TipoArquivoJasper.CONSULTA_DEBITOS_CADASTRO_PDF;
            }
            case 3: {
                return tipoArquivoRelatorio.equals((Object)TipoArquivoRelatorioEnum.CSV) ? TipoArquivoJasper.CONSULTA_DEBITOS_CONTRIBUINTE_CSV : TipoArquivoJasper.CONSULTA_DEBITOS_CONTRIBUINTE_PDF;
            }
            case 4: {
                return tipoArquivoRelatorio.equals((Object)TipoArquivoRelatorioEnum.CSV) ? TipoArquivoJasper.CONSULTA_DEBITOS_RESUMIDO_CSV : TipoArquivoJasper.CONSULTA_DEBITOS_RESUMIDO_PDF;
            }
            case 5: {
                return tipoArquivoRelatorio.equals((Object)TipoArquivoRelatorioEnum.CSV) ? TipoArquivoJasper.CONSULTA_DEBITOS_DETALHADO_CSV : TipoArquivoJasper.CONSULTA_DEBITOS_DETALHADO_PDF;
            }
            case 6: {
                return tipoArquivoRelatorio.equals((Object)TipoArquivoRelatorioEnum.CSV) ? TipoArquivoJasper.CONSULTA_DEBITOS_SITUACAO_LEGAL_TIPO_TRIBUTO_CSV : TipoArquivoJasper.CONSULTA_DEBITOS_SITUACAO_LEGAL_TIPO_TRIBUTO_PDF;
            }
            case 7: {
                return tipoArquivoRelatorio.equals((Object)TipoArquivoRelatorioEnum.CSV) ? TipoArquivoJasper.CONSULTA_DEBITOS_ANALITICO_CONTRIBUINTE_CSV : TipoArquivoJasper.CONSULTA_DEBITOS_ANALITICO_CONTRIBUINTE_PDF;
            }
        }
        throw new EloValidationException(String.format("N\u00e3o foi encontrado o tipo de arquivo jasper para o tipo de agrupamento %s.", tipoAgrupamento.getTipoAgrupamento()));
    }

    private String getReportCustomizado(ArquivoJasper arquivoJasper, TipoArquivoJasper tipoArquivoJasper) throws IOException {
        if (Objects.nonNull(arquivoJasper)) {
            String fileName = TenantUtils.getIdentificadorTenant().concat("-").concat(arquivoJasper.getNomeArquivo());
            File tempFile = FileUtils.createTempFile((String)fileName, (String)EXTENSAO_ARQUIVO_JASPER, (byte[])arquivoJasper.getArquivo());
            return tempFile.getPath();
        }
        return String.format("%s%s", tipoArquivoJasper.getNomeInterno(), EXTENSAO_ARQUIVO_JASPER);
    }

    private byte[] builderExportacaoReport(ArquivoJasper arquivoJasper, String filePath, ReportDatasource datasource, TipoArquivoRelatorioEnum tipoArquivoRelatorio) throws IOException {
        EloReportBuilder reportFactory = EloReportFactory.jasper().setReportDatasource(datasource).setObjectMapper(this.objectMapper);
        if (Objects.nonNull(arquivoJasper)) {
            reportFactory.reportFile(new ReportFileResolverFactory("").fromFile(filePath));
        } else {
            reportFactory.reportFile(this.reportFileResolverFactory.fromFile(filePath));
        }
        byte[] fileType = tipoArquivoRelatorio.getValue().equalsIgnoreCase(TYPE_FILE_CSV) ? reportFactory.build().exportToCsv() : reportFactory.build().exportToPdf();
        if (Objects.nonNull(arquivoJasper)) {
            Files.deleteIfExists(Paths.get(filePath, new String[0]));
        }
        return fileType;
    }

    public String buliderFiltroRelatorio(FiltroConsultaDebitoDTO filtro) {
        StringBuilder builder = new StringBuilder();
        this.adicionarFiltro(builder, " Data de Refer\u00eancia", (Object)this.formatarData(filtro.getDataReferencia()));
        this.adicionarFiltroDataRange(builder, " Data de Lan\u00e7amento", this.formatarData(filtro.getDataLancamentoInicial()), this.formatarData(filtro.getDataLancamentoFinal()));
        this.adicionarFiltroDataRange(builder, " Data de Vencimento", this.formatarData(filtro.getDataVencimentoInicial()), this.formatarData(filtro.getDataVencimentoFinal()));
        if (filtro.getTipoSituacaoParcela() != null) {
            String situacaoParcela = TipoSituacaoParcela.fromValue((Object)filtro.getTipoSituacaoParcela()).getDescricao();
            this.adicionarFiltro(builder, " Situa\u00e7\u00e3o da Parcela", (Object)situacaoParcela);
        }
        this.adicionarFiltro(builder, " Contribuinte", (Object)filtro.getPessoaRange());
        this.adicionarFiltro(builder, " Tipos de Cadastros", Objects.nonNull(filtro.getTiposCadastros()) ? filtro.getTiposCadastros().stream().map(TipoCadastro::getValue).map(String::valueOf).collect(Collectors.joining(", ")) : null);
        this.adicionarFiltro(builder, " Cadastro Geral", (Object)filtro.getCadastroGeral());
        this.adicionarFiltro(builder, " Ano do D\u00e9bito", (Object)filtro.getAnoDebito());
        this.adicionarFiltro(builder, " D\u00edvida", (Object)filtro.getDivida());
        this.adicionarFiltro(builder, " Sub-D\u00edvida", (Object)filtro.getSubDivida());
        this.adicionarFiltro(builder, " Parcelado", (Object)filtro.getParcelado());
        this.adicionarFiltro(builder, " Reparcelado", (Object)filtro.getReparcelado());
        this.adicionarFiltro(builder, " Protesto", (Object)this.getFiltroProtesto(filtro.getDebitosProtestados()));
        this.adicionarFiltro(builder, " Calcula Acr\u00e9scimo", (Object)this.formatarBooleano(filtro.getCalcularAcrescimos()));
        this.adicionarFiltro(builder, " Parcelas em Aberto", (Object)this.formatarBooleano(filtro.getSomenteParcelasEmAberto()));
        this.adicionarFiltro(builder, " No Exerc\u00edcio", (Object)this.formatarBooleano(filtro.getNoExercicio()));
        this.adicionarFiltro(builder, " D\u00edvida Ativa", (Object)this.formatarBooleano(filtro.getDividaAtiva()));
        this.adicionarFiltro(builder, " Em Ju\u00edzo", (Object)this.formatarBooleano(filtro.getJuizo()));
        return builder.toString();
    }

    private void adicionarFiltro(StringBuilder builder, String label, Object valor) {
        if (valor != null && !valor.toString().isEmpty()) {
            if (builder.length() > 0) {
                builder.append(SEPARADOR_FILTRO);
            }
            builder.append(label).append(SEPARADOR_REGISTRO).append(valor);
        }
    }

    private void adicionarFiltroDataRange(StringBuilder builder, String label, String dataInicial, String dataFinal) {
        if (dataInicial != null || dataFinal != null) {
            if (builder.length() > 0) {
                builder.append(SEPARADOR_FILTRO);
            }
            builder.append(label).append(SEPARADOR_REGISTRO);
            if (dataInicial != null && dataFinal != null) {
                builder.append(dataInicial).append(" at\u00e9 ").append(dataFinal);
            } else {
                builder.append(dataInicial != null ? dataInicial : dataFinal);
            }
        }
    }

    private String formatarBooleano(Boolean valor) {
        return valor != null ? (valor.booleanValue() ? "Sim" : "N\u00e3o") : null;
    }

    private String formatarData(LocalDate data) {
        return data != null ? data.format(DateTimeFormatter.ofPattern(FORMATO_DATA_BR)) : null;
    }

    private String getFiltroProtesto(Long protesto) {
        if (protesto == null) {
            return "";
        }
        switch (protesto.intValue()) {
            case 1: {
                return "TODOS";
            }
            case 2: {
                return "Apenas com Protesto";
            }
            case 3: {
                return "Apenas sem Protesto";
            }
        }
        return "";
    }
}

