/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Condominio;
import br.com.elotech.tributos.repository.CondominioRepository;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class CondominioService
extends CrudService<Condominio, Long> {
    private final CondominioRepository condominioRepository;

    public CondominioService(CondominioRepository condominioRepository) {
        this.condominioRepository = condominioRepository;
    }

    protected void beforeSave(Condominio entity, Authentication authentication) {
        entity.setSetorCodigo(entity.getSetor().getSetor());
        entity.setDistritoCodigo(entity.getSetor().getDistrito().getDistrito());
        super.beforeSave((EloEntity)entity, authentication);
    }

    public Condominio findByCondominio(Long condominio) {
        return (Condominio)this.condominioRepository.findByCondominio(condominio).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o Condom\u00ednio com o c\u00f3digo '%d'.", condominio)));
    }

    public Condominio findBySetorDistritoDistritoAndSetorSetorAndCondominio(String distrito, String setor, Long condominio) {
        return this.condominioRepository.findBySetorDistritoDistritoAndSetorSetorAndCondominio(distrito, setor, condominio);
    }
}

