/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcelaId;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.DocumentoItemDividaAtiva;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.domain.protesto.ProtestoItem;
import br.com.elotech.tributos.domain.relatorio.Relatorio;
import br.com.elotech.tributos.dto.ArquivoUnicoSalvarDTO;
import br.com.elotech.tributos.dto.CadastroImobiliarioLocalizacaoDTO;
import br.com.elotech.tributos.dto.CertidaoDividaAtivaDTO;
import br.com.elotech.tributos.dto.CertidaoDividaAtivaDebitoHonorarioDTO;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.DocumentoItemPeticaoDTO;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.SubReportDTO;
import br.com.elotech.tributos.dto.SubReportItemDTO;
import br.com.elotech.tributos.dto.certidaodividaativa.AtualizaNumeroProcessoJudicialDTO;
import br.com.elotech.tributos.dto.certidaodividaativa.ImpressaoExtratoCdaDTO;
import br.com.elotech.tributos.dto.documento.SituacaoDocumentoDTO;
import br.com.elotech.tributos.dto.documento.peticao.CdaGeracaoPeticaoDTO;
import br.com.elotech.tributos.dto.documento.peticao.GeracaoLotePeticaoDTO;
import br.com.elotech.tributos.exception.CadastroImobiliarioDTOException;
import br.com.elotech.tributos.report.loader.CertidaoDividaAtivaParamLoader;
import br.com.elotech.tributos.repository.CertidaoDividaAtivaDebitoHonorarioRepository;
import br.com.elotech.tributos.repository.CertidaoDividaAtivaRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ArquivoUnicoService;
import br.com.elotech.tributos.service.CadastroImobiliarioService;
import br.com.elotech.tributos.service.CertidaoDividaAtivaHistoricoService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.DebitoParcelaTributoService;
import br.com.elotech.tributos.service.DocumentoItemDividaAtivaService;
import br.com.elotech.tributos.service.DocumentoPeticaoService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.ImpressaoExtratoDebitoCdaService;
import br.com.elotech.tributos.service.LogAtualizacaoNumeroProcessoJudicialService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.ProtestoService;
import br.com.elotech.tributos.service.honorarios.CertidaoDividaAtivaDebitoHistoricoService;
import br.com.elotech.tributos.service.ws.AiseRelatorioService;
import br.com.elotech.unico.client.domain.TipoArquivoEnum;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.openl.util.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.server.ResponseStatusException;

@Service
public class CertidaoDividaAtivaService {
    private final CadastroImobiliarioService cadastroImobiliarioService;
    private final CertidaoDividaAtivaRepository certidaoDividaAtivaRepository;
    private final CertidaoDividaAtivaParamLoader certidaoDividaAtivaParamLoader;
    private final DocumentoPeticaoService documentoPeticaoService;
    private final DocumentoService documentoService;
    private final ContextService contextService;
    private final AiseRelatorioService aiseRelatorioService;
    private final ArquivoUnicoService arquivoUnicoService;
    private final CertidaoDividaAtivaHistoricoService certidaoDividaAtivaHistoricoService;
    private final ProtestoService protestoService;
    private final DocumentoItemDividaAtivaService documentoItemDividaAtivaService;
    private final DebitoParcelaTributoService debitoParcelaTributoService;
    private final DebitoParcelaService debitoParcelaService;
    private final ParametroGeralService parametroGeralService;
    private final CertidaoDividaAtivaDebitoHistoricoService certidaoDividaAtivaDebitoHistoricoService;
    private final CertidaoDividaAtivaDebitoHonorarioRepository certidaoDividaAtivaDebitoHonorarioRepository;
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private final LogAtualizacaoNumeroProcessoJudicialService logAtualizacaoNumeroProcessoJudicialService;
    private final EntityManager entityManager;
    private final ImpressaoExtratoDebitoCdaService impressaoExtratoDebitoCdaService;

    public DocumentoDTO findDocumentosDividaAtiva(Long id) {
        Documento documento = (Documento)this.documentoService.findOne((Serializable)id);
        if (Objects.isNull(documento)) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Documento de d\u00edvida ativa n\u00e3o encontrado");
        }
        DocumentoDTO documentoDTO = DocumentoDTO.fromWithDocumentoItemDividaAtivas((Documento)documento);
        if (Optional.ofNullable(documento.getCadastroGeral()).isPresent() && documento.getCadastroGeral().getTipoCadastro().isImobiliario().booleanValue()) {
            CadastroImobiliarioLocalizacaoDTO cadastroImobiliarioLocalizacaoDTO = Optional.ofNullable(this.cadastroImobiliarioService.findByTipoCadastroAndCadastroGeral(documento.getCadastroGeral().getTipoCadastro(), documento.getCadastroGeral().getCadastroGeral())).map(CadastroImobiliarioLocalizacaoDTO::from).orElseThrow(() -> new CadastroImobiliarioDTOException(HttpStatus.NOT_FOUND, "Cadastro Imobili\u00e1rio n\u00e3o encontrado"));
            documentoDTO.setCadastroImobiliarioLocalizacaoDTO(cadastroImobiliarioLocalizacaoDTO);
        }
        documentoDTO.setDocumentoDividaAtivaDTO(documentoDTO.agruparDocumentosDividaAtivaPorParcela(this.contextService.getEntidadePrincipal()));
        documentoDTO.setCertidaoDividaAtivaDebitoHonorarioDTO(this.getHistoricoHonorarios(documentoDTO.getId()));
        return documentoDTO;
    }

    public List<CertidaoDividaAtivaDebitoHonorarioDTO> getHistoricoHonorarios(Long idDocumento) {
        return this.certidaoDividaAtivaDebitoHistoricoService.getCdaDebitoHonorarioByDocumentoId(idDocumento);
    }

    public List<CertidaoDividaAtivaDTO> findByDebitoParcela(DebitoParcelaId parcelaId) {
        return this.certidaoDividaAtivaRepository.findByDebitoParcela(parcelaId);
    }

    public DocumentoDTO cancelarCda(Long id, SituacaoDocumentoDTO cancelamentoDocumentoDTO) {
        List peticao = this.documentoPeticaoService.findPeticoesVinculadasComCDA(id);
        if (!peticao.isEmpty()) {
            throw new EloValidationException(String.format("J\u00e1 existe uma peti\u00e7\u00e3o %d/%d vinculada com esta Certid\u00e3o de d\u00edvida ativa %d/%d", ((DocumentoItemPeticaoDTO)peticao.get(0)).getDocumento(), ((DocumentoItemPeticaoDTO)peticao.get(0)).getExercicio(), ((DocumentoItemPeticaoDTO)peticao.get(0)).getDocumentoCertidao(), ((DocumentoItemPeticaoDTO)peticao.get(0)).getExercicioCertidao()));
        }
        Documento documento = this.documentoService.cancelarDocumento(id, cancelamentoDocumentoDTO);
        this.cancelarDebitosDeHonorariosCda(documento.getId());
        this.certidaoDividaAtivaHistoricoService.salvaHistoricoOperacaoCancelamento(documento, cancelamentoDocumentoDTO.getObservacao());
        return DocumentoDTO.from((Documento)documento);
    }

    public void cancelarDebitosDeHonorariosCda(Long idDocumento) {
        Optional.ofNullable(this.certidaoDividaAtivaDebitoHonorarioRepository.findDebitoByDocumentoId(idDocumento)).orElse(Collections.emptyList()).stream().filter(Debito::hasParcelasAbertas).forEach(debito -> debito.getParcelas().stream().filter(debitoParcela -> debitoParcela.getSituacaoDebito().isAberto()).forEach(arg_0 -> ((DebitoParcelaService)this.debitoParcelaService).cancelarParcelaAberta(arg_0)));
    }

    public ImprimirRelatorioDTO buildImpressaoCDA(Documento documento) {
        if (Objects.isNull(documento)) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Documento de d\u00edvida ativa n\u00e3o encontrado");
        }
        Relatorio relatorio = documento.getDocumentoTipo().getRelatorio();
        if (Objects.isNull(relatorio)) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Relat\u00f3rio n\u00e3o encontrado");
        }
        ImprimirRelatorioDTO dto = new ImprimirRelatorioDTO();
        dto.setRelatorio(relatorio.getId().getRelatorio());
        dto.setModulo(relatorio.getId().getModulo());
        dto.setTipoRelatorio(relatorio.getId().getTipoRelatorio());
        dto.setFiltro(String.format(" td.Exercicio = %d and td.Documento = %d", documento.getExercicio(), documento.getDocumento()));
        dto.setListParametros(this.certidaoDividaAtivaParamLoader.load(documento.getExercicio()));
        dto.setListVariaveisAmbienteTela(String.format("TabelaCDADebito=%s%n", "tribdocumentoitemdividaativa"));
        dto.setSubReports(this.createSubReportImprimirCDA(dto.getFiltro()));
        return dto;
    }

    public Long saveArquivoUnico(Long id) {
        Documento documento = (Documento)this.documentoService.findOne((Serializable)id);
        ArquivoUnicoSalvarDTO arquivoUnicoSalvarDTO = this.buildSalvarArquivoUnicoCDA(documento);
        Long idArquivoUnico = this.arquivoUnicoService.salvarPDF(arquivoUnicoSalvarDTO);
        documento.setIdArquivoUnico(idArquivoUnico);
        this.documentoService.save((EloEntity)documento, null);
        return idArquivoUnico;
    }

    public ArquivoUnicoSalvarDTO buildSalvarArquivoUnicoCDA(Documento documento) {
        ImprimirRelatorioDTO imprimirRelatorioDTO = this.buildImpressaoCDA(documento);
        byte[] relatorio = this.aiseRelatorioService.imprimirRelatorioGenerico(imprimirRelatorioDTO);
        ArquivoUnicoSalvarDTO arquivoUnicoSalvarDTO = new ArquivoUnicoSalvarDTO();
        arquivoUnicoSalvarDTO.setContent(relatorio);
        arquivoUnicoSalvarDTO.setTipoArquivo(TipoArquivoEnum.CERTIDAO_DIVIDA_ATIVA);
        arquivoUnicoSalvarDTO.setDiretorio("/cdas");
        arquivoUnicoSalvarDTO.setFileName("certidao_divida_ativa_" + documento.getId() + ".pdf");
        return arquivoUnicoSalvarDTO;
    }

    private SubReportDTO createSubReportImprimirCDA(String filtro) {
        SubReportDTO subReportDTO = new SubReportDTO();
        subReportDTO.setItems((Set)Sets.newHashSet((Object[])new SubReportItemDTO[]{new SubReportItemDTO("Debitos", filtro), new SubReportItemDTO("S\u00f3cios", filtro), new SubReportItemDTO("Proprietarios", filtro), new SubReportItemDTO("DevedorSolidario", filtro), new SubReportItemDTO("TotalDebitosCDA", filtro.replaceAll("td.", "a.")), new SubReportItemDTO("CertidaoDividaAtivaProprietarios", filtro), new SubReportItemDTO("VALOREXTENSO", filtro.replaceAll("td.", "a.")), new SubReportItemDTO("NaturezaFundamento", filtro.replaceAll("td.", "a."))}));
        return subReportDTO;
    }

    public Page<DocumentoDTO> getDocumentos(Optional<String> search, Pageable pageable) {
        String searchFilter = String.format("tipoDocumento == %d", TipoDocumentoEnum.CERTIDAO_DIVIDA_ATIVA.getCodigo());
        if (search.isPresent()) {
            searchFilter = searchFilter.concat(" and ").concat(search.get());
        }
        return this.documentoService.getDocumentos(Optional.of(searchFilter), pageable);
    }

    public List<CdaGeracaoPeticaoDTO> findCdaGeracaoPeticao(GeracaoLotePeticaoDTO geracaoLotePeticaoDTO) {
        return this.certidaoDividaAtivaRepository.findCdaGeracaoPeticao(geracaoLotePeticaoDTO, this.contextService.getEntidadePrincipal());
    }

    public byte[] printCertidaoDividaAtiva(Long id) {
        Documento documento = (Documento)this.documentoService.findOne((Serializable)id);
        return this.printCertidaoDividaAtiva(documento);
    }

    public byte[] printCertidaoDividaAtiva(Documento documento) {
        if (Objects.isNull(documento.getIdArquivoUnico())) {
            ImprimirRelatorioDTO imprimirRelatorioDTO = this.buildImpressaoCDA(documento);
            byte[] arquivo = this.aiseRelatorioService.imprimirRelatorioGenerico(imprimirRelatorioDTO);
            if (Objects.isNull(arquivo)) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "O relat\u00f3rio est\u00e1 inv\u00e1lido");
            }
            return arquivo;
        }
        return this.arquivoUnicoService.baixarPDF(documento.getIdArquivoUnico());
    }

    public Protesto protestarCda(Long idCda) {
        Long exercicio = this.contextService.getExercicioAtual();
        Protesto protesto = this.createProtesto(idCda, exercicio);
        Long numeroProtesto = this.protestoService.findNextProtesto(exercicio);
        protesto.setProtesto(numeroProtesto);
        Protesto protestoSalvo = (Protesto)this.protestoService.save((EloEntity)protesto, null);
        this.debitoParcelaService.updateParcelaProtesto(protesto.getDocumento(), protesto.getId(), null);
        return protestoSalvo;
    }

    public Documento atualizarNumeroPaf(Long idDocumento, String numeroPaf) {
        Documento documento = (Documento)this.documentoService.findOne((Serializable)idDocumento);
        documento.setNumeroPaf(numeroPaf);
        Documento documentoSalvo = (Documento)this.documentoService.save((EloEntity)documento, null);
        this.certidaoDividaAtivaHistoricoService.salvaHistoricoInclusaoNumeroPaf(documentoSalvo, numeroPaf);
        return documentoSalvo;
    }

    public Protesto createProtesto(Long idCda, Long exercicio) {
        Documento documento = (Documento)this.documentoService.findOne((Serializable)idCda);
        Optional protestoGerado = this.protestoService.findByDocumento(documento);
        if (protestoGerado.isPresent()) {
            throw new EloValidationException(String.format("CDA %d/%d com id %d j\u00e1 est\u00e1 protestado", documento.getDocumento(), documento.getExercicio(), documento.getId()));
        }
        List documentoItemDividaAtivas = this.documentoItemDividaAtivaService.findByDocumentoId(documento.getId());
        this.validaSeTemBoletoVencido(documentoItemDividaAtivas);
        Long entidade = this.contextService.getEntidadePrincipal();
        Protesto protesto = Protesto.from((Documento)documento, (Long)exercicio, (Long)entidade, (String)SecurityUtils.getUserAise());
        AtomicLong sequencia = new AtomicLong();
        documentoItemDividaAtivas.forEach(cda -> {
            ProtestoItem protestoItem = ProtestoItem.from((Protesto)protesto, (DocumentoItemDividaAtiva)cda, (Documento)documento);
            protestoItem.getId().setSequencia(Long.valueOf(sequencia.incrementAndGet()));
            protesto.getProtestoItems().add(protestoItem);
        });
        return protesto;
    }

    private void validaSeTemBoletoVencido(List<DocumentoItemDividaAtiva> dividaAtivas) {
        boolean bloqueiaGeracaoProtesto = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.BLOQUEIA_PROTESTO_BOLETO_A_VENCER);
        if (bloqueiaGeracaoProtesto) {
            dividaAtivas.forEach(cda -> {
                List boletosNaoVencido = this.debitoParcelaTributoService.findBoletosNaoVencidosDividaAtiva(cda.getDocumento().getExercicio(), cda.getDocumento().getEntidade(), cda.getDocumento().getTipoDocumento(), cda.getDocumento().getDocumento(), LocalDate.now());
                if (CollectionUtils.isNotEmpty((Collection)boletosNaoVencido)) {
                    Object erroBoletoNaoVencido = "Os seguintes boletos n\u00e3o est\u00e3o vencidos: ";
                    ArrayList boletosNaoVencidos = new ArrayList();
                    boletosNaoVencido.forEach(boleto -> boletosNaoVencidos.add(boleto.getBloqueto().toString() + "/" + boleto.getExercicio().toString()));
                    erroBoletoNaoVencido = (String)erroBoletoNaoVencido + String.join((CharSequence)",", boletosNaoVencidos);
                    throw new EloValidationException((String)erroBoletoNaoVencido);
                }
            });
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void atualizaNumeroProcessoJudicial(AtualizaNumeroProcessoJudicialDTO dto) {
        if (!dto.isPorLote()) {
            this.applyIdentificadoresCDA(dto);
        }
        this.validaParametrosParaAtualizacaoNumeroProcessoJudicial(dto);
        this.logAtualizacaoNumeroProcessoJudicialService.runWithLog(dto, () -> {
            this.atualizaNumeroProcessoJudicialCDA(dto);
            this.atualizaNumeroProcessoJudicialParcelas(dto);
            return null;
        });
    }

    private void applyIdentificadoresCDA(AtualizaNumeroProcessoJudicialDTO dto) {
        List identificadoresCda = dto.isPorFiltro() ? this.getIdentificadoresCDA(dto.getFiltroCda()) : dto.getIdentificadoresCda();
        dto.setIdentificadoresCda(identificadoresCda);
    }

    public void atualizaNumeroProcessoJudicialCDA(AtualizaNumeroProcessoJudicialDTO dto) {
        String SQL = "   UPDATE aise.tribdocumento\n   SET processojudicial = :numeroProcessoJudicial\n   WHERE idkey IN (:identificadores)\n";
        Map<String, List> params = Map.of("numeroProcessoJudicial", dto.getNumeroProcessoJudicial(), "identificadores", dto.getIdentificadoresCda());
        this.namedParameterJdbcTemplate.update("   UPDATE aise.tribdocumento\n   SET processojudicial = :numeroProcessoJudicial\n   WHERE idkey IN (:identificadores)\n", params);
    }

    public void atualizaNumeroProcessoJudicialParcelas(AtualizaNumeroProcessoJudicialDTO dto) {
        String SQL = "   UPDATE aise.tribdebitoparcela SET processojudicial = :numeroProcessoJudicial\n   WHERE iddebitoparcela IN (\n   SELECT dp.iddebitoparcela\n   FROM aise.tribdebitoparcela dp\n       JOIN aise.tribdocumentoitemdividaativa dida ON dida.entidade = dp.entidade AND dida.exerciciodebito = dp.exercicio\n                                                AND dida.tipocadastro = dp.tipocadastro AND dida.cadastrogeral = dp.cadastrogeral\n                                                AND dida.guiarecolhimento = dp.guiarecolhimento AND dida.subdivida = dp.subdivida\n                                                AND dida.parcela = dp.parcela\n       JOIN aise.tribdocumento d ON d.documento = dida.documento AND d.exercicio = dida.exercicio\n                                AND d.entidade = dida.entidade AND d.tipodocumento = dida.tipodocumento\n   WHERE d.idkey IN (:identificadores)\n   GROUP BY 1\n)\n";
        Map<String, List> params = Map.of("numeroProcessoJudicial", dto.getNumeroProcessoJudicial(), "identificadores", dto.getIdentificadoresCda());
        this.namedParameterJdbcTemplate.update("   UPDATE aise.tribdebitoparcela SET processojudicial = :numeroProcessoJudicial\n   WHERE iddebitoparcela IN (\n   SELECT dp.iddebitoparcela\n   FROM aise.tribdebitoparcela dp\n       JOIN aise.tribdocumentoitemdividaativa dida ON dida.entidade = dp.entidade AND dida.exerciciodebito = dp.exercicio\n                                                AND dida.tipocadastro = dp.tipocadastro AND dida.cadastrogeral = dp.cadastrogeral\n                                                AND dida.guiarecolhimento = dp.guiarecolhimento AND dida.subdivida = dp.subdivida\n                                                AND dida.parcela = dp.parcela\n       JOIN aise.tribdocumento d ON d.documento = dida.documento AND d.exercicio = dida.exercicio\n                                AND d.entidade = dida.entidade AND d.tipodocumento = dida.tipodocumento\n   WHERE d.idkey IN (:identificadores)\n   GROUP BY 1\n)\n", params);
    }

    private List<Long> getIdentificadoresCDA(String rsql) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(Long.class);
        Root acessoEntidade = query.from(Documento.class);
        Expression campo = acessoEntidade.get("id").as(Long.class);
        query.select((Selection)campo).distinct(true);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Predicate tipoDocumentoPredicate = criteriaBuilder.equal((Expression)acessoEntidade.get("tipoDocumento"), (Object)26L);
        predicates.add(tipoDocumentoPredicate);
        Specification spec = RsqlUtils.createSpecFrom((EntityManager)this.entityManager, (String)rsql);
        Predicate predicate = spec.toPredicate(acessoEntidade, query, criteriaBuilder);
        if (predicate != null) {
            predicates.add(predicate);
        }
        query.where((Expression)criteriaBuilder.and(predicates.toArray(new Predicate[0])));
        return this.entityManager.createQuery(query).getResultList();
    }

    public void validaParametrosParaAtualizacaoNumeroProcessoJudicial(AtualizaNumeroProcessoJudicialDTO dto) {
        this.validaSeTemDadosParaAtualizacao(dto);
        this.validaSeAtualizacaoPorLoteETemFiltro(dto);
    }

    public void validaSeTemDadosParaAtualizacao(AtualizaNumeroProcessoJudicialDTO dto) {
        if (StringUtils.isBlank((CharSequence)dto.getFiltroCda()) && dto.getIdentificadoresCda().isEmpty()) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel processar, pois n\u00e3o tem item selecionado");
        }
    }

    public void validaSeAtualizacaoPorLoteETemFiltro(AtualizaNumeroProcessoJudicialDTO dto) {
        if (dto.isPorFiltro() && StringUtils.isBlank((CharSequence)dto.getFiltroCda())) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel atualizar dados dos selecionados. Por favor, preencha com um filtro");
        }
    }

    public byte[] imprimirExtrato(ImpressaoExtratoCdaDTO impressaoDTO) throws IOException {
        if (impressaoDTO.isPorFiltro()) {
            List idCdas = this.getIdentificadoresCDA(impressaoDTO.getFiltro());
            impressaoDTO.setIdCdas(idCdas);
        }
        return this.impressaoExtratoDebitoCdaService.gerarExtrato(impressaoDTO.getIdCdas());
    }

    @Generated
    public CertidaoDividaAtivaService(CadastroImobiliarioService cadastroImobiliarioService, CertidaoDividaAtivaRepository certidaoDividaAtivaRepository, CertidaoDividaAtivaParamLoader certidaoDividaAtivaParamLoader, DocumentoPeticaoService documentoPeticaoService, DocumentoService documentoService, ContextService contextService, AiseRelatorioService aiseRelatorioService, ArquivoUnicoService arquivoUnicoService, CertidaoDividaAtivaHistoricoService certidaoDividaAtivaHistoricoService, ProtestoService protestoService, DocumentoItemDividaAtivaService documentoItemDividaAtivaService, DebitoParcelaTributoService debitoParcelaTributoService, DebitoParcelaService debitoParcelaService, ParametroGeralService parametroGeralService, CertidaoDividaAtivaDebitoHistoricoService certidaoDividaAtivaDebitoHistoricoService, CertidaoDividaAtivaDebitoHonorarioRepository certidaoDividaAtivaDebitoHonorarioRepository, NamedParameterJdbcTemplate namedParameterJdbcTemplate, LogAtualizacaoNumeroProcessoJudicialService logAtualizacaoNumeroProcessoJudicialService, EntityManager entityManager, ImpressaoExtratoDebitoCdaService impressaoExtratoDebitoCdaService) {
        this.cadastroImobiliarioService = cadastroImobiliarioService;
        this.certidaoDividaAtivaRepository = certidaoDividaAtivaRepository;
        this.certidaoDividaAtivaParamLoader = certidaoDividaAtivaParamLoader;
        this.documentoPeticaoService = documentoPeticaoService;
        this.documentoService = documentoService;
        this.contextService = contextService;
        this.aiseRelatorioService = aiseRelatorioService;
        this.arquivoUnicoService = arquivoUnicoService;
        this.certidaoDividaAtivaHistoricoService = certidaoDividaAtivaHistoricoService;
        this.protestoService = protestoService;
        this.documentoItemDividaAtivaService = documentoItemDividaAtivaService;
        this.debitoParcelaTributoService = debitoParcelaTributoService;
        this.debitoParcelaService = debitoParcelaService;
        this.parametroGeralService = parametroGeralService;
        this.certidaoDividaAtivaDebitoHistoricoService = certidaoDividaAtivaDebitoHistoricoService;
        this.certidaoDividaAtivaDebitoHonorarioRepository = certidaoDividaAtivaDebitoHonorarioRepository;
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
        this.logAtualizacaoNumeroProcessoJudicialService = logAtualizacaoNumeroProcessoJudicialService;
        this.entityManager = entityManager;
        this.impressaoExtratoDebitoCdaService = impressaoExtratoDebitoCdaService;
    }
}

