/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.domain.CertidaoDividaAtivaHistorico;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.DocumentoItemDividaAtiva;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.dto.CertidaoDividaAtivaHistoricoDTO;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.enums.CertidaoDividaAtivaHistoricoOperacaoEnum;
import br.com.elotech.tributos.repository.CertidaoDividaAtivaHistoricoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import java.time.LocalDateTime;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CertidaoDividaAtivaHistoricoService {
    private final CertidaoDividaAtivaHistoricoRepository certidaoDividaAtivaHistoricoRepository;

    public CertidaoDividaAtivaHistoricoService(CertidaoDividaAtivaHistoricoRepository certidaoDividaAtivaHistoricoRepository) {
        this.certidaoDividaAtivaHistoricoRepository = certidaoDividaAtivaHistoricoRepository;
    }

    public Page<CertidaoDividaAtivaHistoricoDTO> getHistoricosPaginadosOrderByDataDesc(Long idDocumento, Pageable pageable) {
        Page certidaoDividaAtivaHistoricos = this.certidaoDividaAtivaHistoricoRepository.findByDocumentoIdOrderByDataDesc(idDocumento, pageable);
        Page certidaoDividaAtivaHistoricoDTOs = certidaoDividaAtivaHistoricos.map(certidaoDividaAtivaHistoricoElemento -> CertidaoDividaAtivaHistoricoDTO.from((CertidaoDividaAtivaHistorico)certidaoDividaAtivaHistoricoElemento));
        return certidaoDividaAtivaHistoricoDTOs;
    }

    public void salvaHistoricoOperacaoPessoa(Documento documento, CertidaoDividaAtivaHistoricoOperacaoEnum operacao, Pessoa pessoa) {
        CertidaoDividaAtivaHistorico certidaoDividaAtivaHistorico = this.preparaHistoricoGenerico(documento, operacao);
        certidaoDividaAtivaHistorico.setPessoa(pessoa);
        this.certidaoDividaAtivaHistoricoRepository.save((Object)certidaoDividaAtivaHistorico);
    }

    public void salvaHistoricoOperacaoCancelamento(Documento documento, String observacaoCancelamento) {
        CertidaoDividaAtivaHistorico certidaoDividaAtivaHistorico = this.preparaHistoricoGenerico(documento, CertidaoDividaAtivaHistoricoOperacaoEnum.CANCELAMENTO);
        certidaoDividaAtivaHistorico.setObservacaoCancelamento(observacaoCancelamento);
        this.certidaoDividaAtivaHistoricoRepository.save((Object)certidaoDividaAtivaHistorico);
    }

    public void salvaHistoricoOperacaoRemocaoDebito(Documento documento, DocumentoItemDividaAtiva documentoItemDividaAtiva) {
        CertidaoDividaAtivaHistorico certidaoDividaAtivaHistorico = this.preparaHistoricoDebitoGenerico(documento, CertidaoDividaAtivaHistoricoOperacaoEnum.REMOCAO_DEBITO, documentoItemDividaAtiva);
        this.certidaoDividaAtivaHistoricoRepository.save((Object)certidaoDividaAtivaHistorico);
    }

    public void salvaHistoricoOperacaoInclusaoDebito(Documento documento, DocumentoItemDividaAtiva documentoItemDividaAtiva) {
        CertidaoDividaAtivaHistorico certidaoDividaAtivaHistorico = this.preparaHistoricoDebitoGenerico(documento, CertidaoDividaAtivaHistoricoOperacaoEnum.INCLUSAO_DEBITO, documentoItemDividaAtiva);
        this.certidaoDividaAtivaHistoricoRepository.save((Object)certidaoDividaAtivaHistorico);
    }

    public void salvaHistoricoOperacaoAtualizacaoValor(Documento documento, DocumentoItemDividaAtiva documentoItemDividaAtiva, AcrescimoDTO acrescimoDTO) {
        CertidaoDividaAtivaHistorico certidaoDividaAtivaHistorico = this.preparaHistoricoDebitoGenerico(documento, CertidaoDividaAtivaHistoricoOperacaoEnum.ATUALIZACAO_VALOR, documentoItemDividaAtiva);
        certidaoDividaAtivaHistorico.setValorAnterior(documentoItemDividaAtiva.getValor());
        certidaoDividaAtivaHistorico.setValorMultaAnterior(documentoItemDividaAtiva.getValorMulta());
        certidaoDividaAtivaHistorico.setValorJurosAnterior(documentoItemDividaAtiva.getValorJuros());
        certidaoDividaAtivaHistorico.setValorCorrecaoAnterior(documentoItemDividaAtiva.getValorCorrecao());
        certidaoDividaAtivaHistorico.setValorAtualizado(acrescimoDTO.getValor());
        certidaoDividaAtivaHistorico.setValorMultaAtualizado(acrescimoDTO.getValorMulta());
        certidaoDividaAtivaHistorico.setValorJurosAtualizado(acrescimoDTO.getValorJuros());
        certidaoDividaAtivaHistorico.setValorCorrecaoAtualizado(acrescimoDTO.getValorCorrecao());
        this.certidaoDividaAtivaHistoricoRepository.save((Object)certidaoDividaAtivaHistorico);
    }

    public void salvaHistoricoInclusaoNumeroPaf(Documento documento, String numeroPaf) {
        CertidaoDividaAtivaHistorico certidaoDividaAtivaHistorico = this.preparaHistoricoGenerico(documento, CertidaoDividaAtivaHistoricoOperacaoEnum.INCLUSAO_NUMERO_PAF);
        certidaoDividaAtivaHistorico.setObservacaoCancelamento(numeroPaf);
        this.certidaoDividaAtivaHistoricoRepository.save((Object)certidaoDividaAtivaHistorico);
    }

    private CertidaoDividaAtivaHistorico preparaHistoricoDebitoGenerico(Documento documento, CertidaoDividaAtivaHistoricoOperacaoEnum operacao, DocumentoItemDividaAtiva documentoItemDividaAtiva) {
        CertidaoDividaAtivaHistorico certidaoDividaAtivaHistorico = this.preparaHistoricoGenerico(documento, operacao);
        certidaoDividaAtivaHistorico.setIdDebito(documentoItemDividaAtiva.getDebito().getId());
        certidaoDividaAtivaHistorico.setTributo(documentoItemDividaAtiva.getTributo());
        certidaoDividaAtivaHistorico.setParcela(documentoItemDividaAtiva.getParcela());
        return certidaoDividaAtivaHistorico;
    }

    private CertidaoDividaAtivaHistorico preparaHistoricoGenerico(Documento documento, CertidaoDividaAtivaHistoricoOperacaoEnum operacao) {
        CertidaoDividaAtivaHistorico certidaoDividaAtivaHistorico = new CertidaoDividaAtivaHistorico();
        certidaoDividaAtivaHistorico.setDocumento(documento);
        certidaoDividaAtivaHistorico.setData(LocalDateTime.now());
        certidaoDividaAtivaHistorico.setNomeUsuario(SecurityUtils.getUserName());
        certidaoDividaAtivaHistorico.setCpfCnpjUsuario(SecurityUtils.getPreferredUsername());
        certidaoDividaAtivaHistorico.setOperacao(operacao);
        return certidaoDividaAtivaHistorico;
    }
}

