/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.CancelamentoBoleto;
import br.com.elotech.tributos.domain.CancelamentoBoletoItem;
import br.com.elotech.tributos.domain.CancelamentoBoletoItemId;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincrona;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.dto.FiltroBoletoDTO;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.repository.CancelamentoBoletoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoBoletoRegistradoReceiver;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CancelamentoBoletoService
extends CrudService<CancelamentoBoleto, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CancelamentoBoletoService.class);
    private final BloquetoService bloquetoService;
    private final IntegracaoBoletoRegistradoReceiver integracaoBoletoRegistradoReceiver;
    private final CancelamentoBoletoRepository cancelamentoBoletoRepository;
    private final TarefaAssincronaService tarefaAssincronaService;
    private final NotificacaoService notificacaoService;
    private static final Map<NotificationStatus, String> messagesNotificacao = Map.of(NotificationStatus.STARTED, "Iniciado cancelamento de boletos", NotificationStatus.COMPLETED, "Conclu\u00eddo cancelamento de boletos", NotificationStatus.FAILED, "Cancelamento de boletos falhou");

    public void reprocessarBoletos(Long idCancelamento, UserSecurityDTO user) {
        this.reprocessarBoletosComErro(idCancelamento, user);
    }

    public void cancelarBoletoId(List<Long> idBoletos, UserSecurityDTO user) {
        this.cancelarBoleto(this.bloquetoService.findByBloquetoIds(idBoletos), user);
    }

    public void cancelarBoletoPorFiltro(FiltroBoletoDTO filtro, UserSecurityDTO user) {
        this.cancelarBoleto(this.bloquetoService.findAllByFiltro(filtro), user);
    }

    public void cancelarBoleto(Bloqueto boleto, String mensagem) {
        CancelamentoBoleto cancelamento = this.createCancelamentoBoleto();
        boleto.setCancelado(Boolean.TRUE);
        Bloqueto saved = this.bloquetoService.save(boleto);
        CancelamentoBoletoService.createCancelamentoBoletoItem((Bloqueto)saved, (CancelamentoBoleto)cancelamento, (String)mensagem, (Boolean)Boolean.FALSE);
        this.cancelamentoBoletoRepository.save((Object)cancelamento);
    }

    private CancelamentoBoleto createCancelamentoBoleto() {
        CancelamentoBoleto cancelamentoBoleto = new CancelamentoBoleto();
        cancelamentoBoleto.setDataCancelamento(LocalDate.now());
        cancelamentoBoleto.setUsuario(SecurityUtils.getUserAise());
        return (CancelamentoBoleto)this.cancelamentoBoletoRepository.save((Object)cancelamentoBoleto);
    }

    @Async
    @Transactional
    private void cancelarBoleto(List<Bloqueto> boletos, UserSecurityDTO user) {
        log.debug("Preparando ambiente de cancelamento de boletos com os seguintes IDs {}", (Object)boletos.toString());
        CancelamentoBoleto cancelamentoBoleto = this.createCancelamentoBoleto();
        TarefaAssincronaExecucao tarefaEmExecucao = this.startTarefaAssincrona(cancelamentoBoleto.getId());
        Optional idNotificacao = this.notificaInicioTarefaAssincrona(tarefaEmExecucao, user);
        AtomicBoolean isCancelamentoComErro = new AtomicBoolean(false);
        try {
            log.debug("Iniciando cancelamento de Boletos ");
            boletos.forEach(boleto -> {
                try {
                    this.integracaoBoletoRegistradoReceiver.receiveCancelamento(boleto);
                    CancelamentoBoletoService.createCancelamentoBoletoItem((Bloqueto)boleto, (CancelamentoBoleto)cancelamentoBoleto, (String)"Cancelamento do boleto realizado com sucesso!", (Boolean)Boolean.FALSE);
                }
                catch (Exception e) {
                    CancelamentoBoletoService.createCancelamentoBoletoItem((Bloqueto)boleto, (CancelamentoBoleto)cancelamentoBoleto, (String)("Erro ao cancelar o boleto: " + e.getMessage()), (Boolean)Boolean.TRUE);
                    isCancelamentoComErro.set(true);
                }
            });
            log.debug("Finalizado rotina de cancelamentos de boletos");
            this.cancelamentoBoletoRepository.save((Object)cancelamentoBoleto);
            this.finalizarTarefaAssincrona(isCancelamentoComErro, tarefaEmExecucao, idNotificacao, user);
        }
        catch (Exception e) {
            log.error("Erro ao realizar rotina de cancelamentos de boletos", (Throwable)e);
            this.stopTarefaAssincrona(tarefaEmExecucao, idNotificacao, user, NotificationStatus.FAILED, e);
        }
    }

    @Async
    @Transactional
    private void reprocessarBoletosComErro(Long idCancelamento, UserSecurityDTO user) {
        log.debug("Preparando ambiente para reprocessar o cancelamento de boletos com erros");
        CancelamentoBoleto cancelamentoBoleto = (CancelamentoBoleto)this.cancelamentoBoletoRepository.findById((Object)idCancelamento).orElseThrow(() -> new EloValidationException("Cancelamento n\u00e3o encontrado"));
        TarefaAssincronaExecucao tarefaEmExecucao = this.startTarefaAssincrona(cancelamentoBoleto.getId());
        Optional idNotificacao = this.notificaInicioTarefaAssincrona(tarefaEmExecucao, user);
        AtomicBoolean isCancelamentoComErro = new AtomicBoolean(false);
        try {
            log.debug("Iniciando rotina de reprocessamento de cancelamento de Boletos com erro ");
            List<CancelamentoBoletoItem> boletosComErro = cancelamentoBoleto.getBoleto().stream().filter(boletoItem -> boletoItem.getComErro() != null && boletoItem.getComErro() != false && boletoItem.getId().getBoleto().getPago().equals(Boolean.FALSE)).collect(Collectors.toList());
            boletosComErro.forEach(boleto -> {
                try {
                    this.integracaoBoletoRegistradoReceiver.receiveCancelamento(boleto.getId().getBoleto());
                    boleto.setComErro(Boolean.FALSE);
                    boleto.setMensagem("Cancelamento do boleto realizado com sucesso!");
                }
                catch (Exception e) {
                    boleto.setComErro(Boolean.TRUE);
                    boleto.setMensagem("Erro ao cancelar o boleto com erro: " + e.getMessage());
                    isCancelamentoComErro.set(true);
                }
            });
            log.debug("Finalizado rotina de reprocessamento de cancelamento de Boletos com erro");
            this.cancelamentoBoletoRepository.save((Object)cancelamentoBoleto);
            this.finalizarTarefaAssincrona(isCancelamentoComErro, tarefaEmExecucao, idNotificacao, user);
        }
        catch (Exception e) {
            log.error("Erro ao realizar rotina de reprocessamento de cancelamento de Boletos com erro", (Throwable)e);
            this.stopTarefaAssincrona(tarefaEmExecucao, idNotificacao, user, NotificationStatus.FAILED, e);
        }
    }

    public void finalizarTarefaAssincrona(AtomicBoolean canceladoComErro, TarefaAssincronaExecucao tarefaEmExecucao, Optional<UUID> idNotificacao, UserSecurityDTO user) {
        if (canceladoComErro.get()) {
            this.stopTarefaAssincrona(tarefaEmExecucao, idNotificacao, user, NotificationStatus.FAILED, null);
        } else {
            this.stopTarefaAssincrona(tarefaEmExecucao, idNotificacao, user, NotificationStatus.COMPLETED, null);
        }
    }

    private static void createCancelamentoBoletoItem(Bloqueto boleto, CancelamentoBoleto cancelamentoBoleto, String mensagem, Boolean comErro) {
        CancelamentoBoletoItem cancelamentoBoletoItem = new CancelamentoBoletoItem();
        cancelamentoBoletoItem.setId(new CancelamentoBoletoItemId(cancelamentoBoleto, boleto));
        cancelamentoBoletoItem.setMensagem(mensagem);
        cancelamentoBoletoItem.setComErro(comErro);
        cancelamentoBoleto.getBoleto().add(cancelamentoBoletoItem);
    }

    private TarefaAssincronaExecucao startTarefaAssincrona(Long idCancelamentoBloqueto) {
        return this.tarefaAssincronaService.createTarefaAssincronaCancelamentoBoletos(idCancelamentoBloqueto);
    }

    private Optional<UUID> notificaInicioTarefaAssincrona(TarefaAssincronaExecucao execucao, UserSecurityDTO user) {
        return this.notificaCliente(execucao, Optional.empty(), user, NotificationStatus.STARTED);
    }

    private void stopTarefaAssincrona(TarefaAssincronaExecucao execucao, Optional<UUID> idNotificacao, UserSecurityDTO user, NotificationStatus status, Exception exception) {
        if (status.equals((Object)NotificationStatus.FAILED)) {
            this.tarefaAssincronaService.marcarExecucaoComErro(execucao, exception.getMessage());
        } else {
            this.tarefaAssincronaService.finalizarExecucao(execucao);
        }
        this.notificaCliente(execucao, idNotificacao, user, status);
    }

    private Optional<UUID> notificaCliente(TarefaAssincronaExecucao execucao, Optional<UUID> idNotificacao, UserSecurityDTO user, NotificationStatus status) {
        String titulo = "Cancelamento de Boletos";
        String message = (String)messagesNotificacao.get(status);
        TarefaAssincrona tarefa = execucao.getTarefaAssincrona();
        return this.notificacaoService.send(titulo, message, tarefa, idNotificacao, user, status);
    }

    @Generated
    public CancelamentoBoletoService(BloquetoService bloquetoService, IntegracaoBoletoRegistradoReceiver integracaoBoletoRegistradoReceiver, CancelamentoBoletoRepository cancelamentoBoletoRepository, TarefaAssincronaService tarefaAssincronaService, NotificacaoService notificacaoService) {
        this.bloquetoService = bloquetoService;
        this.integracaoBoletoRegistradoReceiver = integracaoBoletoRegistradoReceiver;
        this.cancelamentoBoletoRepository = cancelamentoBoletoRepository;
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.notificacaoService = notificacaoService;
    }
}

