/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.domain.parcelamento.Parcelamento;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.CancelamentoBoletoService;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class CancelamentoBoletoEstornoParcelamentoService {
    private final BloquetoService bloquetoService;
    private final CancelamentoBoletoService cancelamentoBoletoService;

    public CancelamentoBoletoEstornoParcelamentoService(BloquetoService bloquetoService, CancelamentoBoletoService cancelamentoBoletoService) {
        this.bloquetoService = bloquetoService;
        this.cancelamentoBoletoService = cancelamentoBoletoService;
    }

    public void cancelamentoBoletoPorEstornoParcelamento(Parcelamento parcelamento) {
        if (Boolean.TRUE.equals(parcelamento.getEstornado())) {
            UserSecurityDTO user = SecurityUtils.getUserSecurityDTO();
            List bloquetoIds = this.bloquetoService.findByIdParcelamento(parcelamento.getId());
            this.cancelamentoBoletoService.cancelarBoletoId(bloquetoIds, user);
        }
    }
}

