/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CampoObrigatorio;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.CampoObrigatorioDTO;
import br.com.elotech.tributos.repository.CampoObrigatorioRepository;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.transaction.Transactional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class CampoObrigatorioService
extends CrudService<CampoObrigatorio, Long> {
    private final CampoObrigatorioRepository campoObrigatorioRepository;
    @Autowired
    private EntityManager entityManager;

    public List<CampoObrigatorioDTO> findCamposByTipoCadastro(Long tipoCadastro) {
        Sort sort = Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"aba"), Sort.Order.asc((String)"campo")});
        return this.campoObrigatorioRepository.findByTipoCadastro(TipoCadastro.fromValue((Long)tipoCadastro), sort).stream().map(CampoObrigatorioDTO::from).collect(Collectors.toList());
    }

    @Transactional
    public void updateCampoObrigatorio(Long id, Boolean obrigatorio) {
        try {
            CampoObrigatorio campoObrigatorio = (CampoObrigatorio)this.entityManager.find(CampoObrigatorio.class, (Object)id);
            if (Objects.isNull(campoObrigatorio)) {
                throw new EloValidationException("");
            }
            campoObrigatorio.setObrigatorio(obrigatorio);
        }
        catch (EloValidationException e) {
            throw new EloValidationException("Campo obrigat\u00f3rio n\u00e3o encontrado.");
        }
        catch (Exception e) {
            throw new EloValidationException(String.format("Erro ao atualizar o campo com id %s", id));
        }
    }

    @Generated
    public CampoObrigatorioService(CampoObrigatorioRepository campoObrigatorioRepository, EntityManager entityManager) {
        this.campoObrigatorioRepository = campoObrigatorioRepository;
        this.entityManager = entityManager;
    }
}

