/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.ImobiliarioItbi;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.LogradouroTestada;
import br.com.elotech.tributos.domain.Loteamento;
import br.com.elotech.tributos.domain.ParametroEntidadeEnum;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.domain.SetorQuadra;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoVinculo;
import br.com.elotech.tributos.domain.camposdinamicos.FuncionalidadeCampo;
import br.com.elotech.tributos.domain.camposdinamicos.RespostaSegmento;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioProfundidade;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSegmento;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSituacao;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioTestada;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioTestadaGenerica;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioTestadaGenericaExercicio;
import br.com.elotech.tributos.domain.inscricaocadastral.ConfiguracaoInscricaoCadastral;
import br.com.elotech.tributos.domain.inscricaocadastral.ConfiguracaoInscricaoCadastralItem;
import br.com.elotech.tributos.dto.AdvancedSearchItemDTO;
import br.com.elotech.tributos.dto.BairroDTO;
import br.com.elotech.tributos.dto.CadastroGeralSearchParamsDTO;
import br.com.elotech.tributos.dto.CadastroSearchDTO;
import br.com.elotech.tributos.dto.DebitosEmAbertoComTotalizadorDTO;
import br.com.elotech.tributos.dto.DocumentoCertidaoItemDTO;
import br.com.elotech.tributos.dto.EnderecoCorrespondenciaDTO;
import br.com.elotech.tributos.dto.LogradouroDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroImobiliarioCopiaDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroImobiliarioDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroImobiliarioEnderecoDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroImobiliarioRowDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroImobiliarioUnificacaoDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.HistoricoTransmissaoDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.LoteamentoDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.SegmentoDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.SegmentoDemolicaoDTO;
import br.com.elotech.tributos.hibernatesearch.domain.HibernateSearchParams;
import br.com.elotech.tributos.hibernatesearch.facet.FacetCadastroGeral;
import br.com.elotech.tributos.hibernatesearch.facet.FacetCadastroImobiliario;
import br.com.elotech.tributos.repository.DebitoRepository;
import br.com.elotech.tributos.repository.DocumentoRepository;
import br.com.elotech.tributos.repository.ImobiliarioItbiRepository;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.imobiliario.CadastroImobiliarioRepository;
import br.com.elotech.tributos.repository.imobiliario.CadastroImobiliarioTestadaGenericaExercicioRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.BoletimImobiliarioSegmentoService;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.CadastroImobiliarioAvaliacaoService;
import br.com.elotech.tributos.service.CadastroImobiliarioSituacaoService;
import br.com.elotech.tributos.service.ConfiguracaoInscricaoCadastralService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoEmAbertoService;
import br.com.elotech.tributos.service.EnderecoCorrespondenciaService;
import br.com.elotech.tributos.service.HibernateSearchService;
import br.com.elotech.tributos.service.ParametroEntidadeService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.SequenceCadastroGeralService;
import br.com.elotech.tributos.service.SetorQuadraService;
import br.com.elotech.tributos.service.camposdinamicos.RespostaService;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.validator.CadastroImobiliarioValidator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.query.dsl.BooleanJunction;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class CadastroImobiliarioService
extends CrudService<CadastroImobiliario, Long> {
    private static final int DUAS_CASAS_DECIMAIS = 2;
    private static final int QUATRO_CASAS_DECIMAIS = 4;
    private static final String MESSAGE_VALIDATION_REQUIRED = "%s \u00e9 obrigat\u00f3rio";
    private final ParametroEntidadeService parametroEntidadeService;
    private final ParametroGeralService parametroGeralService;
    private final CadastroGeralService cadastroGeralService;
    private final CadastroImobiliarioSituacaoService imobiliarioSituacaoService;
    private final CadastroImobiliarioRepository cadastroImobiliarioRepository;
    private final CadastroImobiliarioAvaliacaoService cadastroImobiliarioAvaliacaoService;
    private final ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService;
    private final CadastroImobiliarioValidator cadastroImobiliarioValidator;
    private final SetorQuadraService setorQuadraService;
    private final RespostaService respostaService;
    private final HibernateSearchService hibernateSearchService;
    private final SequenceCadastroGeralService sequenceCadastroGeralService;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final EnderecoCorrespondenciaService enderecoCorrespondenciaService;
    private final DebitoEmAbertoService debitoEmAbertoService;
    private final BoletimImobiliarioSegmentoService boletimImobiliarioSegmentoService;
    private final ImobiliarioItbiRepository imobiliarioItbiRepository;
    private final DebitoRepository debitoRepository;
    private final DocumentoRepository documentoRepository;
    private final CadastroImobiliarioTestadaGenericaExercicioRepository cadastroImobiliarioTestadaGenericaExercicioRepository;
    private final ContextService contextService;
    private static final String COMMA = ",";

    protected void beforeSave(CadastroImobiliario cadastroImobiliario, Authentication authentication) {
        boolean somaAreaConstrucaoCoberta = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.SOMA_AREACONSTRUCAO_COBERTA, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        this.cadastroGeralService.validaCadastroGeralExclusaoLogica((CadastroGeral)cadastroImobiliario);
        cadastroImobiliario.setDataAlteracao(LocalDate.now());
        cadastroImobiliario.setUsuario(SecurityUtils.getUserAise());
        this.setInscricaoCadastral(cadastroImobiliario);
        this.setProfundidadeMedia(cadastroImobiliario);
        this.calculaAreasBaseadasNosSegmentos(cadastroImobiliario, somaAreaConstrucaoCoberta);
        this.atualizaAreaTotalInscricao(cadastroImobiliario, somaAreaConstrucaoCoberta);
        this.setArredondamentoArea(cadastroImobiliario);
        if (Objects.nonNull(cadastroImobiliario.getSituacaoImobiliario())) {
            this.imobiliarioSituacaoService.setAtualSituacao(cadastroImobiliario);
        }
        this.cadastroImobiliarioValidator.validaCadastroImobiliario(cadastroImobiliario);
        this.setEnderecoLocalizacao(cadastroImobiliario);
        this.setPessoaCadastroGeral(cadastroImobiliario);
        if (!this.informaCadastroManual().booleanValue() && Objects.isNull(cadastroImobiliario.getCadastroGeral())) {
            cadastroImobiliario.setCadastroGeral(this.getCadastroGeralBySequence());
            cadastroImobiliario.atualizaReferenciaSegmentos();
            cadastroImobiliario.atualizaReferenciaObservacoes();
        }
        if (Boolean.TRUE.equals(this.getUtilizaConvencaoCondominio())) {
            this.alteraCadastrosComMesmaInscricaoCadastralAteUnidade(cadastroImobiliario);
        }
        super.beforeSave((EloEntity)cadastroImobiliario, authentication);
    }

    private Boolean getUtilizaConvencaoCondominio() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_CONVENCAO_CONDOMINIO);
    }

    private void alteraCadastrosComMesmaInscricaoCadastralAteUnidade(CadastroImobiliario cadastroImobiliario) {
        this.cadastroImobiliarioRepository.updateCadastrosMesmaInscricaoWithoutUnidade(this.getPrefixoInscricao(cadastroImobiliario.getInscricaoCadastral(), this.configuracaoInscricaoCadastralService.getConfiguracao().getUnidade().getTamanho()), cadastroImobiliario.getConvencaoCondominio());
    }

    private String getPrefixoInscricao(String inscricaoCadastral, Long tamanhoUnidade) {
        if (Objects.nonNull(inscricaoCadastral) && (long)inscricaoCadastral.length() > tamanhoUnidade) {
            return inscricaoCadastral.substring(0, (int)((long)inscricaoCadastral.length() - tamanhoUnidade));
        }
        return "";
    }

    private void calculaAreasBaseadasNosSegmentos(CadastroImobiliario cadastroImobiliario, boolean somaAreaConstrucaoCoberta) {
        BigDecimal areaUnidadeConstruida = cadastroImobiliario.getSegmentos().stream().map(seg -> {
            BigDecimal area = Optional.ofNullable(seg.getAreaConstruida()).orElse(BigDecimal.ZERO);
            if (somaAreaConstrucaoCoberta) {
                area = area.add(Optional.ofNullable(seg.getAreaCoberta()).orElse(BigDecimal.ZERO));
            }
            return area;
        }).reduce(BigDecimal.ZERO, BigDecimal::add);
        cadastroImobiliario.setAreaUnidadeConstruida(areaUnidadeConstruida);
        Boolean utilizaSituacaoSegmento = this.utilizaSituacaoSegmento();
        BigDecimal areaTotalConstruida = cadastroImobiliario.getAreaTotalSegmentos(utilizaSituacaoSegmento);
        if (somaAreaConstrucaoCoberta) {
            areaTotalConstruida = areaTotalConstruida.add(cadastroImobiliario.getAreaTotalSegmentosAreaCoberta(utilizaSituacaoSegmento));
        }
        cadastroImobiliario.setAreaTotalConstruida(areaTotalConstruida);
    }

    private void atualizaAreaTotalInscricao(CadastroImobiliario cadastroImobiliario, boolean somaAreaConstrucaoCoberta) {
        String inscricaoSemUnidade = this.montaInscricaoCadastralSemUnidade(cadastroImobiliario);
        List cadastrosMesmaInscricao = this.cadastroImobiliarioRepository.getCadastrosMesmaInscricao(inscricaoSemUnidade, cadastroImobiliario.getId());
        Boolean utilizaSituacaoSegmento = this.utilizaSituacaoSegmento();
        BigDecimal areaCadastrosMesmaInscricao = cadastrosMesmaInscricao.stream().reduce(BigDecimal.ZERO, (acc, curr) -> {
            BigDecimal total = Optional.ofNullable(curr.getAreaTotalSegmentos(utilizaSituacaoSegmento)).orElse(BigDecimal.ZERO);
            if (somaAreaConstrucaoCoberta) {
                total = total.add(Optional.ofNullable(curr.getAreaTotalSegmentosAreaCoberta(utilizaSituacaoSegmento)).orElse(BigDecimal.ZERO));
            }
            return acc.add(total);
        }, BigDecimal::add);
        BigDecimal areaTotalInscricao = cadastroImobiliario.getAreaTotalConstruida().add(areaCadastrosMesmaInscricao);
        cadastroImobiliario.setAreaTotalInscricao(areaTotalInscricao);
        cadastrosMesmaInscricao.forEach(cadastro -> {
            cadastro.setAreaTotalInscricao(areaTotalInscricao);
            this.cadastroImobiliarioRepository.save(cadastro);
        });
    }

    private void setPessoaCadastroGeral(CadastroImobiliario cadastroImobiliario) {
        Proprietario proprietarioPrincipal = cadastroImobiliario.getProprietarios().stream().filter(proprietario -> proprietario.getPrincipal() != false && TipoVinculo.PRINCIPAL.equals((Object)proprietario.getVinculo().getTipoVinculo())).findFirst().orElseThrow(() -> new EloValidationException("N\u00e3o h\u00e1 um propriet\u00e1rio marcado como principal"));
        cadastroImobiliario.setPessoa(proprietarioPrincipal.getPessoa());
    }

    private void setEnderecoLocalizacao(CadastroImobiliario cadastroImobiliario) {
        Boolean utilizaTestadaGenerica = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_TESTADA_GENERICA);
        if (utilizaTestadaGenerica.booleanValue()) {
            cadastroImobiliario.getTestadasGenericas().stream().filter(CadastroImobiliarioTestadaGenerica::getPrincipal).findFirst().ifPresent(testadaGenerica -> {
                Logradouro logradouro = (Logradouro)this.getEm().getReference(Logradouro.class, (Object)testadaGenerica.getLogradouro().getId());
                cadastroImobiliario.setCidade(logradouro.getCidade());
                cadastroImobiliario.setLogradouro(logradouro);
                cadastroImobiliario.setNumero(testadaGenerica.getNumero());
            });
        } else {
            cadastroImobiliario.getTestadas().stream().filter(CadastroImobiliarioTestada::getPrincipal).findFirst().ifPresent(testada -> {
                LogradouroTestada logradouroTestada = (LogradouroTestada)this.getEm().getReference(LogradouroTestada.class, (Object)testada.getLogradouroTestada().getId());
                cadastroImobiliario.setCidade(logradouroTestada.getLogradouro().getCidade());
                cadastroImobiliario.setLogradouro(logradouroTestada.getLogradouro());
                cadastroImobiliario.setNumero(testada.getNumero());
            });
        }
    }

    private void setProfundidadeMedia(CadastroImobiliario cadastroImobiliario) {
        List profundidades = cadastroImobiliario.getProfundidades();
        BigDecimal soma = profundidades.stream().map(CadastroImobiliarioProfundidade::getProfundidade).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (soma.compareTo(BigDecimal.ZERO) > 0) {
            cadastroImobiliario.setProfundidadeMedia(soma.divide(new BigDecimal(profundidades.size()), 4, RoundingMode.HALF_UP));
        }
    }

    private void setArredondamentoArea(CadastroImobiliario cadastroImobiliario) {
        int casasDecimais = this.parametroCasasDecimaisImobiliario().intValue();
        if (casasDecimais < 2 || casasDecimais > 4) {
            casasDecimais = 2;
        }
        if (Objects.nonNull(cadastroImobiliario.getAreaLote())) {
            cadastroImobiliario.setAreaLote(cadastroImobiliario.getAreaLote().setScale(casasDecimais, 4));
        }
        if (Objects.nonNull(cadastroImobiliario.getAreaUtilLote())) {
            cadastroImobiliario.setAreaUtilLote(cadastroImobiliario.getAreaUtilLote().setScale(casasDecimais, 4));
        }
        if (Objects.nonNull(cadastroImobiliario.getAreaPrivativa())) {
            cadastroImobiliario.setAreaPrivativa(cadastroImobiliario.getAreaPrivativa().setScale(casasDecimais, 4));
        }
        if (Objects.nonNull(cadastroImobiliario.getAreaComum())) {
            cadastroImobiliario.setAreaComum(cadastroImobiliario.getAreaComum().setScale(casasDecimais, 4));
        }
    }

    private Long parametroCasasDecimaisImobiliario() {
        return this.parametroGeralService.getParamValueAsLong(ParametroGeralEnum.CASAS_DECIMAIS_IMOBILIARIO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private Boolean parametroValidaInscricaoDuplicada() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VALIDA_INSCRICAO_DUPLICADA, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    public Boolean utilizaSituacaoSegmento() {
        return this.parametroEntidadeService.getParamValueAsBoolean(ParametroEntidadeEnum.UTILIZA_SITUACAO_SEGMENTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private Boolean informaCadastroManual() {
        return this.parametroEntidadeService.getParamValueAsBoolean(ParametroEntidadeEnum.INFORMA_CADASTRO_MANUAL, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    public CadastroImobiliario findByTipoCadastroAndCadastroGeral(TipoCadastro tipoCadastro, Long cadastroGeral) {
        CadastroImobiliario cadastroImobiliarioEntity = this.cadastroImobiliarioRepository.findByTipoCadastroAndCadastroGeral(tipoCadastro, cadastroGeral);
        return cadastroImobiliarioEntity;
    }

    public CadastroImobiliarioDTO saveDTO(CadastroImobiliarioDTO cadastroImobiliarioDTO, Boolean novoCadastro) {
        return this.saveDTOWithFlush(cadastroImobiliarioDTO, novoCadastro, Boolean.TRUE);
    }

    public CadastroImobiliarioDTO saveDTOWithFlush(CadastroImobiliarioDTO cadastroImobiliarioDTO, Boolean novoCadastro, Boolean flush) {
        if (Objects.nonNull(cadastroImobiliarioDTO.getSegmentos())) {
            this.atualizaDemolicoes(cadastroImobiliarioDTO.getSegmentos());
            List segmentoDTOS = this.atualizaSegmentos(cadastroImobiliarioDTO.getSegmentos());
            cadastroImobiliarioDTO.setSegmentos(segmentoDTOS);
        }
        CadastroImobiliario cadastroImobiliarioToSave = cadastroImobiliarioDTO.toEntity();
        cadastroImobiliarioToSave.getTestadas().forEach(testada -> {
            Long idSetorQuadra = testada.getLogradouroTestada().getSetorQuadra().getId();
            if (Objects.isNull(idSetorQuadra)) {
                throw new EloValidationException("Obrigat\u00f3rio informar Distrito/Setor/Quadra no cadastro de Logradouro Testada.");
            }
            testada.getLogradouroTestada().setSetorQuadra((SetorQuadra)this.setorQuadraService.findById((Serializable)idSetorQuadra).orElseThrow(() -> new EloValidationException(String.format("Quadra n\u00e3o encontrado com id %d", idSetorQuadra))));
        });
        Long exercicioAtual = this.contextService.getExercicioAtual();
        cadastroImobiliarioToSave.getTestadasGenericas().forEach(testada -> {
            CadastroImobiliarioTestadaGenericaExercicio tge = this.cadastroImobiliarioTestadaGenericaExercicioRepository.findByTestadaGenericaIdAndExercicio(testada.getId(), exercicioAtual).orElseGet(() -> {
                CadastroImobiliarioTestadaGenericaExercicio tgeNew = new CadastroImobiliarioTestadaGenericaExercicio();
                tgeNew.setExercicio(exercicioAtual);
                tgeNew.setTestadaGenerica(testada);
                return tgeNew;
            });
            tge.setValorM2(testada.getValorM2());
            testada.getExercicios().add(tge);
        });
        cadastroImobiliarioToSave.getSegmentos().forEach(segmento -> segmento.getDemolicoes().forEach(demolicao -> {
            if (demolicao.isNew()) {
                if (Objects.isNull(demolicao.getDataDemolicao())) {
                    demolicao.setDataDemolicao(LocalDate.now());
                }
                if (Objects.isNull(demolicao.getUsuario())) {
                    demolicao.setUsuario(SecurityUtils.getUserAise());
                }
            }
        }));
        CadastroImobiliario prepared = this.prepareToSave(cadastroImobiliarioToSave, novoCadastro);
        this.validaRespostasCamposDinamicos(prepared);
        CadastroImobiliario saved = (CadastroImobiliario)this.save((EloEntity)prepared, null);
        if (Boolean.TRUE.equals(flush)) {
            this.getEm().flush();
        }
        return this.loadDTO(saved);
    }

    public CadastroImobiliarioDTO loadDTO(CadastroImobiliario cadastroImobiliario) {
        boolean somaAreaConstrucaoCoberta = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.SOMA_AREACONSTRUCAO_COBERTA, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        CadastroImobiliarioDTO retorno = CadastroImobiliarioDTO.from((CadastroImobiliario)cadastroImobiliario);
        if (somaAreaConstrucaoCoberta) {
            BigDecimal areaCobertaNaoLancada = cadastroImobiliario.getAreaTotalSegmentosAreaCoberta(Boolean.FALSE);
            retorno.setAreaTotalNaoLancada(retorno.getAreaTotalNaoLancada().add(areaCobertaNaoLancada));
        }
        this.preencheEnderecoCorrespondencia(retorno);
        retorno.setRespostasTerreno(this.respostaService.getRespostasAgrupadas(FuncionalidadeCampo.TERRENO, retorno.getId()));
        retorno.getSegmentos().forEach(segmentoDTO -> {
            segmentoDTO.setRespostasSegmento(this.respostaService.getRespostasAgrupadas(FuncionalidadeCampo.SEGMENTO, segmentoDTO.getId()));
            segmentoDTO.getDemolicoes().forEach(demolicao -> Optional.ofNullable(this.documentoRepository.findByEntidadeTributacaoEntidadeIdAndEntidadeTributacaoExercicioAndTipoDocumentoAndDocumento(this.contextService.getEntidadePrincipal(), demolicao.getExercicioDocumento(), demolicao.getTipoDocumento().getId(), demolicao.getDocumento())).map(Documento::getId).ifPresent(arg_0 -> ((SegmentoDemolicaoDTO)demolicao).setIdDocumento(arg_0)));
        });
        retorno.setMensagemAvisoProprietarios(this.buildMensagemAvisoWithProprietariosComDiferenca(cadastroImobiliario));
        return retorno;
    }

    public String buildMensagemAvisoWithProprietariosComDiferenca(CadastroImobiliario cadastroImobiliario) {
        if (Boolean.TRUE.equals(this.getUtilizaConvencaoCondominio()) && Boolean.FALSE.equals(cadastroImobiliario.getConvencaoCondominio())) {
            List cadastroImobiliarioList = this.verificaCadastrosComDiferencasProprietarios(cadastroImobiliario);
            String cadastrosComDiferenca = cadastroImobiliarioList.stream().map(imobiliario -> String.valueOf(imobiliario.getCadastroGeral())).collect(Collectors.joining(COMMA));
            if (cadastrosComDiferenca.isEmpty()) {
                return "";
            }
            return "O(s) seguinte(s) cadastro(s) imobili\u00e1rio(s) est\u00e3o com diverg\u00eancia de propriet\u00e1rios entre as unidades: ".concat(cadastrosComDiferenca);
        }
        return "";
    }

    private List<CadastroImobiliario> verificaCadastrosComDiferencasProprietarios(CadastroImobiliario cadastroImobiliario) {
        ArrayList<CadastroImobiliario> cadastroImobiliarioListWithDiferenca = new ArrayList<CadastroImobiliario>();
        List cadastroImobiliarioList = this.cadastroImobiliarioRepository.getCadastrosMesmaInscricaoWithoutUnidade(this.getPrefixoInscricao(cadastroImobiliario.getInscricaoCadastral(), this.configuracaoInscricaoCadastralService.getConfiguracao().getUnidade().getTamanho()), cadastroImobiliario.getTipoCadastro(), cadastroImobiliario.getCadastroGeral());
        cadastroImobiliarioList.forEach(imobiliario -> {
            if (Boolean.TRUE.equals(this.existsProprietariosDiferentesEntreCadastros(cadastroImobiliario, imobiliario))) {
                cadastroImobiliarioListWithDiferenca.add((CadastroImobiliario)imobiliario);
            }
        });
        return cadastroImobiliarioListWithDiferenca;
    }

    public boolean existsProprietariosDiferentesEntreCadastros(CadastroImobiliario cadastroBase, CadastroImobiliario cadastroToVerify) {
        Set verifyIds;
        Set baseIds = cadastroBase.getProprietarios().stream().map(Proprietario::getPessoa).map(Pessoa::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        return !baseIds.equals(verifyIds = cadastroToVerify.getProprietarios().stream().map(Proprietario::getPessoa).map(Pessoa::getId).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    public List<DocumentoCertidaoItemDTO> loadItensDocumentoCertidao(Long idCadastro) {
        CadastroImobiliario cadastroImobiliario = (CadastroImobiliario)this.cadastroImobiliarioRepository.findById((Object)idCadastro).orElseThrow(() -> new EloValidationException(String.format("Cadastro Imobili\u00e1rio %s n\u00e3o encontrado", idCadastro)));
        Map identificadores = this.loadIdentificadoresItemDocumento();
        ArrayList<DocumentoCertidaoItemDTO> itens = new ArrayList<DocumentoCertidaoItemDTO>();
        for (CadastroImobiliarioSegmento segmento : cadastroImobiliario.getSegmentos()) {
            DocumentoCertidaoItemDTO item = this.buildItemDocumentoCertidao(segmento, identificadores);
            itens.add(item);
        }
        return itens;
    }

    private Map<ParametroGeralEnum, String> loadIdentificadoresItemDocumento() {
        return Map.of(ParametroGeralEnum.IDENTIFICADOR_DOCUMENTO_ITEM_DATA_ALVARA, this.getValorParametroGeral(ParametroGeralEnum.IDENTIFICADOR_DOCUMENTO_ITEM_DATA_ALVARA), ParametroGeralEnum.IDENTIFICADOR_DOCUMENTO_ITEM_NUMERO_ALVARA, this.getValorParametroGeral(ParametroGeralEnum.IDENTIFICADOR_DOCUMENTO_ITEM_NUMERO_ALVARA), ParametroGeralEnum.IDENTIFICADOR_DOCUMENTO_ITEM_DATA_HABITASE, this.getValorParametroGeral(ParametroGeralEnum.IDENTIFICADOR_DOCUMENTO_ITEM_DATA_HABITASE), ParametroGeralEnum.IDENTIFICADOR_DOCUMENTO_ITEM_NUMERO_HABITASE, this.getValorParametroGeral(ParametroGeralEnum.IDENTIFICADOR_DOCUMENTO_ITEM_NUMERO_HABITASE), ParametroGeralEnum.IDENTIFICADOR_DOCUMENTO_ITEM_PADRAO, this.getValorParametroGeral(ParametroGeralEnum.IDENTIFICADOR_DOCUMENTO_ITEM_PADRAO), ParametroGeralEnum.IDENTIFICADOR_DOCUMENTO_ITEM_ANO_CONSTRUCAO, this.getValorParametroGeral(ParametroGeralEnum.IDENTIFICADOR_DOCUMENTO_ITEM_ANO_CONSTRUCAO), ParametroGeralEnum.IDENTIFICADOR_DOCUMENTO_ITEM_CONSTRUCAO, this.getValorParametroGeral(ParametroGeralEnum.IDENTIFICADOR_DOCUMENTO_ITEM_CONSTRUCAO));
    }

    private DocumentoCertidaoItemDTO buildItemDocumentoCertidao(CadastroImobiliarioSegmento segmento, Map<ParametroGeralEnum, String> identificadores) {
        DocumentoCertidaoItemDTO item = new DocumentoCertidaoItemDTO();
        if (segmento.getTipoSegmento() != null) {
            item.setIdTipoSegmento(segmento.getTipoSegmento().getId());
            if (segmento.getTipoSegmento().getUtilizacao() != null) {
                item.setIdUtilizacao(segmento.getTipoSegmento().getUtilizacao().getId());
            }
        }
        item.setSequencia(segmento.getSequencia());
        item.setArea(segmento.getAreaConstruida());
        item.setAreaFiscalizada(segmento.getAreaConstruida());
        item.setAtualizado(Boolean.FALSE);
        item.setRegular(Boolean.FALSE);
        if (segmento.getSituacaoSegmento() != null) {
            item.setSituacao(segmento.getSituacaoSegmento().getId());
        }
        this.fillCamposRespostas(item, segmento, identificadores);
        return item;
    }

    private void fillCamposRespostas(DocumentoCertidaoItemDTO item, CadastroImobiliarioSegmento segmento, Map<ParametroGeralEnum, String> identificadores) {
        Map respostas = segmento.getRespostasSegmento().stream().filter(r -> r.getCampo() != null && r.getCampo().getIdentificador() != null).collect(Collectors.toMap(r -> r.getCampo().getIdentificador(), Function.identity(), (a, b) -> a));
        this.fillCampo(respostas, identificadores.get(ParametroGeralEnum.IDENTIFICADOR_DOCUMENTO_ITEM_DATA_ALVARA), (dto, r) -> {
            String valor = r.getValor();
            if (this.isValidResposta(valor)) {
                LocalDate data = DateUtils.stringToLocalDate((String)valor);
                dto.setDataAprovacao(data);
                dto.setAnoAlvara(Long.valueOf(data.getYear()));
            }
        }, item);
        this.fillCampo(respostas, identificadores.get(ParametroGeralEnum.IDENTIFICADOR_DOCUMENTO_ITEM_NUMERO_ALVARA), (dto, r) -> dto.setNumeroAlvara(r.getValor()), item);
        this.fillCampo(respostas, identificadores.get(ParametroGeralEnum.IDENTIFICADOR_DOCUMENTO_ITEM_DATA_HABITASE), (dto, r) -> {
            String valor = r.getValor();
            if (this.isValidResposta(valor)) {
                LocalDate data = DateUtils.stringToLocalDate((String)valor);
                dto.setDataHabitese(data);
                dto.setAnoHabitese(Long.valueOf(data.getYear()));
            }
        }, item);
        this.fillCampo(respostas, identificadores.get(ParametroGeralEnum.IDENTIFICADOR_DOCUMENTO_ITEM_NUMERO_HABITASE), (dto, r) -> dto.setNumeroHabitese(r.getValor()), item);
        this.fillCampo(respostas, identificadores.get(ParametroGeralEnum.IDENTIFICADOR_DOCUMENTO_ITEM_PADRAO), (dto, r) -> {
            if (r.getAlternativa() != null) {
                dto.setIdRespostaSegmentoPadrao(r.getAlternativa().getId());
            }
        }, item);
        this.fillCampo(respostas, identificadores.get(ParametroGeralEnum.IDENTIFICADOR_DOCUMENTO_ITEM_ANO_CONSTRUCAO), (dto, r) -> {
            String valor = r.getValor();
            if (this.isValidResposta(valor)) {
                dto.setAnoConstrucao(Long.valueOf(valor));
            }
        }, item);
        this.fillCampo(respostas, identificadores.get(ParametroGeralEnum.IDENTIFICADOR_DOCUMENTO_ITEM_CONSTRUCAO), (dto, r) -> {
            if (r.getAlternativa() != null) {
                dto.setIdTipoConstrucao(r.getAlternativa().getCodigo());
            }
        }, item);
    }

    private void fillCampo(Map<String, RespostaSegmento> respostas, String idCampo, BiConsumer<DocumentoCertidaoItemDTO, RespostaSegmento> consumer, DocumentoCertidaoItemDTO item) {
        if (this.isValidResposta(idCampo) && respostas.containsKey(idCampo)) {
            consumer.accept(item, respostas.get(idCampo));
        }
    }

    private boolean isValidResposta(String value) {
        return value != null && !value.isEmpty();
    }

    public String getValorParametroGeral(ParametroGeralEnum parametro) {
        return this.parametroGeralService.getParamValueAsString(parametro, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private void preencheEnderecoCorrespondencia(CadastroImobiliarioDTO cadastroImobiliarioDTO) {
        Optional.ofNullable(cadastroImobiliarioDTO.getTipoEnderecoCorrespondencia()).ifPresent(tipoEnderecoCorrespondencia -> {
            EnderecoCorrespondenciaDTO enderecoCorrespondenciaDTO = this.enderecoCorrespondenciaService.findEnderecoCorrespondenciaByIdAndTipo(cadastroImobiliarioDTO.getId(), tipoEnderecoCorrespondencia);
            cadastroImobiliarioDTO.setEnderecoCorrespondencia(enderecoCorrespondenciaDTO.getLogradouroDescricao());
            cadastroImobiliarioDTO.setBairroCorrespondencia(enderecoCorrespondenciaDTO.getBairroDescricao());
            cadastroImobiliarioDTO.setCidadeUfCorrespondencia(enderecoCorrespondenciaDTO.getCidadeDescricao());
            cadastroImobiliarioDTO.setComplementoCorrespondencia(enderecoCorrespondenciaDTO.getComplemento());
            cadastroImobiliarioDTO.setNumeroCorrespondencia(enderecoCorrespondenciaDTO.getNumero());
            cadastroImobiliarioDTO.setUfCorrespondencia(enderecoCorrespondenciaDTO.getUnidadeFederacao());
            cadastroImobiliarioDTO.setCepCorrespondencia(enderecoCorrespondenciaDTO.getCep());
        });
    }

    private CadastroImobiliario prepareToSave(CadastroImobiliario cadastroImobiliarioToSave, Boolean novoCadastro) {
        if (!novoCadastro.booleanValue() && cadastroImobiliarioToSave.getId() != null) {
            CadastroImobiliario cadastroImobiliarioFound = (CadastroImobiliario)this.cadastroImobiliarioRepository.findById((Object)cadastroImobiliarioToSave.getId()).orElseThrow(() -> new EloValidationException(String.format("Cadastro Imobili\u00e1rio %s n\u00e3o encontrado", cadastroImobiliarioToSave.getId())));
            return cadastroImobiliarioFound.merge(cadastroImobiliarioToSave);
        }
        cadastroImobiliarioToSave.atualizaReferenciaCamposDinamicos();
        return cadastroImobiliarioToSave;
    }

    private void validaRespostasCamposDinamicos(CadastroImobiliario cadastroImobiliario) {
        this.respostaService.validaRespostas(cadastroImobiliario.getRespostaTerrenos(), FuncionalidadeCampo.TERRENO);
        cadastroImobiliario.getSegmentos().forEach(segmento -> this.respostaService.validaRespostas(segmento.getRespostasSegmento(), FuncionalidadeCampo.SEGMENTO));
    }

    private void setInscricaoCadastral(CadastroImobiliario cadastroImobiliario) {
        ConfiguracaoInscricaoCadastral configuracao = this.configuracaoInscricaoCadastralService.getConfiguracao();
        configuracao.validaConfiguracao();
        ArrayList<String> inscricaoCadastral = new ArrayList<String>();
        ArrayList inconsistenciaInscricaoCadastral = new ArrayList();
        if (Boolean.TRUE.equals(configuracao.getQuadricula().getAtivo())) {
            String quadriculaFormatada = Optional.ofNullable(cadastroImobiliario.getQuadriculaLocalizacao()).map(quadricula -> {
                this.getInconsistenciaInscricaoCadastral(inconsistenciaInscricaoCadastral, quadricula.getId(), configuracao.getQuadricula());
                return configuracao.getQuadricula().formatarValor(quadricula.getId());
            }).orElseThrow(() -> new EloValidationException(String.format(MESSAGE_VALIDATION_REQUIRED, configuracao.getQuadricula().getDescricao())));
            inscricaoCadastral.add(quadriculaFormatada);
        }
        if (Boolean.TRUE.equals(configuracao.getDistrito().getAtivo())) {
            String distritoFormatado = Optional.ofNullable(cadastroImobiliario.getDistritoLocalizacao()).map(distrito -> {
                this.getInconsistenciaInscricaoCadastral(inconsistenciaInscricaoCadastral, distrito.getId(), configuracao.getDistrito());
                return configuracao.getDistrito().formatarValor(distrito.getId());
            }).orElseThrow(() -> new EloValidationException(String.format(MESSAGE_VALIDATION_REQUIRED, configuracao.getDistrito().getDescricao())));
            inscricaoCadastral.add(distritoFormatado);
        }
        if (Boolean.TRUE.equals(configuracao.getSetor().getAtivo())) {
            String setorFormatado = Optional.ofNullable(cadastroImobiliario.getSetorLocalizacao()).map(setor -> {
                this.getInconsistenciaInscricaoCadastral(inconsistenciaInscricaoCadastral, setor.getSetor(), configuracao.getSetor());
                return configuracao.getSetor().formatarValor(setor.getSetor());
            }).orElseThrow(() -> new EloValidationException(String.format(MESSAGE_VALIDATION_REQUIRED, configuracao.getSetor().getDescricao())));
            inscricaoCadastral.add(setorFormatado);
        }
        if (Boolean.TRUE.equals(configuracao.getQuadra().getAtivo())) {
            String quadraFormatada = Optional.ofNullable(cadastroImobiliario.getQuadraLocalizacao()).map(quadra -> {
                this.getInconsistenciaInscricaoCadastral(inconsistenciaInscricaoCadastral, quadra.getQuadra(), configuracao.getQuadra());
                return configuracao.getQuadra().formatarValor(quadra.getQuadra());
            }).orElseThrow(() -> new EloValidationException(String.format(MESSAGE_VALIDATION_REQUIRED, configuracao.getQuadra().getDescricao())));
            inscricaoCadastral.add(quadraFormatada);
        }
        if (Boolean.TRUE.equals(configuracao.getLote().getAtivo())) {
            String loteFormatado = Optional.ofNullable(cadastroImobiliario.getLoteLocalizacao()).map(lote -> {
                this.getInconsistenciaInscricaoCadastral(inconsistenciaInscricaoCadastral, lote, configuracao.getLote());
                return configuracao.getLote().formatarValor(lote);
            }).orElseThrow(() -> new EloValidationException(String.format(MESSAGE_VALIDATION_REQUIRED, configuracao.getLote().getDescricao())));
            inscricaoCadastral.add(loteFormatado);
        }
        if (Boolean.TRUE.equals(configuracao.getUnidade().getAtivo())) {
            String unidadeFormatada = Optional.ofNullable(cadastroImobiliario.getUnidadeLocalizacao()).map(unidade -> {
                this.getInconsistenciaInscricaoCadastral(inconsistenciaInscricaoCadastral, unidade, configuracao.getUnidade());
                return configuracao.getUnidade().formatarValor(unidade);
            }).orElseThrow(() -> new EloValidationException(String.format(MESSAGE_VALIDATION_REQUIRED, configuracao.getUnidade().getDescricao())));
            inscricaoCadastral.add(unidadeFormatada);
        }
        if (!inconsistenciaInscricaoCadastral.isEmpty()) {
            throw new EloValidationException(String.format("Inscri\u00e7\u00e3o cadastral inv\u00e1lida. %s", String.join((CharSequence)" ", inconsistenciaInscricaoCadastral)));
        }
        String inscricaoCadastralSemSeparador = String.join((CharSequence)"", inscricaoCadastral);
        if (this.parametroValidaInscricaoDuplicada().booleanValue()) {
            this.validaInscricaoCadastralDuplicada(inscricaoCadastralSemSeparador, cadastroImobiliario.getId());
        }
        cadastroImobiliario.setInscricaoCadastral(inscricaoCadastralSemSeparador);
    }

    private void getInconsistenciaInscricaoCadastral(List<String> inconsistenciaInscricaoCadastral, String campo, ConfiguracaoInscricaoCadastralItem configuracaoItem) {
        if (campo.length() > configuracaoItem.getTamanho().intValue()) {
            inconsistenciaInscricaoCadastral.add(String.format("Tamanho m\u00e1ximo de %s permitido: %d.", configuracaoItem.getDescricao(), configuracaoItem.getTamanho()));
        }
    }

    private void validaInscricaoCadastralDuplicada(String inscricaoCadastral, Long idkeyCadastro) {
        List inscricoesDuplicadas = this.cadastroImobiliarioRepository.findDuplicadosByInscricaoCadastralAndId(inscricaoCadastral, idkeyCadastro);
        if (!inscricoesDuplicadas.isEmpty()) {
            throw new EloValidationException(String.format("Inscri\u00e7\u00e3o cadastral duplicada. Encontrada no Cadastro: %s - %d", ((CadastroImobiliario)inscricoesDuplicadas.get(0)).getTipoCadastro().getDescricao(), ((CadastroImobiliario)inscricoesDuplicadas.get(0)).getCadastroGeral()));
        }
    }

    public String montaInscricaoCadastralSemUnidade(CadastroImobiliario cadastroImobiliario) {
        ConfiguracaoInscricaoCadastral configuracao = this.configuracaoInscricaoCadastralService.getConfiguracao();
        configuracao.validaConfiguracao();
        ArrayList<String> inscricaoCadastral = new ArrayList<String>();
        if (Boolean.TRUE.equals(configuracao.getQuadricula().getAtivo())) {
            String quadriculaFormatada = configuracao.getQuadricula().formatarValor(cadastroImobiliario.getQuadriculaLocalizacao().getId());
            inscricaoCadastral.add(quadriculaFormatada);
        }
        if (Boolean.TRUE.equals(configuracao.getDistrito().getAtivo())) {
            String distritoFormatado = configuracao.getDistrito().formatarValor(cadastroImobiliario.getDistritoLocalizacao().getDistrito());
            inscricaoCadastral.add(distritoFormatado);
        }
        if (Boolean.TRUE.equals(configuracao.getSetor().getAtivo())) {
            String setorFormatado = configuracao.getSetor().formatarValor(cadastroImobiliario.getSetorLocalizacao().getSetor());
            inscricaoCadastral.add(setorFormatado);
        }
        if (Boolean.TRUE.equals(configuracao.getQuadra().getAtivo())) {
            String quadraFormatada = configuracao.getQuadra().formatarValor(cadastroImobiliario.getQuadraLocalizacao().getQuadra());
            inscricaoCadastral.add(quadraFormatada);
        }
        if (Boolean.TRUE.equals(configuracao.getLote().getAtivo())) {
            String loteFormatado = configuracao.getLote().formatarValor(cadastroImobiliario.getLoteLocalizacao());
            inscricaoCadastral.add(loteFormatado);
        }
        return String.join((CharSequence)"", inscricaoCadastral);
    }

    public Boolean existsQuadriculaLocalizacao(String quadricula) {
        return this.cadastroImobiliarioRepository.existsByQuadriculaLocalizacaoId(quadricula);
    }

    public CadastroSearchDTO<CadastroImobiliarioRowDTO> searchCadastrosImobiliarios(CadastroGeralSearchParamsDTO searchParams, Pageable pageable) {
        List<String> searchFields = Arrays.asList("cep", "pessoa.nome", "pessoa.cnpjCpf", "pessoa.nomeFantasia", "pessoa.rg", "proprietarios.pessoa.nome", "proprietarios.pessoa.cnpjCpf", "proprietarios.pessoa.nomeFantasia", "proprietarios.pessoa.rg", "enderecoFormatado", "loteamento.descricao", "complementoLote", "inscricaoCadastral", "quadraFiscalizacao", "loteFiscalizacao", "tipoLoteDescricao", "tipoImovelDescricao", "complementoLote", "situacaoDescricao", "complemento", "matricula");
        HibernateSearchParams hibernateSearchParams = new HibernateSearchParams(this.getEm(), CadastroImobiliario.class, pageable, searchParams.getSearch(), searchFields, Arrays.asList(FacetCadastroImobiliario.values()));
        Query query = hibernateSearchParams.getQueryBuilder().bool().must(hibernateSearchParams.createQueryWithSpecificField("tipoCadastroDescricao", TipoCadastro.IMOBILIARIO.getDescricao())).should((Query)new BoostQuery(hibernateSearchParams.createQueryWithSpecificField("cadastroGeral", searchParams.getSearch()), 1.5f)).should(hibernateSearchParams.createFuzzyQuery()).createQuery();
        return this.hibernateSearchService.geraCadastroSearchDTO(query, hibernateSearchParams, searchParams.getFacets(), CadastroImobiliarioRowDTO::from);
    }

    public CadastroSearchDTO<CadastroImobiliarioRowDTO> advancedSearchCadastros(List<AdvancedSearchItemDTO> searchParams, Pageable pageable) {
        HibernateSearchParams hibernateSearchParams = new HibernateSearchParams(this.cadastroGeralService.getEm(), CadastroImobiliario.class, pageable, "", searchParams.stream().map(AdvancedSearchItemDTO::getName).collect(Collectors.toList()), Arrays.asList(FacetCadastroImobiliario.values()));
        BooleanJunction bool = hibernateSearchParams.getQueryBuilder().bool();
        searchParams.forEach(item -> {
            if ("areaLoteValor".equals(item.getName()) || "areaTotalConstruidaValor".equals(item.getName())) {
                String normalizedValue = item.getValue().replace(',', '.');
                item.setValue(normalizedValue);
            }
            bool.must(hibernateSearchParams.createQueryWithSpecificField(item.getName(), item.getValue()));
        });
        Query query = bool.must(hibernateSearchParams.createQueryWithSpecificField(FacetCadastroGeral.EXCLUSAO_LOGICA.getName(), "false")).must(hibernateSearchParams.createQueryWithSpecificField("tipoCadastroDescricao", TipoCadastro.IMOBILIARIO.getDescricao())).createQuery();
        return this.hibernateSearchService.geraCadastroSearchDTO(query, hibernateSearchParams, new ArrayList(), CadastroImobiliarioRowDTO::from);
    }

    public Boolean existsCadastroImobiliarioAssociadoLoteamento(Long idLoteamento) {
        return this.cadastroImobiliarioRepository.existsByLoteamentoId(idLoteamento);
    }

    public Boolean existsCadastroImobiliarioAssociadoLogradouroTestada(Long idLogradouroTestada) {
        return this.cadastroImobiliarioRepository.existsByTestadasLogradouroTestadaId(idLogradouroTestada);
    }

    public CadastroImobiliarioEnderecoDTO getEnderecoByCadastroImobiliario(Long CadastroGeralImobiliario) {
        CadastroImobiliario cadastroImobiliario = Optional.ofNullable(this.findByTipoCadastroAndCadastroGeral(TipoCadastro.IMOBILIARIO, CadastroGeralImobiliario)).orElseThrow(() -> new EloValidationException("Cadastro Imobili\u00e1rio n\u00e3o encontrado"));
        CadastroImobiliarioEnderecoDTO cadastroImobiliarioEnderecoDTO = new CadastroImobiliarioEnderecoDTO();
        cadastroImobiliarioEnderecoDTO.setId(cadastroImobiliario.getId());
        cadastroImobiliarioEnderecoDTO.setTipoCadastro(cadastroImobiliario.getTipoCadastro());
        cadastroImobiliarioEnderecoDTO.setCadastroGeral(cadastroImobiliario.getCadastroGeral());
        cadastroImobiliarioEnderecoDTO.setCidade(cadastroImobiliario.getCidade());
        Optional.ofNullable(cadastroImobiliario.getLogradouro()).ifPresent(logradouro -> cadastroImobiliarioEnderecoDTO.setLogradouro(LogradouroDTO.from((Logradouro)logradouro)));
        cadastroImobiliarioEnderecoDTO.setNumero(cadastroImobiliario.getNumero());
        Optional.ofNullable(cadastroImobiliario.getCep()).ifPresent(cep -> cadastroImobiliarioEnderecoDTO.setCep(cep.toString()));
        cadastroImobiliarioEnderecoDTO.setComplemento(cadastroImobiliario.getComplemento());
        Optional.ofNullable(cadastroImobiliario.getBairro()).ifPresent(bairro -> cadastroImobiliarioEnderecoDTO.setBairro(BairroDTO.from((Bairro)bairro)));
        Optional.ofNullable(cadastroImobiliario.getLoteamento()).ifPresent(loteamento -> cadastroImobiliarioEnderecoDTO.setLoteamento(LoteamentoDTO.from((Loteamento)cadastroImobiliario.getLoteamento())));
        return cadastroImobiliarioEnderecoDTO;
    }

    public List<CadastroImobiliarioSituacao> getSituacoes(Long id) {
        if (!this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_SITUACAO_IMOBILIARIO).booleanValue()) {
            throw new EloValidationException("O sistema est\u00e1 configurado para n\u0101o utilizar situa\u00e7\u0101o no cadastro imobili\u00e1rio");
        }
        return this.cadastroImobiliarioRepository.findById((Object)id).map(CadastroImobiliario::getSituacoes).map(situacoes -> {
            situacoes.sort(Comparator.comparingLong(CadastroImobiliarioSituacao::getSequencia).reversed());
            return situacoes;
        }).orElseThrow(() -> new EloValidationException(String.format("Cadastro Imobili\u00e1rio %s n\u00e3o encontrado", id)));
    }

    public List<HistoricoTransmissaoDTO> getHistoricoTransmissoes(Long id) {
        List imobiliarioItbis = (List)this.imobiliarioItbiRepository.findByCadastroGeralOrderByDataLancamentoDesc(id).orElseThrow(() -> new EloValidationException(String.format("ITBI n\u00e3o encontrado para o cadastro %s", id)));
        return imobiliarioItbis.stream().map(itbi -> this.debitoRepository.findByCompositeKey(itbi.getEntidade(), itbi.getExercicio(), itbi.getTipoCadastro().getValue(), itbi.getCadastroGeral(), itbi.getGuiaRecolhimento(), itbi.getSubDivida()).map(debito -> HistoricoTransmissaoDTO.from((ImobiliarioItbi)itbi, (Long)debito.getId())).orElseThrow(() -> new EloValidationException(String.format("D\u00e9bito n\u00e3o encontrado para o cadastro %s", itbi.getCadastroGeral())))).collect(Collectors.toList());
    }

    public List<CadastroImobiliarioSituacao> createSituacao(Long id, CadastroImobiliarioSituacao novaSituacao) {
        if (!this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_SITUACAO_IMOBILIARIO).booleanValue()) {
            throw new EloValidationException("O sistema est\u00e1 configurado para n\u0101o utilizar situa\u00e7\u0101o no cadastro imobili\u00e1rio");
        }
        CadastroImobiliario cadastroImobiliario = (CadastroImobiliario)this.cadastroImobiliarioRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("Cadastro imobili\u00e1rio com id %d n\u00e3o encontrado", id)));
        if (cadastroImobiliario.getExclusaoLogica().booleanValue()) {
            throw new EloValidationException(String.format("O cadastro imobili\u00e1rio %d se encontra em exclus\u0101o l\u00f3gica.", cadastroImobiliario.getCadastroGeral()));
        }
        CadastroImobiliarioSituacao situacaoAtual = cadastroImobiliario.getSituacaoAtual();
        if (Objects.nonNull(situacaoAtual)) {
            situacaoAtual.setAtual(Boolean.FALSE);
            situacaoAtual.setDataAlteracao(LocalDate.now());
        }
        novaSituacao.setSequencia(Long.valueOf(cadastroImobiliario.getUltimaSequenciaSituacao() + 1L));
        novaSituacao.setUsuarioInclusao(SecurityUtils.getUserAise());
        novaSituacao.setDataInclusao(LocalDate.now());
        cadastroImobiliario.getSituacoes().add(novaSituacao);
        this.save((EloEntity)cadastroImobiliario, null);
        List result = cadastroImobiliario.getSituacoes();
        result.sort(Comparator.comparingLong(CadastroImobiliarioSituacao::getSequencia).reversed());
        return result;
    }

    public void deleteById(Long id) {
        CadastroImobiliario cadastroImobiliario = (CadastroImobiliario)this.cadastroImobiliarioRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o cadastro imobili\u00e1rio com o id: %d, para realizar a exclus\u00e3o.", id)));
        this.cadastroImobiliarioRepository.delete((Object)cadastroImobiliario);
    }

    public CadastroImobiliarioDTO copiar(Long id, CadastroImobiliarioCopiaDTO cadastroCopia) {
        CadastroImobiliario cadastroImobiliarioToCopy = (CadastroImobiliario)this.cadastroImobiliarioRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("Cadastro Imobili\u00e1rio %s n\u00e3o encontrado", id)));
        if (this.informaCadastroManual().booleanValue() && Objects.isNull(cadastroCopia.getCadastroGeral())) {
            throw new EloValidationException("O c\u00f3digo do cadastro deve ser informado.");
        }
        Long novoCodigoCadastroGeral = this.informaCadastroManual() != false ? cadastroCopia.getCadastroGeral() : this.getCadastroGeralBySequence();
        CadastroImobiliario newCadastroImobiliario = cadastroImobiliarioToCopy.copy(novoCodigoCadastroGeral);
        return CadastroImobiliarioDTO.from((CadastroImobiliario)((CadastroImobiliario)this.cadastroImobiliarioRepository.save((Object)newCadastroImobiliario)));
    }

    private Long getCadastroGeralBySequence() {
        CadastroImobiliario cadastroImobiliario = new CadastroImobiliario();
        cadastroImobiliario.setTipoCadastro(TipoCadastro.IMOBILIARIO);
        String sequenceNome = this.sequenceCadastroGeralService.getExpression((CadastroGeral)cadastroImobiliario);
        return this.sequenceGeneratorRepository.getNextVal(sequenceNome);
    }

    public Long validateAndGetCadastroGeralSequence(Long cadastroGeral) {
        if (!this.informaCadastroManual().booleanValue() && Objects.isNull(cadastroGeral)) {
            return this.getCadastroGeralBySequence();
        }
        return cadastroGeral;
    }

    public List<CadastroImobiliarioUnificacaoDTO> findImobiliariosElegiveisUnificacao(Long idCadastro) {
        CadastroImobiliario cadastroImobiliario = (CadastroImobiliario)this.cadastroImobiliarioRepository.findById((Object)idCadastro).orElseThrow(() -> new EloValidationException(String.format("Cadastro imobili\u00e1rio com %d n\u00e3o encontrado", idCadastro)));
        List cadastrosImobiliariosUnificacao = this.cadastroImobiliarioRepository.getImobiliariosElegiveisUnificacao(cadastroImobiliario.getCadastroGeral(), cadastroImobiliario.getDistritoLocalizacao().getDistrito(), cadastroImobiliario.getSetorLocalizacao().getSetor(), cadastroImobiliario.getQuadraLocalizacao().getQuadra());
        return cadastrosImobiliariosUnificacao.stream().map(cadastroImobiliarioMap -> {
            CadastroImobiliarioUnificacaoDTO cadastroImobiliarioUnificacaoDTO = CadastroImobiliarioUnificacaoDTO.from((CadastroImobiliario)cadastroImobiliarioMap);
            String filtro = this.createStringFilter(cadastroImobiliarioUnificacaoDTO.getCadastroGeral(), cadastroImobiliarioUnificacaoDTO.getTipoCadastro());
            DebitosEmAbertoComTotalizadorDTO debitos = this.debitoEmAbertoService.loadDebitosAbertosAgrupados(filtro, Boolean.TRUE);
            cadastroImobiliarioUnificacaoDTO.setDebitos(debitos);
            cadastroImobiliarioUnificacaoDTO.setDebitosAbertos(Boolean.valueOf(debitos.getValorTotal().compareTo(BigDecimal.ZERO) > 0));
            return cadastroImobiliarioUnificacaoDTO;
        }).collect(Collectors.toList());
    }

    public List<CadastroImobiliario> findCadastroByLocalizacaoCompleta(String distritoId, Long setorId, Long quadraId, String lote) {
        return this.cadastroImobiliarioRepository.findByLocalizacaoCompleta(distritoId, setorId, quadraId, lote);
    }

    private String createStringFilter(Long cadastroGeral, Long tipoCadastro) {
        return String.format(" TRIBDEBITO.TIPOCADASTRO  = %d  and TRIBDEBITO.CADASTROGERAL  = %d ", tipoCadastro, cadastroGeral);
    }

    private List<SegmentoDTO> atualizaSegmentos(List<SegmentoDTO> segmentoDTOs) {
        segmentoDTOs.removeIf(segmento -> {
            if (Boolean.TRUE.equals(segmento.getDelete())) {
                this.excluirSegmento(segmento);
                return true;
            }
            return false;
        });
        return segmentoDTOs;
    }

    private void atualizaDemolicoes(List<SegmentoDTO> segmentoDTOs) {
        segmentoDTOs.forEach(segmento -> segmento.getDemolicoes().removeIf(SegmentoDemolicaoDTO::getDelete));
    }

    private void excluirSegmento(SegmentoDTO segmento) {
        this.boletimImobiliarioSegmentoService.deleteByIdImobiliarioSegmento(segmento.getId());
    }

    public Page<String> findLoteLocalizacaoByRsql(String search, Pageable pageable) {
        Page page = this.findByRsql(search, pageable);
        return page.map(CadastroImobiliario::getLoteLocalizacao);
    }

    public List<CadastroImobiliario> findImobiliariosAptosParaEnglobamento(Long idCadastro, String distritoId, Long setorId, Long quadraId, String lote, String quadricula) {
        return this.cadastroImobiliarioRepository.findImobiliariosAptosParaEnglobamento(idCadastro, distritoId, setorId, quadraId, lote, quadricula);
    }

    @Generated
    public CadastroImobiliarioService(ParametroEntidadeService parametroEntidadeService, ParametroGeralService parametroGeralService, CadastroGeralService cadastroGeralService, CadastroImobiliarioSituacaoService imobiliarioSituacaoService, CadastroImobiliarioRepository cadastroImobiliarioRepository, CadastroImobiliarioAvaliacaoService cadastroImobiliarioAvaliacaoService, ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService, CadastroImobiliarioValidator cadastroImobiliarioValidator, SetorQuadraService setorQuadraService, RespostaService respostaService, HibernateSearchService hibernateSearchService, SequenceCadastroGeralService sequenceCadastroGeralService, SequenceGeneratorRepository sequenceGeneratorRepository, EnderecoCorrespondenciaService enderecoCorrespondenciaService, DebitoEmAbertoService debitoEmAbertoService, BoletimImobiliarioSegmentoService boletimImobiliarioSegmentoService, ImobiliarioItbiRepository imobiliarioItbiRepository, DebitoRepository debitoRepository, DocumentoRepository documentoRepository, CadastroImobiliarioTestadaGenericaExercicioRepository cadastroImobiliarioTestadaGenericaExercicioRepository, ContextService contextService) {
        this.parametroEntidadeService = parametroEntidadeService;
        this.parametroGeralService = parametroGeralService;
        this.cadastroGeralService = cadastroGeralService;
        this.imobiliarioSituacaoService = imobiliarioSituacaoService;
        this.cadastroImobiliarioRepository = cadastroImobiliarioRepository;
        this.cadastroImobiliarioAvaliacaoService = cadastroImobiliarioAvaliacaoService;
        this.configuracaoInscricaoCadastralService = configuracaoInscricaoCadastralService;
        this.cadastroImobiliarioValidator = cadastroImobiliarioValidator;
        this.setorQuadraService = setorQuadraService;
        this.respostaService = respostaService;
        this.hibernateSearchService = hibernateSearchService;
        this.sequenceCadastroGeralService = sequenceCadastroGeralService;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.enderecoCorrespondenciaService = enderecoCorrespondenciaService;
        this.debitoEmAbertoService = debitoEmAbertoService;
        this.boletimImobiliarioSegmentoService = boletimImobiliarioSegmentoService;
        this.imobiliarioItbiRepository = imobiliarioItbiRepository;
        this.debitoRepository = debitoRepository;
        this.documentoRepository = documentoRepository;
        this.cadastroImobiliarioTestadaGenericaExercicioRepository = cadastroImobiliarioTestadaGenericaExercicioRepository;
        this.contextService = contextService;
    }
}

