/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Distrito;
import br.com.elotech.tributos.domain.Quadricula;
import br.com.elotech.tributos.domain.Setor;
import br.com.elotech.tributos.domain.SetorQuadra;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioEnglobado;
import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroEnglobadoDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroImobiliarioEnglobadoDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroImobiliarioEnglobadoPostDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroImobiliarioRowDTO;
import br.com.elotech.tributos.repository.CadastroGeralRepository;
import br.com.elotech.tributos.repository.CadastroImobiliarioEnglobadoRepository;
import br.com.elotech.tributos.service.CadastroImobiliarioService;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class CadastroImobiliarioEnglobadoService
extends CrudService<CadastroImobiliarioEnglobado, Long> {
    private static final String MSG_CADASTRO_JA_ENGLOGADO = "O Cadastro Imobili\u00e1rio %d j\u00e1 est\u00e1 englobado no Cadastro Imobili\u00e1rio %d.";
    private final CadastroImobiliarioEnglobadoRepository cadastroImobiliarioEnglobadoRepository;
    private final CadastroGeralRepository cadastroGeralRepository;
    private final CadastroImobiliarioService cadastroImobiliarioService;

    public CadastroImobiliarioEnglobadoDTO findByCadastroOrigem(Long idCadastro) {
        return CadastroImobiliarioEnglobadoDTO.from((List)this.cadastroImobiliarioEnglobadoRepository.findByCadastroOrigemId(idCadastro));
    }

    public List<CadastroImobiliarioRowDTO> findImobiliariosAptosParaEnglobamentoByImobiliarioOrigem(Long idCadastro) {
        CadastroImobiliario imobiliarioOrigem = this.getCadastroImobiliario(idCadastro);
        return this.cadastroImobiliarioService.findImobiliariosAptosParaEnglobamento(imobiliarioOrigem.getId(), (String)Optional.ofNullable(imobiliarioOrigem.getDistritoLocalizacao()).map(Distrito::getId).orElse(null), (Long)Optional.ofNullable(imobiliarioOrigem.getSetorLocalizacao()).map(Setor::getId).orElse(null), (Long)Optional.ofNullable(imobiliarioOrigem.getQuadraLocalizacao()).map(SetorQuadra::getId).orElse(null), (String)Optional.of(imobiliarioOrigem.getLoteLocalizacao()).orElse(null), (String)Optional.ofNullable(imobiliarioOrigem.getQuadriculaLocalizacao()).map(Quadricula::getId).orElse(null)).stream().map(CadastroImobiliarioRowDTO::from).collect(Collectors.toList());
    }

    public CadastroImobiliarioEnglobadoDTO create(CadastroImobiliarioEnglobadoPostDTO dto) {
        CadastroImobiliarioEnglobadoDTO cadastrosEnglobados = new CadastroImobiliarioEnglobadoDTO();
        CadastroImobiliario cadastroImobiliarioOrigem = this.getCadastroImobiliario(dto.getIdCadastroOrigem());
        this.validaSeCadastroJaEstaEnglobadoByImobiliario(cadastroImobiliarioOrigem);
        cadastrosEnglobados.setCadastroImobiliarioOrigem(CadastroImobiliarioRowDTO.from((CadastroGeral)cadastroImobiliarioOrigem));
        dto.getCadastrosEnglobados().forEach(idCadastroParaEnglobar -> {
            CadastroImobiliario cadastroImobiliario = this.getCadastroImobiliario(idCadastroParaEnglobar);
            if (!cadastroImobiliario.getCadastrosEnglobados().isEmpty()) {
                throw new EloValidationException(String.format("O Cadastro Imobili\u00e1rio %d j\u00e1 \u00e9 origem de um Englobamento, portanto, n\u00e3o pode ser Englobado.", cadastroImobiliario.getCadastroGeral()));
            }
            this.validaSeCadastroJaEstaEnglobadoByImobiliario(cadastroImobiliario);
            CadastroImobiliarioEnglobado cadastroImobiliarioEnglobadoSaved = this.createEnglobamento(cadastroImobiliarioOrigem, cadastroImobiliario);
            this.setEnglobado(cadastroImobiliarioEnglobadoSaved.getCadastroEnglobado(), Boolean.TRUE);
            cadastrosEnglobados.incrementQtde();
            cadastrosEnglobados.setAreaTotalConstruida(cadastrosEnglobados.getAreaTotalConstruida().add(cadastroImobiliario.getAreaTotalConstruida()));
            cadastrosEnglobados.getCadastrosEnglobados().add(CadastroEnglobadoDTO.from((CadastroImobiliarioEnglobado)cadastroImobiliarioEnglobadoSaved));
        });
        return cadastrosEnglobados;
    }

    public void delete(Long idEnglobamento) {
        CadastroImobiliarioEnglobado cadastroImobiliarioEnglobado = (CadastroImobiliarioEnglobado)this.findById((Serializable)idEnglobamento).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o englobamento id %d.", idEnglobamento)));
        cadastroImobiliarioEnglobado.getCadastroOrigem().getCadastrosEnglobados().removeIf(englobado -> englobado.getId().equals(idEnglobamento));
        cadastroImobiliarioEnglobado.getCadastroEnglobado().setCadastroEnglobadoOrigem(null);
        this.setEnglobado(cadastroImobiliarioEnglobado.getCadastroEnglobado(), Boolean.FALSE);
        this.cadastroImobiliarioEnglobadoRepository.delete((Object)cadastroImobiliarioEnglobado);
    }

    private void validaSeCadastroJaEstaEnglobadoByImobiliario(CadastroImobiliario cadastroImobiliario) {
        if (Objects.nonNull(cadastroImobiliario.getCadastroEnglobadoOrigem())) {
            throw new EloValidationException(String.format(MSG_CADASTRO_JA_ENGLOGADO, cadastroImobiliario.getCadastroGeral(), cadastroImobiliario.getCadastroEnglobadoOrigem().getCadastroOrigem().getCadastroGeral()));
        }
    }

    public void validaSeCadastroJaEstaEnglobadoByIdCadastro(Long idCadastro) {
        CadastroImobiliarioEnglobado cadastroImobiliarioEnglobado = this.cadastroImobiliarioEnglobadoRepository.findByCadastroEnglobadoId(idCadastro);
        if (Objects.nonNull(cadastroImobiliarioEnglobado)) {
            throw new EloValidationException(String.format(MSG_CADASTRO_JA_ENGLOGADO, cadastroImobiliarioEnglobado.getCadastroEnglobado().getCadastroGeral(), cadastroImobiliarioEnglobado.getCadastroOrigem().getCadastroGeral()));
        }
    }

    private CadastroImobiliario getCadastroImobiliario(Long idCadastro) {
        return (CadastroImobiliario)this.cadastroImobiliarioService.findById((Serializable)idCadastro).orElseThrow(() -> new EloValidationException(String.format("Cadastro Imobili\u00e1rio Id %d n\u00e3o localizado.", idCadastro)));
    }

    private CadastroImobiliarioEnglobado createEnglobamento(CadastroImobiliario cadastroImobiliarioOrigem, CadastroImobiliario cadastroImobiliarioParaEnglobar) {
        CadastroImobiliarioEnglobado cadastroImobiliarioEnglobado = new CadastroImobiliarioEnglobado();
        cadastroImobiliarioEnglobado.setCadastroOrigem(cadastroImobiliarioOrigem);
        cadastroImobiliarioEnglobado.setCadastroEnglobado(cadastroImobiliarioParaEnglobar);
        return (CadastroImobiliarioEnglobado)this.save((EloEntity)cadastroImobiliarioEnglobado, null);
    }

    private void setEnglobado(CadastroImobiliario cadastroImobiliario, Boolean englobado) {
        cadastroImobiliario.setEnglobado(englobado);
        this.cadastroGeralRepository.save((Object)cadastroImobiliario);
    }

    @Generated
    public CadastroImobiliarioEnglobadoService(CadastroImobiliarioEnglobadoRepository cadastroImobiliarioEnglobadoRepository, CadastroGeralRepository cadastroGeralRepository, CadastroImobiliarioService cadastroImobiliarioService) {
        this.cadastroImobiliarioEnglobadoRepository = cadastroImobiliarioEnglobadoRepository;
        this.cadastroGeralRepository = cadastroGeralRepository;
        this.cadastroImobiliarioService = cadastroImobiliarioService;
    }
}

