/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.ModeloResposta;
import br.com.elotech.tributos.domain.imobiliario.BoletimImobiliarioTerreno;
import br.com.elotech.tributos.dto.integracaoelogeo.BoletimElogeoDTO;
import br.com.elotech.tributos.repository.imobiliario.BoletimImobiliarioTerrenoRepository;
import br.com.elotech.tributos.util.EloRequireNonNull;
import br.com.elotech.tributos.util.ListUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class BoletimImobiliarioTerrenoService
extends CrudService<BoletimImobiliarioTerreno, Long> {
    private final BoletimImobiliarioTerrenoRepository boletimImobiliarioTerrenoRepository;

    public BoletimImobiliarioTerrenoService(BoletimImobiliarioTerrenoRepository boletimImobiliarioTerrenoRepository) {
        this.boletimImobiliarioTerrenoRepository = boletimImobiliarioTerrenoRepository;
    }

    public List<BoletimImobiliarioTerreno> findByIdCadastroImobiliario(Long idCadastroImobiliario) {
        return this.boletimImobiliarioTerrenoRepository.findByIdCadastroImobiliario(idCadastroImobiliario);
    }

    public void merge(List<BoletimElogeoDTO> respostas, Long idCadastroImobiliario) {
        List boletimSalvo = this.findByIdCadastroImobiliario(idCadastroImobiliario);
        ArrayList boletimAlterado = new ArrayList();
        respostas.stream().map(respostaBoletim -> {
            ModeloResposta modeloResposta = (ModeloResposta)EloRequireNonNull.eloRequireNonNull((Object)((ModeloResposta)this.getEm().find(ModeloResposta.class, (Object)respostaBoletim.getResposta().getId())), (String)String.format("Modelo Resposta %s do Boletim n\u00e3o encontrado.", respostaBoletim.getResposta().getId()));
            return respostaBoletim.toEntityTerreno(idCadastroImobiliario, modeloResposta);
        }).forEach(boletimAlterado::add);
        List merged = ListUtils.merge((List)boletimSalvo, boletimAlterado, boletimImobiliarioTerreno -> boletimImobiliarioTerreno.getModeloResposta().getModeloCampo(), BoletimImobiliarioTerreno::merge);
        this.boletimImobiliarioTerrenoRepository.saveAll((Iterable)merged);
    }
}

